
Buddhist Dictionary
Manual of Buddhist Terms and Doctrines, by NYANATILOKA
Fourth Revised Edition, edited by Nyanaponika 
Buddhist Publication Society 
P. O. Box 61 
54, Sangharaja Mawatha 
Kandy, Sri Lanka 
  
First Edition 1952 
Second Revised Edition 1956 
Third Revised & Enlarged Edition 1972 
(Pub. by Frewin & Co., Ltd., Colombo) 
Fourth Revised Edition 1980 
(Buddhist Publication Society) 
Reprinted 1988 
  
1980 by Buddhist 
Publication Society 
ISBN - 955 - 24 - 0019 - 8 

From The Preface To The First Edition
 
As a first attempt of an authentic dictionary of Buddhist doctrinal terms, used in the Pli Canon and its Commentaries, this present manual will fill a real gap felt by many students of Buddhism. It provides the reader not with a mere superficial enumeration of important Pli terms and their English equivalents, but offers him precise and authentic definitions and explanations of canonical and post-canonical terms and doctrines, based on Sutta, Abhidhamma and Commentaries, and illustrated by numerous quotations taken from these sources, so that, if anyone wishes, he could, by intelligently joining together the different articles, produce without difficulty a complete exposition of the entire teachings of Buddhism.

As already pointed out by the author in the preface to his Guide through the Abhidhamma-Pitaka (Colombo 1938), there are found in the Abhidhamma Canon numerous technical terms not met with in the Sutta Canon; and again other terms are found only in the Commentaries and not in Sutta and Abhidhamma. The author therefore has made a first attempt - without, however, laying any claim to absolute reliability or completeness in this by no means easy undertaking - to indicate in the Appendix all the terms that in the oldest Sutta texts are either not found at all, or at least not in the same form or meaning, and to set forth how far these are deviations from the older texts, or further developments.

In this connection, the author wishes to state that the often quoted Patisambhid-Magga, as well as Niddesa, Buddhavamsa and Cariyapitaka, though included in the Khuddaka Nikya of the Sutta Pitaka, nevertheless bear throughout the character of Commentaries, and though apparently older than the Sutta Commentaries handed down to us in Buddhaghosa's version, must doubtless belong to a later period of origin than the Abhidhamma Canon.

In rendering the terms into English, I often had to differ considerably from the interpretation of Western scholars, and to introduce quite new words. A great number of such earlier translations must be considered partly as totally incorrect, partly as misleading, or at the very least ambiguous. Incorrect are, for instance, the English renderings of nma-rpa by 'name and form'; javana (impulsion, i.e. the karmic impulsive moments) by 'apperception', etc.

The expositions concerning the true nature of the 8-fold Path, the 4 Noble Truths, the paticca-samuppda and the 5 groups of existence - doctrines which, with regard to their true nature, have been often misunderstood by Western authors - are sure to come to many as a revelation.

On the doctrine of anatt, or 'egolessness', i.e. the impersonality and emptiness of all phenomena of existence, the author repeatedly felt the necessity of throwing light from every possible point of view, for it is exactly this doctrine which, together with the doctrine of the conditionality of all phenomena of existence, constitutes the very essence of the whole Teaching of the Buddha without which it will be by no means possible to understand it in its true light. Thus the doctrine of impersonality runs like a red thread right through the whole book.

May this little manual provide an ever-helpful companion and vade mecum to all earnest students in their study of the original Buddhist scriptures, and also give to Buddhist authors and lecturers the opportunity of supplementing and deepening their knowledge of the profound teachings of the Buddha!
Should it, for a better understanding, prove necessary to give to certain subjects a more detailed treatment, the carrying out of this task may be reserved for a later edition of this work.
 
NYANATILOKA 
Central Internment Camp 
Dehra-Dun, India 
28-8-1946 

Editor's Preface To The Third Edition
 
The present revised and enlarged Third Edition was intended to be issued in commemoration of the tenth anniversary of the venerable author's passing away on 28th May 1957. But due to unavoidable circumstances the publication had to be delayed.

It was the venerable author's wish to enlarge the first edition of this work, but when a second edition became necessary, he was prevented from expanding it by the illness to which he later succumbed. It rested, therefore, with his pupil, the present editor, to make, within the original scope and character of the work, such additions and revisions as seemed useful.

Over seventy articles have been expanded and partly rewritten; others were slightly revised; more source references were included, and information on literature for further study of the respective subjects was added to some of the articles. But only very few new words have been added (e.g. anupassan, nupubbi-kath, etc.). This restriction was observed because the venerable author himself thought only of 'a more detailed treatment' of existing articles (see Preface to the 1st ed.) as he obviously wished to preserve the original form and character of the book. It was also considered that the adding of more words such as those coined in later commentarial and abhidhammic literature, would be superfluous as in the English language such terms will generally be found only in a few scholarly books and translations which themselves give the explanations needed.

This book is chiefly intended for those who study the Buddhist teachings through the medium of the English language, but wish to familiarize themselves with some of the original Pli terms of doctrinal import. They are in the same position as a student of philosophy or science who has to know the terminology of his field, which for common parlance is mostly not less 'unfamiliar' than are the words of the Pli language found in the Dictionary.

Such acquaintance with the Pli terms of the original texts will also be useful to the student for the purpose of identifying the various renderings of them favored by different translators. It is deplorable that there is a considerable multiplication of new English coining for the same doctrinal term. This great variety of renderings has proved to be confusing to those students of Buddhism who are not familiar with the Pli language. Even at this late stage when many translations of Pli texts are in print, it will be desirable if, for the sake of uniformity, translators forgo their preference for their own coining, even if they think them better than others. In any case, doctrinal terms have to be known by definition, just as in the case of philosophical and technical terms in a Western language.

As a small help in the situation described, a number of alternative renderings used by other translators have been included in some articles of this edition. In a very few cases, unacceptable though familiar renderings have been bracketed. The Venerable Nyanatiloka's own preferences have been placed in inverted commas. Generally it may be said that his renderings, based on his comprehensive knowledge of texts and doctrine, are very sound and adequate. Only in a very few cases has the editor changed the author's preferred rendering e.g. 'canker' for sava (instead of 'bias'), 'right view' for samm-ditthi (instead of 'right understanding'). The latter change was made for the sake of economizing with the few English equivalents for the numerous Pli synonyms for 'knowing', etc.; and also to avoid having to render the opposite term, micch-ditthi, by 'wrong understanding'.
This Dictionary appeared also in the author's own German version (published by Verlag Christiani, Konstanz, Germany) and in a French translation made by the late Mme Suzanne Karpeles (published by 'Adyar', Paris, 1961).

NYANAPONIKA 
Kandy, Ceylon 
February 1970 

Only few and minor revisions have been made to the text of the Fourth Edition which is now issued by the Buddhist Publication Society.
NYANAPONIKA 
Kandy, Sri Lanka 
March 1980 
A.   	Anguttara Nikya (figures refer to number of book (nipta) and Sutta)
Abh.   	 Abhidhamma Pitaka (Canon)
Abh. S.   	 Abhidhammattha Sangaha
Abh. St.   	 Abhidhamma Studies, by Nyanaponika Thera (BPS)
App.   	 Appendix at the end of this book
Atthaslini   	 (Com. to Dhammasangani)
Atthaslini Tr.   	 The Expositor, tr. by Maung Tin. PTS Tr. Series
Boehtl.   	 Otto Boehtlingk, Sanskrit-W?rterbuch
BPS   	 Buddhist Publication Society, Kandy
CNid.   	 Cla Niddesa
Com.   	 Commentary
D.   	 Dgha Nikya (figures: number of Sutta)
Dhp.   	 Dhammapada
Dhs.   	 Dhammasangani
Fund.   	 Fundamentals of Buddhism, Nyanatiloka (BPS)
Guide   	 Guide through the Abhidhamma Pitaka, Nyanatiloka, 3rd ed. 1971 (BPS)
It.   	 Itivuttaka
Kath.   	 Kathvatthu
Khp.   	 Khuddakaptha
Khp. Tr.   	 Minor Readings & Illustrator, tr. (of Khp. & Com) by ?namoli Thera.
PTS Tr.   	 Series
M.   	 Majjhima Nikya (figures: number of Sutta)
MNid.   	 Mah Niddesa
Mil.   	 Milinda Pa?h
Path   	 Path to Deliverance, Nyanatiloka (BPS) (figures: paragraphs)
Patth.   	 Patthna
Pts.M.   	 Patisambhid Magga
PTS   	 Pli Text Society's editions
Pug.   	 Puggala-Pa??atti (figures: paragraphs)
R. Und.   	 Right Understanding, tr. (of M. 9 & Com.) by Soma Thera (BPS)
S.   	 Samyutta Nikya (figures: numbers of Samyutta and Sutta)
Sn.   	 Sutta Nipta (figures numbers of verses)
Tab.   	 Table at the end of the book
Therag.   	 Theragth
Tr.   	 Translation
Vibh.   	 Vibhanga
Vis.M.   	 Visuddhi Magga (figures numbers of chapter & the paragraphing in Path of Purification, tr. by ?namoli Thera, 3rd ed., BPS)
WHEEL   	 THE WHEEL publ. by BPS
W.of B.   	 The Word of the Buddha, Nyanatiloka (BPS)
Yam.   	 Yamaka   contemplation of: patinissagga^nupassana^, is one of the 18 chief kinds of insight; s. vipassana^, further a^na^pa^nasati (16).  'living in the open air', is one of the ascetic means to purification (dhutanga, q.v.).  in morality and understanding): s. vipatti.  'incapable of progressing'... 
"Those beings 
who are obstructed by their evil actions (kamma, s. karma),  
by their defilements (kilesa, q.v.),  
by the result of their evil actions (s. vipa^ka),  
or who are devoid of faith,  
energy and  
knowledge, and  
unable to enter the right path and reach perfection in wholesome things,  
all those are said to be incapable of progressing" (Pug. 13). 
According to Commentary the 'evil actions' denote the 5 heinous deeds with immediate result (a^nantarika-kamma, q.v.), whilst the 'defilements' refer to the 'evil views with fixed destiny' (niyata-miccha^-ditthi; s. ditthi).  he 'Radiant Ones', are a class of heavenly beings of the fine-material world (rpa-loka); cf. deva.  he 8 'stages of mastery', ... 
the 8 'stages of mastery', are powers to be obtained by means of the kasina-exercises (s. kasina). In the Com. to M.77, where a^yatana is explained by 'means' (ka^rana) it is said: "The abhibha^yatana through their counteracting may master (suppress) the adverse states, and by means of higher knowledge they may master the objects of mind." They are means for transcending the sensuous sphere.
The stereotype text often met with in the Suttas (e.g. D.11, D.33; M.77; A.VIII.65; A.X.29) is as follows:
(1) "Perceiving (blue..., red..., yellow..., white) forms on one's own body, one sees forms externally small ones, beautiful or ugly; and in mastering these one understands: 'I know, I understand.' This is the first stage of mastery.
(2) "Perceiving forms on one's own body, one sees forms externally, large ones .... This is the second stage of mastery.
(3) "Not perceiving forms on one's own body, one sees forms externally, small ones .... This is the third stage of mastery.
(4) "Not perceiving forms on one's own body, one sees forms externally, large ones .... This is the fourth stage of mastery.
(5) "Not perceiving forms on one's own body, one sees forms externally, blue forms, forms of blue colour, blue appearance, blue lustre, and mastering these one understands: 'I know, I understand. This is the fifth stage of mastery."
(6-8) The same is repeated with yellow, red and white forms.
As preparatory kasina-object for the 1st and 2nd exercise one should choose on one's own body a small or a large spot, beautiful or ugly, and thereon one should concentrate one's full undivided attention, so that this object after a while reappears as mental reflex or image (nimitta, q.v.) and, as it were, as something external. Such an exercise, though appearing quite mechanical, if properly carried out will bring about a high degree of mental concentration and entrance into the 4 absorptions (jha^na, q.v.). In the 3rd and 4th exercises the monk by an external kasina-object gains the mental reflexes and absorptions. As objects of the remaining exercises, perfectly clear and radiant colours should be chosen, flowers, cloth, etc.
A kasina-object of small size is said to be suitable for a mentally unsteady nature, one of a large size for a dull nature, a beautiful object for an angry nature, an ugly one for a lustful nature.
In Vis.M. V it is said: "By means of the earth-kasina one succeeds in reaching the stage of mastery with regard to small and large objects .... By means of the blue-kasina one succeeds in causing blue forms to appear, in producing darkness, in reaching the stage of mastery with regard to beautiful and ugly colours, in reaching 'deliverance through the beautiful', etc." (cf. vimokkha II, 3). The same is also said with regard to the other colour kasinas.   'covetousness' is a synonym of lobha (s. mla) and tanha^ (q.v.) and is the 8th link of the unwholesome courses of action (s. kamma-patha, I).   a Sutta term for rebirth; s. punabbhava.   The 6 'higher powers', or supernormal knowledge's, ... 
The 6 'higher powers', or supernormal knowledge's, consist of 5 mundane (lokiya, q.v.) powers attainable through the utmost perfection in mental concentration (sama^dhi, q.v.) and one supermundane (lokuttara, q.v.) power attainable through penetrating insight (vipassana^, q.v.), i.e. extinction of all cankers (a^savakkhaya; s. a^sava), in other words, realization of Arahatship or Holiness. 
They are: 
(1) magical powers (iddhi-vidha),  
(2) divine ear (dibba-sota),  
(3) penetration of the minds of others (ceto-pariya-n~a^na),  
(4) remembrance of former existences (pubbe-niva^sa^nussati),  
(5) divine eye (dibba-cakkhu),  
(6) extinction of all cankers (a^savakkhaya).  
The stereotype text met with in all the 4 Sutta-collections (e.g. D.34; M.4, M.6, M.77; A.III.99; A.V.23; S.15.9 and Pug.271, Pug.239) is as follows:
(1) "Now, O Bhikkhus, the monk enjoys the various magical powers (iddhi-vidha), such as being one he becomes manifold, and having become manifold he again becomes one. He appears and disappears. Without being obstructed he passes through walls and mountains, just as if through the air. In the earth he dives and rises up again, just as if in the water. He walks on water without sinking, just as if on the earth. Cross-legged he floats through the air, just like a winged bird. With his hand he touches the sun and moon, these so mighty ones, so powerful ones. Even up to the Brahma-world he has mastery over his body. 
(2) "With the divine ear (dibba-sota) he hears sounds both heavenly and human, far and near. 
(3) "He knows the minds of other beings (parassa ceto-pariya-n~a^na), of other persons, by penetrating them with his own mind. He knows the greedy mind as greedy and the not-greedy one as not greedy; knows the hating mind as hating and the not-hating one as not hating; knows the deluded mind as deluded and the not-deluded one as not deluded; knows the shrunken mind and the distracted one, the developed mind and the undeveloped one, the surpassable mind and the unsurpassable one, the concentrated mind and the unconcentrated one, the freed mind and the unfreed one. 
(4) "He remembers manifold former existences (pubbe-niva^sa^nussati), such as one birth, two, three, four and five births .... hundred thousand births; remembers many formations and dissolutions of worlds: 'There I was, such name I had .... and vanishing from there I entered into existence somewhere else .... and vanishing from there I again reappeared here.' Thus he remembers, always together with the marks and peculiarities, many a former existence . 
(5) ''With the divine eye (dibba-cakkhu = yatha^-kammpaga-n~a^na or cutpapa^ta-n~a^na), the pure one, he sees beings vanishing and reappearing, low and noble ones, beautiful and ugly ones, sees how beings are reappearing according to their deeds (s. karma): 'These beings, indeed, followed evil ways in bodily actions, words and thoughts, insulted the noble ones, held evil views, and according to their evil views they acted. At the dissolution of their body, after death, they have appeared in lower worlds, in painful states of existence, in the world of suffering, in hell. Those other beings, however, are endowed with good action .... have appeared in happy state of existence, in a heavenly world. 
(6) "Through the extinction of all cankers (a^savakkhaya) even in this very life he enters into the possession of deliverance of mind, deliverance through wisdom, after having himself understood and realized it.'' 
4-6 appear frequently under the name of the 'threefold (higher) knowledge' (te-vijja^, q.v.). They are, however, not a necessary condition for the attainment of sainthood (arahatta), i.e. of the sixth abhin~n~a^.
Vis.M. XI-XIII gives a detailed explanation of the 5 mundane higher powers, together with the method of attaining them.
In connection with the 4 kinds of progress (s. patipada^), abhin~n~a^ means the 'comprehension' achieved on attainment of the paths and fruitions.  'morality consisting in good behaviour', ... 
'morality consisting in good behaviour', 
relates to the external duties of a monk such as towards his superior, etc. 
"abhisama^ca^rika si^la is a name for those moral rules other than the 8 ending with right livelihood (i.e. 4-fold right speech, 3-fold right action and right livelihood, as in the Eightfold Path) (Vis.M. I; s. sacca IV, 3-5). 
"Impossible is it, o monks, that without having fulfilled the law of good behaviour, a monk could fulfil the law of genuine pure conduct" (A.V.21). 
Cf. a^dibrahmacariyakasi^la.   'truth-realization', ... 
is the full and direct grasp of the Four Noble Truths by the Stream-winner (Sota^panna; s. ariya-puggala). 
In the Com. the term is represented by 'penetration' (pativedha, q.v.). Frequently occurring as dhamma^bhisamaya, 'realization of the doctrine' 
Cf. S. XIII (Abhisamaya Samyutta) and Pts.M. (Abhisamaya Katha^).   identical with the 2nd link of the paticca-samuppa^da (q.v.), sankha^ra (q.v.; under I, 1) or karmaformations .  cf. ugghatitan~n~, vipacitan~n~ neyya.   viha^ra (q.v.). The 4 Divine a.: brahma-viha^ra (q.v.) The 9 a. of beings: satta^va^sa (q.v.).   natthi-paccaya, is one of the 24 conditions (paccaya, (q.v.).   s. jha^na.   the 3: virati (q.v.).   Moment of: s. javana.  s. sama^dhi.  (of Karma): a^yhana (q.v.).  habitual karma; s. karma.   lit. 'That which cannot or should not be thought, the unthinkable, ... 
lit. 'That which cannot or should not be thought, the unthinkable, incomprehensible, impenetrable, that which transcends the limits of thinking and over which therefore one should not ponder. 
These 4 unthinkables are: 
the sphere of a Buddha (buddha-visaya),  
of the meditative absorptions (jha^na-visaya),  
of karma-result (kamma-vipa^ka), and  
brooding over the world (loka-cinta^), especially over an absolute first beginning of it  
(s. A.IV.77).
"Therefore, o monks, do not brood over the world as to whether it is eternal or temporal, limited or endless .... Such brooding, O monks, is senseless, has nothing to do with genuine pure conduct (s. a^dibrahmacariyaka-si^la), does not lead to aversion, detachment, extinction, nor to peace, to full comprehension, enlightenment and Nibba^na, etc." (S.56.41).  image (during concentration): s. nimitta, sama^dhi, kasina.   karma (q.v.) - Right bodily a.: samma^-kammanta; s. sacca (IV.4)  (of body, mental factors and consciousness): kamman~n~ata^ (q.v.); cf. khandha (corporeality) and Tab. II.  anuloma-n~a^na (q.v.).   para^ma^sa (q.v.)   upa^saka (q.v.)  sikkha^ 'training in higher mentality'; s. sikkha^.   'determination', decision, resolve ... 
'determination', decision, resolve: 
is one of the mental concomitants (cetasika) and belongs to the group of mental formations (sankha^ra-kkhandha). 
In M.111, it is mentioned together with other mental concomitants. 
See Tab. II, III.  'insight into things based on higher wisdom', is one of the 18 chief kinds of insight (s. vipassana^).  'predominance-condition' is one of the 24 conditions (paccaya, q.v.); if developed, it is considered as the fourfold road to power (iddhi-pa^da. q.v.).  'training in higher morality': s. sikkha^.   Determination ... 
as a doctrinal term, occurs chiefly in two meanings:
1. 'Foundation': four 'foundations' of an Arahat's mentality, mentioned and explained in M. 140: the foundation of wisdom (pan~n~a^), of truthfulness (sacca) of liberality (ca^ga) and of peace (upasama). See also D. 33 and Com.
2. 'Determination', resolution, in: adhittha^na-iddhi, 'magical power of determination' (s. iddhi); adhittha^na-pa^rami^, 'perfection of resolution' (s. pa^rami^).  'morality of genuine pure conduct', ... 
'morality of genuine pure conduct', 
consists in right speech, right bodily action and right livelihood, forming the 3rd, 4th and 5th links of the Eightfold Path (s. sacca, IV.3, 4, 5); cf. Vis.M. I. 
In A. II, 86 it is said:
"With regard to those moral states connected with and corresponding to the genuine pure conduct, he is morally strong, morally firm and trains himself in the moral rules taken upon himself. After overcoming the 3 fetters (ego-belief. sceptic doubt and attachment to mere rules and ritual; s. samyojana) he becomes one who will be 'reborn seven times at the utmost' (s. Sota^panna) and after only seven times more wandering through this round of rebirths amongst men and heavenly beings, he will put an end to suffering."  'knowledge consisting in contemplation of misery', ... 
'knowledge consisting in contemplation of misery', 
is one of the 8 kinds of insight (vipassana^) that form the 'purification of the knowledge and vision of the path-progress (s. visuddhi, VI. 4). 
It is further one of the 18 chief kinds of insight (s. vipassana^).   'hatelessness, is one of the 3 wholesome roots (mla, q.v.).  'feeling which is neither painful nor joyful', i.e. indifferent feeling; s. khandha, vedana^.  (of mind to the object): a^vajjana, is one of the functions of consciousness (vin~n~a^na-kicca, q.v.). Cf. manasika^ra.   kappa (q.v.).   the 4 'wrong paths' ... 
the 4 'wrong paths' are: 
the path of greed (chanda),  
of hate,  
of delusion,  
of cowardice (bhaya).  
"One who is freed from evil impulses is no longer liable to take the wrong path of greed, etc.'' (A.IV.17; A.IX.7).   Old: jara^ (q.v.).   khandha (q.v.).   lahuta^ (q.v.).   'nutriment', 'food', ... 
'nutriment', 'food', 
is used in the concrete sense as material food and as such it belongs to derived corporeality (s. khandha, Summary I.) 
In the figurative sense, as 'foundation' or condition, it is one of the 24 conditions (paccaya, q.v.) and is used to denote 4 kinds of nutriment, which are material and mental: 
material food (kabalinka^ra^ha^ra),  
(sensorial and mental) impression (phassa),  
mental volition (mano-san~cetana^),  
consciousness (vin~n~a^na). 
 
Material food feeds the eightfold corporeality having nutrient essence as its 8th factor (i.e. the solid, liquid, heat, motion, colour, odour, the tastable and nutrient essence; s. rpa-kala^pa).  
Sensorial and mental impression is a condition for the 3 kinds of feeling (agreeable, disagreeable and indifferent); s. paticcasamuppa^da (6).  
Mental volition (= karma, q.v.) feeds rebirth; s. paticca-samuppa^da (2).  
Consciousness feeds mind and corporeality ;na^ma-rpa; ib., 2) at the moment of conception" (Vis.M. XI). 
Literature (on the 4 Nutriments): M. 9 & Com. (tr. in 'R. Und.'), M 38; S. XII, 11, 63, 64 - The Four Nutriments of Life, Selected texts & Com. (WHEEL 105/106).   'Food-produced corporeality'; s. samuttha^na.  'reflection on the loathsomeness of food', fully described in Vis.M. XI, l.  s. hetu.  'view of uncausedness' (of existence); s. ditthi.  s. patisandhi.   s. avihimsa^.  'lack of moral shame and dread', ... 
are two of the 4 unwholesome factors associated with all karmically unwholesome states of consciousness, the two others being restlessness (uddhacca) and delusion (moha). Cf. Tab. II.
"There are two sinister things, namely, lack of moral shame and dread, etc." (A.II.6). "Not to be ashamed of what one should be ashamed of; not to be ashamed of evil, unwholesome things: this is called lack of moral shame" (Pug. 59). "Not to dread what one should dread ... this is called lack of moral dread (Pug. 60).  'ineffective karma'; s. karma.   'livelihood'. About right and wrong livelihood., s. sacca (IV. 5) and miccha^-magga (5).  'morality consisting in purification of livelihood', is one of the 4 kinds of perfect morality; s. si^la.   the 'Great Ones', i.e. 'Highest Gods', are the inhabitants of the 5th and highest heaven of the Pure Abodes (suddha^va^sa, q.v.); cf. avacara, deva (II) Ana^ga^mi^.   'space', ... 
'space', is, according to Com., of two kinds: 
limited space (paricchinna^ka^sa or pariccheda^ka^sa),  
endless space (ananta^ka^sa), i.e. cosmic space. 
1. Limited space, under the name of a^ka^sa-dha^tu (space element), belongs to derived corporeality (s. khandha, Summary I; Dhs 638) and to a sixfold classification of elements (s. dha^tu; M.112, M.115, M.140). It is also an object of kasina (q.v.) meditation. It is defined as follows: "The space element has the characteristic of delimiting matter. Its function is to indicate the boundaries of matter. It is manifested as the confines of matter; or its manifestation consists in being untouched (by the 4 great elements), and in holes and apertures. Its proximate cause is the matter delimited. It is on account of the space element that one can say of material things delimited that 'this is above. below, around that' " (Vis.M. XIV.63).
2. Endless space is called in Atthasa^lini ajata^ka^sa, 'unentangled', i.e. unobstructed or empty space. It is the object of the first immaterial absorption (s. jha^na), the sphere of boundless space (a^ka^sa^nan~ca^yatana). According to Abhidhamma philosophy, endless space has no objective reality (being purely conceptual), which is indicated by the fact that it is not included in the triad of the wholesome (kusalatika), which comprises the entire reality. Later Buddhist schools have regarded it as one of several unconditioned or uncreated states (asankhata dharma) - a view that is rejected in Kath. (s. Guide. p. 70). Therava^da Buddhism recognizes only Nibba^na as an unconditioned element (asankhata-dha^tu: s. Dhs. 1084).  'space element'; see above and dha^tu.  kasina 'space-kasina exercise'; s. kasina.   'sphere of boundless space', is identical with the 1st absorption in the immaterial sphere; s. jha^na (6).  s. ceto-vimutti.   s. jha^na (7).  view of the inefficacy of action'; s. ditthi.  cf. ceto-vimutti.  'unshakable', ... 
'unshakable', is one who has attained full mastery over the absorptions (jha^na, q.v.). 
In Pug. 4 it is said:
'What person is unshakable? If a person gains the meditative attainments of the fine-material and immaterial sphere (rpa^vacara-arpa^vacara); and he gains them at his wish, without toil and exertion; and according to his wish, as regards place, object and duration, enters them or arises from them, then it is impossible that in such a person the attainments may become shaken through negligence. This person is unshakable."   'unwholesome', ... 
are all those karmic volitions (kamma-cetana^; s. cetana^) and the consciousness and mental concomitants associated therewith, which are accompanied either by greed (lobha) or hate (dosa) or merely delusion (moha); and all these phenomena are causes of unfavourable karma-results and contain the seeds of unhappy destiny or rebirth. 
Cf. karma, paticca-samuppa^da (1), Tab. II.  'general unwholesome mental factors ... 
'general unwholesome mental factors associated with all unwholesome actions' (volitions), are four: 
(1) lack of moral shame (ahirika),  
(2) lack of moral dread (anottappa),  
(3) restlessness (uddhacca),  
(4) delusion (moha).  
For (1) and (2) s. ahirika-anottappa, for (3) s. ni^varana, for (4) mla. (App.).
The corresponding term in the field of wholesome consciousness is sobhana- sa^dha^rana-cetasika (s. sobhana).  'unwholesome thoughts' ... 
'unwholesome thoughts' 
as defined under akusala (q.v.). In M. 20, five methods of overcoming them are given: 
by changing the object,  
thinking of the evil results,  
paying no attention,  
analysing,  
suppressing. 
Tr. in The Removal of Distracting Thoughts (WHEEL 21).  s. sura^meraya-majja-ppama^dattha^na^ etc.   vow of going for; or to do so without omitting any house: s. dhutanga, 3, 4.  bowl eater, the practice of the: s. dhutanga.  da^na (q.v.).  goer, the practice of the; s. dhutanga.   'greedlessness', is one of the 3 karmically wholesome roots (mla, q.v.).  'light-kasina-exercise'; s. kasina.  'perception of light'. ... 
The recurring canonical passage reads: 
"Here the monk contemplates the perception of light. He fixes his-mind to the perception of the day; as at day-time so at night, and as at night, so in the day. In this way, with a mind clear and unclouded, he develops a stage of mind that is full of brightness." 
It is one of the methods of overcoming drowsiness, recommended by the Buddha to Maha^-Moggalla^na (A.VII. 58). According to D. 33, it is conducive to the development of 'knowledge and vision' (s. visuddhi), and it is said to be helpful to the attainment of the 'divine eye' (s. abhin~n~a^).  mudita^, is one of the 4 sublime abodes (brahmaviha^ra, q.v.).  'Deathlessness' ... 
(Sanskrit amrta; ? mr to die; = Gr. ambrosia): 'Deathlessness' 
according to popular belief also the gods' drink conferring immortality, is a name for Nibba^na (s. Nibba^na), the final liberation from the wheel of rebirths, and therefore also from the ever-repeated deaths .   'non-delusion', wisdom, is one of the 3 karmically wholesome roots (mla, q.v.).   'freedom from covetousness', unselfishness; s. kammapatha (II. 8).  s. sabba-loke anabhirati-s.   the 'Non-Returner', ... 
the 'Non-Returner', is a noble disciple (ariya-puggala, q.v.) on the 3rd stage of holiness. There are 5 classes of Non-Returners, as it is said (e.g. Pug. 42-46):
"A being, through the disappearing of the 5 lower fetters (samyojana, q.v.), reappears in a higher world (amongst the devas of the Pure Abodes, suddha^va^sa, q.v.), and without returning from that world (into the sensuous sphere) he there reaches Nibba^na.
(1) "He may, immediately after appearing there (in the Pure Abodes) or without having gone beyond half of the life-time, attain the holy path for the overcoming of the higher fetters. Such a being is called 'one who reaches Nibba^na within the first half of the life' (antara^-parinibba^yi^).
(2) "Or, whilst living beyond half of the lifetime, or at the moment of death, he attains the holy path for the overcoming of the higher fetters. Such a being is called 'one who reaches Nibba^na after crossing half the life-time' (upahacca-parinibba^yi^).
(3) "Or, with exertion he attains the holy path for the overcoming of the higher fetters. Such a being is called 'one who reaches Nibba^na with exertion' (sasankha^ra-parinibba^yi^).
(4) "Or, without exertion he attains the holy path for the overcoming of the higher fetters. Such a being is called 'one who reaches Nibba^na without exertion' (asankha^ra-parinibba^yi^).
(5) "Or, after vanishing from the heaven of the Aviha-gods (s. suddha^va^sa), he appears in the heaven of the unworried (atappa) gods. After vanishing from there he appears in the heaven of the clearly-visible (sudassa) gods, from there in the heaven of the clear-visioned (sudassi^) gods, from there in the heaven of the highest (akanittha) gods. There he attains the holy path for the overcoming of the higher fetters. Such a being is called 'one who passes up-stream to the highest gods' (uddhamsota-akanittha-ga^mi^)."  dha^tu-vavattha^na (q.v.).  vibhajja-va^da (q.v.).  knowledge, the 4 kinds of: patisambhida^ (q.v.).  is one of the 3 supermundane senses or faculties; s. indriya (20).  'proximity', is one of the 24 conditions (paccaya, q.v.).  the 5 heinous 'actions with immediate destiny'  are 
parricide,  
matricide,  
killing an Arahat (Saint),  
wounding a Buddha,  
creating schism in the monks' Order.  
In A.V. 129 it is said:
"There are 5 irascible and incurable men destined to the lower world and to hell, namely: the parricide," etc. About the 5th see A.X. 35, 38. 
With regard to the first crime, it is said in D. 2 that if King Aja^tasattu had not deprived his father of life, he would have reached entrance into the path of Stream-entry (App.).   the 'Immediacy', ... 
the 'Immediacy', is a name for that concentration of mind which is associated with such insight (vipassana^, q.v.) as is present in any one of the 4 kinds of supermundane path consciousness (s. ariya-puggala), and which therefore is the cause of the immediately following consciousness as its result or 'fruition' (phala, q.v.). 
According to the Abhidhamma, the path (of the Sota^panna, etc.) is generated by the insight into the impermanence, misery and impersonality of existence, flashing up at that very moment and transforming and ennobling one's nature forever.
It is mentioned under the name of a^nantarika-sama^dhi in the Ratana Sutta (Sn.v.22) and in Pts.M.1, n~a^nakatha^.  'mindfulness on in-and-out-breathing', i... 
is one of the most important exercises for reaching mental concentration and the 4 absorptions (jha^na, q.v.).
In the Satipattha^na Sutta (M. 10, D. 22) and elsewhere, 4 methods of practice are given, which may also serve as basis for insight meditation. The 'Discourse on Mindfulness of Breathing' (a^na^pa^nasati Sutta, M. 118) and other texts have 16 methods of practice, which divide into 4 groups of four. The first three apply to both tranquillity (samatha, q.v.) and insight-meditation, while the fourth refers to pure insight practice only. The second and the third group require the attainment of the absorptions.
"With attentive mind he breathes in, with attentive mind he breathes out.
I. (1) "When making a long inhalation he knows: 'I make a long inhalation'; when making a long exhalation he knows: 'I make a long exhalation.'
(2) "When making a short inhalation he knows: 'I make a short inhalation'; when making a short exhalation he knows: 'I make a short exhalation.'
(3) " 'Clearly perceiving the entire (breath-) body I will breathe in,' thus he trains himself; 'clearly perceiving the entire (breath-) body I will breathe out,' thus he trains himself.
(4) " 'Calming this bodily function I will breathe in,' thus he trains himself; 'calming this bodily function I will breathe out,' thus he trains himself.
II. (5) " 'Feeling rapture (pi^ti) I will breathe in,' thus he trains himself; 'feeling rapture I will breathe out,' thus he trains himself.
(6) " 'Feeling joy I will breathe in,' thus he trains himself; 'feeling joy I will breathe out,' thus he trains himself.
(7) " 'Feeling the mental formation (citta-sankha^ra) I will breathe in,' thus he trains himself, 'feeling the mental formation I will breathe out,' thus he trains himself.
(8) " 'Calming the mental formation I will breathe in,' thus he trains himself; 'calming the mental formation I will breathe out,' thus he trains himself.
III. (9) " 'Clearly perceiving the mind (citta) I will breathe in,' thus he trains himself; 'clearly perceiving the mind I will breathe out,' thus he trains himself.
(10) " 'Gladdening the mind I will breathe in,' thus he trains himself; 'gladdening the mind I will breathe out,' thus he trains himself.
(11) " 'Concentrating the mind I will breathe in, thus he trains himself; 'concentrating the mind I will breathe out', thus he trains himself.
(12) " 'Freeing the mind I will breathe in,' thus he trains himself; 'freeing the mind I will breathe out,' thus he trains himself
IV. (13) " 'Reflecting on impermanence (anicca) I will breathe in,' thus he trains himself; 'reflecting on impermanence I will breathe out,' thus he trains himself.
(14) " 'Reflecting on detachment (vira^ga) I will breathe in,' thus he trains himself; 'reflecting on detachment I will breathe out,' thus he trains himself.
(15) " 'Reflecting on extinction (nirodha) I will breathe in,' thus he trains himself; 'reflecting on extinction I will breathe out,' thus he trains himself.
(16) " 'Reflecting on abandonment (patinissagga) I will breathe in, thus he trains himself; 'reflecting on abandonment I will breathe out,' thus he trains himself."
In M. 118 it is further shown how these 16 exercises bring about the 4 foundations of mindfulness (satipattha^na, q.v.), namely: 
1-4 contemplation of the body,  
5-8 contemplation of feeling,  
9-12 contemplation of mind (consciousness),  
13-16 contemplation of mind-objects. 
 Then it is shown how these 4 foundations of mindfulness bring about the 7 factors of enlightenment (bojjhanga, q.v.); then these again deliverance of mind (ceto-vimutti, q.v.) and deliverance through wisdom (pan~n~a^-vimutti, q.v.). 
Literature: a^na^pa^nasati Samyutta (S. LIV). -  
Pts.M. a^na^pa^nakatha^ - Full explanation of practice in Vis.M. VIII, 145ff. -  
For a comprehensive anthology of canonical and commentarial texts, see Mindfulness of Breathing, n~a^namoli Thera (Kandy: BPS, 1964).   'not-self', non-ego, egolessness, impersonality, ... 
is the last of the three characteristics of existence (ti-lakkhana, q.v.) The anatta^ doctrine teaches that neither within the bodily and mental phenomena of existence, nor outside of them, can be found anything that in the ultimate sense could be regarded as a self-existing real ego-entity, soul or any other abiding substance. 
This is the central doctrine of Buddhism, without understanding which a real knowledge of Buddhism is altogether impossible. It is the only really specific Buddhist doctrine, with which the entire Structure of the Buddhist teaching stands or falls. All the remaining Buddhist doctrines may, more or less, be found in other philosophic systems and religions, but the anatta^-doctrine has been clearly and unreservedly taught only by the Buddha, wherefore the Buddha is known as the anatta^-va^di, or 'Teacher of Impersonality'. 
Whosoever has not penetrated this impersonality of all existence, and does not comprehend that in reality there exists only this continually self-consuming process of arising and passing bodily and mental phenomena, and that there is no separate ego-entity within or without this process, he will not be able to understand Buddhism, i.e. the teaching of the 4 Noble Truths (sacca, q.v.), in the right light. He will think that it is his ego, his personality, that experiences suffering, his personality that performs good and evil actions and will be reborn according to these actions, his personality that will enter into Nibba^na, his personality that walks on the Eightfold Path. Thus it is said in Vis.M. XVI:
 
"Mere suffering exists, no sufferer is found; 
The deeds are, but no doer of the deeds is there; 
Nibba^na is, but not the man that enters it; 
The path is, but no traveler on it is seen." 
 
"Whosoever is not clear with regard to the conditionally arisen phenomena, and does not comprehend that all the actions are conditioned through ignorance, etc., he thinks that it is an ego that understands or does not understand, that acts or causes to act, that comes to existence at rebirth .... that has the sense-impression, that feels, desires, becomes attached, continues and at rebirth again enters a new existence" (Vis.M. XVII. 117).
While in the case of the first two characteristics it is stated that all formations (sabbe sankha^ra^) are impermanent and subject to suffering, the corresponding text for the third characteristic states that "all things are not-self" (sabbe dhamma^ anatta^; M. 35, Dhp. 279). This is for emphasizing that the false view of an abiding self or substance is neither applicable to any 'formation' or conditioned phenomenon, nor to Nibba^na, the Unconditioned Element (asankhata^ dha^tu).
The Anatta^-lakkhana Sutta, the 'Discourse on the Characteristic of Not-self', was the second discourse after Enlightenment, preached by the Buddha to his first five disciples, who after hearing it attained to perfect Holiness (arahatta).
The contemplation of not-self (anatta^nupassana^) leads to the emptiness liberation (sun~n~ata^-vimokkha, s. vimokkha). Herein the faculty of wisdom (pan~n~indriya) is outstanding, and one who attains in that way the path of Stream-entry is called a Dhamma-devotee (dhamma^nusa^ri; s. ariya-puggala); at the next two stages of sainthood he becomes a vision-attainer (ditthippatta); and at the highest stage, i.e. Holiness, he is called 'liberated by wisdom' (pan~n~a^-vimutta).
For further details, see paramattha-sacca, paticca-samuppa^da, khandha, ti-lakkhana, na^ma-rpa, patisandhi.
Literature: Anatta^-lakkhana Sutta, Vinaya I, 13-14; S.22. 59; tr. in Three Cardinal Discourses of the Buddha (WHEEL 17). -  
Another important text on Anatta^ is the Discourse on the Snake Simile (Alagaddpama Sutta, M. 22; tr. in WHEEL 48/49) .  
Other texts in "Path". - Further: Anatta^ and Nibba^na, by Nyanaponika Thera (WHEEL 11);  
The Truth of Anatta^, by Dr. G. P. Malalasekera (WHEEL 94);  
The Three Basic Facts of Existence III: Egolessness (WHEEL 202/204)   'contemplation of not-self' is one of the 18 chief kinds of insight (s. vipassana^). See also above.  'perception of not-self'; see A.VI.104; A.VII.48; A.X.60; Ud.IV.1.  the 'doctrine of impersonality'; s. anatta^.   'imperturbability', denotes the immaterial sphere (arpa^vacara; s. avacara); s. sankha^ra. cf. M.106.   s. mla.   'impermanent' (or, as abstract noun, aniccata^, 'impermanence') ... 
is the first of the three characteristics of existence (tilakkhana, q.v.). It is from the fact of impermanence that, in most texts, the other two characteristics, suffering (dukkha) and not-self (anatta^), are derived (S.22. 15; Ud.IV. I)
"Impermanence of things is the rising, passing and changing of things, or the disappearance of things that have become or arisen. The meaning is that these things never persist in the same way, but that they are vanishing dissolving from moment to moment" (Vis.M. VII, 3).
Impermanence is a basic feature of all conditioned phenomena, be they material or mental, coarse or subtle, one's own or external: All formations are impermanent" (sabbe sankha^ra^ anicca^; M. 35, Dhp. 277). That the totality of existence is impermanent is also often stated in terms of the five aggregates (khandha, q.v.), the twelve personal and external sense bases (a^yatana q.v.), etc. Only Nibba^na (q.v.), which is unconditioned and not a formation (asankhata), is permanent (nicca, dhuva).
The insight leading to the first stage of deliverance, Stream-entry (sota^patti; s. ariya-puggala), is often expressed in terms of impermanence: "Whatever is subject to origination, is subject to cessation" (s. Dhammacakkappavattana Sutta, S.46. 11). In his last exhortation, before his Parinibba^na, the Buddha reminded his monks of the impermanence of existence as a spur to earnest effort: "Behold now, Bhikkhus, I exhort you: Formations are bound to vanish. Strive earnestly!" (vayadhamma^ sankha^ra^, appama^dena sampa^detha; D. 16).
Without the deep insight into the impermanence and insubstantiality of all phenomena of existence there is no attainment of deliverance. Hence comprehension of impermanence gained by direct meditative experience heads two lists of insight knowledge: 
(a) contemplation of impermanence (anicca^nupassana^) is the first of the 18 chief kinds of insight (q.v.);  
(b) the contemplation of arising and vanishing (udayabbaya^nupassana^-n~a^na) is the first of 9 kinds of knowledge which lead to the 'purification by knowledge and vision of the path-progress' (s. visuddhi, VI). -  
Contemplation of impermanence leads to the conditionless deliverance (animitta-vimokkha; s. vimokkha). As herein the faculty of confidence (saddhindriya) is outstanding, he who attains in that way the path of Stream-entry is called a faith-devotee (saddha^nusa^ri^; s. ariya-puggala) and at the seven higher stages he is called faith-liberated (saddha^-vimutta), - See also anicca-san~n~a^.
See The Three Basic Facts of Existence I: Impermanence (WHEEL 186/187)   'contemplation of impermanence', is one of the 18 chief kinds of insight (s. vipassana^).  'perception of impermanence', ... 
'perception of impermanence', is defined in the Girimananda Sutta (A.X. 60) as meditation on the impermanence of the five groups of existence.
"Though, with a faithful heart, one takes refuge in the Buddha, his Teaching and the Community of Monks; or with a faithful heart observes the rules of morality, or develops a mind full of loving-kindness, far more meritorious it is if one cultivates the perception of impermanence, be it only for a moment" (A.X. 20).
See A.VI. 102; A.VII. 48; Ud.IV. 1; S.22. 102.  s. ceto-vimutti.   s. vipassana^.  s. vimokkha.   'other', being of the opposite category.   'highest knowledge', gnosis, refers to the perfect knowledge of the Saint (Arahat; s. ariya-puggala). The following passage occurs frequently in the Suttas, when a monk indicates his attainment of Holiness (arahatta): "He makes known highest knowledge (an~n~am vya^karoti), thus: 'Rebirth has ceased, fulfilled is the holy life, the task is accomplished, and there is no more of this to come.' "
The 'faculty of highest knowledge' (an~n~' indriya = an~n~a^-indriya; s. indriya), however, is present in six of the eight stages of holiness, that is, beginning with the fruition of Stream-Winning (sota^patti-phala) up to the path of Holiness (arahatta-magga). See Dhs. (PTS) 362-364, 505, 553; Indriya Vibhanga; "Path" 162.  'mutuality-condition,' is one of the 24 conditions (paccaya, q.v.).   'the faculty of one who knows'; s. indriya, 22.   'the faculty of highest knowledge'; s. an~n~a^ and indriya, 21.   s. ahirika.  4 ways of: s. pan~ha^-bya^karana.  is one of the 5 kinds of Non-Returners or Ana^ga^mi^ (q.v.).   s. ditthi.  'adaptation-moment of consciousness', denotes the third of the 4 moments of impulsion (javana, q.v.) flashing up immediately before either reaching the absorptions (jha^na, q.v.) or the supermundane paths (s. ariya-puggala). These 4 moments of impulsion are: the preparation (parikamma), access (upaca^ra), adaptation (anuloma) and maturity (gotrabh) moments. For further details, s. javana, gotrabh.  'adaptation-knowledge' or conformity-knowledge, is identical with the 'adaptation-to-truth knowledge', the last of 9 insight-knowledges (vipassana^-n~a^na) which constitute the purification of knowledge and vision of the path-progress' (s. visuddhi VI, 9). Cf. Vis.M. XXI.  see Nibba^na, upa^di.   'contemplation' - 4 fold: s. satipattha^na - 18 fold: s. vipassana^. - 7 fold: "The seven contemplation's: (1) Contemplating (formations) as impermanent, one abandons the perception of permanence. (2) Contemplating (them) as painful, one abandons the perception of happiness (to be found in them). (3) Contemplating (them) as not self, one abandons the perception of self. (4) Becoming dispassionate, one abandons delighting. (5) Causing fading away, one abandons greed. (6) Causing cessation, one abandons originating. (7) Relinquishing, one abandons grasping" (Pts.M. I, p. 58). - See also Vis.M. XXI, 43; XXII, 114.  The 9 'successive extinctions', are the 8 extinctions reached through the 8 absorptions (jha^na, q.v.) and the extinction of feeling and perception' (s. nirodha-sama^patti), as it is said in A. IX, 31 and D. 33:
"In him who has entered the 1st absorption, the sensuous perceptions (ka^ma-san~n~a^) are extinguished. Having entered the 2nd absorption, thought-conception and discursive thinking (vitakkavica^ra, q.v.) are extinguished. Having entered the 3rd absorption, rapture (pi^ti, q.v.) is extinguished. Having entered the 4th absorption, in-and-out breathing (assa^sa-passa^sa, q.v.) are extinguished. Having entered the sphere of boundless space (a^ka^sa^nan~ca^yatana), the corporeality perceptions (rpa-san~n~a^) are extinguished. Having entered the sphere of boundless consciousness (vin~n~a^nan~ca^yatana), the perception of the sphere of boundless space is extinguished. Having entered the sphere of nothingness (a^kin~can~n~a^yatana), the perception of the sphere of boundless consciousness is extinguished. Having entered the sphere of neither-perception-nor-non-perception (neva-san~n~a^-na^san~n~a^yatana) the perception of the sphere of nothingness is extinguished. Having entered the extinction of perception and feeling (san~n~a^vedayitanirodha) perception and feeling are extinguished." For further details, s. jha^na, nirodha-sama^patti.  the 9 'successive abodes', are identical with the 9 anupubba-nirodha (s. above). In A. IX, 33 they are called successive attainments (anupubba-sama^patti).  'gradual instruction', progressive sermon; given by the Buddha when it was necessary to prepare first the listener's mind before speaking to him on the advanced teaching of the Four Noble Truths. The stock passage (e.g. D. 3; D 14; M. 56) runs as follows:
"Then the Blessed One gave him a gradual instruction - that is to say, he spoke on liberality ('giving', da^na, q.v.), on moral conduct (si^la) and on the heaven (sagga); he explained the peril, the vanity and the depravity of sensual pleasures, and the advantage
of renunciation. When the Blessed One perceived that the listener's mind was prepared, pliant, free from obstacles, elevated and lucid; then he explained to him that exalted teaching particular to the Buddhas (buddha^nam sa^mukkamsika^ desana^), that is: suffering, its cause, its ceasing, and the path."  the 'effort to maintain' wholesome states; s. padha^na.   the 7 'proclivities', inclinations, or tendencies are: sensuous greed (ka^ma-ra^ga, s. samyojana), grudge (patigha), speculative opinion (ditthi, q.v.), sceptical doubt (vicikiccha^, q.v.), conceit (ma^na, q.v.), craving for continued existence (bhavara^ga), ignorance (avijja^, q.v.) (D. 33; A. VII, 11, 12).
"These things are called 'proclivities' since, in consequence of their pertinacity, they ever and again tend to become the conditions for the arising of ever new sensuous greed, etc.'' (Vis.M. XXII, 60).
Yam. VII, first determines in which beings such and such proclivities exist, and which proclivities, and with regard to what, and in which sphere of existence. Thereafter it gives an explanation concerning their overcoming, their penetration, etc. Cf. Guide VI (vii). According to Kath. several ancient Buddhist schools erroneously held the opinion that the anusayas, as such, meant merely latent, hence karmically neutral qualities, which however Contradicts the Therava^da conception. Cf. Guide V, 88, 108, 139.   'recollection', meditation, contemplation. The six recollections often described in the Suttas (e.g. A. VI, 10, 25; D. 33) are: (1) recollection of the Buddha, (2) his Doctrine, (3) his Community of noble disciples, (4) of morality, (5) liberality, (6) heavenly beings (buddha^nussati, dhamma^nussati, sangha^nussati, si^la^nussati, ca^ga^nussati, devata^nussati).
(1) "The noble disciple, Maha^na^ma, recollects thus: 'This Blessed One is holy, a fully Enlightened One, perfected in wisdom and conduct, faring happily, knower of the worlds, unsurpassed leader of men to be trained, teacher of heavenly beings and men, a Buddha, a Blessed One.'
(2) 'Well proclaimed by the Blessed One is the Doctrine (dhamma), directly visible, with immediate fruit, inviting investigation, leading on to Nibba^na, to be comprehended by the wise, each by himself.'
(3) 'Of good conduct is the Community (Sangha) of the Blessed One's disciples, of upright conduct, living on the right path, performing their duties, to wit: the 4 pairs of men or 8 individuals (s. ariya puggala). This Community of the Blessed One's disciples is worthy of offerings, worthy of hospitality, worthy of gifts, worthy of reverence with raised hands, the unsurpassed field for doing meritorious deeds.'
(4) "The noble disciple further recollects his own morality (si^la) which is unbroken, without any breach, undefiled, untarnished, conducive to liberation, praised by the wise, not dependent (on craving or opinions), leading to concentration.
(5) "The noble disciple further recollects his own liberality (ca^ga) thus: 'Blessed truly am I, highly blessed am I who, amongst beings defiled with the filth of stinginess, live with heart free from stinginess, liberal, open-handed, rejoicing in giving, ready to give anything asked for, glad to give and share with others.'
(6) "The noble disciple further recollects the heavenly beings (devata^): 'There are the heavenly beings of the retinue of the Four Great Kings, the heavenly beings of the World of the Thirty-Three, the Ya^madevas ... and there are heavenly beings besides (s. deva). Such faith, such morality, such knowledge, such liberality, such insight, possessed of which those heavenly beings, after vanishing from here, are reborn in those worlds, such things are also found in me.' " (A. III,70; VI,10; XI,12).
"At the time when the noble disciple recollects the Perfect One ... at such a time his mind is neither possessed of greed, nor of hate, nor of delusion. Quite upright at such a time is his mind owing to the Perfect One ... With upright mind the noble disciple attains understanding of the sense, understanding of the law, attains joy through the law. In the joyous one rapture arises. With heart enraptured, his whole being becomes stilled. Stilled within his being, he feels happiness; and the mind of the happy one becomes firm. Of this noble disciple it is said that amongst those gone astray, he walks on the right path, among those suffering he abides free from suffering. Thus having reached the stream of the law, he develops the recollection of the Enlightened One...." (A. VI, 10).
In A. I, 21 (PTS: I, xvi) and A. I, 27 (PTS: xx. 2) another 4 recollections are added: mindfulness on death (marana-sati, q.v.), on the body (ka^yagata^-.sati, q.v.), on breathing (a^na^pa^na-sati, q.v.), and the recollection of peace (upasama^nussati, q.v.).
The first six recollections are fully explained in Vis.M. VII, the latter four in Vis.M. VIII.  'karma bearing fruits in later births'; s. karma.  'incapable of relapse', or 'of falling away', namely, with regard to deliverance from some or all fetters of existence (s. samyojana). Thus all noble disciples are called, i.e. all those who have attained any of the 4 noble paths to holiness (s. ariyapuggala). With regard to the absorptions (jha^na, q.v.), anyone is called 'unrelapsable' who has attained full mastery over the absorptions. See A. VI, 62; Pug. 6. Cf. akuppa-dhamma.  'conditions of welfare' (lit. of non-decline), for a nation. Seven such conditions are mentioned in the Maha^-Parinibba^na Sutta (D. 16). They are followed by five sets of 7, and one set of 6 conditions, conducive to the welfare of the Community of Monks, the Sangha. Identical texts at A. VII, 20-25. To be distinguished from the preceding term.   The 4 'lower worlds'. are: the animal world, ghost world, demon-world, hell. See Vis.M. XIII, 92f.  'water-element'; s. dha^tu.   'zeal', non-laxity, earnestness, diligence, is considered as the foundation of all progress.
Just as all the footprints of living beings are surpassed by the footprint of the elephant, and the footprint of the elephant is considered as the mightiest amongst them, just so have all the meritorious qualities zeal as their foundation, and zeal is considered as the mightiest of these qualities'' (A. X, 15).
Cf. the Chapter on Zeal (Appama^da Vagga) in Dhp., and the Buddha's last exhortation: "Transient are all formations. Strive zealously!" (appama^dena sampa^detha: D. 16) - In the commentaries, it is often explained as the presence (lit. 'non-absence') of mindfulness (satiya^ avippava^sa).   a kind of heavenly being; s. deva, (II).  s. ceto-vimutti.  a kind of heavenly being: s. deva (II).   The 4 'Boundless States', identical with brahma-viha^ra (q.v.).  'attainment concentration' or 'full concentration' (from apeti, to fix), is the concentration existing during absorption (jha^na, q.v.), whilst the neighbourhood or access-concentration (upaca^ra-sama^dhi) only approaches the 1st absorption without attaining it; s. sama^dhi.  s. vimokkha. - Appanihita^nupassana^; s. vipassana^.   The 3: kin~cana (q.v.).   'having only few wishes', contentedness, is one of the indispensable virtues of the monk; cf. A. X. 181-190, and ariyavamsa (q.v.).   s. sankha^ra.  and arahatta magga, phala: s. ariya-puggala.   'object'. There are six: visible object, sound, odor, taste, body-impression, mind-object. The mind-object (dhamma^rammana) may be physical or mental, past, present or future, real or imaginary. The 5 sense-objects belong to the corporeality-group (rpa-kkhandha, s. khandha). They form the external foundations for the sense-perceptions, and without them no sense-perception or sense-consciousness (seeing, hearing, etc.) can arise. Cf. a^yatana, paccaya. (App: paccaya 2.).  s. paccaya.   The 'exercise of the forest-dweller', is one of the ascetic purification-exercises (dhutanga, q.v.).  and vanishing (of things). The knowledge consisting in the contemplation of; s. visuddhi (VI. 1.).  s. iddhi.  s. foll.  or simply ariya: 'Noble Ones', 'noble persons'.
(A) The 8 ,a. are those who have realized one of the 8 stages of holiness, i.e. the 4 supermundane paths (magga) and the 4 supermundane fruitions (phala) of these paths. There are 4 pairs:
1. The one realizing the path of Stream-winning (sota^pattimagga).
2. The one realizing the fruition of Stream-winning (sota^pattiphala).
3. The one realizing the path of Once-return (sakada^ga^miphala).
4. The one realizing the fruition of Once-return (sakada^ga^miphala).
5. The one realizing the path of Non-return (ana^ga^mimagga).
6. The one realizing the fruition of Non-return (ana^ga^miphala).
7. The one realizing the path of Holiness (arahatta-magga).
8. The one realizing the fruition of Holiness (arahatta-phala).
Summed up, there are 4 noble individuals (ariya-puggala): the Stream-winner (Sota^panna), the Once-Returner (Sakada^ga^mi), the Non-Returner (Ana^ga^mi^), the Holy One (Arahat).
In A. VIII,10 and A. IX, 16 the gotrabh (q.v.) is listed as the 9th noble individual.
According to the Abhidhamma, 'supermundane path', or simply 'path' (magga), is a designation of the moment of entering into one of the 4 stages of holiness - Nibba^na being the object - produced by intuitional insight (vipassana^) into the impermanence, misery and impersonality of existence, flashing forth and forever transforming one's life and nature. By 'fruition' (phala) is meant those moments of consciousness which follow immediately thereafter as the result of the path, and which in certain circumstances may repeat for innumerable times during the life-time.
(I) Through the path of Stream-winning (sota^patti-magga) one 'becomes' free (whereas in realizing the fruition, one 'is' free) from the first 3 fetters (samyojana, q.v.) which bind beings to existence in the sensuous sphere, to wit: (1) personality-belief (sakka^ya-ditthi; s. ditthi), (2) skeptical doubt (vicikiccha^, q.v.), (3) attachment to mere rules and rituals (si^labbata-para^ma^sa; s. upa^da^na).
(II) Through the path of Once-return (sakada^ga^mi-magga) one becomes nearly free from the 4th and 5th fetters, to wit: (4) sensuous craving (ka^ma-cchanda = ka^ma-ra^ga; s. ra^ga), (5) ill-will (vya^pa^da = dosa, s. mla).
(III) Through the path of Non-return (ana^ga^mi-magga) one becomes fully free from the above-mentioned 5 lower fetters.
(IV) Through the path of Holiness (arahatta-magga) one further becomes free from the 5 higher fetters, to wit: (6) craving for fine material existence (rpa-ra^ga), (7) craving for immaterial existence. (arpa-ra^ga), (8) conceit (ma^na, q.v.), (9) restlessness (uddhacca, q.v.), (10) ignorance (avijja^, q.v.).
The stereotype Sutta text runs as follows:
(I) "After the disappearance of the three fetters, the monk has won the stream (to Nibba^na) and is no more subject to rebirth in lower worlds, is firmly established, destined for full enlightenment.
(II) "After the disappearance of the three fetters and reduction of greed, hatred and delusion, he will return only once more; and having once more returned to this world, he will put an end to suffering.
(III) "After the disappearance of the five fetters he appears in a higher world, and there he reaches Nibba^na without ever returning from that world (to the sensuous sphere).
(IV) "Through the extinction of all cankers (a^sava-kkhaya) he reaches already in this very life the deliverance of mind, the deliverance through wisdom, which is free from cankers, and which he himself has understood and realized."
For the various classes of Stream-winners and Non-Returners, s. Sota^panna, Ana^ga^mi^.
(B) The sevenfold grouping of the noble disciples is as follows:
(1) the faith-devotee (saddha^nusa^ri^), (2) the faith-liberated one (saddha^vimutta), (3) the body-witness (ka^ya-sakkhi^), (4) the both-ways-liberated one (ubhato-bha^ga-vimutta), (5) the Dhamma-devotee (dhamma^nusa^ri^), (6) the vision-attainer (ditthippatta), (7) the wisdom-liberated one (pan~n~a^-vimutta). This group of seven noble disciples is thus explained in Vis.M. XXI, 73:
(1) "He who is filled with resolution (adhimokkha) and, in considering the formations as impermanent (anicca), gains the faculty of faith, he, at the moment of the path to Stream-winning (A.1) is called a faith-devotee (saddha^nusa^ri^); (2) at the seven higher stages (A. 2-8) he is called a faith-liberated one (saddha^-vimutta). (3) He who is filled with tranquillity and, in considering the formations as miserable (dukkha), gains the faculty of concentration, he in every respect is considered as a body-witness (ka^ya-sakkhi^). (4) He, however, who after reaching the absorptions of the immaterial sphere has attained the highest fruition (of Holiness), he is a both-ways-liberated one (ubhato-bha^ga-vimutta). (5) He who is filled with wisdom and, in considering the formations as not-self (anatta^), gains the faculty of wisdom, he is at the moment of Stream-winning a Dhamma-devotee (dhamma^nusa^ri^), (6) at the later stages (A. 2-7) a vision-attainer (ditthippatta), (7) at the highest stage (A. 8) a wisdom-liberated one (pan~n~a^vimutta)." - Further details about the body-witness, the both-ways-liberated one and the wisdom-liberated one, s. under the three Pa^li terms. Cf. also M. 70; A. IX, 44; S. XII, 70; Pts.M. II, p. 33, PTS.  The Four 'Noble Truths'; s. sacca.  The four 'noble usage's', are: contentedness (of the monk) with any robe, contentedness with any alms-food, contentedness with any dwelling, and delight in meditation and detachment. In the Ariya-vamsa Sutta, (A. IV , 28) and similarly in D. 33, it is said :
"Now the monk is contented with any robe, with any alms-food, with any dwelling, finds pleasure and enjoyment in mental training and detachment . But neither is he haughty on that account, nor does he look down upon others. Now, of a monk who herein is fit and indefatigable, who remains clearly conscious and mindful, of such a monk it is said that he is firmly established in the ancient, noble usage's known as the most lofty ones."
Full tr. of Ariya-vamsa Sutta in WHEEL 83/84.  s. viha^ra.  s. bhava, loka.  - s. jha^na.  The four 'immaterial groups' of existence are: feeling, perception, mental formations, consciousness; s. khandha.   s. avacara.   s. jha^na.  The 'one reaching Nibba^na without exertion', is one of the five classes of Non-Returners (Ana^ga^mi^, q.v.)  an Abhidhamma term signifying a 'state of consciousness arisen spontaneously', i. e. without previous deliberation, preparation, or prompting by others; hence: 'unprepared, unprompted'. This term and its counterpart (sasankha^rikacitta, q.v.), probably go back to a similar distinction made in the Suttas (A. IV, 171; "Path" 184). See Tab. I; examples in Vis.M. XIV, 84f.   The 'Unformed, Unoriginated, Unconditioned' is a name for Nibba^na, the beyond of all becoming and conditionality.  The 'unconscious beings', are a class of heavenly beings in the fine-material world; s. deva (II). "There are, o monks, heavenly beings known as the unconscious ones. As soon, however, as in those beings consciousness arises, those beings will vanish from that world. Now, o monks, it may happen that one of those beings after vanishing from that world, may reappear in this world...." (D. 24). Further details, s. Kath., Yam. (Guide, pp. 68, 79, 96 ff.).   (lit: influxes), 'cankers', taints, corruption's, intoxicant biases. There is a list of four (as in D. 16, Pts.M., Vibh.): the canker of sense-desire (ka^ma^sava), of (desiring eternal) existence (bhava^sava), of (wrong) views (dittha^sava), and of ignorance (avijja^sava). A list of three, omitting the canker of views, is possibly older and is more frequent in the Suttas, e.g. in M. 2, M. 9, D. 33; A. III, 59, 67; A. VI, 63. - In Vibh. (Khuddakavatthu Vibh.) both the 3-fold and 4-fold division are mentioned. The fourfold division also occurs under the name of 'floods' (ogha) and 'yokes' (yoga).
Through the path of Stream-Entry, the canker of views is destroyed; through the path of Non-Returning, the canker of sense-desire; through the path of Arahatship, the cankers of existence and ignorance. M. 2 shows how to overcome the cankers, namely, through insight, sense-control, avoidance, wise use of the necessities of life, etc. For a commentarial exposition, see Atthasa^lini Tr. I, p. 63f: II, pp. 475ff.
Khi^na^sava, 'one whose cankers are destroyed', or 'one who is canker-free', is a name for the Arahat or Holy One. The state of Arahatship is frequently called a^savakkhaya, 'the destruction of the cankers'. Suttas concluding with the attainment of Arahatship by the listeners, often end with the words: "During this utterance, the hearts of the Bhikkhus were freed from the cankers through clinging no more" (anupa^da^ya a^savehi citta^ni vimuccims'ti).   see above.  s. vuttha^na-ga^mini^-vipassana^.  s. dhutanga.   (lit.: 'not-learner'; s. sekha), a disciple 'perfected in training', one beyond training, an adept. This is a name for the Arahat, the Holy One (s. ariya-puggala), since he has reached the perfection in higher moral training, higher mind training and higher wisdom training (s. sikkha^) and needs no longer to train himself therein.  'repetition', is one of the 24 conditions (paccaya, q.v.).  (lit.: 'I am'-conceit), 'ego-conceit', may range from the coarsest pride and self-assertion to a subtle feeling of one's distinctiveness or superiority that persists, as the 8th fetter (samyojana, q.v.), until the attainment of Arahatship or Holiness. It is based upon the comparison of oneself with others, and may, therefore, manifest itself also as a feeling of inferiority or the claim to be equal (s. ma^na). It has to be distinguished from 'ego-belief' (sakka^ya-ditthi, q.v.) which implies a definite belief or view (ditthi) concerning the assumption of a self or soul, and, being the 1st of the fetters, disappears at attainment of Stream-Entry (sota^patti; s. ariya-puggala).
"Even when the five lower fetters have vanished in a noble disciple, there is still in him, with regard to the five groups of clinging, a slight undiscarded measure of the conceit 'I am', of the will 'I am', of the proclivity 'I am' " (S . XXII, 89) . - s. ma^na.  'in-and-out-breathing', are corporeal or physical functions or 'formations' (ka^ya-sankha^ra), whilst thought-conception and discursive thinking (vitakka and vica^ra) are called verbal functions (vaci^-sankha^ra), s. sankha^ra (2). In-and-out-breathing forms one of the 6 aspects of the wind-element (s. dha^tu). Cf. M. 62.   sampayutta-paccaya, is one of the 24 conditions (paccaya, q.v.). asubha: 'impurity', loathsomeness, foulness. - In Vis.M. VI, it is the cemetery contemplations (si^vathika, q.v.) that are called 'meditation-subjects of impurity' (asubha-kammattha^na; s. bha^vana^). In the Girimananda Sutta (A. X., 50), however, the perception of impurity (asubha-san~n~a^) refers to the contemplation of the 32 parts of the body (s. ka^ya-gata^-sati). The contemplation of the body's impurity is an antidote against the hindrance of sense-desire (s. ni^varana) and the mental perversion (vipalla^sa, q.v.) which sees what is truly impure as pure and beautiful. See S. XLVI, 51; A. V. 36, Dhp. 7, 8; Sn. 193ff. - The Five Mental Hindrances (WHEEL 26), pp. 5ff.   'demons', titans, evil ghosts, inhabiting one of the lower worlds (apa^ya, q.v.).   'the unworried', is the name of a class of deities (s. deva,) inhabiting the first of the five Pure Abodes (suddha^va^sa, q.v.), in which the Ana^ga^mi^ (q.v.) has his last rebirth.   'superiority-conceit'; s. ma^na.   'self, ego, personality, is in Buddhism a mere conventional expression (voha^radesana^), and no designation for anything really existing; s. paramattha-desana^, anatta^, puggala, satta, ji^va.   s. para^ma^sa.  ditthi (-va^da): 'ego-belief', 'personality-belief', s. ditthi.  appana^-sama^dhi (q.v.); s. sama^dhi.   'The 8 a.'; s. sama^patti.  'self-mortification', is one of the two extremes to be avoided, the other extreme being addiction to sensual pleasures (ka^ma-sukha), whilst the Noble 8-fold Path constitutes the Middle Path (majjhima-patipada^, q.v.). See the Buddha's first sermon, "The Establishment of the Realm of Dhamma" (Dhamma-cakkappavattana-Sutta).  san~n~a^ (citta, ditthi): 'perception (consciousness, view) of an ego', is one of the 4 perversions (vipalla^sa, q.v.).  'attachment to the ego-belief', is one of the 4 kinds of clinging (upa^da^na, q.v.).   s. manasika^ra.   attention, mindfulness; s. sati, satipattha^na.  The 'Eightfold Path'; s. magga.  The 'analytical knowledge of meaning', is one of the 4 kinds of analytical knowledge (patisambhida^, q.v.).  'presence', is one of the 24 conditions (paccaya, q.v.) .  s. a^yatana.   'sphere', realm. The 3 spheres of existence are: the sensuous sphere (ka^ma^vacara), the fine-material sphere (rpa^vacara), the immaterial sphere (arpa^vacara). "Which things are of the sensuous sphere (ka^ma^vacara)? Whatever things exist within the interval bounded beneath by the Avi^ci-hell and above by the Paranimmitavasavatti-heaven (s. deva), having therein their sphere, and being therein included, to wit: the groups of existence, the elements, bases (s. khandha, dha^tu, a^yatana), corporeality, feeling, perception, mental formations and consciousness, all these things are of the sensuous sphere. - But which things are of the fine material sphere (rpa^vacara)? Whatever things exist within the interval bounded beneath by the Brahma-world and above by the Akanittha-world (s. deva), having therein their sphere, and being therein included ... and also consciousness and mental factors in one who has entered the (fine-material) absorptions, or who has been reborn in that sphere, or who already during his life-time is living in happiness (of the absorptions), all these things are of the fine-material sphere. - Which things are of the immaterial sphere (arpa^vacara)? Consciousness and mental factors arising within the interval bounded beneath by the beings reborn in the sphere of unbounded space and above by the beings reborn in the sphere of neither-perception-nor-non-perception (s. jha^na 5-8), and consciousness and mental factors in one who has entered the (immaterial absorptions), or who has been reborn in that sphere, or who already during his lifetime is living in happiness (of the immaterial absorptions), all these things are of the immaterial sphere." (Cf. Dhs. 1280, 1282, 1284; Vibh. XVIII). (App.).   'advertence' of the mind towards the object, forms the first stage in the process of consciousness (s. vin~n~a^na-kicca). If an object of the 5 physical senses is concerned, it is called 'five-door advertence' (pan~ca dva^ra^vajjana); in the case of a mental object, 'mind-door advertence' (mano-dva^ra^vajjana).  (from existence), contemplation of: s. vipassana^ (VI . 5)  is the name of one of the most frightful hells (niraya, q.v.).  'non-disappearance', is one of the 24 conditions (paccaya, q.v.).  (derivation uncertain; Sanskrit avrha) is one of the five Pure Abodes (suddha^va^sa, q.v.) in the fine-material sphere. For details, s. under Ana^ga^mi^.  (equivalents: ahimsa^, avihesa^): 'harmlessness', nonviolence, absence of cruelty. The 'thought of harmlessness' (or: 'non-cruelty'; avihimsa^-vitakka) is one of the three constituents of right thought (samma^-sankappa), i.e. the 2nd factor of the Eightfold Path (s. magga). In the several lists of 'elements' (dha^tu) appears also an 'element of harmlessness' (avihesa^-dha^tu), in the sense of an elementary quality of noble thought. See Dhp. 225, 261, 270, 300.   'ignorance,' nescience, unknowing; synonymous with delusion (moha, s. mla), is the primary root of all evil and suffering in the world, veiling man's mental eyes and preventing him from seeing the true nature of things. It is the delusion tricking beings by making life appear to them as permanent, happy, substantial and beautiful and preventing them from seeing that everything in reality is impermanent, liable to suffering, void of 'I' and 'mine', and basically impure (s. vipalla^sa). Ignorance is defined as 'not knowing the four truths, namely, suffering, its origin, its cessation, and the way to its cessation' (S. XII, 4).
As ignorance is the foundation of all life-affirming actions, of all evil and suffering, therefore it stands first in the formula of Dependent Origination (paticca-samuppa^da, q.v.). But for that reason, says Vis.M. (XVII, 36f) ignorance should not be regarded as "the causeless root-cause of the world ... It is not causeless. For a cause of it is stated thus 'With the arising of cankers (a^sava, q.v.) there is the arising of ignorance' (M. 9). But there is a figurative way in which it can be treated as a root-cause; namely, when it is made to serve as a starting point in an exposition of the Round of Existence ... As it is said: 'No first beginning of ignorance can be perceived, Bhikkhus, before which ignorance was not, and after which it came to be. But it can be perceived that ignorance has its specific condition (idappaccaya)" (A. X, 61). The same statement is made (A. X, 62) about the craving for existence (bhava-tanha^; s. tanha^). The latter and ignorance are called "the outstanding causes of kamma that lead to unhappy and happy destinies" (Vis.M. XVII, 38).
As ignorance still exists - though in a very refined way until the attainment of Arahatship or Holiness, it is counted as the last of the 10 fetters (samyojana, q.v.) which bind beings to the cycle of rebirths. As the first two roots of evil, greed and hate (s. mla), are on their part rooted in ignorance, consequently all unwholesome states of mind are inseparably bound up with it. Ignorance (or delusion) is the most obstinate of the three roots of evil.
Ignorance is one of the cankers (a^sava, q.v.) and proclivities (anusaya, q.v.). It is often called a hindrance (ni^varana; e.g. in S.XV, 3; A.X, 61) but does not appear together with the usual list of five hindrances.   'undistractedness', is a synonym of concentration (sama^dhi, q.v.), one-pointedness of mind (citt'ekaggata^) and tranquillity (samatha, q.v.; further s. samatha-vipassana^).  s. ca^ritta, etc. - The effort to avoid, s. padha^na.   lit. 'indeterminate' - i.e. neither determined as karmically 'wholesome' nor as 'unwholesome' - are the karmically neutral, i.e. amoral, states of consciousness and mental factors. They are either mere karma-results (vipa^ka, q.v.), as e.g. all the sense perceptions and the mental factors associated therewith, or they are karmically independent functions (kiriya-citta, q.v.), i.e. neither karmic nor karma-resultant. See Tab. I. (App.).   'hatelessness', non-ill-will, goodness; is one of the three kinds of right thought (s. sacca, IV. 2), or wholesome thoughts (vitakka, q.v.) and is the 9th of the 10 wholesome courses of actions (kammapatha II. q.v.). The most frequently used synonyms are adosa (s. mla) and metta^ (s. brahma-viha^ra).   s. bodhi.   1. 'spheres', is a name for the four immaterial absorptions; s. jha^na (5-8). 2. The 12 'bases' or 'sources' on which depend the mental processes, consist of five physical sense-organs and consciousness, being the six personal (ajjhattika) bases; and the six objects, the so-called external (ba^hira) bases - namely:
eye, or visual organ visible object
ear, or auditory organ sound, or audible object
nose, or olfactory organ odour, or olfactive object
tongue, or gustatory organ taste, or gustative object
body, or tactile organ body-impression, or tactile object
mind-base, or consciousness mind-object
(mana^yatana) (dhamma^yatana)
 
"By the visual organ (cakkha^yatana) is meant the sensitive part of the eye (cakkhu-pasa^da) built up of the four elements ... responding to sense-stimuli" (sa-ppatigha).... (Vibh. II). Similar is the explanation of the four remaining physical sense-organs.
Mind-base (mana^yatana) is a collective term for all consciousness whatever, and should therefore not be confounded with the mind-element (mano-dha^tu; s. dha^tu II, 16), which latter performs only the functions of adverting (a^vajjana) to the sense-object, and of receiving (sampaticchana) the sense-object. On the functions of the mind, s. vin~n~a^na-kicca.
The visible object (rpa^yatana) is described in Vibh. II as "that phenomenon which is built up of the four physical elements and appears as color, etc." What is' seen by-visual perception, i.e. by eye-consciousness (cakkhu-vin~n~a^na) are colors and differences of light, but not three dimensional bodily things.
'Mind-object-base' (dhamma^yatana) is identical with 'mind-object-element' (dhamma-dha^tu; s. dha^tu II) and dhamma^rammana (s. a^rammana). It may be physical or mental, past, present or future, real or imaginary.
The 5 physical sense-organs are also called faculties (indriya, q.v.), and of these faculties it is said in M. 43: "Each of the five faculties owns a different sphere, and none of them partakes of the sphere of another one; ... they have mind as their support... are conditioned by vitality, ... but vitality again is conditioned by heat, heat again by vitality, just as the light and flame of a burning lamp are mutually conditioned."
The 12 bases are fully discussed in Vis.M. XV. In Yam III (s Guide, p 98f) the 12 terms are subjected to a logical investigation The six personal bases form the 5th link of dependent origination (paticca-samuppa^da 5, q.v.).   (karmic) 'accumulation', is a name used in the commentarial literature for the wholesome and unwholesome volitional activities (karma, q.v.) or karma-formations (sankha^ra; s. paticca-samuppa^da), being the bases of future rebirth. " 'Accumulation', is a name for the karma-formations, and signifies those volitions (cetana^) which arise at the performance of a karma, first while thinking 'I will give alms', and then while actually giving alms (e.g.) for one month or a year. The volition, however, at the time when one is handing the alms over to the recipient; is called karma-process (kamma-bhava, s. Vis.M. XVII, IX, X). Or, the volitions during the first six impulsive-moments (javana, q.v.) depending on one and the same state of advertence (a^vajjana, s. vin~n~a^na-kicca), these are called the karma-formations, whilst the 7th impulsive moment is called the karma-process (kamma-bhava).... Or, each volition is called 'karma-process' and the accumulation connected with it, 'karma-formation'. " (Vis.M. XVII). Cf. paticca-samuppa^da (2, 10) - (App.).  'habitual karma': s. karma.   'powers'. Among various groups of powers the following five are most frequently met with in the texts: (1) faith (saddha^, q.v.), (2) energy (viriya, q.v.), (3) mindfulness (sati, q.v.), (4) concentration (sama^dhi, q.v.), (5) wisdom (pan~n~a^, q.v.).
Their particular aspect, distinguishing them from the corresponding 5 spiritual faculties (indriya, q.v.), is that they are unshakable by their opposites: (1) the power of faith is unshakable by faithlessness (unbelief); (2) energy, by laziness; (3) mindfulness, by forgetfulness; (4) concentration, by distractedness; (5) wisdom, by ignorance (see Pts.M., n~a^na Katha^). They represent, therefore, the aspect of firmness in the spiritual faculties.
According to A.V. 15, the power (1) becomes manifest in the 4 qualities of the Stream-winner (sota^pannassa anga^ni, q.v.), (2) in the 4 right efforts (s. padha^na), (3) in the 4 foundations of mindfulness (satipattha^na, q.v.), (4) in the 4 absorptions (jha^na, q.v.), (5) in the (full comprehension of the) 4 Noble Truths (sacca, q.v.) .
Cf. S. XLVIII, 43; S. L. (Bala Samyutta).
In A. VII, 3, the powers of moral shame (hiri, q.v.) and moral dread (ottappa) are added to the aforementioned five Several other groups of 2 (s. patisankha^na-bala), 4, 5 and more powers are mentioned in the texts. - About the 10 powers of a Buddha, s. dasa-bala.  indriya samatta (q.v.).   The 12 of the perceptual process: a^yatana (q.v.).   sobhana (q.v.).   deliverance through the perception of: cf. vimokkha (II. 3) To hold for beautiful or pure (subha) what is impure (asubha), is one of the 4 perversions (s. vipalla^sa).   morality consisting in good: abhisama^ca^rikasi^la (q.v.) .   living: satta (q.v.); further s. puggala. - Belief in eternal personality: bhava-ditthi (s. ditthi), sassata-ditthi (q.v.).   The 9 worlds of: satta^va^sa (q.v.). F  blind: s. indriya-samatta.  'knowledge consisting in contemplation of dissolution' (of all forms of existence), is one kind of insight: s. visuddhi (VI, 2).   'becoming', 'process of existence', consists of 3 planes: sensuous existence (ka^ma-bhava), fine-material existence (rpa-bhava), immaterial existence (arpa-bhava). Cf. loka.
The whole process of existence may be divided into two aspects:
(1) Karma-process (kamma-bhava), i.e. the karmically active side of existence, being the cause of rebirth and consisting in wholesome and unwholesome volitional actions. See Karma, paticca-samuppa^da (IX).
(2) Karma-produced rebirth, or regenerating process (uppattibhava), i.e. the karmically passive side of existence consisting in the arising and developing of the karma-produced and therefore morally neutral mental and bodily phenomena of existence. Cf. Tab. - (App.).   (feminine and masculine) 'nature', refers to the sexual characteristics of the body, and belongs to the group of corporeality (s. khandha). It is a commentarial term for the faculties of femininity and masculinity (s. indriya 7, 8). (App.).  'belief in being' (eternal personality); s. sassataditthi, ditthi.   'mental development' (lit. 'calling into existence, producing') is what in English is generally but rather vaguely called 'meditation'. One has to distinguish 2 kinds: development of tranquillity (samatha-bha^vana^), i.e. concentration (sama^dhi), and development of insight (vipassana^-bha^vana^), i.e. wisdom (pan~n~a^).
These two important terms, tranquillity and insight (s. samatha-vipassana^), are very often met with and explained in the Sutta, as well as in the Abhidhamma.
Tranquillity (samatha) is the concentrated, unshaken, peaceful, and therefore undefiled state of mind, whilst insight (vipassana^) is the intuitive insight into the impermanence, misery and impersonality (anicca, dukkha, anatta^; s. tilakkhana) of all bodily and mental phenomena of existence, included in the 5 groups of existence, namely, corporeality, feeling, perception, mental formations and consciousness; s. khandha.
Tranquillity, or concentration of mind, according to Sankhepavannana (Commentary to Abhidhammattha-sangaha), bestows a threefold blessing: favourable rebirth, present happy life, and purity of mind which is the condition of insight. Concentration (sama^dhi) is the indispensable foundation and precondition of insight by purifying the mind from the 5 mental defilements or hindrances (ni^varana, q.v.), whilst insight (vipassana^) produces the 4 supra mundane stages of holiness and deliverance of mind. The Buddha therefore says: "May you develop mental concentration, o monks; for who is mentally concentrated, sees things according to reality" (S. XXII, 5). And in Mil. it is said: "Just as when a lighted lamp is brought into a dark chamber, the lamp-light Will destroy the darkness and produce and spread the light, just so will insight, once arisen, destroy the darkness of ignorance and produce the light of knowledge."
Vis.M. III-XI gives full directions how to attain full concentration and the absorptions (jha^na, q.v.) by means of the following 40 meditation subjects (kammattha^na):
10 kasina-exercises (s. kasina). These produce the 4 absorptions
10 loathsome subjects (asubha, q.v.). These produce the 1st absorption.
10 recollections (anussati, q.v.): of the Buddha (buddha^nussati), the Doctrine (dhamma^nussati), the Brotherhood of the Noble Ones (sangha^nussati), morality, liberality, the heavenly beings, death (maranasati, q.v. ), the body (ka^yagata^sati, q.v.), in-and-outbreathing (a^na^pa^na-sati, q.v.) and peace (upasama^nussati, q.v.). Among these, the recollection (or mindfulness) of in-and-out breathing may produce all the 4 absorptions, that of the body the 1st absorption, the rest only neighbourhood-concentration (upaca^ra-sama^dhi, s. sama^dhi).
4 sublime abodes (brahma-viha^ra, q.v.): loving-kindness, compassion, altruistic joy, equanimity (metta^, karuna^, mudita^, upekkha^). Of these, the first 3 exercises may produce 3 absorptions, the last one the 4th absorption only.
4 immaterial spheres (arpa^yatana, s. jha^na): of unbounded space, unbounded consciousness, nothingness, neither-perception-nor-non-perception. These are based upon the 4th absorption.
1 perception of the loathsomeness of food (a^ha^re patikkla-san~n~a^), which may produce neighbourhood-concentration
1 analysis of the 4 elements (catudha^tu-vavattha^na, s. dha^tu-vavattha^na), which may produce neighbourhood-concentration.
Mental development forms one of the 3 kinds of meritorious action (pun~n~a-kiriya-vatthu, q.v.). 'Delight in meditation' (bha^vana^-ra^mata^) is one of the noble usages (ariya-vamsa, q.v.) .  s. patisankha^na-bala.  wisdom based on mental development'; s. pan~n~a^  'continuity of subconsciousness'; s. santa^na  sota and bhavanga citta: The first term may tentatively be rendered as the 'undercurrent forming the condition of being, or existence', and the second as 'subconsciousness', though, as will be evident from the following, it differs in several respects from the usage of that term in Western psychology. Bhavanga (bhava-anga), which, in the canonical works, is mentioned twice or thrice in the Pattha^na, is explained in the Abhidhamma commentaries as the foundation or condition (ka^rana) of existence (bhava), as the sine qua non of life, having the nature of a process, lit. a flux or stream (sota). Herein, since time immemorial, all impressions and experiences are, as it were, stored up, or better said, are functioning, but concealed as such to- full consciousness, from where however they occasionally emerge as subconscious phenomena and approach the threshold of full consciousness, or crossing it become fully conscious. This so-called 'subconscious life-stream' or undercurrent of life is that by which might be explained the faculty of memory, paranormal psychic phenomena, mental and physical growth, karma and rebirth. etc. An alternative rendering is 'life-continuum'.
It should be noted that bhavanga-citta is a karma-resultant state of consciousness (vipa^ka, q.v.), and that, in birth as a human or in higher forms of existence, it is always the result of good, or wholesome karma (kusala-kamma-vipa^ka), though in varying degrees of strength (s. patisandhi, end of the article). The same holds true for rebirth consciousness (patisandhi) and death consciousness (cuti), which are only particular manifestations of subconsciousness. In Vis.M. XIV it is said:
"As soon as rebirth-consciousness (in the embryo at the time of conception) has ceased, there arises a similar subconsciousness with exactly the same object, following immediately upon rebirth-consciousness and being the result of this or that karma (volitional action done in a former birth and remembered there at the moment before death). And again a further similar state of subconsciousness arises. Now, as long as no other consciousness arises to interrupt the continuity of the life-stream, so long the life-stream, like the flow of a river, rises in the same way again and again, even during dreamless sleep and at other times. In this way one has to understand the continuous arising of those states of consciousness in the life-stream." Cf. vin~n~a^na-kicca. For more details, s. Fund. 11. (App.).  'craving for (eternal) existence'; s. tanha^.   'canker of existence'; s. a^sava.  'knowledge consisting in the awareness of terror', is one of those kinds of insight-knowledge that form the 'purification by knowledge and vision of the path-progress' (s. visuddhi, VI.).   A fully ordained disciple of the Buddha is called a bhikkhu. "Mendicant monk" may be suggested as the closest equivalent for "Bhikkhu", literally it means "he who begs" but bhikkhus do not beg. They silently stand at the door for alms. They live on what is spontaneously given by the supporters. He is not a priest as he is no mediator between God and man. He has no vows for life, but he is bound by his rules which he takes of his own accord. He leads a life of voluntary poverty and celibacy. If he is unable to live the Holy Life, he can discard the robe at any time.  'knowing the measure in eating'.
"Now, o monks, the monk wisely reflecting partakes of his almsfood, neither for pastime, nor for indulgence, nor to become beautiful or handsome, but only to maintain and support this body, to avoid harm and to assist the holy life, knowing: 'In this way I shall dispel the former pain (of hunger, etc.) and no new pain shall I let arise, and long life, blamelessness and ease will be my share ' This, o monks, is knowing the measure in eating." (A. III. 16). "How o monks, would it be possible for Nanda to lead the absolutely pure life of holiness, if he did not watch over his senses and did not know the measure in eating?" (A. VII, 9).   s. a^sava.  upapatti-bhava: s. bhava. Further s. patisandhi, ja^ti.  (from verbal root budhi, to awaken, to understand): awakenment, enlightenment, supreme knowledge. "(Through Bodhi) one awakens from the slumber or stupor (inflicted upon the mind) by the defilements (kilesa, q.v.) and comprehends the Four Noble Truths (sacca, q.v.)" (Com. to M. 10).
The enlightenment of a Buddha is called samma^-sambodhi (q.v.) 'perfect enlightenment'. The faith (saddha^, q.v.) of a lay follower of the Buddha is described as "he believes in the enlightenment of the Perfect One" (saddahati Tatha^gatassa bodhim: M. 53, A. III, 2).
As components of the state of enlightenment and contributory factors to its achievement, are mentioned in the texts: the 7 factors of enlightenment (bojjhanga (q.v.)= bodhi-anga) and the 37 'things pertaining to enlightenment' (bodhipakkhiya-dhamma^, q.v.). In one of the later books of the Sutta-Pitaka, the Buddhavamsa, 10 bodhipa^cana-dhamma^ are mentioned, i.e. qualities that lead to the ripening of perfect enlightenment; these are the 10 perfections (pa^rami^, q.v.).
There is a threefold classification of enlightenment: 1. that of a noble disciple (sa^vaka-bodhi, q.v.). i.e. of an Arahat, 2. of an Independently Enlightened One (pacceka-bodhi, q.v.), and 3. of a Perfect Enlightened One (samma^-sambodhi). This 3-fold division, however, is of later origin, and in this form it neither occurs in the canonical texts nor in the older Sutta commentaries. The closest approximation to it is found in a verse sutta which is probably of a comparatively later period, the Treasure Store Sutta (Nidhikkanda Sutta) of the Khuddakapa^tha, where the following 3 terms are mentioned in stanza 15: sa^vaka-pa^rami^, pacceka-bodhi, buddha-bhmi (see Khp. Tr., pp. 247f.).
The commentaries (e.g. to M., Buddhavamsa, Cariyapitaka) generally give a 4-fold explanation of the word bodhi: 1. the tree of enlightenment, 2. the holy path (ariya-magga), 3. Nibba^na, 4 omniscience (of the Buddha: sabban~n~uta^-n~a^na). As to (2), the commentaries quote Cula-Nidesa where bodhi is defined as the knowledge relating to the 4 paths (of Stream-entry, etc.; catsu maggesu n~a^na).
Neither in the canonical texts nor in the old commentaries is it stated that a follower of the Buddha may choose between the three kinds of enlightenment and aspire either to become a Buddha, a Pacceka-Buddha, or an Arahat-disciple. This conception of a choice between three aspirations is, however, frequently found in present-day Therava^da countries, e.g. in Sri Lanka.  The 37 'things pertaining to enlightenment', or 'requisites of enlightenment' comprise the entire doctrines of the Buddha. They are:
the 4 foundations of mindfulness (satipattha^na, q.v.),
the 4 right efforts (s. padha^na),
the 4 roads to power (iddhi-pa^da, q.v.),
the 5 spiritual faculties (indriya; s. bala),
the 5 spiritual powers (bala, q.v.),
the 7 factors of enlightenment (bojjhanga, q.v.),
the Noble 8-fold Path (s. magga).
In M. 77 all the 37 bodhipakkhiya-dhamma^ are enumerated and explained though not called by that name. A detailed explanation of them is given in Vis.M. XXII. In S.XLVII, 51, 67, only the five spiritual faculties (indriya) are called bodhipakkhiya-dhamma^; and in the Jha^na Vibhanga, only the 7 factors of enlightenment (bojjhanga).
See The Requisites of Enlightenment, by Ledi Sayadaw (WHEEL 169/172).   'Enlightenment Being', is a being destined to Buddhahood, a future Buddha. According to the traditional belief a Bodhisatta, before reaching his last birth as a Buddha on this earth, is living in the Tusita-heaven (s. deva), the heaven of bliss. Cf. A. IV, 127; VIII, 70.
In the Pa^li Canon and commentaries, the designation 'Bodhisatta' is given only to Prince Siddhattha before his enlightenment and to his former existences. The Buddha himself uses this term when speaking of his life prior to enlightenment (e.g. M. 4, M. 26). Bodhisattahood is neither mentioned nor recommended as an ideal higher than or alternative to Arahatship; nor is there any record in the Pa^li scriptures of a disciple declaring it as his aspiration. - See bodhi.  action (wholesome or unwholesome); s. karma, karma formations - Right b.a. = samma^-kammanta; s. magga.  postures, the 4: iriya^-patha (q.v.)   ka^ya (q.v.) Contemplation on the b. is one of the 4 satipattha^na (q.v.).  ka^ya-sakkhi (q.v.).   'the 7 factors of enlightenment', are: mindfulness (sati-sambojjhanga; s. sati), investigation of the law (dhamma-vicaya-sambojjhanga), energy (viriya-sambojjhanga; s. viriya, padha^na), rapture (pi^ti-sambojjhanga, q.v.) tranquillity (passaddhi-sambojjhanga, q.v.), concentration (sama^dhi-sambojjhanga, q.v.), equanimity (upekkha^, q.v.). "Because they lead to enlightenment, therefore they are called factors of enlightenment" (S. XLVI, 5).
Though in the 2nd factor, dhamma-vicaya, the word dhamma is taken by most translators to stand for the Buddhist doctrine, it probably refers to the bodily and mental phenomena (na^ma-rpa-dhamma^) as presented to the investigating mind by mindfulness, the 1st factor. With that interpretation, the term may be rendered by 'investigation of phenomena'.
In A.X. 102, the 7 factors are said to be the means of attaining the threefold wisdom (s. tevijja^).
They may be attained by means of the 4 foundations of mindfulness (satipattha^na, q.v.), as it is said in S. XLVI, 1 and explained in M. 118:
(1) "Whenever, o monks, the monk dwells contemplating the body (ka^ya), feeling (vedana^), mind (citta) and mind-objects (dhamma^), strenuous, clearly-conscious, mindful, after subduing worldly greed and grief, at such a time his mindfulness is present and undisturbed; and whenever his mindfulness is present and undisturbed, at such a time he has gained and is developing the factor of enlightenment 'mindfulness' (sati-sambojjhanga), and thus this factor of enlightenment reaches fullest perfection.
(2) "Whenever, while dwelling with mindfulness, he wisely investigates, examines and thinks over the law ... at such a time he has gained and is developing the factor of enlightenment 'investigation of the law' (dhamma-vicaya) ....
(3) "Whenever, while wisely investigating his energy is firm and unshaken ... at such a time he has gained and is developing the factor of enlightenment 'energy' (viriya) ....
(4) "Whenever in him, while firm in energy, arises supersensuous rapture ... at such a time he has gained and is developing the factor of enlightenment 'rapture' (pi^ti) ..
(5) "Whenever, while enraptured in mind, his body and his mind become composed ... at such a time he has gained and is developing the factor of enlightenment 'tranquillity' (passaddhi).
(6) "Whenever, while being composed in his body and happy, his mind becomes concentrated ... at such a time he has gained and is developing the factor of enlightenment 'concentration' (sama^dhi)
(7) "Whenever he looks with complete indifference on his mind thus concentrated ... at such a time he has gained and is developing the factor of enlightenment 'equanimity' (upekkha^).
Literature: Bojjhanga Samyutta (S. XLVI); Bojjhanga Vibh. - For the conditions leading to the arising of each of the factors, see the Com. to Satipattha^na Sutta (Way of Mindfulness, by Soma Thera; 3rd ed., 1967, BPS). Further, The 'Seven Factors of Enlightenment, by Piyadassi Thera (WHEEL 1.)   mental: cetaso vinibandha (q.v.).   the 4: yoga (q.v.).  ways liberated, s. ubhato-bha^ga-vimutta, ariyapuggala B. 4.  consciousness (and b. space), Sphere of: s. jha^na 5, 6.  'pure (chaste) or holy life', is a term for the life of the monk. Also a lay-devotee who observes the 8 moral precepts (sikkha^pada, q.v.), takes as the third precept the vow of chastity, i.e. full abstention from sexual relations. The highest aim and purpose of b. is, according to M. 29, the 'unshakable deliverance of mind' (akuppa^ ceto-vimutti).  The 'heavenly beings of the Brahma-world' inhabit the first 3 heavens of the fine-material world, (rpaloka), corresponding to the 1st absorption (jha^na, q.v.). The highest ruler of them is called the Great Brahma (Maha^-Brahma^). With caustic humor he is said (D. 11) to pretend: "I am Brahma, the Great Brahma^, the Most High, the Invincible One, the Omniscient One, the Ruler, the Lord, the Creator, the Maker, the Perfect One, the Preserver, the Controller, the Father of all that was and will be." Cf. deva (II. 1-3).  'Brahma-world', in the widest sense, is a name for the fine-material (rpa-loka) and immaterial world (arpa-loka); in a narrower sense, however, only for the first three heavens of the fine-material world. Cf. Brahma-ka^yika-deva.  the 4 'sublime' or 'divine abodes', also called the 4 boundless states (appaman~n~a^), are: loving-kindness (metta^), compassion (karuna^), altruistic (or sympathetic) joy (mudita^), equanimity (upekkha^).
The stereotype text on the development of these 4 sublime abodes (brahma-viha^ra-bha^vana^; s. bha^vana^), often met with in the Suttas,- is as follows: "'There, o monks, the monk with a mind full of loving-kindness pervading first one direction, then a second one, then a third one, then the fourth one, just so above, below and all around; and everywhere identifying himself with all, he is pervading the whole world with mind full of loving-kindness, with mind wide, developed, unbounded, free from hate and ill-will." Hereafter follows the same theme with compassion, altruistic joy, and equanimity.
Literature: Detailed explanation in Vis.M. IX. - For texts s. "Path", 97ff; texts on metta^ in The Practice of Loving Kindness, by n~a^namoli Thera (WHEEL 7). - The Four Sublime States, by Nyanaponika Thera (WHEEL 6). - Brahma Viha^ra, by Narada Thera (Vajirarama, Colombo, 1962).   mindfulness of in-and-out-breathing a^na^pa^nasati (q.v.) .   s. samma^-sambodhi.   'recollection of the Enlightened One'; s. anussati.  s. sa^sana.   'liberality', is one of the 'blessings' (s. sampada^), 'foundations' (s. adhittha^na), 'recollections' (s. anussati), 'treasures' (s. dhana).   'wheel', is one of the seven 'precious possessions' (ratana) of a righteous World Emperor (cakkavatti: 'He who owns the Wheel,' cf. D. 26), and symbolizes conquering progress and expanding sovereignty. From that derives the figurative expression dhamma-cakkam pavatteti, 'he sets rolling the Wheel of the Law' and the name of the Buddha's first sermon, Dhamma-cakkappavattana Sutta (s. dhamma-cakka).
Another figurative meaning of C. is 'blessing'. There are 4 such 'auspicious wheels' or 'blessings': living in a suitable locality, company of good people, meritorious acts done in the past, right inclinations (A. IV, 31).
Bhava-cakka, 'wheel of existence', or of life, is a name for 'dependent origination' (s. paticca-samuppa^da).
See The Buddhist Wheel Symbol, by T. B. Karunaratne (WHEEL 137/138); The Wheel of Birth and Death, by Bhikkhu Khantipalo (WHEEL 147/149)  'the base "visual organ" ' (s. a^yatana).   'eye' s. a^yatana. - The foll. 5 kinds of 'eyes' are mentioned and explained in CNid. (PTS, p. 235; the first 3 also in It. 52): 1. the physical eye (mamsa cakkhu), 2. the divine eye (dibba-cakkhu; s. abhin~n~a^), 3. the eye of wisdom (pan~n~a^-cakkhu), 4 the eye of a Buddha (Buddha-c.), 5. the eye of all-round knowledge (samanta-c.; a frequent appellation of the Buddha).  'the element "visual organ" '(s. dha^tu).  'eye-consciousness' (s. vin~n~a^na).   s. a^sava.   s. vijja^-carana.   'nature, character'. In Vis.M. III there are explained six types of men: the greedy-natured (ra^ga-carita), the hate-natured (dosa-carita), the stupid or dull-natured (moha-carita), the faithful-natured (saddha^-carita), the intelligent-natured (buddhi-carita), the ruminating-natured (vitakka-carita). - (App.).   and va^ritta si^la: 'morality consisting in performance and morality consisting in avoidance,' means "the performance of those moral rules which the Blessed one has ordained to be followed, and the avoidance of those things that the Blessed One has rejected as not to be followed" (Vis.M. III). - (App.).  'analysis of the four elements'; s. dha^tu-vavattha^na.  maha^ra^jika deva a class of heavenly beings of the sensuous sphere; s. deva.  s. si^la.  'four-group existence', is the existence in the immaterial world (arpa-loka; s. loka), since only the four mental groups (feeling, perception, mental formations, consciousness, s. khandha) are found there, the corporeality group being absent. Cf. pan~ca-voka^ra-bhava, eka-voka^ra-bhava. (App.: voka^ra).   cf. paccaya (1). - For the five c. of existence, s. paticca-samuppa^da (10).   ascetic practice of living in a c.; s. dhutanga.  s. si^vathika^.   'volition', will, is one of the seven mental factors (cetasika, q.v.) inseparably bound up with all consciousness, namely sensorial or mental impression (phassa), feeling (vedana^), perception (san~n~a^), volition (cetana^), concentration (sama^dhi), vitality (ji^vita), advertence (manasika^ra). Cf. Tab. II, III.
With regard to karmical volition (i.e. wholesome or unwholesome karma) it is said in A. VI, 13: "Volition is action (karma), thus I say, o monks; for as soon as volition arises, one does the action, be it by body, speech or mind." For details, s. paticca-samuppa^da (10), karma.   'mental things, mental factors', are those mental concomitants which are bound up with the simultaneously arising consciousness (citta = vin~n~a^na) and conditioned by its presence . Whereas in the Suttas all phenomena of existence are summed up under the aspect of 5 groups: corporeality, feeling, perception, mental formations, consciousness (s. khandha), the Abhidhamma as a rule treats them under the more philosophical 3 aspects: consciousness, mental factors and corporeality (citta, cetasika, rpa). Thus, of these 3 aspects, the mental factors (cetasika) comprise feeling, perception and the 50 mental formations, altogether 52 mental concomitants. Of these, 25 are lofty qualities (either karmically wholesome or neutral), 14 karmically unwholesome, while 13 are as such karmically neutral, their karmical quality depending on whether they are associated with wholesome, unwholesome or neutral consciousness. For details s. Tab. II, III. Cf. prec. (App . )  'mental bondages', are 5 things which hinder the mind from making right exertion, namely: lust for sensuous objects, for the body, for visible things, for eating and sleeping, and leading the monk's life for the sake of heavenly rebirth. For details, s. A.V, 205; X, 14; D. 33; M. 16. Cf. foll.   'mental obduracies', are 5 things which stiffen and hinder the mind from making right exertion, namely: doubt about the Master, about the Doctrine, about the (holy) Brotherhood, about the training, and anger against one's fellow-monks. For details s. A.V, 206, X 14; D. 33; M. 16. Cf. prec.  'penetrating knowledge of the mind (of others)', is one of the 6 higher powers (abhin~n~a^ 3, q.v.).  'deliverance of mind'. In the highest sense it signifies the fruition of Arahatship (s. ariya-puggala), and in particular, the concentration associated with it. It is often linked with the 'deliverance through wisdom' (pan~n~a^-vimutti, q.v.), e.g. in the ten powers of a Perfect One (s. dasa-bala). See vimokkha I.
It is also called 'unshakable deliverance of mind' (akuppa-c.); further 'boundless d. of m'. (appama^na-c.); 'd. of m. from the conditions of existence, or signless d. of m.' (animitta^-c.); 'd. of m. from the appendages' (a^kincan~n~a-c.), since that state of mind is free from the 3 bonds, conditions and appendants, i.e. from greed, hatred and ignorance; and since it is void thereof, it is called the 'void deliverance of mind' (sun~n~ata^-c.)
In a more restricted sense, 'boundless deliverance of mind' is a name for the 4 boundless states, i.e. loving-kindness, compassion, altruistic joy and equanimity (s. brahma-viha^ra); 'd. of m. from the appendages' stands for the 'sphere of nothingness' (a^kin~can~n~a^yatana s. jha^na 7); 'd. of mind from the conditions of existence', for d. of mind due to non-attention to all conditions of existence; 'void d. of m' for d. of m. due to contemplating voidness of self. For further details, s. M. 43.  the 6 'higher powers'; s. abhin~n~a^.  an Arahat who is a 'possessor of the 6 higher powers' (s. abhin~n~a^).   intention, desire, will.
1. As an ethically neutral psychological term, in the sense of 'intention', it is one of those general mental factors (cetasika, q.v. Tab. II) taught in the Abhidhamma, the moral quality of which is determined by the character of the volition (cetana^, q.v.) associated therewith. The Com. explains it as 'a wish to do' (kattu-kamyata^-chanda). If intensified, it acts also as a 'predominance condition' (s. paccaya 3).
2. As an evil quality it has the meaning of 'desire', and is frequently coupled with terms for 'sensuality', 'greed', etc., for instance: ka^ma-cchanda, 'sensuous desire', one of the 5 hindrances (s. ni^varana); chanda-ra^ga, 'lustful desire' (s. ka^ma). It is one of the 4 wrong paths (s. agati).
3. As a good quality it is a righteous will or zeal (dhamma-chanda) and occurs, e.g. in the formula of the 4 right efforts (s. padha^na): "The monk rouses his will (chandam janeti)...." If intensified, it is one of the 4 roads to power (s. iddhipa^da).   contemplation of: one of the 18 chief kinds of insight (vipassana^, q.v.) .   cf. kappa.   On the 6 kinds of human character, s. carita.  of existence, the. 3: ti-lakkhana (q.v.).  brahma-cariya (q.v.). F elements, the 4: maha^-bhta (q.v.) - dha^tu (q.v.).  'Wisdom (or knowledge) based on thinking', s. pan~n~a^.   'mind', 'consciousness', 'state of consciousness', is a synonym of mano (q.v.) and vin~n~a^na (s. khandha and Tab. 1). Dhs. divides all phenomena into consciousness (citta), mental concomitants (cetasika, q.v.) and corporeality (rpa).
In adhicitta, 'higher mentality', it signifies the concentrated, quietened mind, and is one of the 3 trainings (s. sikkha^). The concentration (or intensification) of consciousness is one of the 4 roads to power (s. iddhipa^da).  'mind-produced corporeality'; s. samuttha^na.  kamman~n~ata^, lahuta^, muduta^, pagun~n~ata^, passaddhi, ujukata^; s. Tab. II.  'consciousness-moment', is the time occupied by one single stage in the perceptual process or cognitive series (cittavi^thi; s. vin~n~a^na-kicca). This moment again is subdivided into the genetic (uppa^da), static (thiti) and dissolving (bhanga) moment. One such moment is said in the commentaries to be of inconceivably short duration and to last not longer than the billionth part of the time occupied by a flash of lightning. However that may be, we ourselves know from experience that it is possible within one single second to dream of innumerable things and events. In A. I, 10 it is said: "Nothing, o monks, do I know that changes so rapidly as consciousness. Scarcely anything may be found that could be compared with this so rapidly changing consciousness." (App. khana).   'contemplation of consciousness', is one of the 4 foundations of mindfulness (satipattha^na, q.v.)  'mind-produced corporeality'; s. samuttha^na.  s. sankha^ra.  'consciousness-continuity'; s. santa^na.   'one-pointedness of mind', is a synonym of concentration, or sama^dhi (q.v.)  'perversion of mind'; s. vipalla^sa.  'purification of mind', is the 2nd of the 7 stages of purification (visuddhi, II,. q.v.).  'process of consciousness'; s. vin~n~a^na-kicca.  = cittass'ekaggata^ (q.v.).  sampajan~n~a (q.v.).   the 4 kinds of: upa^da^na (q.v.).  s. vin~n~a^na-kicca.   Influence of good and bad = samseva (q.v.) .   karuna^; s. brahma-viha^ra.   clear c.: s. sampajan~n~a. - c. in insight, s. sammasana. - As an alternative tr. for full understanding, s. parin~n~a^.  sahaja^ta-paccaya, is one of the 24 conditions (paccaya, q.v.) .   ma^na (q.v.); further s. samyojana.   sama^dhi (q.v.) - right, s. sacca (IV. 8), magga (8). - wrong, s. miccha^-magga (8).  1. thought-c: cf. vitakka-vica^ra.  2. (in the mother's womb): okkanti (q.v.).   the 24: paccaya (q.v.).  of existence, deliverance from the: see ceto-vimutti; vimokkha.   s. saddha^.   vin~n~a^na (s. khandha), citta (q.v.), mano (q v ) - Moment of : citta-kkhana (q.v.). Contemplation of : citta^nupassana^: s. satipattha^na - Corporeality produced by : citta-ja-rpa, s. samuttha^na - Abodes or supports of : cf. vin~n~a^natthiti (q.v.) Functions of : vin~n~a^na-kicca (q.v.).   s. anupassana^.  (with whatever robe, etc.) belongs to the noble usages: ariya-vamsa (q.v.).   appicchata^, is one of the ascetic virtues. Cf. A. X, 181-90.   samanantara-paccaya, is one of the 24 conditions (paccaya, q.v.).  (of body, subconsciousness, consciousness or groups of existence): santa^na (q.v.).   effort of: s. padha^na.  (expression or truth): s. desana^.   produced through consciousness, karma, etc.; s. samuttha^na. - Sensitive c.: pasa^da-rpa. (q.v.).  s. na^ma-rpa.  rpa-kkhandha: s. khandha.  rpa-san~n~a^: s. jha^na.   s. upakkilesa.   cf. kappa.  upapi^laka-kamma; s. karma.  image (during concentration): s. nimitta, kasina, sama^dhi.  of action (wholesome or unwholesome): kammapatha (q.v.).   abhijjha^ (q.v.); further s. kamma-patha (1).   s. agati.   tanha^ (q.v.), ra^ga (q.v.); further s. mla.   the: sankhata (q.v.).  'death-consciousness', lit. 'departing consciousness', is one of the 14 functions of consciousness (vin~n~a^na-kicca q.v.).  n~a^na the 'knowledge of the vanishing and reappearing' (of beings) is identical with the divine eye; s. abhin~n~a^.  s. samsara^, vatta.   'almsgiving', liberality, offering. "He who gives alms, bestows a fourfold blessing: he helps to long life, good appearance, happiness and strength. Therefore long life, good appearance, happiness and strength will be his share, whether amongst heavenly beings or amongst men" (A. IV, 57).
"Five blessings accrue to the giver of alms: the affection of many, noble association, good reputation, self-confidence, and heavenly rebirth" (see A. V, 34). Seven further blessings are given in A. VII, 54.
Liberality, especially the offering of robes, food, etc., to the monks, is highly praised in all Buddhist countries of Southern Asia as a fundamental virtue and as a means to suppress man's inborn greed and egoism. But, as in any other good or bad action, so also in offering gifts, it is the noble intention and volition that really counts as the action, not the mere outward deed.
Almsgiving or liberality (da^na), constitutes the first. kind of meritorious activity, the two others being morality (si^la, q.v.) and mental development (bha^vana^); s. pun~n~a-kiriya-vatthu. Liberality (ca^ga) forms one of the 10 recollections (anussati, q.v.) and almsgiving one of the 10 perfections (s. pa^rami^).  'the ten powers (of a Perfect One); or, he who Possesses the 10 P.', i.e. the Buddha. About him it is said (e.g., M. 12.; A. X, 21):
There, o monks, the Perfect One understands according to reality the possible as possible, and the impossible as impossible ... the result of past, present and future actions ... the path leading to the welfare of all ... the world with its many different elements ... the different inclinations in beings ... the lower and higher faculties in beings ... the defilement, purity and rising with regard to the absorptions, deliverances, concentration and attainments ... remembering many former rebirths ... perceiving with the divine eye how beings vanish and reappear again according to their actions (karma) ... gaining, through extinction of all taints, possession of 'deliverance of mind' and 'deliverance through wisdom' ...."  s. rpa-kala^pa.  s. pa^rami^.  s. pun~n~a-kiriya-vatthu.   marana (q.v.) - Contemplation of : marana^nussati (q.v.) - As divine messenger: deva-dta (q.v.).  cuti-citta, is one of the 14 functions of consciousness (vin~n~a^na-kicca, q.v.).   amata (q.v.).  marana^san~n~a^-kamma; s. karma.  function (of consciousness): s. vin~n~a^na-kicca.  (in morality, wisdom, etc.): s. ha^na-bha^giya-si^la. - Liable to , pariha^na-dhamma (q.v.).   s. kilesa, upakkilesa. -10 d. of insight: vipassanpakkilesa, s. visuddhi VI. - Round of d., s. vatta (1).   s. vimutti, vimokkha. - The 8 kinds of d. (or liberation), s. vimokkha. - D. of mind, d. through voidness, boundless d. etc., s. ceto-vimutti. - Desire for d., s. visuddhi (VI, 6). - D. through wisdom; pan~n~a^-vimutti (q.v.). - 3 doors of d. (or gateways of liberation) s. visuddhi (VI, 8).  s. Tab. I. 32, 33.  moha-carita; s. carita.   s. moha, avijja^.  asura-nika^ya; s. apa^ya.   the spirits of the: peta (q.v.).  paticca samuppa^da (q.v.).  upa^da^-rpa (q.v.); further s. khandha (I. B.).   'exposition' of the doctrine, may be either an exposition true in the highest sense (paramattha-desana^); or it may not be true in the highest, but only in the conventional sense (voha^ra-desana^). See paramattha.  s. visuddhi (VI, 6).  s. vimokkha (1).   contemplation on: s. vipassana^ (12).   evil views with fixed d.: niyata-miccha^-ditthi (q.v.). Men with fixed d.: niyata-puggala (q.v.). See gati.   overcoming, or liberation from, evil things through their d.; samuccheda-paha^na or samuccheda-vimutti; s. paha^na.  upagha^taka-kamma; s. karma.   viveka (q.v.).   s. adhimokkha, adhittha^na.   votthapana (s. vin~n~a^na-kicca).  s. vavattha^na.  (lit: the Radiant Ones; related to Lat. deus): heavenly beings, deities, celestials, are beings who live in happy worlds, and who, as a rule, are invisible to the human eye. They are subject, however, just like all human and other beings, to ever-repeated rebirth, old age and death, and thus are not freed from the cycle of existence and from misery. There are many classes of heavenly beings.
I. The 6 classes of heavenly beings of the sensuous sphere (ka^ma^vacara or ka^ma-loka; s. avacara loka), are Ca^tumaha^ra^jika-deva, Ta^vatimsa, Ya^ma, Tusita (s. Bodhisatta), Nimma^na-rati, Paranimmita-vasavatti. Cf. anussati. (6).
II. The heavenly beings of the fine-material sphere (rpa^vacara or rpaloka) are:
1. Brahma-pa^risajja, Brahma-purohita, Maha^-brahma^no (s. brahma-ka^yika-deva). Amongst these 3 classes will be reborn those with a weak, medium or full experience of the 1st absorption (jha^na, q.v.).
2. Paritta^bha, Appama^na^bha, a^bhassara. Here will be reborn those with experience of the 2nd absorption.
3. Paritta-subha, Appama^na-subha, Subha-kinna (or kinha). Here will be reborn those with experience of the 3rd absorption.
4. Vehapphala, Asan~n~a-satta (q.v.), Suddha^va^sa (q.v.; further s. Ana^ga^mi). Amongst the first 2 classes will be reborn those with experience of the 4th absorption, but amongst the 3rd class only Ana^ga^mis (q.v.).
III. The 4 grades of heavenly beings of the immaterial sphere (arpa^vacara or arpa-loka) are: the heavenly beings of the sphere of unbounded space (a^ka^sa^nan~ca^yatanpaga-deva^), of unbounded consciousness (vin~n~a^nan~ca^yatanpaga-deva), of nothingness (a^kin~can~n~a^yatanpaga deva^), of neither-perception-nor- non-perception (nevasan~n~a^-na^san~n~a^yatanpaga-deva^). Here will be reborn those with experience of the 4 immaterial spheres (arpa^yatana; s. jha^na 5-8).
See Gods and the Universe by Francis Story (WHEEL 180/181).  'divine messengers', is a symbolic name for old age, disease and death, since these three things remind man of his future and rouse him to earnest striving. In A. III, 35, it is said:
"Did you, o man, never see in the world a man or a woman eighty, ninety or a hundred years old, frail, crooked as a gable-roof, bent down, resting on crutches, with tottering steps, infirm, youth long since fled, with broken teeth, grey and scanty hair, or baldheaded, wrinkled, with blotched limbs? And did it never occur to you that you also are subject to old age, that you also cannot escape it?
"Did you never see in the world a man or a woman, who being sick, afflicted and grievously ill, and wallowing in their own filth, was lifted up by some people, and put down by others? And did it never occur to you that you also are subject to disease, that you also cannot escape it?
"Did you never see in the world the corpse of a man or a woman, one or two or three days after death, swollen up, blue-black in colour, and full of corruption? And did it never occur to you that you also are subject to death, that you also cannot escape it?" - See M. 130.   'recollection of the heavenly beings'; s. anussati.  (mental): bha^vana^ (q.v.). - Effort to develop, s. padha^na. - Wisdom based on d. s. pan~n~a^. - Gradual d. of the Eightfold Path in the 'progress of the disciple' (q.v.).   (from morality and understanding): vipatti (q.v.).   upa^saka (q.v.) .   lit. the 'bearer', constitution (or nature of a thing), norm, law (jus), doctrine; justice, righteousness; quality; thing, object of mind (s. a^yatana) 'phenomenon'. In all these meanings the word 'dhamma' is to be met with in the texts. The Com. to D. instances 4 applications of this term guna (quality, virtue), desana^ (instruction), pariyatti (text), nijji^vata^ (soullessness, e.g. "all dhamma^, phenomena, are impersonal," etc.). The Com. to Dhs. has hetu (condition) instead of desana^. Thus, the analytical knowledge of the law (s. patisambhida^) is explained in Vis.M. XIV. and in Vibh. as hetumhi-n~a^na, knowledge of the conditions.
The Dhamma, as the liberating law discovered and proclaimed by the Buddha, is summed up in the 4 Noble Truths (s. sacca). It forms one of the 3 Gems (ti-ratana, q.v.) and one of the 10 recollections (anussati q.v.).
Dhamma, as object of mind (dhamma^yatana, s. a^yatana) may be anything past, present or future, corporeal or mental, conditioned or not (cf. sankha^ra, 4), real or imaginary.  The 'Wheel (realm) of the Law', is a name for the doctrine 'set rolling' (established) by the Buddha, i.e. the 4 Noble Truths (sacca, q.v.).
"The Perfect One, o monks, the Holy One, fully Enlightened One, in the Deer Park at Isipatana near Benares, has set rolling (established) the unsurpassed Wheel (realm) of the Law" (M. 141). Cf. cakka.  'exposition of the Doctrine (law)'; s. desana^.  mind-object-element (s. dha^tu).   'contemplation of the mind-objects' is the last of the 4 foundations of mindfulness (satipattha^na, q.v.)   the 'dhamma-devotee', is one of the 7 noble disciples (ariya-puggala, q.v.).   'recollection of the Law', is one of the 10 recollections (anussati, q.v.).  the 'analytical knowledge of the law, is one of the 4 kinds of analytical knowledge (patisambhida^, q.v.).  'knowledge of the fixity of law, is a name for that 'insight which is leading up' to the entrance into one of the 4 supermundane paths (vuttha^na-ga^mini^-vipassana^, q.v.). In the Susima Sutta (S. XII, 70) this (ascending) insight is called the 'knowledge of the fixity of the law', namely: "At first, Susima, there exists the knowledge of the fixity of the law, and later the knowledge of Nibba^na." (See Vis.M. XXI.)  'investigation of the law as factor of enlightenment', is one of the 7 factors of enlightenment (bojjhanga, q.v.).   'mind-object as base' (a^yatana, q.v.).   'treasures', a term for the following 7 qualities: faith, morality, moral shame, moral dread, learning, liberality and wisdom. Cf. A. VII, 5, 6.
See 'Treasures of the Noble', by Soma Thera (BODHI LEAVES B. 27, BPS).   'elements', are the ultimate constituents of a whole.
(1) The 4 physical elements (dha^tu or maha^-bhta), popularly called earth, water, fire and wind, are to be understood as the primary qualities of matter. They are named in Pa^li: pathavi^-dha^tu, a^po-dha^tu, tejo-dha^tu, and va^yo-dha^tu. In Vis.M. XI, 2 the four elements are defined thus: "Whatever is characterized by hardness (thaddha-lakkkhana) is the earth or solid-element; by cohesion (a^bandhana) or fluidity, the water-element; by heating (paripa^cana), the fire or heat-element; by strengthening or supporting (vitthambhana), the wind or motion-element. All four are present in every material object, though in varying degrees of strength. If, for instance, the earth element predominates, the material object is called 'solid', etc. - For the analysis of the 4 elements, s. dha^tu-vavattha^na.
(II) The 18 physical and mental elements that constitute the conditions or foundations of the process of perception, are:
 
1. visual organ (eye) 9. gustative object
2. auditory organ (ear) 10. body-impression
3. olfactory organ (nose) 11. eye-consciousness
4. gustatory organ (tongue) 12. ear-consciousness
5. tactile organ (body) 13. nose-consciousness
6. visible object 14. tongue-consciousness
7. sound or audible object 15. body-consciousness
8. odour or olfactive object
16. mind-element 17. mind-object
(mano-dha^tu) (dhamma-dha^tu)
18. mind-consciousness-element
(mano-vin~n~a^na-dha^tu)
 
1-10 are physical; 11-16 and 18 are mental; 17 may be either physical or mental. - 16 performs the function of advertence (a^vajjana) towards the object at the inception of a process of sensuous consciousness; it further performs the function of receiving (sampaticchana) the sensuous object. 18 performs, e.g., the function of investigation (santi^rana), determining (votthapana) and registering (tada^rammana) - (for its other functions, s. Table I). For the 14 functions of consciousness, s. vin~n~a^na-kicca.
Cf. M. 115; S. XIV and especially Vibh. II (Guide p. 28f), Vis.M. XV, 17ff.
Of the many further groupings of elements (enumerated in M. 115), the best known is that of the 3 world-elements: the sensuous world (ka^ma-dha^tu), the fine-material world (rpa-dha^tu), the immaterial world (arpa-dha^tu); further the sixfold group: the solid, liquid, heat, motion, space, consciousness (pathavi^, a^po, tejo, va^yo, a^ka^sa, vin~n~a^na; s. above I), described in M. 140; see also M. 112.  'analysis (or determining) of the 4 elements', is described in Vis.M. XI, 2, as the last of the 40 mental exercises (s. bha^vana^). In a condensed form this exercise is handed down in D. 22 and M. 10 (s. satipattha^na), but in detail explained in M. 28, 62, 140. The simile of the butcher in M. 10 ("Just, o monks, as a skilled butcher or butcher's apprentice, after having slaughtered a cow and divided it into separate portions, should sit down at the junction of four highroads; just so does the disciple contemplate this body with regard to the elements") is thus explained in Vis.M. XI.: "To the butcher, who rears the cow, brings it to the slaughter-house, ties it, puts it there, slaughters it, or looks at the slaughtered and dead cow, the idea 'cow' does not disappear as long as he has not yet cut the body open and taken it to pieces. As soon, however, as he sits down, after having cut it open and taken it to pieces, the idea 'cow' disappears to him, and the idea 'meat' arises. And he does not think: 'A cow do I sell, or 'A cow do they buy.' Just so, when the monk formerly was still an ignorant worldling, layman or a homeless one, the ideas 'living being' or 'man' or 'individual' had not yet disappeared as long as he had not taken this body, whatever position or direction it had, to pieces and analysed it piece by piece. As soon, however, as he analysed this body into its elements, the idea 'living being' disappeared to him, and his mind became established in the contemplation of the elements." - (App.).   (lit. 'means of shaking off (the defilements)'); 'means of purification', ascetic or austere practices. These are strict observances recommended by the Buddha to monks as a help to cultivate contentedness, renunciation, energy and the like. One or more of them may be observed for a shorter or longer period of time.
"The monk training himself in morality should take upon himself the means of purification, in order to gain those virtues through which the purity of morality will become accomplished, to wit: fewness of needs, contentedness, austerity, detachment, energy, moderation, etc." (Vis.M. II).
 
Vis.M. II describes 13 dhutangas, consisting in the vows of
1. wearing patched-up robes: pamsuklik'anga,
2. wearing only three robes: teci^varik'anga,
3. going for alms: pindapa^tik'anga,
4. not omitting any house whilst going for alms: sapada^nikanga,
5. eating at one sitting: eka^sanik'anga,
6. eating only from the alms-bowl: pattapindik'anga,
7. refusing all further food: khalu-paccha^-bhattik'anga,
8. living in the forest: a^ran~n~ik'anga,
9. living under a tree: rukkha-mlik'anga,
10. living in the open air: abbhoka^sik'anga,
11. living in a cemetery: susa^nik'anga,
12. being satisfied with whatever dwelling: yatha^-santhatik'anga,
13. sleeping in the sitting position (and never lying down): nesajjik'anga.
 
These 13 exercises are all, without exception, mentioned in the old sutta texts (e.g. M. 5, 113; A.V., 181-90), but never together in one and the same place.
"Without doubt, o monks, it is a great advantage to live in the forest as a hermit, to collect one's alms, to make one's robes from picked-up rags, to be satisfied with three robes" (A.I, 30).
The vow, e.g. of No. 1, is taken in the words: "I reject robes offered to me by householders," or "I take upon myself the vow of wearing only robes made from picked-up rags." Some of the exercises may also be observed by the lay-adherent.
Here it may be mentioned that each newly ordained monk, immediately after his being admitted to the Order, is advised to be satisfied with whatever robes, alms-food, dwelling and medicine he gets: "The life of the monks depends on the collected alms as food ... on the root of a tree as dwelling ... on robes made from patched-up rags ... on stale cow's urine as medicine. May you train yourself therein all your life."
Since the moral quality of any action depends entirely upon the accompanying intention and volition, this is also the case with these ascetic practices, as is expressly stated in Vis.M. Thus the mere external performance is not the real exercise, as it is said (Pug. 275-84): "Some one might be going for alms; etc. out of stupidity and foolishness - or with evil intention and filled with desires - or out of insanity and mental derangement - or because such practice had been praised by the Noble Ones...." These exercises are, however properly observed "if they are taken up only for the sake of frugality, of contentedness, of purity, etc."(App.)
On dhutanga practice in modern Thailand, see With Robes and Bowl, by Bhikkhu Khantipalo (WHEEL 82/83).  the 'divine eye', is one of the 6 higher powers (abhin~n~a^, q.v.), and one of the three kinds of knowledge (tevijja^, q.v.).  heavenly world; s. deva.  the 'divine ear', is one of the 6 higher powers (abhin~n~a^, q.v.).  s. viha^ra.   vigata-paccaya, is one of the 24 conditions (paccaya, q.v.) . disciplinary code: s. pa^timokkha.  vica^ra; s. vitakka-vica^ra.   one of the 'divine messengers' (deva-dta, q.v.).   (regarding the whole world): s. sabbaloke anabhirati-san~n~a^.   s. sa^sana.   vippayutta-paccaya, is one of the 24 conditions (paccaya, q.v.) .   contemplation of: khaya^nupassana^, is one of the 18 chief kinds of insight (vipassana^, q.v.).  karma bearing fruit in this present life; s. karma.  (lit. 'sight'; ? dis, to see): view, belief, speculative opinion, insight. If not qualified by samma^, 'right', it mostly refers to wrong and evil view or opinion, and only in a few instances to right view, understanding or insight (e.g. ditthi-ppatta, q.v.; ditthi-visuddhi, purification of insight; ditthi-sampanna, possessed of insight).
Wrong or evil views (ditthi or miccha^-ditthi) are declared as utterly rejectable for being a source of wrong and evil aspirations and conduct, and liable at times to lead man to the deepest abysses of depravity, as it is said in A. I, 22:
"No other thing than evil views do I know, o monks, whereby to such an extent the unwholesome things not yet arisen arise, and the unwholesome things already arisen are brought to growth and fullness. No other thing than evil views do I know, whereby to such an extent the wholesome things not yet arisen are hindered in their arising, and the wholesome things already arisen disappear. No other thing than evil views do I know, whereby to such an extent human beings at the dissolution of the body, at death, are passing to a way of suffering, into a world of woe, into hell." Further in A. I, 23: "Whatever a man filled with evil views performs or undertakes, or whatever he possesses of will, aspiration, longing and tendencies, all these things lead him to an undesirable, unpleasant and disagreeable state, to woe and suffering."
From the Abhidhamma (Dhs) it may be inferred that evil views, whenever they arise, are associated with greed (s. Tab. I. 22, 23, 26, 27).
Numerous speculative opinions and theories, which at all times have influenced and still are influencing mankind, are quoted in the sutta-texts. Amongst them, however, the wrong view which everywhere, and at all times, has most misled and deluded mankind is the personality-belief, the ego-illusion. This personality-belief (sakka^ya-ditthi), or ego-illusion (atta-ditthi), is of 2 kinds: eternity-belief and annihilation-belief.
Eternity-belief (sassata-ditthi) is the belief in the existence of a persisting ego-entity, soul or personality, existing independently of those physical and mental processes that constitute life and continuing even after death.
Annihilation-belief (uccheda-ditthi), on the other hand, is the belief in the existence of an ego-entity or personality as being more or less identical with those physical and mental processes, and which therefore, at the dissolution at death, will come to be annihilated. - For the 20 kinds of personality-belief, see sakka^ya-ditthi.
Now, the Buddha neither teaches a personality which will continue after death, nor does he teach a personality which will be annihilated at death, but he shows us that 'personality', 'ego', 'individual', 'man', etc., are nothing but mere conventional designations (voha^ra-vacana) and that in the ultimate sense (s. paramattha-sacca) there is only this self-consuming process of physical and mental phenomena which continually arise and again disappear immediately. - For further details, s. anatta^, khandha, paticcasamuppa^da.
"The Perfect One is free from any theory (ditthigata), for the Perfect One has seen what corporeality is, and how it arises and passes away. He has seen what feeling ... perception ... mental formations ... consciousness are, and how they arise and pass away. Therefore I say that the Perfect One has won complete deliverance through the extinction, fading away, disappearance, rejection and casting out of all imaginings and conjectures, of all inclination to the 'vain-glory of 'I' and 'mine." (M. 72).
The rejection of speculative views and theories is a prominent feature in a chapter of the Sutta-Nipa^ta, the Atthaka-Vagga.
The so-called 'evil views with fixed destiny' (niyata-miccha^ditthi) constituting the last of the 10 unwholesome courses of action (kammapatha, q.v.), are the following three: (1) the fatalistic 'view of the uncausedness' of existence (ahetukaditthi), (2) the view of the inefficacy of action' (akiriyaditthi), (3) nihilism (natthikaditthi).
(1) was taught by Makkhali-Gosa^la, a contemporary of the Buddha who denied every cause for the corruptness and purity of beings, and asserted that everything is minutely predestined by fate.
(2) was taught by Prana-Kassapa, another contemporary of the Buddha who denied every karmical effect of good and bad actions: "To him who kills, steals, robs, etc., nothing bad will happen. For generosity, self-restraint and truthfulness, etc. no reward is to be expected."
(3) was taught by Ajita-Kesakambali, a third contemporary of the Buddha who asserted that any belief in good action and its reward is a mere delusion, that after death no further life would follow, that man at death would become dissolved into the elements, etc.
For further details about these 3 views, s. D. 2, M. 60; commentarial exposition in WHEEL 98/99, P. 23.
Frequently mentioned are also the 10 antinomies (antaga^hika^ miccha^-ditthi): 'Finite is the world' or 'infinite is the world' ... 'body and soul are identical' or 'body and soul are different' (e.g. M. 63).
In the Brahma^jala Sutta .(D.1), 62 false views are classified and described, comprising all conceivable wrong views and speculations about man and world.
See The All-Embracing Net of Views (Brahma^jala Sutta), tr. with Com. by Bhikkhu Bodhi (BPS).
Further s. D. 15, 23, 24, 28; M. 11, 12, 25, 60, 63, 72, 76, 101, 102, 110; A. II, 16; X, 93; S. XXI, XXIV; Pts.M. Ditthikatha^,. etc.
 
Wrong views (ditthi) are one of the proclivities (s. anusaya), cankers (s. a^sava), clingings (s. upa^da^na), one of the three modes of perversions (s. vipalla^sa). Unwholesome consciousness (akusala citta), rooted in greed, may be either with or without wrong views (ditthigata-sampayutta or vippayutta); s. Dhs.; Tab I.
On right view (samma^-ditthi), s. magga and M. 9 (Trans. with Com. in 'R. Und.').  'morality based on wrong views'; s. nissaya.  the 'vision attainer', is one of the 7 Noble Persons (ariya-puggala, q.v.).  'perversion of views'; s. vipalla^sa.  'purification of view' is the 3rd of the 7 stages of purification (visuddhi III, q.v.).   'clinging to views', is one of the 4 kinds of clinging (upa^da^na, q.v.).  s. viha^ra.  s. abhin~n~a^.  messengers, the 3: deva-dta (q.v.).  s. dhamma, sa^sana.  articles, the 3: tittha^yatana (q.v.).   lit. 'sad-mindedness', grief, i.e. mentally painful feeling (cetasika-vedana^), is one of the 5 feelings (vedana^, q.v.) and one of the 22 faculties (indriya, q.v.). According to the Abhidhamma, grief is always associated with antipathy and grudge, and therefore karmically unwholesome (akusala, q.v.) Cf. Tab. I. 30, 31.   'indulging in grief'; s. manopavica^ra.  of deliverance, the 3: vimokkha-dva^ra; s. vimokkha I; visuddhi VI, 8.   'hatred', anger, is one of the 3 unwholesome, roots (mla, q.v.). - d. citta: hate consciousness; s. Tab. I (30, 31).  'angry-or hate-natured'; s. carita.   skeptical: vicikiccha^ (q.v.), kankha^ (q.v.).   moral: ottappa s. hiri-ottappa.   On the evil effects of drinking intoxicants, s. sura^meraya, etc.  s. sukkha-vipassaka.   'evil conduct', is threefold: in deeds, words and thoughts. See kammapatha (I).   'woeful course' (of existence); s. gati.   (1) 'pain', painful feeling, which may be bodily and mental (s. vedana^).
(2) 'Suffering', 'ill'. As the first of the Four Noble Truths (s. sacca) and the second of the three characteristics of existence (s. ti-lakkhana), the term dukkha is not limited to painful experience as under (1), but refers to the unsatisfactory nature and the general insecurity of all conditioned phenomena which, on account of their impermanence, are all liable to suffering, and this includes also pleasurable experience. Hence 'unsatisfactoriness' or 'liability to suffering' would be more adequate renderings, if not for stylistic reasons. Hence the first truth does not deny the existence of pleasurable experience, as is sometimes wrongly assumed. This is illustrated by the following texts:
"Seeking satisfaction in the world, monks, I had pursued my way. That satisfaction in the world I found. In so far as satisfaction existed in the world, I have well perceived it by wisdom. Seeking for misery in the world, monks, I had pursued my way. That misery in the world I found. In so far as misery existed in the world, I have well perceived it by wisdom. Seeking for the escape from the world, monks, I had pursued my way. That escape from the world I found. In so far as an escape from the world existed, I have well perceived it by wisdom" (A. 111, 101).
"If there were no satisfaction to be found in the world, beings would not be attached to the world .... If there were no misery to be found in the world, beings would not be repelled by the world .... If there were no escape from the world, beings could not escape therefrom" (A. 111, 102).
See dukkhata^. For texts on the Truth of Suffering, see W. of B. and 'Path'.
See The Three Basic Facts of Existence, II. Suffering (WHEEL 191/193).   s. vipassana^.  (abstr. noun fr. dukkha): 'the state of suffering', painfulness, unpleasantness, the unsatisfactoriness of existence. "There are three kinds of suffering: (1) suffering as pain (dukkha-dukkhata^), (2) the suffering inherent in the formations (sankha^ra-dukkhata^), (3) the suffering in change (viparina^ma-dukkhata^)" (S. XLV, 165; D. 33).
(1) is the bodily or mental feeling of pain as actual]y felt. (2) refers to the oppressive nature of all formations of existence (i.e. all conditioned phenomena), due to their continual arising and passing away; this includes also experiences associated with neutral feeling. (3) refers to bodily and mental pleasant feelings, "because they are the cause for the arising of pain when they change" (Vis.M. XIV, 34f).  'painful progress'; s. patipada^.  s. patisandhi.   Suitable d. for monks; s. sena^sana. Satisfied with whatever d.; s. dhutanga.   appama^da (q.v.).  s. dha^tu (I).   knowing the measure in bhojane mattan~n~uta^ (q.v.).   the 4 right e.: samma-ppadha^na; s. padha^na. Right e. s. sacca (IV 6), magga (6) . - 5 elements of e.: padha^niyanga (q.v.).  atta^ (q.v.).  s. ditthi, sakka^ya-ditthi, vipalla^sa.  s. vipalla^sa.   anatta^ (q.v.).  s. magga.  'germinating only once more', is the name for one of the 3 kinds of Stream-winners: s. Sota^panna.   the exercise of eating at one sitting, is one of the ascetic practices; s. dhutanga.  one-group existence, is the existence of the unconscious beings (asan~n~a-satta, q.v.) as they possess only the corporeality-group. Cf. catu-voka^ra-bhava, pan~ca-voka^ra-bhava.  (of corporeality, mental factors or consciousness): muduta^; s. khandha (Corporeality I.B.) and Tab. II.   the teaching of the: Therava^da (q.v.).   dha^tu (q.v.). - Analysis of the 4 e.: dha^tu-vavattha^na (q.v.).   8 sources of e.: samvega-vatthu (q.v.). The 4 places rousing emotion; samvejani^ya-ttha^na (q.v.).   sun~n~ata^ (q.v.). - Contemplation of e.: sun~n~ata^nupassana^. - For emptiness of self, pertaining to the 4 truths, s. sacca.   'attaining two ends simultaneously'; sama-si^si^ (q.v.).   viriya (q.v.); further s. bojjhanga, bala, pa^rami^.  one, the: Buddha; s. samma^-sambuddha.   bodhi (q.v.). - The 7 elements of e.: bojjhanga (q.v.). - A being destined for e.: Bodhisatta (q.v.).   pi^ti (q.v.).   issa^ (q.v.).  s. ma^na.   upekkha^ (q.v.) = tatra-majjhattata^ (q.v.). - Knowledge consisting in e. with regard to all formations, s. visuddhi (VI, 8). - Indulging in e., s. manopavica^ra.  indriya-samatta (q.v.).   nissarana (s. paha^na).   cf. kappa.  sassata-ditthi; s. ditthi.   see padha^na, viriya, magga (6). - Reaching Nibba^na with or without e.; s. Ana^ga^mi.   bhava (q.v.) - The 5 groups of e.: khandha (q.v.) - The 4 substrata of e.: upadhi (q.v.). - Courses of e.: gati (q.v.). - Wheel of e.: samsa^ra (q.v.). - Craving for e.: bhava-tanha^; s. tanha^; - The 3 characteristics of e.: ti-lakkhana (q.v.).  (bodily and verbal): s. vin~n~atti.   s. nirodha; - of craving: tanhakkhaya (q.v.).   the two e. and the middle path; s. majjhima-patipada^.   5 kinds, s. cakkhu. - Visual organ, s. a^yatana.  cakkhu-vin~n~a^na; s. dha^tu, khandha.  s. a^yatana.   mental: s. cetasika. - F. of absorption, s. jha^na - F. of enlightenment, s. bojjhanga.   indriya (q.v.); see also paccaya 16.  s. vira^ga.   saddha^ (q.v.).  devotee and faith liberated one: s. ariyapuggala (B).  saddha^-carita; s. carita.   s. ditthi.   4 ways of showing sangaha-vatthu. (q.v.).   vedana^ (q.v.); further s. khandha. - Contemplation of f.: vedana^nupassana^; s. satipattha^na.   s bha^va, indriya.   The 10 f. binding to existence; s. samyojana.  s. appicchata^.  material sphere or world: s. avacara, loka. Absorptions of the: rpa-jjha^na; s. jha^na.  s. dha^tu (I).  sense door, Advertence to the: pan~cadva^ra^vajjana; s. vin~n~a^na-kicca.  pan~ca-voka^ra-bhava (q.v.).  s. niyata-miccha^-ditthi, niyata-puggala.   s. niyama, tathata^, dhamma-tthiti-n~a^na.   the 4: ogha, are identical with the 4 cankers (a^sava, q.v.).   material: is one of the 4 nutriments (a^ha^ra, q.v.). Foodproduced corporeality, s. samuttha^na. - Refusing all further f., s. dhutanga. - Loathsomeness of f. s. a^ha^re patikkla-san~n~a^.  sampha-ppala^pa; s. karma, kammapatha (I); cf. tiraccha^na-katha^.   khanti (q.v.).  dweller, the ascetic practice for the: s. dhutanga.   sankha^ra (q.v.).   nissaya, one of the 24 conditions (paccaya, q.v.). Wrong f. of morality, s. nissaya. - f. of sympathy: sangaha-vatthu (q.v.) - f.-forming absorptions: pa^daka-jjha^na (q.v.); - f. of an Arahat's mentality: s. adhittha^na.  of mindfulness, the 4: satipattha^na (q.v.) .  catu-voka^ra-bhava (q.v.).  of will, problem of the: cf. paticcasamuppa^da (X).   noble: kalya^na-mitta (q.v.).  cf. tiraccha^na-katha^, kamma-patha (I, 7), karma.  (result of supermundane path): phala; s. ariyapuggala (A) .  sa^man~n~a-phala (q.v.)  parin~n~a^ (q.v.).  consciousness, or consciousness functioning independently of karma: kiriya-citta (q.v.); see vin~n~a^na-kicca.  vin~n~a^na-kicca (q.v.).   'ties'. "There are 4 ties: the bodily tie (ka^yagantha) of covetousness (abhijjha^), of ill-will (vya^pa^da), of clinging to rule and ritual (si^labbata-para^ma^sa), of dogmatical fanaticism (idamsacca^bhinivesa)" (D. 33). - "These things are ties, since they tie this mental and material body" (Vis.M. XXII, 54).  weighty karma; s. karma.  (lit. 'going'): 'course of existence', destiny, destination. "There are 5 courses of existence: hell, animal kingdom, ghost realm, human world, heavenly world" (D. 33; A. XI, 68). Of these, the first 3 count as woeful courses (duggati, s. apa^ya), the latter 2 as happy courses (sugati).   the 3: ti-ratana (q.v.).   the 4 modes of: yoni (q.v.).  eka-bi^ji^, is the name of one of the 3 kinds of Sota^panna (q.v.).   cf. peta, yakkha; s. loka.   da^na (q.v.).   somanassa (q.v.). - Indulging in g., s. manopavica^ra.   s. indriya (21).   lit. 'who has entered the lineage (of the Noble Ones)', i.e. the Matured One.
I. 'Maturity-Moment' (gotrabh-citta) is the last of the 4 impulsive moments (javana, q.v.; cf. vin~n~a^na-kicca) immediately preceding the entering into an absorption (jha^na, q.v.) or into one of the supermundane paths (s. ariya-puggala, A.). Cf. visuddhi VII.
II. The 'Matured One'. "He who is endowed with those things, immediately upon which follows the entrance into the noble path (ariya-magga), this person is called a 'Matured One'." (Pug 10). In the Com. to this passage it is said: "He who through perceiving Nibba^na, leaves behind the whole multitude of worldlings (puthujjana, q.v.), the family of worldlings, the circle of worldlings, the designation of a worldling and enters into the multitude of the Noble Ones, the family of the Noble Ones, the circle of the Noble Ones, and obtains the designation of a Noble One, such a being is called a Matured One." By this state of consciousness is meant the lightning-like transitional stage between the state of a worldling and that of a Sota^panna; s. ariya-puggala. - Gotrabh is mentioned in this sense, i.e. as 9th ariyapuggala (q.v.), in A. IX, 10; X, 16.  'Maturity-knowledge'; s. prec. and visuddhi (VII)  a^nupubbi^katha^ (q.v.).   cf. para^ma^sa, upa^da^na.  man, the 8 thoughts of a: maha^purisa-vitakka (q.v.).   lobha (q.v.).  s. Tab, I, III. (22-29).  ra^ga-carita; s. carita. F  domanassa (q.v.) - Indulging in g. s. manopavica^ra.   of existence, s. khandha; corporeal groups, s. rpa-kala^pa; corporeality-group, s. rpa-ka^ya; mind-group, s. na^ma-ka^ya.   bodily: rpassa upacaya: s. khandha I.   s. patigha.  s. a^yatana.  bahula-kamma: s. karma.  'heart as physical base' of mental life. The heart, according to the commentaries as well as to the general Buddhist tradition, forms the physical base (vatthu) of consciousness In the canonical texts, however, even in the Abhidhamma Pitaka, no such base is ever localized, a fact which seems to have first been discovered by Shwe Zan Aung (Compendium of Philosophy, pp. 277ff.). In the Patth. we find repeatedly only the passage: "That material thing based on which mind-element and mind-consciousness element function" (yam rpam nissa^ya manodha^tu ca mano-vin~n~a^na-dha^tu ca vattanti, tam rpam).  bha^giya si^la, h. b. sama^dhi, h. b. pan~n~a^: morality, concentration or wisdom connected with decline. The other three stages are: thiti-bha^giya-si^la, etc. morality, etc. connected with a standstill; visesa-bha^giya si^la, etc.: morality, etc. connected with progress; nibbedha-bha^giya si^la, etc.: morality, etc. connected with penetration. Cf. A. IV, 179; VI. X, 71.
" 'Decline' (ha^na) is to be understood with regard to the arising of opposing qualities, 'standstill' (thiti) with regard to the standstill of the corresponding attentiveness, 'progress' (visesa) with regard to higher excellency, 'penetration' (nibbedha) with regard to the arising of perception and reflection connected with the turning away (from existence)" (Vis.M. III). Cf. voda^na (2).   feeling of h.: s. sukha. - The idea of h. (of the world), s. vipalla^sa.  s. gati.   s. avihimsa^.  lit. 'consciousness producing mirth' (smile), is found in the Abhidhammattha Sangaha as a name for the joyful mind-consciousness element (manovin~n~a^na-dha^tu, Tab. I. 72) arising as functional consciousness independent of karma (kiriya-citta), only in the Arahat. - (App.).  and hatelessness: (dosa, adosa) are two of the 6 karmical roots (mla, q.v.) or root-conditions (hetu; paccaya 1).  s. Tab. I. (30, 31).  dosa-carita; s. carita.  s. mada.  (disciple): sa^vaka (q.v.).  tejo-dha^tu; s. dha^tu.   niraya (q.v.).   'cause', condition, reason; (Abhidhamma) root-condition. In sutta usage it is almost synonymous with paccaya, 'condition', and often occurs together with it ('What is the cause, what is the condition', ko hetu ko paccayo).
In Abhidhamma, it denotes the wholesome and unwholesome roots (mla, q.v.). In that sense, as 'root-condition' (hetu-paccaya; s. paccaya), it is the first of the 24 conditions given in the introduction to the Pattha^na (s. Guide, p. 117). The Dhs (1052-1082) and Pattha^na (Duka-patth; Guide, p. 144) have sections on roots (hetu). - The term is also used (a) for the classification of consciousness, as sa-hetuka and a-hetuka, with and without concomitant root-conditions; (b) for a division of rebirth consciousness into ahetuka, dvihetuka and tihetuka, without, with 2, or with 3 root-conditions (s. patisandhi).
Ahetuka-ditthi, the false view of the uncausedness of existence; s. ditthi.  clear insight based on h. w.: s. vipassana^. Training in H. W., s. sikkha^.  s. an~n~a^.   the 5: ni^varana (q.v.).  'moral shame and moral dread', are associated with all karmically wholesome consciousness (s. Tab. II).
"To be ashamed of what one ought to be ashamed of, to be ashamed of performing evil and unwholesome things: this is called moral shame. To be in dread of what one ought to be in dread of, to be in dread of performing evil and unwholesome things: this is called moral dread" (Pug, 79, 80).
"Two lucid things, o monks, protect the world: moral shame and moral dread. If these two things were not to protect the world, then one would respect neither one's mother, nor one's mother's sister, nor one's brother's wife, nor one's teacher's wife ...." (A. II, 7). Cf. ahirika. See Atthasa^lini Tr. I. pp. 164ff.   going into pabbajja^ (q.v.). Cf. Progress of the disciple.  cf. loka, gati.   'power', 'magical power'. The magical powers constitute one of the 6 kinds of higher spiritual powers (abhin~n~a^, q.v.). One distinguishes many kinds of magical powers: the power of determination (adhittha^n' iddhi), i.e. the power of becoming oneself manifold; the power of transformation (vikubbana iddhi), i.e. the power of adopting another form; the power of spiritual creation (manomaya iddhi), i.e. the power of letting issue from this body another mentally produced body; the power of penetrating knowledge (n~a^na-vipphara iddhi), i.e. the power of inherent insight to remain unhurt in danger; the power of penetrating concentration (sama^dhivipphara^ iddhi) producing the same result. The magical powers are treated in detail in Vis.M. XII; Pts.M., Vibh. - (App.). They are not a necessary condition for final deliverance.
'Noble power' (ariya^-iddhi) is the power of controlling one's ideas in such a way that one may consider something not repulsive as repulsive and something repulsive as not repulsive, and remain all the time imperturbable and full of equanimity. This training of mind is frequently mentioned in the Suttas (e.g. M. 152, A.V. 144), but only once the name of ariya^-iddhi is applied to it (D. 28). See further Pts.M., Iddhi-katha^, Vis.M. XII.  'roads to power' (or success) are the 4 following qualities, "for as guides, they indicate the road to power connected therewith; and because they form, by way of preparation, the roads to the power constituting the fruition of the path" (Vis.M. XII), namely: "concentration of intention (chanda-sama^dhi) accompanied by effort of will (padha^na-sankha^ra-samanna^gata), concentration of energy (viriya-sama^dhi) ... concentration of consciousness (citta-sama^dhi) ... and concentration of investigation (vimamsa-sama^dhi) accompanied by effort of will." As such, they are supermundane (lokuttara, i.e. connected with the path or the fruition of the path; s. ariyapuggala) But they are mundane (lokiya, q.v.) as predominant factors (adhipati; s. paccaya 3), for it is said: "Because the monk, through making intention a predominant factor, reaches concentration, it is called the concentration of intention (chanda-sama^dhi), etc." (Vis.M. XII).
"These 4 roads of power lead to the attaining and acquiring of magical power, to the power of magical transformation, to the generation of magical power, and to mastery and skill therein" (Pts.M. II. 205, PTS). For a detailed explanation, s. Vis.M. XII.
"Once the monk has thus developed and often practised the 4 roads to power, he enjoys various magical powers, ... hears with the divine ear heavenly and human sounds, ... perceives with his mind the mind of other beings ... remembers many a former existence ... perceives with the divine eye beings passing away and reappearing, ... attains, after the extinction of cankers, deliverance of mind and deliverance through wisdom, free from. cankers.... (S. LI, 2). For a detailed explanation of these 6 higher powers, s. abhin~n~a^.
"Whosoever, o monks, has missed the 4 roads to power, he has missed the right path leading to the extinction of suffering; but whosoever, o monks, has reached the 4 roads to power, he has reached the right path leading to the extinction of suffering" (S. LI, 2).
See the chapter on Iddhipa^da in The Requisites of Enlightenment by Ledi Sayadaw (WHEEL 169/172).   avijja^ (q.v.); further s. paticcasamuppa^da (1).  humour, heavenly beings who come to grief through: mano-padosika-deva (q.v.).  vya^pa^da, is a synonym of dosa (s. mla) and patigha and is one of the 10 fetters (samyojana, q.v.), 5 hindrances (ni^varana, q.v.) and 10 unwholesome courses of action (s. kammapatha, I).   mental: s. nimitta, sama^dhi, kasina.  arpa^vacara: cf. avacara, jha^na (5-8); Tab. I.  arpa-loka; s. loka.   an alternative rendering for contiguity-condition, samanatara-paccaya, which is one of the 24 conditions (paccaya, q.v.)   the: a^nantariya (q.v.).   s. amata.   s. upakkilesa.   anicca (q.v.). - Contemplation of i., cf. vipassana^ (1).  s. anatta^. - Contemplation of: s. vipassana^ (3).  a^nen~ja^bhisankha^ra; s. sankha^ra.   sensorial or mental: phassa (q.v.).   javana (q.v.).   s. upakkilesa.  of the body, contemplation of the: s. asubha, si^vathika^.   s. anusaya.  Pacceka-Buddha (q.v.).  feeling cf. vedana^, upekkha^.   puggala (q.v.).   'faculties', is a name for 22, partly physical, partly mental, phenomena often treated in the Suttas as well as in the Abhidhamma. They are:
 
6 Bases (a^yatana, q.v.):
1. eye: cakkhu
2. ear: sota
3. nose: gha^na
4. tongue: jivha^
5. body: ka^ya
6. mind: mano
Sex (bhava, q.v.):
7. femininity: itthi
8. masculinity: purisa
9. vitality: ji^vita
5 Feelings (vedana^, q. v.)
10. bodily pleasant feeling: sukha
11. bodily pain: dukkha
12. gladness: somanassa
13. sadness: domanassa
14. indifference: upekkha^
5 Spiritual Faculties (s. bala)
15. faith: saddha^
16. energy: viriya
17. mindfulness: sati
18. concentration: sama^dhi
19. wisdom: pan~n~a^
3 Supermundane Faculties
20. the assurance: 'I shall know what I did not yet know!': an~n~a^tan~-n~assa^mi^t' indriya
21. the faculty of highest knowledge: an~n~indriya
22. the faculty of him who knows: an~n~a^ta^vindriya.
 
(1-5, 7-8) are physical; (9) is either physical or mental. All the rest are mental. - (14) (s. upekkha^) is here merely indifferent feeling (= adukkha-m-asukha^ vedana^, i.e. 'neither pleasant nor unpleasant feeling') and not identical with that highly ethical state of equanimity (= tatramajjhattata^, i.e. 'keeping everywhere the middle', the equipoise of mind), also called upekkha^ which belongs to the group of mental formations (sankha^ra-kkhandha; s. Tab II). - (20) arises at the moment of entering the Sota^patti-Path (sota^patti-magga), (21) on reaching the Sota^patti-Fruition (sota^patti-phala), (22) at attaining the Arahat-Fruition (arahatta-phala). For the three last, s. ariya-puggala.
The faculties, excepting (7) and (8), form one of the 24 conditions (paccaya 16, q.v.).
In Vibh. V all these faculties are treated in the above order, whereas S. XLVIII enumerates and explains them by way of the above indicated groups, leaving only 20-22 unexplained. See Vis XVI; Path 138ff. - For the 5 spiritual faculties (15-19), s. The Way of Wisdom (WHEEL 65/66).  s. paccaya 16.  'equilibrium, balance, or harmony of faculties', relates to the 5 spiritual faculties: faith, energy, mindfulness, concentration and wisdom (s. indriya 15-19). Of these there are two pairs of faculties, in each of which both faculties should well counter-balance each other, namely: faith and wisdom (saddha^, pan~n~a^, q.v.) on the one hand and energy and concentration (viriya, sama^dhi, q.v.) on the other. For excessive faith with deficient wisdom leads to blind belief, whilst excessive wisdom with deficient faith leads to cunning. In the same way, great energy with weak concentration leads to restlessness, whilst strong concentration with deficient energy leads to indolence. Though for both faculties in each of the 2 pairs a balanced degree of intensity is desirable, mindfulness should be allowed to develop to the highest degree of strength. Cf. Vis.M. III- (App.).  'morality consisting of purity of restraint of the senses'; s. si^la.  'guarding the sense-doors' is identical with sense-control (indriya-samvara; s. si^la).  and out breathing, watching over: a^na^pa^na-sati (q.v.).   an alternative rendering for decisive-support condition, upanissaya, is one of the 24 conditions (paccaya; q.v.).  (in joy, sadness etc.): s. manopavica^ra.  s. karma.   cf. mada, moha (s. mla), avijja^.  an 'expression the meaning of which is to be inferred': neyyattha-dhamma (q.v.). - Antonym: 'expression with an established meaning': ni^tattha-dhamma (s. neyyattha-dhamma).  s. ma^na.  (cankers), the 4: a^sava (q.v.).  consciousness, karmically; s. kiriyacitta.  mental factors, the 7 i. m. f. in all consciousness: s. cetana^, phassa, na^ma.   cf. pan~n~a^, vipassana^, n~a^na.  s. carita.   chanda (q.v.) .   pi^ti (q.v.); cf. Tab. II.   cf. vin~n~atti.   s. a^sava.  drinks, the evil effect of taking: s. sura^meraya.  function (of consciousness): santi^rana; s. vin~n~a^na-kicca.   full understanding through: ti^ranaparin~n~a^, s. parin~n~a^. - 'Investigation' (vi^mamsa^) is one of the 4 roads to power (iddhipa^da, q.v.) and one of the 4 predominants (adhipati; s paccaya 3). - i. of truth: dhamma-vicaya, is one of the 7 factors of enlightenment (bojjhanga, q.v.).  patha (lit. 'ways of movement'): 'bodily postures', i.e. going, standing, sitting, lying. In the Satipattha^na-sutta (s. satipattha^na), they form the subject of a contemplation and an exercise in mindfulness.
"While going, standing, sitting or lying down, the monk knows 'I go', 'I stand', 'I sit', 'I lie down'; he understands any position of the body." - "The disciple understands that there is no living being, no real ego, that goes, stands, etc., but that it is by a mere figure of speech that one says: 'I go', 'I stand', and so forth." (Com.).   'envy', is a karmically unwholesome (akusala) mental factor, which is occasionally associated with hate-rooted consciousness (s. Tab. I. 30, 31,). Explained in Pug. 55.   'femininity'; s. bha^va.  'regenerative karma'; s. karma.   'old age, decay', is one of the 3 divine messengers (s. deva-dta, q.v.). For its conditioning by birth, s. paticcasamuppa^da (11).   'birth', comprises the entire embryonic process beginning with conception and ending with parturition.
"The birth of beings belonging to this or that order of beings, their being born, their conception (okkanti) and springing into existence, the manifestation of the groups (corporeality, feeling, perception, mental formations, consciousness; s. khandha), the acquiring of their sensitive organs: this is called birth" (D. 22). For its conditioning by the prenatal karma-process (kamma-bhava; s. bhava), s. paticcasamuppa^da (9, 10), patisandhi.  (fr. javati, to impel): 'impulsion', is the phase of full cognition in the cognitive series, or perceptual process (citta-vi^thi; s. vin~n~a^na-kicca) occurring at its climax, if the respective object is large or distinct. It is at this phase that karma is produced, i.e. wholesome or unwholesome volition concerning the perception that was the object of the previous stages of the respective process of consciousness. There are normally 7 impulsive moments. In mundane consciousness (lokiya, q.v.), any of the 17 karmically wholesome classes of consciousness (Tab. I, 1-17) or of the 12 unwholesome ones (Tab. I, 22-23) may arise at the phase of impulsion. For the Arahat, however, impulsion has no longer a karmic, i.e. rebirth-producing character, but is a karmically independent function (kiriya, q.v.; Tab. I, 72-89). There are further 8 supermundane classes of impulsion (Tab. I, 18-21, 66-69).
The 4 impulsive moments immediately before entering an absorption (jha^na, q.v.) or one of the supermundane paths (magga; s. ariyapuggala) are: the preparatory (parikamma), approach (upaca^ra), adaptation (anuloma), and maturity-moment (gotrabh, q.v.) In connection with entering the earth-kasina absorption (s. kasina), they are explained as follows, in Vis.M. IV: "After the breaking off of the subconscious stream of being (bhavanga-sota, q.v.), there arises the 'advertence at the mind-door' (manodva^ra^vajjana, s. vin~n~a^nakicca), taking as object the earthkasina (whilst thinking), 'Earth! Earth!' Thereupon, 4 or 5 impulsive moments flash forth, amongst which the last one (maturity-moment) belongs to the fine-material sphere (rpa^vacara), whereas the rest belong to the sense-sphere (ka^ma^vacara; s. avacara), though the last one is more powerful in thought conception, discursive thinking, interest (rapture), joy and concentration (cf. jha^na) than the states of consciousness belonging to the sense-sphere. They are called 'preparatory' (parikamma-sama^dhi), as they are preparing for the attainment-concentration (appana^-sama^dhi); 'approaching' (upaca^ra-sama^dhi), as they are close to the attainment-concentration and are moving in its neighbourhood; 'adaptive' (anuloma), as they adapt themselves to the preceding preparatory states and to the succeeding attainment concentration. The last one of the four is called 'matured' (gotrabh). In a similar way, the impulsive moments before reaching the divine ear are described in Vis.M. XIII, 1. - Cf. Karma - (App.).   The 3: ti-ratana (q.v.).   'absorption' (meditation) refers chiefly to the four meditative absorptions of the fine-material sphere (rpa-jjha^na or rpa^vacara-jjha^na; s. avacara). They are achieved through the attainment of full (or attainment -, or ecstatic) concentration (appana^, s. sama^dhi), during which there is a complete, though temporary, suspension of fivefold sense-activity and of the 5 hindrances (s. ni^varana). The state of consciousness, however, is one of full alertness and lucidity. This high degree of concentration is generally developed by the practice of one of the 40 subjects of tranquillity meditation (samatha-kammattha^na; s. bha^vana^). Often also the 4 immaterial spheres (arpa^yatana) are called absorptions of the immaterial sphere (arpa-jjha^na or arpa^vacara-jjha^na). The stereotype text, often met with in the Suttas, runs as follows:
(1) "Detached from sensual objects, o monks, detached from unwholesome consciousness, attached with thought-conception (vitakka) and discursive thinking (vica^ra), born of detachment (vivekaja) and filled with rapture (pi^ti) and joy (sukha) he enters the first absorption.
(2) "After the subsiding of thought-conception and discursive thinking, and by gaining inner tranquillity and oneness of mind, he enters into a state free from thought-conception and discursive thinking, the second absorption, which is born of concentration (sama^dhi), and filled with rapture (pi^ti) and joy (sukha).
(3) "After the fading away of rapture he dwells in equanimity, mindful, clearly conscious; and he experiences in his person that feeling of which the Noble Ones say, 'Happy lives the man of equanimity and attentive mind'; thus he enters the 3rd absorption.
(4) "After having given up pleasure and pain, and through the disappearance of previous joy and grief, he enters into a state beyond pleasure and pain, into the 4th absorption, which is purified by equanimity (upekkha^) and mindfulness.
(5) "Through the total overcoming of the perceptions of matter, however, and through the vanishing of sense-reactions and the non-attention to the perceptions of variety, with the idea, 'Boundless is space', he reaches the sphere of boundless space (a^ka^sa^nan~ca^yatana) and abides therein.
 
["By 'perceptions of matter' (rpa-san~n~a^) are meant the absorptions of the fine-material sphere, as well as those objects themselves . . . " (Vis.M. X, 1).
"By 'perceptions of sense-reactions' (patigha-san~n~a^) are meant those perceptions that have arisen due to the impact of sense-organs (eye, etc.) and the sense-objects (visible objects, etc.). They are a name for the perception of visible objects, as it is said (Jha^na-Vibh . ): 'What are here the perceptions of sense-reactions? They are the perceptions of visible objects, sounds, etc.' - Surely, they do no longer exist even for one who has entered the 1st absorption, etc., for at such a time the five-sense consciousness is no longer functioning. Nevertheless, this is to be understood as having been said in praise of this immaterial absorption, in order to incite the striving for it" (Vis.M. X, 16).
"Perceptions of variety (n~a^natta-san~n~a^) are the perceptions that arise in various fields, or the various perceptions" (ib.). Hereby, according to Vis.M. X, 20, are meant the multiform perceptions outside the absorptions.]
 
(6) "Through the total overcoming of the sphere of boundless space, and with the idea 'Boundless is consciousness', he reaches the sphere of boundless consciousness (vin~n~a^nan~ca^yatana) and abides therein.
(7) "Through the total overcoming of the sphere of boundless consciousness, and with the idea 'Nothing is there', he reaches the sphere of nothingness (a^kin~can~n~a^yatana) and abides therein.
(8) "Through the total overcoming of the sphere of nothingness he reaches the sphere of neither-perception-nor-non-perception (nevasan~n~a^-n'asan~n~a^yatana) and abides therein."
"Thus the 1st absorption is free from 5 things (i.e. the hindrances, ni^varana, q.v.), and 5 things are present (i.e. the factors of absorption; jha^nanga). Whenever the monk enters the 1st absorption, there have vanished sensuous desire, ill-will, sloth and torpor, restlessness and scruples, doubts; and there are present: thought-conception (vitakka), discursive thinking (vica^ra) rapture (pi^ti), joy (sukha), and concentration (sama^dhi). In the 2nd absorption there are present: rapture, joy and concentration; in the 3rd: joy and concentration; in the 4th: equanimity (upekkha^) and concentration" (Vis.M. IV).
The 4 absorptions of the immaterial sphere (s. above 5-8) still belong, properly speaking, to the 4th absorption as they possess the same two constituents. The 4th fine-material absorption is also the base or starting point (pa^daka-jha^na, q.v.) for the attaining of the higher spiritual powers (abhin~n~a^, q.v.).
In the Abhidhamma, generally a fivefold instead of a fourfold division of the fine-material absorptions is used: the 2nd absorption has still the constituent 'discursive thinking' (but without thought-conception), while the 3rd, 4th and 5th correspond to the 2nd, 3rd and 4th, respectively, of the fourfold division (s. Tab. I, 9- 13) . This fivefold division is based on sutta texts like A . VIII, 63 .
For the 8 absorptions as objects for the development of insight (vipassana^), see samatha-vipassana^. - Full details in Vis.M. IV-X.
Jha^na in its widest sense (e.g. as one of the 24 conditions; s. paccaya 17), denotes any, even momentary or weak absorption of mind, when directed on a single object.   'constituents (or factors) of absorption'; s. prec.  paccaya, is one of the 24 conditions (paccaya, q.v.).   life, vital principle, individual soul. 'Soul (life) and body are identical' and 'Soul and body are different', these two frequently quoted wrong views fall under the 2 kinds of personality-belief (sakka^ya-ditthi; s. ditthi), i.e. the first one under the annihilation-belief (uccheda-ditthi) and the second under the eternity-belief (sassata-ditthi).
"Verily, if one holds the view that the soul (life) is identical with the body, in that case a holy life is not possible; or if one holds the view that the soul (life) is something quite different, also in that case a holy life is impossible. Both these extremes the Perfect One has avoided and shown the Middle Doctrine, which says: 'On ignorance depend the karma-formations, on the karma-formations depends consciousness', etc." (S. XII. 35).  and ji^vitindriya: 'Life, vitality', may be either physical (rpa-ji^vitindriya) or mental (na^ma-ji^vitindriya). The latter is one of the mental factors inseparably associated with all consciousness; cf. na^ma, cetana^, phassa.  ninefold vital group; s. rpa-kala^pa.   somanassa (q.v.). - Altruistic j. = mudita^ (s. brahma-viha^ra).   lit. 'food formed into balls', i.e. food formed into mouthfuls for eating (according to Indian custom); it denotes 'material food' and belongs, together with the three mental nutriments, to the group of four nutriments (s. a^ha^ra).   'group', 'unit': 1. 'corporeal unit' (s. rpa-kala^pa); 2. It has the meaning of 'group of existence' (khandha) in kala^pasammasana (s. sammasana), i.e. 'comprehension by groups', which is the application of 'methodical (or inductive) insight' (naya-vipassana^) to the comprehension of the 5 aggregates (khandha) as impermanent, painful and not-self. It is a process of methodical summarization, or generalization, from one's own meditative experience that is applied to each of the 5 aggregates, viewed as past, present, future, as internal and external, etc. In Vis.M. XX, where the 'comprehension by groups' is treated in detail, it is said to constitute 'the beginning of insight' as it leads to the 'knowledge of rise and fall', being the first of the 8 insightknowledges (s. visuddhi VI). It is necessary for accomplishing the 5th purification (s. visuddhi V; Vis.M. XX, 2, 6ff.).   (Skr) = kappa (q.v.).  'noble (or good) friend', is called a senior monk who is the mentor and friend of his pupil, "wishing for his welfare and concerned with his progress", guiding his meditation; in particular, the meditation teacher (kammattha^na^cariya) is so called. For details see Vis.M. III, 28,57ff. The Buddha said that "noble friendship is the entire holy life" (S. III, 18; XLV, 2), and he himself is the good friend par excellence: "Ananda, it is owing to my being a good friend to them that living beings subject to birth are freed from birth" (S. III, 18).  may denote: 1. subjective sensuality, 'sense-desire'; 2. objective sensuality, the five sense-objects.
1. Subjective sensuality, or sense-desire, is directed to all five sense-objects, and is synonymous with ka^ma-cchanda, 'sensuous desire', one of the 5 hindrances (ni^varana, q.v.); ka^ma-ra^ga, sensuous lust', one of the ten fetters (samyojana, q.v.); ka^ma-tanha^, 'sensuous craving', one of the 3 cravings (tanha^, q.v.); ka^ma-vitakka, 'sensuous thought', one of the 3 wrong thoughts (miccha^-sankappa; s. vitakka). - Sense-desire is also one of the cankers (a^sava, q.v.) and clingings (upa^da^na, q.v.).
2. Objective sensuality is, in the canonical texts, mostly called ka^ma-guna, 'cords (or strands) of sensuality'.
"There are 5 cords of sensuality: the visible objects, cognizable by eye-consciousness, that are desirable, cherished, pleasant, lovely, sensuous and alluring; the sounds ... smells ... tastes ... bodily impressions cognizable by body-consciousness, that are desirable .... " (D. 33; M. 13, 26, 59, 66).
These two kinds of ka^ma are called 1. kilesa-ka^ma, i.e. ka^ma as a mental defilement, 2. vatthu-ka^ma, i.e. ka^ma as the object-base of sensuality; first in MNid.. I, p. 1, and frequently in the commentaries.
Sense-desire is finally eliminated at the stage of the Non-Returner (Ana^ga^mi; s. ariya-puggala, samyojana).
The peril and misery of sense-desire is often described in the texts, e.g. in stirring similes at M. 22, 54, and in the 'gradual instruction' (s. a^nupubbi^-katha^). See further M. 13, 45, 75; Sn. v. 766ff.; Dhp. 186, 215.
The texts often stress the fact that what fetters man to the world of the senses are not the sense-organs nor the sense-objects but lustful desire (chandara^ga). On this see A. VI, 63; S. XXXV, 122, 191. - (App.).  'sensuous existence'; s. bhava.  'sensuous desire', s. ni^varana, chanda.  s. ka^ma.  'sensuous world', s. loka.  'sensuous lust', is one of the 10 fetters (samyojana, q .v .) .   s: a^sava.  'being addicted to sensual pleasures', is one of the 2 extremes to be avoided by the monk; s. majjhima-patipada^.  'sensuous craving'; s. tanha^.   'sensuous sphere'; s. avacara.  lit. 'wrong or evil conduct with regard to sensual things'; 'unlawful sexual intercourse' refers to adultery, and to intercourse with minors or other persons under guardianship. The abstaining from this unlawful act is one of the 5 moral rules (s. sikkha^pada) binding upon all Buddhists. Through any other sexual act one does not become guilty of the above transgression, which is considered a great crime. The monk, however, has to observe perfect chastity.
In many Suttas (e.g. A.X., 176) we find the following explanation: "He avoids unlawful sexual intercourse, abstains from it. He has no intercourse with girls who are still under the protection of father or mother, brother, sister or relatives, nor with married women, nor female convicts, nor, lastly, with betrothed girls."   (wholesome or unwholesome) action; s. karma.  s. bhava, paticcasamuppa^da.  'karma-produced corporeality'; s. samuttha^na.   'adaptability', i.e. of corporeality (rpassa; s. khandha, Summary I), mental factors (ka^ya), and of consciousness (citta); cf. Tab. II.   samma^-: 'right action'; s. magga.  'karma as condition'; s. paccaya (13).  'course of action', is a name for the group of 10 kinds of either unwholesome or wholesome actions, viz.
I. The tenfold unwholesome courses of action (akusala-kamma-patha):
3 bodily actions: killing, stealing, unlawful sexual intercourse;
4 verbal actions: lying, slandering, rude speech, foolish babble;
3 mental actions: covetousness, ill-will, evil views.
Unwholesome mental courses of action comprise only extreme forms of defiled thought: the greedy wish to appropriate others' property, the hateful thought of harming others, and pernicious views. Milder forms of mental defilement are also unwholesome, but do not constitute 'courses of action'.
II. The tenfold wholesome course of action (kusala-kamma-patha):
3 bodily actions: avoidance of killing, stealing, unlawful sexual intercourse;
4 verbal actions: avoidance of lying, slandering, rude speech, foolish babble; i.e. true, conciliatory, mild, and wise speech;
3 mental actions: unselfishness, good-will, right views.
Both lists occur repeatedly, e.g. in A. X, 28, 176; M. 9; they are explained in detail in M. 114, and in Com. to M. 9 (R. Und., p. 14), Atthasa^lini Tr. I, 126ff.  'corporeality produced through karma'; s. samuttha^na.   lit. 'working-ground' (i.e. for meditation), is the term in the Com. for 'subjects of meditation'; s. bha^vana^.  'karma-round'; s. vatta.   s. a^yhana.   'sensuous clinging', is one of the 4 kinds of clinging (upa^da^na, q.v.).   'doubt', may be either an intellectual, critical doubt or an ethically and psychologically detrimental doubt. The latter may either be a persistent negative skepticism or wavering indecision. Only the detrimental doubt (identical with vicikiccha^, q.v.) is to be rejected as karmically unwholesome, as it paralyses thinking and hinders the inner development of man. Reasoned, critical doubt in dubious matters is thereby not discouraged.
The 16 doubts enumerated in the Suttas (e.g. M. 2) are the following: "Have I been in the past? Or, have I not been in the past? What have I been in the past? How have I been in the past? From what state into what state did I change in the past? - Shall I be in the future? Or, shall I not be in the future? What shall I be in the future? How shall I be in the future? From what state into what state shall I change in the future? - Am I? Or, am I not? What am I? How am I? Whence has this being come? Whither will it go?"  'purification by overcoming doubt', is the 4th of the 7 stages of purification (visuddhi, q.v.).  (Sanskrit kalpa): 'world-period', an inconceivably long space of time, an aeon. This again is subdivided into 4 sections: world-dissolution (samvatta-kappa) dissolving world), continuation of the chaos (samvatta-ttha^yi^), world-formation (vivatta-kappa), continuation of the formed world (vivatta-ttha^yi^).
"How long a world-dissolution will continue, how long the chaos, how long the formation, how long the continuation of the formed world, of these things; o monks, one hardly can say that it will be so many years, or so many centuries, or so many millennia, or so many hundred thousands of years" (A. IV, 156)
A detailed description of the 4 world-periods is given in that stirring discourse on the all-embracing impermanence in A. VII, 62.
The beautiful simile in S. XV, 5 may be mentioned here: "Suppose, o monks, there was a huge rock of one solid mass, one mile long, one mile wide, one mile high, without split or flaw. And at the end of every hundred years a man should come and rub against it once with a silken cloth. Then that huge rock would wear off and disappear quicker than a world-period. But of such world-periods, o monks, many have passed away, many hundreds, many thousands, many hundred thousands. And how is this possible? Inconceivable, o monks, is this samsa^ra (q.v.), not to be discovered is any first beginning of beings, who obstructed by ignorance and ensnared by craving, are hurrying and hastening through this round of rebirths."
Compare here Grimm's German fairy-tale of the little shepherdboy: 'In Farther Pommerania there is the diamond-mountain, one hour high, one hour wide, one hour deep. There every hundred years a little bird comes and whets its little beak on it. And when the whole mountain is ground off, then the first second of eternity has passed."  (Sanskrit), Pa^li: kamma: 'action', correctly speaking denotes the wholesome and unwholesome volitions (kusala- and akusala-cetana^) and their concomitant mental factors, causing rebirth and shaping the destiny of beings. These karmical volitions (kamma cetana^) become manifest as wholesome or unwholesome actions by body (ka^ya-kamma), speech (vaci^-kamma) and mind (mano-kamma). Thus the Buddhist term 'karma' by no means signifies the result of actions, and quite certainly not the fate of man, or perhaps even of whole nations (the so-called wholesale or mass-karma), misconceptions which, through the influence of theosophy, have become widely spread in the West.
"Volition (cetana^), o monks, is what I call action (cetana^ham bhikkhave kammam vada^mi), for through volition one performs the action by body, speech or mind. . There is karma (action), o monks, that ripens in hell.... Karma that ripens in the animal world.. Karma that ripens in the world of men.... Karma that ripens in the heavenly world.... Threefold, however, is the fruit of karma: ripening during the life-time (dittha-dhamma-vedani^ya-kamma), ripening in the next birth (upapajja-vedani^ya-kamma), ripening in later births (apara^pariya-vedani^ya kamma) ...." (A.VI, 63).
The 3 conditions or roots (mla, q.v.) of unwholesome karma (actions) are greed, hatred, delusion (lobha, dosa, moha); those of wholesome karma are: unselfishness (alobha), hatelessness (adosa = metta^, good-will), undeludedness (amoha = pan~n~a^, knowledge) .
"Greed, o monks, is a condition for the arising of karma; hatred is a condition for the arising of karma; delusion is a condition for the arising of karma ...." (A. III, 109).
"The unwholesome actions are of 3 kinds, conditioned by greed, or hate, or delusion.
"Killing ... stealing ... unlawful sexual intercourse ... lying ... slandering ... rude speech ... foolish babble, if practised, carried on, and frequently cultivated, leads to rebirth in hell, or amongst the animals, or amongst the ghosts" (A. III, 40). "He who kills and is cruel goes either to hell or, if reborn as man, will be short-lived. He who torments others will be afflicted with disease. The angry one will look ugly, the envious one will be without influence, the stingy one will be poor, the stubborn one will be of low descent, the indolent one will be without knowledge. In the contrary case, man will be reborn in heaven or reborn as man, he will be long-lived, possessed of beauty, influence, noble descent and knowledge" (cf. M. 135).
For the above 10-fold wholesome and unwholesome course of action, see kamma-patha. For the 5 heinous crimes with immediate result, s. a^nantarika-kamma.
"Owners of their karma are the beings, heirs of their karma, their karma is their womb from which they are born, their karma is their friend, their refuge. Whatever karma they perform, good or bad, thereof they will be the heirs" (M. 135).
With regard to the time of the taking place of the karma-result (vipa^ka), one distinguishes, as mentioned above, 3 kinds of karma:
1. karma ripening during the life-time (dittha-dhamma-vedani^ya kamma);
2. karma ripening in the next birth (upapajja-vedani^ya-kamma);
3. karma ripening in later births (apara^pariya-vedani^ya-kamma).
The first two kinds of karma may be without karma-result (vipa^ka), if the circumstances required for the taking place of the karma-result are missing, or if, through the preponderance of counteractive karma and their being too weak, they are unable to produce any result. In this case they are called ahosi-kamma, lit. 'karma that has been', in other words, ineffectual karma.
The third type of karma, however, which bears fruit in later lives, will, whenever and wherever there is an opportunity, be productive of karma-result. Before its result has ripened, it will never become ineffective as long as the life-process is kept going by craving and ignorance.
According to the Com., e.g. Vis.M. XIX, the 1st of the 7 karmical impulsive-moments (kamma javana; s. javana) is considered as 'karma ripening during the life-time', the 7th moment as 'karma ripening in the next birth', the remaining 5 moments as 'karma ripening in later births'.
With regard to their functions one distinguishes:
1. regenerative (or productive) karma (janaka-kamma),
2. supportive (or consolidating) karma (upatthambhaka-kamma),
3. counteractive (suppressive or frustrating) karma (upapi^laka-kamma),
4. destructive (or supplanting) karma (upagha^taka- or upacchedaka-kamma).
(1) produces the 5 groups of existence (corporeality, feeling, perception, mental formations, consciousness) at rebirth as well as during life-continuity.
(2) does not produce karma-results but is only able to maintain the already produced karma-results.
(3) counteracts or suppresses the karma-results.
(4) destroys the influence of a weaker karma and effects only its own result.
With regard to the priority of their result one distinguishes:
1. weighty karma (garuka-kamma),
2. habitual karma (a^cinnaka- or bahula-kamma),
3. death-proximate karma (marana^sanna-kamma),
4. stored-up karma (katatta^-kamma).
(1, 2) The weighty (garuka) and the habitual (bahula) wholesome or unwholesome karma are ripening earlier than the light and rarely performed karma. (3) The death-proximate (marana^sanna) karma - i.e. the wholesome or unwholesome volition present immediately before death, which often may be the reflex of some previously performed good or evil action (kamma), or of a sign of it (kamma-nimitta), or of a sign of the future existence (gati-nimitta) - produces rebirth. (4) In the absence of any of these three actions at the moment before death, the stored-up (katatta^) karma will produce rebirth.
A real, and in the ultimate sense true, understanding of Buddhist karma doctrine is possible only through a deep insight into the impersonality (s. anatta^) and conditionality (s. paticcasamuppa^da, paccaya) of all phenomena of existence. "Everywhere, in all the forms of existence ... such a one is beholding merely mental and physical phenomena kept going by their being bound up through causes and effects.
"No doer does he see behind the deeds, no recipient apart from the karma-fruit. And with full insight he clearly understands that the wise ones are using merely conventional terms when, with regard to the taking place of any action, they speak of a doer, or when they speak of a receiver of the karma-results at their arising. Therefore the ancient masters have said:
'No doer of the deeds is found,
No one who ever reaps their fruits;
Empty phenomena roll on:
This view alone is right and true.
 
'And whilst the deeds and their results
Roll on, based on conditions all,
There no beginning can be seen,
Just as it is with seed and tree.' " (Vis.M. XIX)
 
Karma (kamma-paccaya) is one of the 24 conditions (paccaya, q.v.) (App.: Kamma).
Literature: Karma and Rebirth, by Nyanatiloka (WHEEL 9); Survival and Karma in Buddhist Perspective, by K.N. Jayatilleke (WHEEL 141/143); Kamma and its Fruit (WHEEL 221/224).  a^yhana (q.v.).  sankha^ra, i.e. wholesome or unwholesome volitions (cetana^) manifested as actions of body, speech or mind, form the 2nd link of the formula of dependent origination (paticca-samuppa^da, q.v.).  s. bhava, paticcasamuppa^da.  s. samuttha^na.  vipa^ka (q.v.).  kamma vatta (s. vatta).  upa^dinnarpa (q.v.).  kusala (q.v.), akusala (q.v.) avya^kata (q.v.); cf. Tab. I.. .   'compassion', is one of the 4 sublime abodes (brahma-viha^ra, q.v.).   (perhaps related to Sanskrit krtsna, 'all, complete, whole'), is the name for a purely external device to produce and develop concentration of mind and attain the 4 absorptions (jha^na q.v.). It consists in concentrating one's full and undivided attention on one visible object as preparatory image (parikamma-nimitta), e.g. a colored spot or disc, or a piece of earth, or a pond at some distance, etc., until at last one perceives, even with the eyes closed, a mental reflex, the acquired image (uggaha-nimitta). Now, while continuing to direct one's attention to this image, there may arise the spotless and immovable counter-image (patibha^ga-nimitta), and together with it the neighbourhood-concentration (upaca^ra-sama^dhi) will have been reached. While still persevering in the concentration on the object, one finally will reach a state of mind where all sense-activity is suspended, where there is no more seeing and hearing, no more perception of bodily impression and feeling, i.e. the state of the 1st mental absorption (jha^na, q.v.).
The 10 kasinas mentioned in the Suttas are: earth-kasina, water, fire, wind, blue, yellow, red, white, space, and consciousness. "There are 10 kasina-spheres: someone sees the earth kasina, above, below, on all sides, undivided, unbounded .... someone see the water-kasina, above, below, etc." (M. 77; D. 33) Cf. abhibha^yatan, bha^vana^; further s. Fund. IV.
For space and consciousness-kasina we find in Vis.M. V the names limited space-kasina (paricchinna^ka^sa-kasina; . . . s. App. ) and light-kasina (a^loka-kasina).
For full description see Vis.M. IV-V; also Atthasa^lini Tr. I, 248.  'stored-up karma'; s. karma.  (lit: accumulation): 'group', 'body', may either refer to the physical body (rpa-ka^ya) or to the mental body (na^ma-ka^ya). In the latter case it is either a collective name for the mental groups (feeling, perception, mental formations, consciousness; s. khandha), or merely for feeling, perception and a few of the mental formations (s. na^ma), e.g. in ka^ya-lahuta^, etc. (cf. Tab. II). Ka^ya has this same meaning in the standard description of the 3rd absorption (jha^na, q.v.) "and he feels joy in his mind or his mental constitution (ka^ya)", and (e.g. Pug. 1-8) of the attainment of the 8 deliverances (vimokkha, q.v.); "having attained the 8 deliverances in his mind, or his person (ka^ya)." - Ka^ya is also the 5th sense-organ, the body-organ; s. a^yatana, dha^tu, indriya.  'mindfulness with regard to the body', refers sometimes (e.g. Vis.M. VIII, 2) only to the contemplation on the 32 parts of the body, sometimes (e.g. M. 119) to all the various meditations comprised under the 'contemplation of the body' (ka^ya^nupassana^), the 1st of the 4 'foundations of mindfulness' (satipattha^na, q.v.), consisting partly in concentration (sama^dhi) exercises, partly in insight (vipassana^) exercises. On the other hand, the cemetery meditations (si^vathika, q.v.) mentioned in the Satipattha^na S.(M. 10) are nearly the same as the 10 contemplations of loathsomeness (asubha-bha^vana^, q.v.). of Vis.M. VI, whereas elsewhere the contemplation on the 32 parts of the body is called the 'reflection on impurity' (patikkla-san~n~a^).
In such texts as: 'One thing, o monks, developed and repeatedly practised, leads to the attainment of wisdom. It is the contemplation on the body' (A.I), the reference is to all exercises mentioned in the 1st Satipattha^na.
Vis.M. VIII, 2 gives a detailed description and explanation of the method of developing the contemplation on the 32 parts of the body. This exercise can produce the 1st absorption only (jha^na, q.v.) The stereotype text given in the Satipattha^na Sutta and elsewhere - but leaving out the brain - runs as follows:
"And further, o monks, the monk contemplates this body from the soles of the feet upward, and from the tops of the hairs downward, with skin stretched over it, and filled with manifold impurities: 'This body has hairs of the head, hairs of the body, nails, teeth, skin, flesh, sinews, bones, marrow, kidneys, heart, liver, diaphragm, spleen, lungs, intestines, bowels, stomach, excrement, bile, phlegm, pus, blood, sweat, fat, tears, skin grease, spittle, nasal mucus, oil of the joints, and urine ...."
Vis.M. VIII, 2 says "By repeating the words of this exercise one will become well acquainted with the wording, the mind will not rush here and there, the different parts will become distinct and appear like a row of fingers, or a row of hedge-poles. Now, just as one repeats the exercise in words, one should do it also in mind. The repeating in mind forms the condition for the penetration of the characteristic marks.... He who thus has examined the parts of the body as to colour, shape, region, locality and limits, and considers them one by one, and not too hurriedly, as something loathsome, to such a one, while contemplating the body, all these things at the same time are appearing distinctly clear. But also when keeping one's attention fixed outwardly (i.e. to the bodies of other beings), and when all the parts appear distinctly, then all men and animals moving about lose the appearance of living beings and appear like heaps of many different things. And it looks as if those foods and drinks, being swallowed by them, were being inserted into this heap of things. Now, while again and again one is conceiving the idea 'Disgusting! Disgusting!' - omitting in due course several parts - gradually the attainment - concentration (appana^-sama^dhi, i.e. the concentration of the jha^na) will be reached. In this connection, the appearing of forms ... is called the acquired image (uggaha-nimitta), the arising of loathsomeness, however, the counter-image (patibha^ganimitta)."  'bodily action'; s. karma, kammapatha.  kamman~n~ata^, k.-lahuta^, k.-muduta^, k.-pa^gun~n~ata^, k.-passaddhi, k.-ujukata^; s. Tab. II. For passaddhi, s. further bojjhanga.  agility or lightness of mental factors (s. lahuta^).   'contemplation of the body', is one of the 4 foundations of mindfulness; s. satipattha^na.  tranquillity of mental factors, s. bojjhanga.  'body-witness', is one of the 7 noble disciples (s. ariya-puggala, B.). He is one who "in his own person (lit. body) has attained the 8 deliverances (vimokkha, q.v.), and after wisely understanding the phenomena, the cankers have partly come to extinction" (Pug. 32). In A. IX, 44 it is said: "A monk, o brother, attains the 1st absorption (jha^na, q.v.), and as far as this domain reaches,- so far he has realized it in his own person. Thus the Blessed One calls such a person a body-witness in certain respects. (The same is then repeated with regard to the 7 higher absorptions). Further again, o brother, the monk attains the extinction of perception and feeling (s. nirodha-sama^patti), and after wisely understanding the phenomena, all the cankers come to extinction. Thus, o brother, the Blessed One calls such a person a body-witness in all respects."  s. vin~n~atti.  s. dhutanga.   'moment'; s. citta-kkhana.   the 5 'groups (of existence)' or 'groups of clinging' (upa^da^nakkhandha); alternative renderings: aggregates, categories of clinging's objects. These are the 5 aspects in which the Buddha has summed up all the physical and mental phenomena of existence, and which appear to the ignorant man as his ego, or personality, to wit:
(1) the corporeality group (rpa-kkhandha),
(2) the feeling group (vedana^-kkhandha),
(3) the perception group (san~n~a^-kkhandha),
(4) the mental-formation group (sankha^ra-kkhandha),
(5) the consciousness-group (vin~n~a^na-kkhandha).
"Whatever there exists of corporeal things, whether past, present or future, one's own or external, gross or subtle, lofty or low, far or near, all that belongs to the corporeality group. Whatever there exists of feeling ... of perception ... of mental formations ... of consciousness ... all that belongs to the consciousness-group" (S. XXII, 48). - Another division is that into the 2 groups: mind (2-5) and corporeality (1) (na^ma-rpa), whilst in Dhamma Sangani^, the first book of the Abhidhamma, all the phenomena are treated by way of 3 groups: consciousness (5), mental factors (2-4), corporeality (1), in Pa^li citta, cetasika, rpa. Cf. Guide I.
What is called individual existence is in reality nothing but a mere process of those mental and physical phenomena, a process that since time immemorial has been going on, and that also after death will still continue for unthinkably long periods of time. These 5 groups, however, neither singly nor collectively constitute any self-dependent real ego-entity, or personality (atta^), nor is there to be found any such entity apart from them. Hence the belief in such an ego-entity or personality, as real in the ultimate sense, proves a mere illusion.
"When all constituent parts are there,
The designation 'cart' is used;
Just so, where the five groups exist,
Of 'living being' do we speak." (S. V. 10).
The fact ought to be emphasized here that these 5 groups, correctly speaking, merely form an abstract classification by the Buddha, but that they as such, i.e. as just these 5 complete groups, have no real existence, since only single representatives of these groups, mostly variable, can arise with any state of consciousness. For example, with one and the same unit of consciousness only one single kind of feeling, say joy or sorrow, can be associated and never more than one. Similarly, two different perceptions cannot arise at the same moment. Also, of the various kinds of sense-cognition or consciousness, only one can be present at a time, for example, seeing, hearing or inner consciousness, etc. Of the 50 mental formations, however, a smaller or larger number are always associated with every state of consciousness, as we shall see later on.
Some writers on Buddhism who have not understood that the five khandha are just classificatory groupings, have conceived them as compact entities ('heaps', 'bundles'), while actually, as stated above, the groups never exist as such, i.e. they never occur in a simultaneous totality of all their constituents. Also those single constituents of a group which are present in any given body- and -mind process, are of an evanescent nature, and so also their varying combinations. Feeling, perception and mental formations are only different aspects and functions of a single unit of consciousness. They are to consciousness what redness, softness, sweetness, etc. are to an apple and have as little separate existence as those qualities.
In S. XXII, 56, there is the following short definition of these 5 groups:
"What, o monks, is the corporeality-group? The 4 primary elements (maha^-bhta or dha^tu) and corporeality depending thereon, this is called the corporeality-group.
"What, o monks, is the feeling-group? There are 6 classes of feeling: due to visual impression, to sound impression, to odour impression, to taste impression, to bodily impression, and to mind impression....
"What, o monks, is the perception-group? There are 6 classes of perception: perception of visual objects, of sounds, of odours, of tastes, of bodily impressions, and of mental impressions....
"What, o monks, is the group of mental formations? There are 6 classes of volitional states (cetana^): with regard to visual objects, to sounds, to odours, to tastes, to bodily impressions and to mind objects....
"What, o monks, is the consciousness-group? There are 6 classes of consciousness: eye-consciousness, ear-consciousness, nose-consciousness, tongue-consciousness, body-consciousness, and mind-consciousness."
About the inseparability of the groups it is said:
''Whatever, o brother, there exists of feeling, of perception and of mental formations, these things are associated, not dissociated, and it is impossible to separate one from the other and show their difference. For whatever one feels, one perceives; and whatever one perceives, of this one is conscious" (M. 43).
Further: "Impossible is it for anyone to explain the passing out of one existence and the entering into a new existence, or the growth, increase and development of consciousness independent of corporeality, feeling, perception and mental formations" (S. XII, 53)
For the inseparability and mutual conditionality of the 4 mental groups s. paccaya (6, 7).
Regarding the impersonality (anatta^) and emptiness (sun~n~ata^) of the 5 groups, it is said in S. XXII, 49:
"Whatever there is of corporeality, feeling, perception, mental formations and consciousness, whether past, present or future, one's own or external, gross or subtle, lofty or low, far or near, this one should understand according to reality and true wisdom: 'This does not belong to me, this am I not, this is not my Ego.' "
Further in S. XXII, 95: "Suppose that a man who is not blind were to behold the many bubbles on the Ganges as they are driving along; and he should watch them and carefully examine them. After carefully examining them, however, they will appear to him empty, unreal and unsubstantial. In exactly the same way does the monk behold all the corporeal phenomena ... feelings ... perceptions ... mental formations ... states of consciousness, whether they be of the past, present or future ... far or near. And he watches them and examines them carefully; and after carefully examining them, they appear to him empty, unreal and unsubstantial."
The 5 groups are compared, respectively, to a lump of froth, a bubble, a mirage, a coreless plantain stem, and a conjuring trick (S. XXII, 95).
See the Khandha Samyutta (S. XXII); Vis.M. XIV.
 
SUMMARY OF THE 5 GROUPS
 
I. Corporeality Group
(rpa-kkhandha)
 
A. Underived (no-upa^da^): 4 elements
 
the solid, or earth-element (pathavi^-dha^tu)
the liquid, or water-element (a^po-dha^tu)
heat, or fire-element (tejo-dha^tu)
motion, or wind-element (va^yo-dha^tu)
 
B. Derived (upa^da^): 24 secondary phenomena
 
Physical sense-organs of: seeing, hearing, smelling, tasting, body
Physical sense-objects: form, sound, odour, taste, (bodily impacts)
'Bodily impacts' (photthabba) are generally omitted in this list, because these physical objects of body-sensitivity are identical with the afore-mentioned solid element, heat and motion element. Hence their inclusion under 'derived corporeality' would be a duplication.
 
femininity (itthindriya)
virility (purisindriya)
physical base of mind (hadaya-vatthu, q.v.)
bodily expression (ka^ya-vin~n~atti; s. vin~n~atti)
verbal expression (vaci^-vin~n~atti)
physical life (rpa ji^vita; s. ji^vita)
space element (a^ka^sa-dha^tu, q.v.)
physical agility (rpassa lahuta^)
physical elasticity (rpassa muduta^)
physical adaptability (rpassa kamman~n~ata^)
physical growth (rpassa upacaya)
physical continuity (rpassa santati; s. santa^na)
decay (jara^, q.v.)
impermanence (aniccata^)
nutriment (a^ha^ra, q.v.)
 
II. Feeling Group
(vedana^-kkhandha)
 
All feelings may, according to their nature, be classified as 5 kinds:
bodily agreeable feeling sukha = ka^yika^ sukha^ vedana^
bodily painful feeling dukkha = ka^yika^ dukkha^ vedana^
mentally agreeable feeling somanassa = cetasika^ sukha^ vedana^
mentally painful feeling domanassa = cetasika^ dukkha^ vedana^
indifferent feeling upekkha^ = adukkha-m-asukha^ vedana^
 
III. Perception Group
(san~n~a^-kkhandha)
 
All perceptions are divided into 6 classes: perception of form, sound, odour, taste, bodily impression, and mental impression.
 
IV. Group of Mental Formations
(sankha^ra-kkhandha)
 
This group comprises 50 mental phenomena, of which 11 are general psychological elements, 25 lofty (sobhana) qualities, 14 karmically unwholesome qualities. Cf. Tab. 11.
 
V. Consciousness Group
(vin~n~a^na-kkhandha)
 
The Suttas divide consciousness, according to the senses, into 6 classes: eye-, ear-, nose-, tongue-, body-, mind-consciousness.
The Abhidhamma and commentaries, however, distinguish, from the karmical or moral viewpoint, 89 classes of consciousness. Cf. vin~n~a^na and Tab. 1.
The moral quality of feeling, perception and consciousness is determined by the mental formations.  s. nibba^na.  s. santa^na.   'patience', forbearance', is one of the 10 perfections (pa^rami^, q.v.).   'contemplation of dissolution', is one of the 18 chief kinds of insight (s. vipassana^).  'the celestial beings corruptible by pleasures', are a class of devas (q.v.) of the sensuous sphere. They waste their time in merriment, play and enjoyment, and thereby become thoughtless, and in their thoughtlessness they fall from that world (D. 1; 24).   'the one in whom all cankers are destroyed' is a name for the Arahat, or Holy One; s. a^sava.  'function'. Regarding the 14 functions of consciousness, s. vin~n~a^na-kicca.   'defilements', are mind-defiling, unwholesome qualities. Vis.M. XXII, 49, 65: "There are 10 defilements, thus called because they are themselves defiled, and because they defile the mental factors associated with them. They are: (1) greed (lobha), (2) hate (dosa), (3) delusion (moha), (4) conceit (ma^na), (5) speculative views (ditthi), (6) skeptical doubt (vicikiccha^), (7) mental torpor (thi^na), (8) restlessness (uddhacca); (9) shamelessness (ahirika), (10) lack of moral dread or unconscientiousness (anottappa)." For 1-3, s. mla; 4, s. ma^na; 5, s. ditthi; 6-8, s. ni^varana; 9 and 10, s. ahirika-anottappa.
The ten are explained in Dhs. 1229f and enumerated in Vibh. XII. No classification of the k. is found in the Suttas, though the term occurs quite often in them. For the related term, upakkilesa (q.v.; 'impurities') different lists are given - (App.).  'sensuality considered as defilement' (s. kilesa) might well be called 'subjective sensuality', in contradistinction to 'objective sensuality' (vatthu-ka^ma), i.e. the sensuous objects (ka^ma-guna). Cf. ka^ma.  s. nibba^na (1).   s. karma, kammapatha, sikkha^pada.   'something', i.e. something evil that sticks or adheres to character. 'Evil appendant', is a name for the 3 unwholesome roots (mla). "There are 3 appendants: greed (lobha) is an appendant, hate (dosa) is an appendant, delusion (moha) is an appendant" (D. 33). 'Freed from appendants' (akin~cana) is a term for the perfectly Holy One (Arahat).  (or kriya)-citta: 'functional consciousness' or 'karmically inoperative consciousness', is a name for such states of consciousness as are neither karmically wholesome (kusala), nor unwholesome (akusala), nor karma-results (vipa^ka); that is, they function independently of karma. Thus are also called all those worldly mental states in the Arahat which are accompanied by 2 or 3 noble roots (greedlessness, hatelessness, undeludedness), being in the Arahat karmically neutral and corresponding to the karmically wholesome states of a non-Arahat (s. Tab. 1-8 and 73-89), as well as the rootless mirth-producing (hasituppa^da) mind-consciousness-element of the Arahat (Tab. 72); further, that mind-element (mano-dha^tu) which performs the function of advertence (a^vajjana) to the sense object (Tab. 70), and that mind-consciousness-element (manovin~n~a^na-dha^tu) which performs the functions of deciding (votthapana) and advertence to the mental object (Tab. 71). The last-named 2 elements, of course, occur in all beings.
Together with karma-resultant consciousness (vipa^ka) it belongs to the group of 'karmically neutral consciousness' (avya^kata). See Tab. I (last column). - (App.).   cf. pan~n~a^, n~a^na, vijja^, vipassana^, abhin~n~a^.   'passing from one noble family to another', is the name for one of the 3 kinds of Sota^panna (q.v.).  citta = kiriya (q.v.).   lit. 'wrongly-performed-ness' (ku+krta+ya), i.e. scruples, remorse, uneasiness of conscience, worry, is one of the karmically unwholesome (akusala) mental faculties (Tab. II) which, whenever it arises, is associated with hateful (discontented) consciousness (Tab. I and III, 30, 31). It is the 'repentance over wrong things done, and right things neglected' (Com. to A. I). Restlessness and scruples (uddhacca-kukkucca), combined, are counted as one of the 5 mental hindrances (ni^varana, q.v.).  dhamma 'liable to perturbation', is one who has not yet attained full mastery over the absorptions. In Pug. 3 it is said: "What person is liable to perturbation? Such a person gains the attainments of the fine-material and immaterial sphere (s. avacara). But he does not gain them at his wish, nor without toil and exertion; and not at his wish as regards place, object and duration, does he enter them or arise from them. Thus it is well possible that in case of such a person, through negligence, the attainments will become perturbed. This person is liable to perturbation."   'karmically wholesome' or 'profitable', salutary, morally good, (skillful) Connotations of the term, according to Com. (Atthasa^lini), are: of good health, blameless, productive of favourable karma-result, skillful. It should be noted that Com. excludes the meaning 'skillful', when the term is applied to states of consciousness.
It is defined in M. 9 as the 10 wholesome courses of action (s. kammapatha). In psychological terms, 'karmically wholesome' are all those karmical volitions (kamma-cetana^) and the consciousness and mental factors associated therewith, which are accompanied by 2 or 3 wholesome roots (s. mla), i.e. by greedlessness (alobha) and hatelessness (adosa), and in some cases also by non-delusion (amoha: wisdom, understanding). Such states of consciousness are regarded as 'karmically wholesome' as they are causes of favourable karma results and contain the seeds of a happy destiny or rebirth. From this explanation, two facts should be noted: (1) it is volition that makes a state of consciousness, or an act, 'good' or 'bad'; (2) the moral criterion in Buddhism is the presence or absence of the 3 wholesome or moral roots (s. mla).
The above explanations refer to mundane (lokiya, q.v.) wholesome consciousness. Supermundane wholesome (lokuttara-kusala) states, i.e. the four paths of sanctity (s. ariyapuggala), have as results only the corresponding four fruitions; they do not constitute karma, nor do they lead to rebirth, and this applies also to the good actions of an Arahat (Tab. I, 73-80) and his meditative states (Tab. 1, 81-89), which are all karmically inoperative (functional; s. kiriya).
Kusala belongs to a threefold division of all consciousness, as found in the Abhidhamma (Dhs.), into wholesome (kusala), unwholesome (akusala) and karmically neutral (avya^kata), which is the first of the triads (tika) in the Abhidhamma schedule (ma^tika^); s. Guide, pp. 4ff., 12ff; Vis.M. XIV, 83ff.  'wholesome course of action'; s. kammapatha.  the 'wholesome roots' or 'roots of wholesome action', are greedlessness (alobha), hatelessness (adosa), and non-delusion (amoha; s. mla). They are identical with kusala-hetu (s . paccaya, 1).  the (mental) 'karma-result of wholesome karma' (s. karma).   'lightness', or 'agility', may be of 3 kinds: of corporeality (rpassa lahuta^; s. khandha, I ), of mental factors (ka^ya-lahuta^), and of consciousness (citta-lahuta^). Cf. Tab. II.   'characteristics'. For the 3 ch. of existence, s. ti-lakkhana.   dhamma (q.v.).   wisdom based on: s. pan~n~a^.   da^na (q.v.), ca^ga (q.v.).   s. vimokkha.  s. mada.   perception of: s. a^loka-san~n~a^.  s. kasina.  (of corporeality, mental factors and consciousness): lahuta^ (q.v.).  (of the body): s. asubha, sivathika^, ka^yagata^sati.   'greed', is one of the 3 unwholesome roots (mla, q.v.) and a synonym of ra^ga (q.v.) and tanha^ (q.v.).  'greedy-natured', s. carita.  s. sobhana.  'red-kasina', s. kasina.   'world', denotes the 3 spheres of existence comprising the whole universe, i.e. (1) the sensuous world (ka^ma-loka), or the world of the 5 senses; (2) the fine-material world (rpa-loka), corresponding to the 4 fine-material absorptions (s. jha^na 1-4); (3) the immaterial world (arpa-loka), corresponding to the 4 immaterial absorptions (s. jha^na, 5-8).
The sensuous world comprises the hells (niraya), the animal kingdom (tiraccha^na-yoni), the ghost-realm (peta-loka), the demon world (asura-nika^ya), the human world (manussa-loka) and the 6 lower celestial worlds (s. deva I). In the fine-material world (s. deva II) still exist the faculties of seeing and hearing, which, together with the other sense faculties, are temporarily suspended in the 4 absorptions. In the immaterial world (s. deva III) there is no corporeality whatsoever, only the four mental groups (s. khandha) exist there.
Though the term loka is not applied in the Suttas to those 3 worlds, but only the term bhava, 'existence' (e.g. M. 43), there is no doubt that the teaching about the 3 worlds belongs to the earliest, i.e. sutta-period, of the Buddhist scriptures, as many relevant passages show.  'worldly conditions'. "Eight things are called worldly conditions, since they arise in connection with worldly life, namely: gain and loss, honour and dishonour, happiness and misery, praise and blame" (Vis.M. XXII). Cf. also A. VIII, 5.   'mundane', are all those states of consciousness and mental factors - arising in the worldling, as well as in the Noble One - which are not associated with the supermundane (lokuttara; s. the foll.) paths and fruitions of sota^patti, etc. See ariyapuggala, A.   'supermundane', is a term for the 4 paths and 4 fruitions of sota^patti, etc. (s. ariya-puggala), with Nibba^na as ninth. Hence one speaks of '9 supermundane things' (nava-lokuttara-dhamma). Cf. prec.  metta^; s. brahmaviha^ra.  fetters, the 5: s. samyojana.  worlds, the 4: apa^ya (q.v.).  tiraccha^na-katha^ (q.v.).   s. ra^ga.   'stinginess', avarice. "There are 5 kinds of stinginess, o monks; regarding the dwelling place, regarding families, regarding gain, regarding recognition, regarding mental things' (A. IX, 49; Pug. 56).   'infatuation'. "Infatuation is of 3 kinds: youth-infatuation, health-infatuation, life-infatuation" (D. 33). "Infatuated by youth-infatuation, by health-infatuation and by life-infatuation, the ignorant worldling pursues an evil course in bodily actions, speech and thought, and thereby, at the dissolution of the body, after death, passes to a lower world, to a woeful course of existence, to a state of suffering and hell" (A. III, 39).   'path'. 1. For the 4 supermundane paths (lokuttara-magga), s. ariya-puggala - 2. The Eightfold Path (atthangika-magga) is the path leading to the extinction of suffering, i.e. the last of the 4 Noble Truths (sacca, q.v.), namely:
 
Wisdom (pan~n~a^) III.
1. Right view (samma^-ditthi)
2. Right thought (samma^-sankappa)
Morality (si^la) I.
3. Right speech (samma^-va^ca^)
4. Right bodily action (samma^-kammanta)
5. Right livelihood (samma^-a^ji^va)
Concentration (sama^dhi) II.
6. Right effort (samma^-va^ya^ma)
7. Right mindfulness (samma^-sati)
8. Right concentration (samma^-sama^dhi)
 
1. Right view or right understanding (samma^-ditthi) is the understanding of the 4 Noble Truths about the universality of suffering (unsatisfactoriness), of its origin, its cessation, and the path leading to that cessation. - See the Discourse on 'Right Understanding' (M. 9, tr. and Com. in 'R. Und.').
2. Right thought (samma^-sankappa): thoughts free from sensuous desire, from ill-will, and cruelty.
3. Right speech (samma^-va^ca^): abstaining from lying, tale-bearing, harsh language, and foolish babble.
4 Right bodily action (samma^-kammanta): abstaining from killing, stealing, and unlawful sexual intercourse.
5. Right livelihood (samma^-a^ji^va): abstaining from a livelihood that brings harm to other beings, such as trading in arms, in living beings, intoxicating drinks, poison; slaughtering, fishing, soldiering, deceit, treachery soothsaying, trickery, usury, etc.
6. Right effort (samma^-va^ya^ma): the effort of avoiding or overcoming evil and unwholesome things, and of developing and maintaining wholesome things (s. padha^na).
7. Right mindfulness (samma^-sati): mindfulness and awareness in contemplating body, feelings, mind, and mind-objects (s. sati, satipattha^na).
8. Right concentration (samma^-sama^dhi): concentration of mind associated with wholesome (kusala) consciousness, which eventually may reach the absorptions (jha^na, q.v.). Cf. sama^dhi.
There are to be distinguished 2 kinds of concentration, mundane (lokiya) and supermundane (lokuttara) concentration. The latter is associated with those states of consciousness known as the 4 supermundane paths and fruitions (s. ariya-puggala). As it is said in M. 117:
"I tell you, o monks, there are 2 kinds of right view: the understanding that it is good to give alms and offerings, that both good and evil actions will bear fruit and will be followed by results.... This, o monks, is a view which, though still subject to the cankers, is meritorious, yields worldly fruits, and brings good results. But whatever there is of wisdom, of penetration, of right view conjoined with the path - the holy path being pursued, this is called the supermundane right view (lokuttara-samma^-ditthi), which is not of the world, but which is supermundane and conjoined with the path."
In a similar way the remaining links of the path are to be understood.
As many of those who have written about the Eightfold Path have misunderstood its true nature, it is therefore appropriate to add here a few elucidating remarks about it, as this path is fundamental for the understanding and practice of the Buddha's .teaching.
First of all, the figurative expression 'path' should not be interpreted to mean that one has to advance step by step in the sequence of the enumeration until, after successively passing through all the eight stages, one finally may reach one's destination, Nibba^na. If this really were the case, one should have realized, first of all, right view and penetration of the truth, even before one could hope to proceed to the next steps, right thought and right speech; and each preceding stage would be the indispensable foundation and condition for each succeeding stage. In reality, however, the links 3-5 constituting moral training (si^la), are the first 3 links to be cultivated, then the links 6-8 constituting mental training (sama^dhi), and at last right view, etc. constituting wisdom (pan~n~a^).
It is, however, true that a really unshakable and safe foundation to the path is provided only by right view which, starting from the tiniest germ of faith and knowledge, gradually, step by step, develops into penetrating insight (vipassana^) and thus forms the immediate condition for the entrance into the 4 supermundane paths and fruits of holiness, and for the realization of Nibba^na. Only with regard to this highest form of supermundane insight, may we indeed say that all the remaining links of the path are nothing but the outcome and the accompaniments of right view.
Regarding the mundane (lokiya) eightfold path, however, its links may arise without the first link, right view.
Here it must also be emphasized that the links of the path not only do not arise one after the other, as already indicated, but also that they, at least in part, arise simultaneously as inseparably associated mental factors in one and the same state of consciousness. Thus, for instance, under all circumstances at least 4 links are inseparably bound up with any karmically wholesome consciousness, namely 2, 6, 7 and 8, i.e. right thought, right effort, right mindfulness and right concentration (M. 117), so that as soon as any one of these links arises, the three others also do so. On the other hand, right view is not necessarily present in every wholesome state of consciousness.
Magga is one of the 24 conditions (s. paccaya 18).
Literature: The Noble Eightfold Path and its Factors Explained, by Ledi Sayadaw (WHEEL 245/247). - The Buddha's Ancient Path, by Piyadassi Thera (BPS).- The Noble Eightfold Path, by Bhikkhu Bodhi (WHEEL 308/311).  'purification by knowledge of what is path and not-path', is one of the 7 stages of purification (visuddhi V, q.v.).  'path as a condition', is one of the 24 conditions (paccaya, q.v.). magical powers: s. iddhi; abhin~n~a^ (1).  the 4 'primary elements', is another name for the 4 elements (dha^tu) underlying all corporeality; s. dha^tu.  the 'great gods', are a class of heavenly beings in the fine-material world; s. deva, II.   lit., 'grown great', i.e. 'developed', exalted, supernormal. As mahaggata-citta, it is the state of 'developed consciousness', attained in the fine-material and immaterial absorptions (s. jha^na); it is mentioned in the mind-contemplation of the Satipattha^na Sutta (M. 10). - As mahaggata^rammana, it is the 'developed mental object' of those absorptions and is mentioned in the 'object triad' of the Abhidhamma schedule and Dhs. (s. Guide, p. 6).  the 8 'thoughts of a great man', are described in A. VIII, 30, and D. 34.  the 18 'chief kinds of insight'; s. vipassana^.   effort to maintain wholesome things; s. padha^na.  'Middle Path', is the Noble Eightfold Path which, by avoiding the two extremes of sensual lust and self-torment, leads to enlightenment and deliverance from suffering.
To give oneself up to indulgence in sensual pleasure (ka^ma-sukha), the base, common, vulgar, unholy, unprofitable; and also to give oneself up to self-torment (atta-kilamatha), the painful, unholy, unprofitable, both these two extremes the Perfect One has avoided and has found the Middle Path (s. magga), which causes one both to see and to know, and which leads to peace, to discernment, to enlightenment, to Nibba^na. It is the Noble Eightfold Path, the way that leads to the extinction of suffering, namely: right understanding, right thought, right speech, right bodily action, right livelihood, right effort, right mindfulness, and right concentration" (S. LVI, 11).   'stains', is a name for the 3 karmically unwholesome roots (akusala-mla); greed, hate and delusion (lobha, dosa, moha).   'conceit', pride, is one of the 10 fetters binding to existence (s. samyojana). It vanishes completely only at the entrance to Arahatship, or Holiness (cf. asmi-ma^na). It is further one of the proclivities (s. anusaya) and defilements (s. kilesa). "
The (equality-) conceit (ma^na), the inferiority-conceit (oma^na) and the superiority-conceit (atima^na): this threefold conceit should be overcome. For, after overcoming this threefold conceit, the monk, through the full penetration of conceit, is said to have put an end suffering" (A. VI, 49).
"Those ascetics and brahman priests who, relying on this impermanent, miserable and transitory nature of corporeality, feelings, perceptions, mental formations and consciousness, fancy: 'Better am I', or 'Equal am I', or 'Worse am I', all these imagine thus through not understanding reality" (S. XXII, 49).
In reality no ego-entity is to be found. Cf. anatta^.   'attention', 'mental advertence', 'reflection'.
1. As a psychological term, attention belongs to the formation-group (sankha^ra-kkhandha; s. Tab. II) and is one of the 7 mental factors (cetasika) that are inseparably associated with all states of consciousness (s. cetana^). In M. 9, it is given as one of the factors representative of mind (na^ma) It is the mind's first 'confrontation with an object' and 'binds the associated mental factors to the object.' It is, therefore, the prominent factor in two specific classes of consciousness: i.e. 'advertence (a^vajjana, q.v.) at the five sense-doors' (Tab. I, 70) and at the mind-door (Tab. I, 71). These two states of consciousness, breaking through the subconscious life-continuum (bhavanga), form the first stage in the perceptual process (citta-vi^thi; s. vin~n~a^na-kicca). See Vis.M. XIV, 152.
2. In a more general sense, the term appears frequently in the Suttas as yoniso-manasika^ra, 'wise (or reasoned, methodical) attention' or 'wise reflection'. It is said, in M. 2, to counteract the cankers (a^sava, q.v.); it is a condition for the arising of right view (s. M. 43), of Stream-entry (s. sota^pattiyanga), and of the factors of enlightenment (s. S. XLVI, 2.49,51). - 'Unwise attention' (ayoniso-manasika^ra) leads to the arising of the cankers (s. M. 2) and of the five hindrances (s. S. XLVI, 2.51).   'mind-base', is a collective term for all the different states of consciousness; s. a^yatana.   means, in general usage, anything regarded as 'auspicious' 'lucky', or a 'good omen'. Against the contemporary superstitions notions about it, the Buddha, in the Maha^-mangala Sutta (Sn., w. 258 ff.), set forth 36 'blessings' that are truly auspicious, i.e. conducive to happiness, beginning with the 'avoidance of bad company' and ending with a 'serene mind'. It is one of the most popular Suttas in Buddhist countries, and a fundamental text on Buddhist lay ethics.
Tr. in Everyman's Ethics (WHEEL 14). See Life's Highest Blessings, by Dr. R. L. Soni. (WHEEL 254/256).   'mind', is in the Abhidhamma used as synonym of vin~n~a^na (consciousness) and citta (state of consciousness, mind). According to the Com. to Vis.M., it sometimes means sub-consciousness (s. bhavanga-sota).  'mind-element', is one of the 18 elements (s. dha^tu II). This term, unlike mana^yatana, does not apply to the whole of consciousness, but designates only that special element of consciousness which first, at the beginning of the process of sense-perception, performs the function of advertence (a^vajjana; Tab. I, 70) to the sense-object and, then after twice having become conscious of it performs the function of reception (sampaticchana; Tab I- 39,.55) into mind-consciousness. See vin~n~a^na-kicca.  'mental action'; s. karma, kammapatha.  s. iddhi.  'the celestial beings corruptible by temper', are a class of devas (q.v.) of the sensuous sphere. "They spend their time in becoming annoyed with one another, and getting into a temper, and thus by being bodily and mentally exhausted, they pass from that world" (D. 1; 24).   'mental indulging'. There are mentioned 18 ways of indulging: 6 in gladness (somanasspavica^ra), 6 in sorrow (domanassa), 6 in indifference (upekkha^). "Perceiving with the eye a visible form ... hearing with the ear a sound ... being in mind conscious of an object, one indulges in the joy-producing object, the sorrow-producing object, the indifference-producing object... " (M. 137; A. III, 61). - In the Com. to A., upavica^ra is said to be identical with vitakka-vica^ra (q.v.).  'mental volition'; s. a^ha^ra.  'mind-consciousness element', one of the 18 'elements' (s. dha^tu II). This term is generally used as a name for that consciousness-element which performs the functions of investigation (santi^rana), determining (votthapana), registering (tada^rammana), etc. See Tab. I, 40, 41, 56, 71, 72.   (lit. 'the killer'), is the Buddhist 'Tempter-figure. He is often called 'Ma^ra the Evil One' (pa^pima^ ma^ro) or Namuci (lit. 'the non-liberator', i.e. the opponent of liberation). He appears in the texts both as a real person (i.e. as a deity) and as personification of evil and passions, of the totality of worldly existence, and of death. Later Pa^li literature often speaks of a 'fivefold Ma^ra' (pan~ca-ma^ra): 1. M. as a deity (devaputta-ma^ra), 2. the M. of defilements (kilesa-m.), 3. the M. of the aggregates (khandha-m.), 4. the M. of the karma-formations (kamma-m.), and 5. Ma^ra as death (maccu-m.).
As a real person, M. is regarded as the deity ruling over the highest heaven of the sensuous sphere (ka^ma^vacara), that of the paranimmitavasavatti-devas, the 'deities wielding power over the creations of others' (Com. to M. 1). According to tradition, when the Bodhisatta was seated under the Bodhi-tree, Ma^ra tried in vain to obstruct his attainment of Enlightenment, first by frightening him through his hosts of demons, etc., and then by his 3 daughters' allurements. This episode is called 'Ma^ra's war' (ma^ra-yuddha). For 7 years M. had followed the Buddha, looking for any weakness in him; that is, 6 years before the Enlightenment and one year after it (Sn. v. 446). He also tried to induce the Buddha to pass away into Parinibba^na without proclaiming the Dhamma, and also when the time for the Buddha's Parinibba^na had come, he urged him on. But the Buddha acted on his own insight in both cases. See D. 16.
For (3) M. as the aggregates, s. S. XXIII, 1, 11, 12, 23. See Padha^na Sutta (Sn. v. 425ff.); Ma^ra Samyutta (S. IV).   'death', in ordinary usage, means the disappearance of the vital faculty confined to a single life-time, and therewith of the psycho-physical life-process conventionally called 'man, animal, personality, ego', etc. Strictly speaking, however, death is the continually repeated dissolution and vanishing of each momentary physical-mental combination, and thus it takes place every moment. About this momentaneity of existence, it is said in Vis.M. VIII:
"In the absolute sense, beings have only a very short moment to live, life lasting as long as a single moment of consciousness lasts. Just as a cart-wheel, whether rolling or whether at a standstill, at all times only rests on a single point of its periphery, even so the life of a living being lasts only for the duration of a single moment of consciousness. As soon as that moment ceases, the being also ceases. For it is said: 'The being of the past moment of consciousness has lived, but does not live now, nor will it live in future. The being of the future moment has not yet lived, nor does it live now, but it will live in the future. The being of the present moment has not lived, it does live just now, but it will not live in the future.' "
In another sense, the coming to an end of the psycho-physical life-process of the Arahat, or perfectly Holy One, at the moment of his passing away may be called the final and ultimate death, as up to that moment the psycho-physical life-process was still going on from life to life.
Death, in the ordinary sense, combined with old age, forms the 12th link in the formula of dependent origination (paticca-samuppa^da q.v.).
For death as a subject of meditation, s. marana^nussati; as a function of consciousness, s. vin~n~a^na-kicca.  s. karma.   'recollection of death', is one of the 10 recollections treated in detail in Vis.M. VIII:
''Recollection of death, developed and frequently practised, yields great reward, great blessing, has Deathlessness as its goal and object. But how may such recollection be developed?
"As soon as the day declines, or as the night vanishes and the day is breaking, the monk thus reflects: 'Truly, there are many possibilities for me to die: I may be bitten by a serpent, or be stung by a scorpion or a centipede, and thereby I may lose my life. But this would be an obstacle for me. Or I may stumble and fall to the ground, or the food eaten by me may not agree with my health; or bile, phlegm and piercing body gases may become disturbing, or men or ghosts may attack me, and thus I may lose my life. But this would be an obstacle for me.' Then the monk has to consider thus: 'Are there still to be found in me unsubdued evil, unwholesome things which, if I should die today or tonight, might lead me to suffering?' Now, if he understands that this is the case, he should use his utmost resolution, energy, effort, endeavour, steadfastness, attentiveness and clear-mindedness in order to overcome these evil, unwholesome things" (A VIII, 74).
In Vis.M. VIII it is said: 'He who wishes to develop this meditation, should retreat to solitude, and whilst living secluded he should thus wisely reflect: 'Death will come to me! The vital energy will be cut off!' Or: 'Death! Death!' To him, namely, who does not wisely reflect, sorrow may arise by thinking on the death of a beloved person, just as to a mother whilst thinking on the death of her beloved child. Again, by reflecting on the death of a disliked person, joy may arise, just as to enemies whilst thinking on the death of their enemies. Through thinking on the death of an indifferent person, however, no emotion will arise, just as to a man whose work consists in cremating the dead at the sight of a dead body. And by reflecting on one's own death fright may arise ... just as at the sight of a murderer with drawn sword one becomes filled with horror. Thus, whenever seeing here or there slain or other dead beings, one should reflect on the death of such deceased persons who once lived in happiness, and one should rouse one's attentiveness, emotion and knowledge and consider thus: 'Death will come, etc.' .... Only in him who considers in this way, will the hindrances (ni^varana, q.v.) be repressed; and through the idea of death attention becomes steadfast, and the exercise reaches neighbourhood-concentration (upaca^ra-sama^dhi)."
According to Vis.M. VIII, one may also reflect on death in the following various ways: one may think of it as a murderer with a drawn sword standing in front of oneself; or one may bear in mind that all happiness ends in death; or that even the mightiest beings on this earth are subject to death; or that we must share this body with all those innumerable worms and other tiny beings residing therein; or that life is something dependent on in-and-out breathing, and bound up with it; or that life continues only as long as the elements, food, breath, etc. are properly performing their functions; or that nobody knows when, where, and under what circumstances, death will take place, and what kind of fate we have to expect after death; or, that life is very short and limited. As it is said: 'Short, indeed, is this life of men, limited, fleeting, full or woe and torment; it is just like a dewdrop that vanishes as soon as the sun rises; like a water-bubble; like a furrow drawn in the water; like a torrent dragging everything along and never standing still; like cattle for slaughter that every moment look death in the face" (A. VII, 74).
"The monk devoted to this recollection of death is at all time indefatigable, gains the idea of disgust with regard to all forms of existence, gives up delight in life, detests evil, does not hoard up things, is free from stinginess with regard to the necessities of life, the idea of impermanence (anicca) becomes familiar to him; and through pursuing it, the idea of misery (dukkha) and of impersonality (anatta^) become present to him .... Free from fear and bewilderment will he pass away at death; and should he not yet realize the Deathless State in his life-time, he will at the dissolution of the body attain to a happy course of existence" (Vis.M. VIII).
See Buddhist Reflections on Death, by V. F. Gunaratna (WHEEL 102/103). -Buddhism and Death, by M.Q.C. Walshe (WHEEL. 260).   s. pa^tiha^riya.  (regarding the absorptions): s. vasi^. - 8 stages of: abhibha^yatana (q.v.).  kabalinka^ra^ha^ra (q.v.).  (corporeality): s. khandha, rpa-kala^pa.  one, the: gotrabh (q.v.).  gotrabh-n~a^na; s. visuddhi (VII).   evident, and to be inferred: s. neyyatthadhamma.  eating. Just as the karmical, i.e. moral, quality of any action is determined by the quality of volition (cetana^) underlying it, and independently of this volition nothing whatever can be called karmically wholesome or unwholesome (kusala, akusala), just so it is with the merely external act of meat-eating, this being as such purely non-moral, i.e. karmically neutral (avya^kata).
'In 3 circumstances meat-eating is to be rejected: if one has seen, or heard, or suspects (that the animal has been slaughtered expressly for one's own sake)" (M. 55). For if in such a case one should partake of the meat, one would as it were approve the murder of animals, and thus encourage the animal-murderer in his murderous deeds. Besides, that the Buddha never objected, in ordinary circumstances, to meat-eating may be clearly understood from many passages of the Suttas (e.g. A. V. 44; VIII, 12; M. 55, etc.), as also from the Vinaya, where it is related that the Buddha firmly rejected Devadatta's proposal to forbid meat-eating to the monks; further from the fact that 10 kinds of meat were (for merely external reasons) forbidden to the monks, namely from elephants, tigers, serpents, etc.
See Amagandha Sutta (Sn.). Early Buddhism and the Taking of Life, by I. B. Horner (WHEEL 104).   s. bha^vana^, jha^na, sama^dhi.  mano-kamma; s. karma.  mano-dva^ra^vajjana; s. a^vajjana.  sankha^ra (q.v.). s. Tab. II.  citta-sankha^ra; s. sankha^ra (2).  s. nimitta, kasina, sama^dhi.  ceto-khila (q.v.).   the 4 streams of: pun~n~a-dha^ra^ (q.v.). - For transference of merit, s. patti-da^na.  s. pun~n~a, pun~n~a-kiriya-vatthu.   the 9-fold: of the Buddhasa^sana, s. sa^sana.   the 3 divine: s. deva-dta.   the right: n~a^ya, is a name for the 8-fold path (s. magga)   'loving-kindness', is one of the 4 sublime abodes (brahma-viha^ra, q.v.).  ditthi, -sankappa, -va^ca etc.: s. foll.  magga, Atthangika: the 'eightfold wrong path', i.e. (1) wrong view (miccha^-ditthi), (2) wrong thought (miccha^-sankappa), (3) wrong speech (miccha^-va^ca^), (4) wrong bodily action (miccha^-kammanta), (5) wrong livelihood (miccha^-a^ji^va), (6) wrong effort (miccha^-va^ya^ma), (7) wrong mindfulness (miccha^-sati), (8) wrong concentration (miccha^-sama^dhi). Just as the Eightfold Right Path (samma^-magga), so also here the 8 links are included in the group of mental formations (sankha^ra-kkhandha; s. khandha). The links 2, 6, 7, 8, are inseparably bound up with every karmically-unwholesome state of consciousness. Often are also present 3, 4, or 5, sometimes link 1.   'wrongnesses' = prec.   'sloth': Combined with thi^na, 'torpor', it forms one of the 5 hindrances (ni^varana, q.v.). Both may be associated with greedy consciousness (s. Tab. III and I, 23, 25, 27, 29).  majjhima-patipada^ (q.v.).   mano (q.v.); cf. na^ma.  na^ma-rpa (q.v.).  mana^yatana; s. a^yatana.  mano-vin~n~a^na-dha^tu (q.v.).  mano-dha^tu (q.v.).   sati (q.v.); s. satipattha^na. - Right m.: s. sacca, magga.  dhamma; s. a^yatana. - Contemplation of the, s. satipattha^na (4).  training, 'higher': adhicitta-sikkha^, s. sikkha^.   s. pa^tiha^riya.  (in the Arahat): s. hasituppa^da-citta.   s. para^ma^sa.   contemplation of: dukkha^nupassana^; s. ti-lakkhana.   'delusion', is one of the 3 unwholesome roots (mla, q.v.). The best known synonym is avijja^ (q.v.).  carita the 'deluded-natured'; s. carita.  (of existence): s. marana.   the fruits of; sa^man~n~a-phala (q.v.).  Sangha (q.v.); further s. pabbajja^, progress of the disciple.   si^la (q.v.). - Contemplation on, s. anussati (4).  training, higher: adhisi^la-sikkha^; s. sikkha^.  rules, the 5, 8 or 10: s. sikkha^pada.  'knowledge consisting in the desire for deliverance'; s. visuddhi (VI. 6).   'altruistic (or sympathetic) joy', is one of the 4 sublime abodes (brahma-viha^ra, q.v.).  (rpa, ka^ya, citta): 'elasticity' (of corporeality, mental factors, consciousness); s. khandha (I) and Tab. II.   'roots', also called hetu (q.v.; s. paccaya, 1), are those conditions which through their presence determine the actual moral quality of a volitional state (cetana^), and the consciousness and mental factors associated therewith, in other words, the quality of karma (q.v.). There are 6 such roots, 3 karmically wholesome and 3 unwholesome roots, viz.,: greed, hate, delusion (lobha, dosa, moha), and greedlessness, hatelessness, undeludedness (alobha, adosa, amoha).
In A. III, 68 it is said that greed arises through unwise reflection on an attractive object, hate through unwise reflection on a repulsive object. Thus, greed (lobha or ra^ga) comprises all degrees of 'attractedness' towards an object from the faintest trace of a longing thought up to grossest egoism, whilst hatred (dosa) comprises all degrees of 'repulsion' from the faintest trace of ill-humor up to the highest pitch of hate and wrath.
The 3 wholesome (kusala) roots, greedlessness, etc., though expressed in negative terms, nevertheless possess a distinctly positive character, just as is also often the case with negative terms in other languages, for example, the negative term 'immorality', which has a decidedly positive character.
Thus, greedlessness (alobha) is a name for unselfishness, liberality, etc., hatelessness (adosa) for kindness or goodwill (metta^), undeludedness (amoha) for wisdom (pan~n~a^).
"The perception of impurity is to be developed in order to overcome greed (lust); loving-kindness in order to overcome hate; wisdom in order to overcome delusion" (A. VI, 107).
"Killing, stealing, unlawful sexual intercourse, lying, tale-bearing, harsh language, frivolous talk, covetousness, ill-will and wrong views (s. kammapatha), these things are due either to greed, or hate, or delusion" (A. X, 174).
"Enraptured with lust (greed), enraged with hate, blinded by delusion, overwhelmed, with mind ensnared, man aims at his own ruin, at others' ruin, at the ruin of both, and he experiences mental pain and grief. And he follows evil ways in deeds, words and thought... And he really knows neither his own welfare, nor the welfare of others, nor the welfare of both. These things make him blind and ignorant, hinder his knowledge, are painful, and do not lead him to peace."
The presence or absence of the 3 unwholesome roots forms part of the mind contemplation in the Satipattha^na Sutta (M. 10). They are also used for the classification of unwholesome consciousness (s. Tab. I).
See The Roots of Good and Evil, by Nyanaponika Thera (WHEEL 251/253).  na^natta-san~n~a^; s. jha^na (5).   lokiya (q.v.).   Contemplation of: viparina^manupassana^: see vipassana^.   (lit. 'name'): 'mind', mentality. This term is generally used as a collective name for the 4 mental groups (arpino khandha), viz. feeling (vedana^), perception (san~n~a^), mental formations (sankha^ra) and consciousness (vin~n~a^na). Within the 4th link (na^ma-rpa) in the formula of the paticcasamuppa^da (q.v.), however, it applies only to karma-resultant (vipa^ka) feeling and perception and a few karma-resultant mental functions inseparable from any consciousness. As it is said (M. 9; D. 15; S. XII, 2): "Feeling (vedana^), perception (san~n~a^), volition (cetana^), impression (phassa), mental advertence (manasika^ra): this, o brother, is called mind (na^ma)." With the addition of 2 more mental factors, namely, mental vitality (ji^vita) and concentration (sama^dhi), here 'stationary phase of mind' (cittatthiti), these 7 factors are said in the Abhidhammattha Sangaha to be the inseparable mental factors in any state of consciousness.
For the complete list of all the 50 mental formations of the sankha^ra-kkhandha (not including feeling and perception), s. Tab. II.  the 'mind-group' (as distinguished from rpa-ka^ya, the corporeality-group) comprises the 4 immaterial groups of existence (arpino khandha^; s. khandha). This twofold grouping, frequent in Com., occurs first in D. 15, also in Pts.M. (I, 183); na^ma-ka^ya alone is mentioned in Sn. 1074.  rpa (lit. 'name and form'): 'mind-and-body', mentality and corporeality. It is the 4th link in the dependent origination (s. paticcasamuppa^da 3, 4) where it is conditioned by consciousness, and on its part is the condition of the sixfold sense-base. In two texts (D. 14, 15), which contain variations of the dependent origination, the mutual conditioning of consciousness and mind-and-body is described (see also S. XII, 67), and the latter is said to be a condition of sense-impression (phassa); so also in Sn. 872.
The third of the seven purifications (s. visuddhi), the purification of views, is defined in Vis.M. XVIII as the "correct seeing of mind-and-body," and various methods for the discernment of mind-and-body by way of insight-meditation (vipassana^, q.v.) are given there. In this context, 'mind' (na^ma) comprises all four mental groups, including consciousness. - See na^ma.
In five-group-existence (pan~ca-voka^ra-bhava, q.v.), mind-and body are inseparable and interdependent; and this has been illustrated by comparing them with two sheaves of reeds propped against each other: when one falls the other will fall, too; and with a blind man with stout legs, carrying on his shoulders a lame cripple with keen eye-sight: only by mutual assistance can they move about efficiently (s. Vis.M. XVIII, 32ff). On their mutual dependence, see also paticca-samuppa^da (3).
With regard to the impersonality and dependent nature of mind and corporeality it is said:
"Sound is not a thing that dwells inside the conch-shell and comes out from time to time, but due to both, the conch-shell and the man that blows it, sound comes to arise: Just so, due to the presence of vitality, heat and consciousness, this body may execute the acts of going, standing, sitting and lying down, and the 5 sense-organs and the mind may perform their various functions" (D. 23).
"Just as a wooden puppet though unsubstantial, lifeless and inactive may by means of pulling strings be made to move about, stand up, and appear full of life and activity; just so are mind and body, as such, something empty, lifeless and inactive; but by means of their mutual working together, this mental and bodily combination may move about, stand up, and appear full of life and activity."   'knowledge, comprehension, intelligence, insight', is a synonym for pan~n~a^ (q.v.); see also vipassana^.  'purification of knowledge and vision', is the last of the 7 purifications and a name for path-knowledge (maggan~a^na), i.e. the penetrating realization of the path of Stream-winning, Once-returning, Non-returning or Arahatship. Vis.M. XXII furnishes a detailed explanation of it (s. visuddhi, VII).
In A. IV, 41 n~a^nadassana apparently means the divine eye (dibbacakkhu, s. abhin~n~a^), being produced through concentrating the mind on light.  The 'variety (or multiformity) - perceptions are explained under jha^na (q.v.).  the 'power of penetrating knowledge', is one of the magical powers (iddhi, q.v.).  'full understanding (or comprehension) of the known', is one of the 3 kinds of full understanding (parin~n~a^ q.v.).  'nihilistic view' (a doctrine that all values are baseless, that nothing is knowable or can be communicated, and that life itself is meaningless), s. ditthi.  'absence-condition', is one of the 24 conditions (paccaya, q.v.).  pakati-si^la (q.v.).  buddha (or satthu)- sa^sana: s. sa^sana.  s. satta^va^sa.  s. kala^pa (2).   'right method', is often used as a name for the Noble Eightfold Path (s. magga), e.g. in the Satipattha^na Sutta (M. 10, D. 22).  upaca^ra-sama^dhi (q.v.) .   'freedom from sensual lust', renunciation. Though apparently from nir + ? kram, 'to go forth (into the homeless state of a monk)', this term is in the Pa^li texts nevertheless used as if it were derived from ka^ma, lust, and always as an antonym to ka^ma. It is one of the perfections (s. pa^rami^). N. sankappa, thought free from lust, or thought of renunciation, is one of the 3 kinds of right thought (samma^-sankappa), the 2nd link of the Noble Eightfold Path (s. magga, 2), its antonym being ka^masankappa, lustful thought.   one of the 13 dhutanga (q.v.).   karmically: avya^kata (q.v.); n. feelings, s. vedana^.  The 'sphere of neither-perception-nor-non-perception', is the name for the fourth absorption of the immaterial sphere (arpa^vacara), a semi-conscious state, which is surpassed only by the state of complete suspense of consciousness, called 'attainment of extinction' (nirodha-sama^patti, q.v.). See jha^na (8).  'neither in training nor beyond training', i.e. neither learner nor master. Thus is called the worldling (puthujjana, q.v.), for he is neither pursuing the 3-fold training (sikkha^ q.v.) in morality, mental culture and wisdom, on the level of the first 3 paths of sanctity, nor has he completed his training as an Arahat. See sekha. - (App.).   'requiring guidance', is said of a person "who through advice and questioning, through wise consideration, and through frequenting noble-minded friends, having intercourse with them, associating with them, gradually comes to penetrate the truth" (Pug. 162). Cf. ugghatitan~n~.  A 'teaching the meaning of which is implicit, or has to be inferred' as contrasted with a 'teaching with an explicit or evident meaning' (ni^tattha-dhamma). In A. I, 60 (PTS) it is said: "Whoso declares a sutta with an implicit meaning as a sutta with explicit meaning (and conversely), such a one makes a false statement with regard to the Blessed One." - See paramattha.   (Sanskrit nirva^na): lit. 'extinction' (nir + ? va, to cease blowing, to become extinguished); according to the commentaries, 'freedom from desire' (nir+ vana). Nibba^na constitutes the highest and ultimate goal of all Buddhist aspirations, i.e. absolute extinction of that life-affirming will manifested as greed, hate and delusion, and convulsively clinging to existence; and therewith also the ultimate and absolute deliverance from all future rebirth, old age, disease and death, from all suffering and misery. Cf. Parinibba^na.
"Extinction of greed, extinction of hate, extinction of delusion: this is called Nibba^na" (S. XXXVIII. 1).
The 2 aspects of Nibba^na are:
(1) The full extinction of defilements (kilesa-parinibba^na), also called sa-upa^di-sesa-nibba^na (s. It. 41), i.e. 'Nibba^na with the groups of existence still remaining' (s. upa^di). This takes place at the attainment of Arahatship, or perfect holiness (s. ariya-puggala).
(2) The full extinction of the groups of existence (khandha-parinibba^na), also called an-upa^di-sesa-nibba^na (s. It. 41, A. IV, 118), i.e. 'Nibba^na without the groups remaining', in other words, the coming to rest, or rather the 'no-more-continuing' of this physico-mental process of existence. This takes place at the death of the Arahat. - (App.: Nibba^na).
Sometimes both aspects take place at one and the same moment, i.e. at the death of the Arahat; s. sama-si^si^.
"This, o monks, truly is the peace, this is the highest, namely the end of all formations, the forsaking of every substratum of rebirth, the fading away of craving, detachment, extinction, Nibba^na" (A. III, 32).
"Enraptured with lust (ra^ga), enraged with anger (dosa), blinded by delusion (moha), overwhelmed, with mind ensnared, man aims at his own ruin, at the ruin of others, at the ruin of both, and he experiences mental pain and grief. But if lust, anger and delusion are given up, man aims neither at his own ruin, nor at the ruin of others, nor at the ruin of both, and he experiences no mental pain and grief. Thus is Nibba^na visible in this life, immediate, inviting, attractive, and comprehensible to the wise" (A. III, 55).
"Just as a rock of one solid mass remains unshaken by the wind, even so neither visible forms, nor sounds, nor odours, nor tastes, nor bodily impressions, neither the desired nor the undesired, can cause such a one to waver. Steadfast is his mind, gained is deliverance" (A, VI, 55).
"Verily, there is an Unborn, Unoriginated, Uncreated, Unformed. If there were not this Unborn, Unoriginated, Uncreated, Unformed, escape from the world of the born, the originated, the created, the formed, would not be possible" (Ud. VIII, 3).
One cannot too often and too emphatically stress the fact that not only for the actual realization of the goal of Nibba^na, but also for a theoretical understanding of it, it is an indispensable preliminary condition to grasp fully the truth of anatta^ (q.v.), the egolessness and insubstantiality of all forms of existence. Without such an understanding, one will necessarily misconceive Nibba^na - according to one's either materialistic or metaphysical leanings - either as annihilation of an ego, or as an eternal state of existence into which an ego or self enters or with which it merges. Hence it is said:
"Mere suffering exists, no sufferer is found;
The deed is, but no doer of the deed is there;
Nibba^na is, but not the man that enters it;
The path is, but no traveler on it is seen."
(Vis.M. XVI)
 
Literature: For texts on Nibba^na, see Path, 36ff. - See Vis.M. XVI. 64ff. - Anatta^ and Nibba^na, by Nyanaponika Thera (WHEEL 11); The Buddhist Doctrine of Nibba^na, by Ven. P. Vajiranana & F. Story (WHEEL 165/166).   'arising', 'rebirth', is a synonym for patisandhi (q.v.).  bha^giya si^la (-sama^dhi, -pan~n~a^): 'morality (concentration, wisdom) connected with penetration'; s. ha^na-bha^giya-si^la.  'contemplation of aversion', is one of the 18 chief kinds of insight; s. vipassana^ (4), samatha-vipassana^ (2), visuddhi (VI, 5).  san~n~a^ (-citta,-ditthi): perception (or consciousness, or view) of permanency, is one of the 4 perversions (vipalla^sa, q.v.).  natthika-ditthi; s. ditthi.  'blue-kasina exercise' s. kasina.   mark, sign; image; target, object; cause, condition. These meanings are used in, and adapted to, many contexts of which only the doctrinal ones are mentioned here.
1. 'Mental (reflex-) image', obtained in meditation. In full clarity, it will appear in the mind by successful practice of certain concentration-exercises and will then appear as vividly as if seen by the eye. The object perceived at the very beginning of concentration is called the preparatory image (parikamma-nimitta). The still unsteady and unclear image, which arises when the mind has reached a weak degree of concentration, is called the acquired image (uggaha-nimitta). An entirely clear and immovable image arising at a higher degree of concentration is the counter-image (patibha^ga-nimitta). As soon as this image arises, the stage of neighbourhood (or access) concentration (upaca^ra-sama^dhi) is reached. For further details, s. kasina, sama^dhi.
2. 'Sign of (previous) kamma' (kamma-nimitta) and 'sign of (the future) destiny' (gati-nimitta); these arise as mental objects of the last karmic consciousness before death (marana^sanna-kamma; s. karma, III, 3).
Usages (1) and (2) are commentarial (s. App.). In sutta usage, the term occurs, e.g. as:
3. 'Outward appearance': of one who has sense-control it is said- that "he does not seize upon the general appearance' of an object (na nimittagga^hi^; M. 38, D. 2; expl. Vis I, 54f; see si^la).
4. 'Object': the six objects, i.e. visual, etc. (rpa-nimitta; S. XXII, 3). Also, when in explanation of animitta-cetovimutti, signless deliverance of mind (s. cetovimutti, vimokkha), it is said, 'sabba-nimitta^nam amanasika^ra^', it refers to the 6 sense-objects (Com. to M. 43), and has therefore to be rendered "by paying no attention to any object (or object-ideas)." - A pleasant or beautiful object (subha-nimitta, q.v.) is a condition to the arising of the hindrance of sense-desire; a 'repellent object' (patigha-nimitta) for the hindrance of ill-will; contemplation on the impurity of an object (asubha-nimitta; s. asubha) is an antidote to sense-desire.
5. In Pts.M. II, in a repetitive series of terms, nimitta appears together with uppa^do (origin of existence), pavattam (continuity of existence), and may then be rendered by 'condition of existence' (s. Path, 194f.).  the name of a class of heavenly beings of the sensuous sphere; s. deva.  s. satta^va^sa.  s: sa^sana.   s. papan~ca.  'produced corporeality', is identical with rpa-rpa, 'corporeality proper', i.e. material or actual corporeality, as contrasted with 'unproduced corporeality' (anipphanna-rpa), consisting of mere qualities or modes of corporeality, e.g. impermanence, etc., which are also enumerated among the 28 phenomena of the corporeality group. See khandha, Summary I; Vis.M. XIV, 73.   lit. 'the downward-path', the nether or infernal world, usually translated by 'hell', is one of the 4 lower courses of existence (apa^ya, q.v.). The Buddhists are well aware that on account of the universal sway of impermanence a life in hell, just as in heaven, cannot last eternally, but will after exhaustion of the karma which has caused the respective form of rebirth, necessarily be followed again by a new death and a new rebirth, according to the stored-up karma.   'extinction'; s. nirodha-sama^patti, anupubba-nirodha.   'contemplation of extinction', is one of the 18 chief kinds of insight (vipassana^ q.v.). See a^na^pa^nasati (15).  'attainment of extinction' (S. XIV, 11), also called san~n~a^-vedayita-nirodha, 'extinction of feeling and perception', is the temporary suspension of all consciousness and mental activity, following immediately upon the semi-conscious state called 'sphere of neither-perception-nor-non-perception' (s. jha^na, 8). The absolutely necessary pre-conditions to its attainment are said to be perfect mastery of all the 8 absorptions (jha^na), as well as the previous attainment of Ana^ga^mi or Arahatship (s. ariya-puggala).
According to Vis.M. XXIII, the entering into this state takes place in the following way: by means of mental tranquillity (samatha) and insight (vipassana^) one has to pass through all the 8 absorptions one after the other up to the sphere of neither-perception-nor-non-perception and then one has to bring this state to an end. If, namely, according to the Vis.M., the disciple (Ana^ga^mi or Arahat) passes through the absorption merely by means of tranquillity, i.e. concentration, he will only attain the sphere of neither-perception-nor-non-perception, and then come to a standstill; if, on the other hand, he proceeds only with insight, he will reach the fruition (phala) of Ana^ga^mi or Arahatship. He, however, who by means of both faculties has risen from absorption to absorption and, having made the necessary preparations, brings the sphere of neither-perception-nor-non-perception to an end, such a one reaches the state of extinction. Whilst the disciple is passing through the 8 absorptions, he each time emerges from the absorption attained, and regards with his insight all the mental phenomena constituting that special absorption, as impermanent, miserable and impersonal. Then he again enters the next higher absorption, and thus, after each absorption practising insight, he at last reaches the state of neither-perception-nor-non-perception, and thereafter the full extinction. This state, according to the Com., may last for 7 days or even longer. Immediately at the rising from this state, however, there arises in the Ana^ga^mi the fruition of Ana^ga^miship (ana^ga^mi-phala), in the Arahat the fruition of Arahatship (arahatta-phala).
With regard to the difference existing between the monk abiding in this state of extinction on the one hand, and a dead person on the other hand, M 43 says: "In him who is dead, and whose life has come to an end, the bodily (in-and-outbreathing), verbal (thought-conception and discursive thinking), and mental functions (s. sankha^ra, 2) have become suspended and come to a standstill, life is exhausted, the vital heat extinguished, the faculties are destroyed. Also in the monk who has reached 'extinction of perception and feeling' (san~n~a^-vedayita-nirodha), the bodily, verbal and mental functions have been suspended and come to a standstill, but life is not exhausted, the vital heat not extinguished, and the faculties are not destroyed."
For details, see Vis.M. XXIII; for texts s. Path 206.  the 'analytical knowledge of language', is one of the 4 patisambhida^ (q.v.).   (Sanskrit= ) Nibba^na (q.v.).  'overcoming by escape', is one of the 5 kinds of overcoming (paha^na q.v.).   'foundation'. The 2 wrong foundations of morality are craving (tanha^-nissaya) and views (ditthi-nissaya). Hence there are two wrong bases of morality: morality based on craving (tanha^-nissita-si^la) and morality based on views (ditthi-nissita-si^la). (App.)
" 'Based on craving' is that kind of morality which has come about by the desire for a happy existence, e.g.: 'O that by this morality I might become a godlike or heavenly being!' (A.IX, 172). 'Based on views' is that morality which has been induced by the view that through the observation of certain moral rules purification may be attained" (Vis.M. I).  'support', base, foundation, is one of the 24 conditions (s. paccaya, 8).  A 'doctrine with evident meaning', contrasted with a 'doctrine with a meaning to be inferred' (neyyattha-dhamma, q.v.). See also paramattha.   'hindrances', are 5 qualities which are obstacles to the mind and blind our mental vision. In the presence of them we cannot reach neighbourhood-concentration (upaca^ra-sama^dhi) and full concentration (appana^-sama^dhi), and are unable to discern clearly the truth. They are:
1. sensuous desire (ka^macchanda),
2. ill-will (vya^pa^da),
3. sloth and torpor (thi^na-middha),
4. restlessness and scruples (uddhacca-kukkucca), and
5. skeptical doubt (vicikiccha^; q.v.).
In the beautiful similes in A. V, 193, sensuous desire is compared with water mixed with manifold colours, ill-will with boiling water, sloth and torpor with water covered by moss, restlessness and scruples with agitated water whipped by the wind, skeptical doubt with turbid and muddy water. Just as in such water one cannot perceive one's own reflection, so in the presence of these 5 mental hindrances, one cannot clearly discern one's own benefit, nor that of others, nor that of both.
Regarding the temporary suspension of the 5 hindrances on entering the first absorption, the stereotype sutta text (e g. A. IX, 40) runs as follows:
"He has cast away sensuous desire; he dwells with a heart free from sensuous desire; from desire he cleanses his heart.
"He has cast away ill-will; he dwells with a heart free from ill-will, cherishing love and compassion toward all living beings, he cleanses his heart from ill-will.
"He has cast away sloth and torpor; he dwells free from sloth and torpor; loving the light, with watchful mind, with clear consciousness, he cleanses his mind from sloth and torpor.
"He has cast away restlessness and scruples; dwelling with mind undisturbed, with heart full of peace, he cleanses his mind from restlessness and scruples.
"He has cast away skeptical doubt; dwelling free from doubt, full of confidence in the good, he cleanses his heart from doubt.
"He has put aside these 5 hindrances, and come to know these paralysing defilements of the mind. And far from sensual impressions, far from unwholesome things, he enters into the first absorption, etc."
The overcoming of these 5 hindrances by the absorptions is, as already pointed out, a merely temporary suspension, called 'overcoming through repression' (vikkhambhana-paha^na). They disappear forever on entering the 4 supermundane paths (s. ariyapuggala), i.e. skeptical doubt on reaching Sota^panship; sensuous desire, ill-will and mental worry on reaching Ana^ga^miship; sloth, torpor and restlessness on reaching Arahatship.
For their origination and their overcoming, s. A. I, 2; VI, 21; S. XLVI, 51.
See The Five Mental Hindrances, by Nyanaponika Thera (WHEEL 26).   the 'fixedness of law' regarding all things; cf. tathata^. - Pan~ca-niya^ma is a commentarial term, signifying the 'fivefold lawfulness' or 'natural order' that governs: (1) temperature, seasons and other physical events (utu-niya^ma); (2) the plant life (bi^ja-n.); (3) karma (kamma-n.); (4) the mind (citta-n.), e.g. the lawful sequence of the functions of consciousness (s. vin~n~a^na-kicca) in the process of cognition; (5) certain events connected with the Dhamma (dhamma-n.), e.g. the typical events occurring in the lives of the Buddhas. (App.).  'wrong views with fixed destiny', are the views of uncausedness of existence (ahetuka-ditthi), of the inefficacy of action (akiriya-ditthi), and nihilism (natthika-ditthi). For details, s. ditthi; and M. 60, Com. (WHEEL 98/99). - (App.)  a 'person with a fixed destiny', may be either one who has committed one of the 5 'heinous deeds with immediate result' (a^nantarika-kamma, q.v.), or one who follows 'wrong views with fixed destiny' (niyata-miccha^-ditthi, q.v.), or one who has reached one of the 4 stages of holiness (s. ariya-puggala). About the latter cf. the frequent passage: "Those disciples in whom the 3 fetters (of personality-belief, sceptical doubt and attachment to mere rules and ritual; s. samyojana) have vanished, they all have entered the stream, have forever escaped the states of woe; fixed is their destiny (niyata), assured their final enlightenment."  s. viha^ra.  family, Passing from n.f. to n.f.: kolankola; s. sota^pan~n~a^.  ariya-puggala (q.v.).  ariya iddhi; s. iddhi.  truths, the 4: ariya-sacca; s. sacca. - The 2-fold knowledge of the n.t.; s. sacca-n~a^na.  usages, the 4: ariya-vamsa (q.v.).  avigata-paccaya, is one of the 24 conditions (paccaya, q.v.).  s. avihimsa^.  s. anatta^.  'underived corporeality', designates the 4 primary elements (maha^bhta or dha^tu), as distinguished from the 'derived corporeality' (upa^da^-rpa), such as the sensitive organs, etc. Cf. khandha, I.   s. oja^, a^ha^ra. - a^ha^ra is one of the 24 conditions (paccaya, q.v.) - n.- produced corporeality; s. samuttha^na.   the 5 mental: ceto-khila (q.v.).   'effulgence of light', aura, appearing at times during deep insight (vipassana^), may become a 'defilement of insight' (vipassanpakkilesa); cf. visuddhi, V.   a^rammana (q.v.); as condition s. paccaya (2).   the 10 o. of meditation: palibodha (q.v.); for the 5 mental obstacles, or hindrances, s. ni^varana.  'white-kasina-exercise'; s. kasina.   'floods', is a name for the 4 cankers (a^sava, q.v.).   'nutriment' (synonym of a^ha^ra, q.v.), is one of those 8 minimal constituent parts, or qualities, of all corporeality, to wit: the solid, liquid, heat, motion; colour, odour, taste and nutriment. This is the 'octad with nutriment as the eighth (factor)' (ojatthamaka-kala^pa), also called the 'pure eightfold unit' (suddhatthaka-kala^pa), being the most primitive material combination. For further details, s. rpa-kala^pa.   'conception', lit. 'descent', designates the appearance of the embryo in the mother's womb, i.e. the beginning of the birth process (ja^ti, q.v.). "Through the concurrence of 3 circumstances arises the embryo. When father and mother have united, ... and the mother has her time, and the 'genius' (metaphorically for the karma energy) is ready; under these 3 circumstances does the embryo appear" (M. 38).  jara^ (q.v.), is one of the 3 divine messengers (s. devadta).  s. a^yatana.   'inferiority-conceit'; s. ma^na.  eater, the practice of the: s. dhutanga.  eka-voka^ra-bhava (q.v.).  pointedness of mind (citt'ekaggata^): a name for mental concentration (sama^dhi, q.v.).   lit. 'accidental' (from upapa^ta, accident; not from upapatti, as PTS Dict. has); 'spontaneously born', i.e. born without the instrumentality of parents. This applies to all heavenly and infernal beings. "After the disappearing of the 5 lower fetters (samyojana, q.v.), he (the Ana^ga^mi) appears in a spiritual world (opapa^tika) ...."  air, practice of living in the: s. dhutanga.   'overcoming by the opposite,' s. paha^na.  the 'lower fetters', i.e. the first 5 fetters that bind to lower existence; s. samyojana.   dependent: paticcasamuppa^da (q.v.).  s. samuttha^na.   'moral dread'; s. hiri-ottappa.   the 5 kinds of: s. paha^na. - Full understanding consisting in o.; s. parin~n~a^ - the effort to overcome, s. padha^na. - Overcoming doubt, the purification by; s. visuddhi, IV.   lit. 'the going forth', or more fully stated, 'the going forth from home to the homeless life' of a monk (aga^rasma^ anaga^riyam pabbajja^), consists in severing all family and social ties to live the pure life of a monk, in order to realize the goal of final deliverance pointed out by the Enlightened One. Thus, p. has become the name for admission as a sa^manera, or novice, i.e. as a candidate for the Order of Bhikkhus, or monks.
See Going Fonh, by Sumana Samanera (WHEEL 27/28) - Ordination in Therava^da Buddhism (WHEEL 56).  'retrospective knowledge', refers to the recollected mental image obtained in concentration, or to any inner experience just passed, as for instance, any absorption (jha^na q.v.), or any supermundane path, or fruition of the path, etc. (s. ariya-puggala). As it is said: "At the end of fruitional consciousness, consciousness sinks into the subconscious stream of existence (bhavanga-sota, q.v.). Then, breaking off the stream of existence, mental advertence (manodva^ra^vajjana) arises at the mind-door, for the purpose of retrospecting the (just passed) path-moment. Now, as soon as this stage has passed, 7 moments of impulsive consciousness (javana-citta), one after the other, flash up while retrospecting the path. After they again have sunk into the subconscious stream, there arise, for the purpose of retrospecting the fruition of the path the moments of advertence and impulsion, during whose arising the monk is retrospecting the path, retrospecting the fruition, retrospecting the abandoned defilements, retrospecting the still remaining defilements, retrospecting Nibba^na as object .... 'This blessing have I attained' .... 'This and that defilement still remains in me' .... 'This object have I beheld in my mind', etc." (Vis.M. XXII).  'purity of reflection', is a name for wise consideration in using the 4 requisites allowed to the monk, i.e. robes, food, dwelling, and medicine; s. si^la (4).   'condition', is something on which something else, the so-called 'conditioned thing', is dependent, and without which the latter cannot be. Manifold are the ways in which one thing, or one occurrence, may be the condition for some other thing, or occurrence. In the Pattha^na, the last book of the Abhidhamma Pitaka (comprising 6 large vols. in the Siamese edition), these 24 modes of conditionality are enumerated and explained, and then applied to all conceivable mental and physical phenomena and occurrences, and thus their conditioned nature is demonstrated.
The first two volumes of the Pattha^na have been translated into English by the Venerable U Na^rada (Mlapattha^na Sayadaw) of Burma, under the title Conditional Relations (Published by the Pa^li Text Society, London 1969, 1981). For a synopsis of this work, see Guide VII.
The 24 modes of conditionality are:
 
1. Root condition : hetu paccaya
2. Object " : a^rammana "
3. Predominance " : adhipati "
4. Priority " : anantara "
5. Contiguity " : samanantara "
6. Co-nascence " : sahaja^ta "
7. Mutuality " : an~n~aman~n~a "
8. Support " : nissaya "
9. Decisive Support " : upanissaya "
10. Pre-nascene " : pureja^ta "
11. Post-nascene " : paccha^ja^ta "
12. Repitition " : a^sevana "
13. Karma " : kamma "
14. Karma-result " : vipa^ka "
15. Nutriment " : a^ha^ra "
16. Faculty " : indriya "
17. Jha^na " : jha^na "
18. Path " : magga "
19. Associaton " : sampayutta "
20. Dissociation " : vippayutta "
21. Presence " : atthi "
22. Absence " : natthi "
23. Disappearance " : vigata "
24. Non-disappearance " : avigata "
 
(1) Root-condition (hetu-paccaya) is that condition that resembles the root of a tree. Just as a tree rests on its root, and remains alive only as long as its root is not destroyed, similarly all karmically wholesome and unwholesome mental states are entirely dependent on the simultaneity and presence of their respective roots, i.e, of greed (lobha), hate (dosa), delusion (moha), or greedlessness (alobha), hatelessness (adosa), undeludedness (amoha). For the definition of these 6 roots, s. mla.
"The roots are a condition by way of root for the (mental) phenomena associated with a root, and for the corporeal phenomena produced thereby (e.g. for bodily expression)" (Patth).
(2) Object-condition (a^rammana-paccaya) is called something which, as object, forms the condition for consciousness and mental phenomena. Thus, the physical object of sight consisting in colour and light ('light-wave'), is the necessary condition and the sine qua non for the arising of eye-consciousness (cakkhu-vin~n~a^na), etc.; sound ('sound wave') for ear-consciousness (sota^-vin~n~a^na), etc.; further, any object arising in the mind is the condition for mind-consciousness (mano-vin~n~a^na). The mind-object may be anything whatever, corporeal or mental, past, present or future, real or imaginary.
(3) Predominance-condition (adhipati-paccaya) is the term for 4 things, on the preponderance and predominance of which are dependent the mental phenomena associated with them, namely: concentrated intention (chanda, q.v.), energy (viriya, q.v.), consciousness (citta) and investigation (vi^mamsa^). In one and the same state of consciousness, however, only one of these 4 phenomena can be predominant at a time. "Whenever such phenomena as consciousness and mental concomitants are arising by giving preponderance to one of these 4 things, then this phenomenon is for the other phenomena a condition by way of predominance" (Patth.). Cf. iddhi-pa^da.
(4-5) Proximity and contiguity (or immediacy)-condition (anantara and samanantara-paccaya) - both being identical - refer to any state of consciousness and mental phenomena associated with them, which are the conditions for the immediately following stage in the process of consciousness. For example, in the visual process, eye-consciousness is for the immediately following mindelement - performing the function of receiving the visible object - a condition by way of contiguity; and so is this mind-element for the next following mind-consciousness element, performing the function of investigating the object, etc. Cf. vin~n~a^na-kicca.
(6) Co-nascence condjtion (sahaja^ta-paccaya), i.e. condition by way of simultaneous arising, is a phenomenon that for another one forms, a condition in such a way that, simultaneously with its arising, also the other thing must arise. Thus, for instance, in one and the same moment each of the 4 mental groups (feeling, perception, mental formations and consciousness) is for the 3 other groups a condition by way of co-nascence or co-arising; or again each of the 4 physical elements (solid, liquid, heat, motion) is such a condition for the other 3 elements. Only at the moment of conception in the mother's womb does corporeality (physical base of mind) serve for the 4 mental groups as a condition by way of conascence.
(7) Condition by way of mutuality (an~n~a^man~n~a-paccaya). All the just mentioned associated and co-nascent mental phenomena, as well as the 4 physical elements, are, of course, at the same time also conditioned by way of mutuality, "just like three sticks propped up one by another." The 4 mental groups are one for another a condition by way of mutuality. So also are the 4 elements, and also mentality and corporeality at the moment of conception.
(8) Support-condition (nissaya-paccaya). This condition refers either to a pre-nascent (s. 10) or co-nascent (s. 6) phenomenon which is aiding other phenomena in the manner of a foundation or base, just as the trees have the earth as their foundation, or as the oil-painting rests on the canvas. In this way, the 5 sense-organs and the physical base of the mind are for the corresponding 6 kinds of consciousness a prenascent, i.e. previously arisen, condition by way of support. Further all co-nascent (s. 6) phenomena are mutually (s. 7) conditioned by each other by way of support.
(9) Decisive-support (or inducement) condition (upanissaya-paccaya) is threefold, namely (a) by way of object (a^rammanpanissaya-paccaya), (b) by way of proximity (anantarpanissaya), (c) natural decisive support (pakatupanissaya). These conditions act as strong inducement or cogent reason.
(a) Anything past, present or future, corporeal or mental, real or imaginary, may, as object of our thinking, become a decisive support, or strong inducement, to moral, immoral or karmically neutral states of mind. Evil things, by wrong thinking about them, become an inducement to immoral life; by right thinking, an inducement to moral life. But good things may be an inducement not only to similarly good things, but also to bad things, such as self-conceit, vanity, envy, etc.
(b;) is identical with proximity condition (No. 4).
(c) Faith, virtue, etc., produced in one's own mind, or the influence of climate, food, etc., on one's body and mind, may act as natural and decisive support-conditions. Faith may be a direct and natural inducement to charity, virtue to mental training, etc.; greed to theft, hate to murder; unsuitable food and climate to ill-health; friends to spiritual progress or deterioration.
(10) Pre-nascence-condition (pureja^ta-paccaya) refers to something previously arisen, which forms a base for something arising later on. For example, the 5 physical sense-organs and the physical base of mind, having already arisen at the time of birth, form the condition for the consciousness arising later, and for the mental phenomena associated therewith.
(11) Post-nascence-condition (paccha^-ja^ta-paccaya) refers to consciousness and the phenomena therewith associated, because they are - just as is the feeling of hunger- a necessary condition for the preservation of this already arisen body.
(12) Repetition-condition (a^sevana-paccaya) refers to the karmical consciousness, in which each time the preceding impulsive moments (javana-citta, q.v.) are for all the succeeding ones a condition by way of repetition and frequency, just as in learning by heart, through constant repetition, the later recitation becomes gradually easier and easier.
(13) Karma-condition (kamma-paccaya). The pre-natal karma (i.e karma-volitions, kamma-cetana^, in a previous birth) is the generating condition (cause) of the 5 sense-organs, the fivefold sense-consciousness, and the other karma-produced mental and corporeal phenomena in a later birth. - Karmical volition is also a condition by way of karma for the co-nascent mental phenomena associated therewith, but these phenomena are in no way karma-results.
(14) Karma-result-condition (vipa^ka-paccaya). The karma-resultant 5 kinds of sense-consciousness are a condition by way of karma-result for the co-nascent mental and corporeal phenomena.
(15) Nutriment-condition (a^ha^ra-paccaya). For the 4 nutriments, s. a^ha^ra.
(16) Faculty-condition (indriya-paccaya). This condition applies to 20 faculties (indriya, q.v.), leaving out No. 7 and 8 from the 22 faculties. Of these 20 faculties, the 5 physical sense-organs (1 - 5), in their capacity as faculties, form a condition only for uncorporeal phenomena (eye-consciousness etc.); physical vitality (6) and all the remaining faculties, for the co-nascent mental and corporeal phenomena.
(17) Jha^na-condition (jha^na-paccaya) is a name for the 7 so-called jha^na-factors, as these form a condition to the co-nascent mental and corporeal phenomena, to wit: (1) thought-conception (vitakka), (2) discursive thinking (vica^ra), (3) interest (pi^ti), (4) joy (sukha), (5) sadness (domanassa), (6) indifference (upekkha^), (7) concentration (sama^dhi). (For definition s. Pa^li terms. )
1, 2, 3, 4, 7 are found in 4 classes of greedy consciousness (s. Tab. I. 22-25); 1, 2, 5, 7 in hateful consciousness (ib. 30, 31); 1, 2, 6, 7 in the classes of deluded consciousness (ib. 32, 33).
This condition does not only apply to jha^na alone, but also to the general intensifying ('absorbing') impact of these 7 factors.
(18) Path-condition (magga-paccaya) refers to the 12 path-factors, as these are for the karmically wholesome and unwholesome mental phenomena associated with them, a way of escape from this or that mental constitution, namely: (1) knowledge (pan~n~a^ = samma^ditthi, right understanding), (2) (right or wrong) thought-conception (vitakka), (3) right speech (samma^-va^ca^), (4) right bodily action (samma^-kammanta), (5) right livelihood (samma^-a^ji^va), (6) (right or wrong) energy (viriya), (7) (right or wrong) mindfulness (sati), (8) (right or wrong) concentration (sama^dhi), (9) wrong views (miccha^ditthi), (10) wrong speech (miccha^-va^ca^), (11) wrong bodily action (miccha^-kammanta), (12) wrong livelihood (miccha^-a^ji^va). Cf. magga.
(19) Association-condition (sampayutta-paccaya) refers to the co-nascent (s. 6) and mutually (s. 7) conditioned 4 mental groups (khandha), "as they aid each other by their being associated, by having a common physical base, a common object, and by their arising and disappearing simultaneously" (Patth. Com.).
(20) Dissociation-condition (vippayutta-paccaya) refers to such phenomena as aid other phenomena by not baving the same physical base (eye, etc.) and objects. Thus corporeal phenomena are for mental phenomena, and conversely, a condition by way of dissociation, whether co-nascent or not.
(2l) Presence-condition (atthi-paccaya) refers to a phenomenon - being pre-nascent or co-nascent - which through its presence is a condition for other phenomena. This condition applies to the conditions Nos. 6, 7, 8, 10, 11.
(22) Absence-condition (natthi-paccaya) refers to consciousness, etc., which has just passed, and which thus forms the necessary condition for the immediately following stage of consciousness by giving it an opportunity to arise. Cf. No. 4.
(23) Disappearance-condition (vigata-paccaya) is identical with No. 22.
(24) Non-disappearance-condition (avigata-paccaya) is identical with No. 21.
These 24 conditions should be known thoroughly for a detailed understanding of that famous formula of the dependent origination (paticcasamuppa^da, q.v.). Cf. Fund. III, Guide p. 117 ff. (App.) .
See The Significance of Dependent Origination, by Nyanatiloka (WHEEL 140).  'morality consisting in the wise use of the monk's requisities'; s. si^la (4).  'independent enlightenment'; s. the foll. and bodhi.  an 'Independently Enlightened One'; or Separately or Individually (=pacceka) Enlightened One (renderings by 'Silent' or 'Private Buddha' are not very apt). This is a term for an Arahat (s. ariya-puggala) who has realized Nibba^na without having heard the Buddha's doctrine from others. He comprehends the 4 Noble Truths individually (pacceka), independent of any teacher, by his own effort. He has, however, not the capacity to proclaim the Teaching effectively to others, and therefore does not become a 'Teacher of Gods and Men', a Perfect or Universal Buddha (samma^-sambuddha). - Paccekabuddhas are described as frugal of speech, cherishing solitude. According to tradition, they do not arise while the Teaching of a Perfect Buddha is known; but for achieving their rank after many aeons of effort, they have to utter an aspiration before a Perfect Buddha.
Canonical references are few; Pug. 29 (defin.); A. II, 56; in M. 116, names of many Paccekabuddhas are given; in D. 16 they are said to be worthy of a thpa (dagoba); the Treasure-Store Sutta (Nidhikhandha Sutta, Khp.) mentions pacceka-bodhi; the C. Nidd. ascribes to individual Paccekabuddhas the verses of the Rhinoceros Sutta (Khaggavisa^na Sutta, Sn.) - See bodhi.
See The Paccekabuddha, by Ria Kloppenborg (WHEEL 305/307).  'post-nascence-condition', is one of the 24 conditions (paccaya, q.v.).  'foundation-forming absorption', is an absorption used as a foundation, or starting point, for the higher spiritual powers (abhin~n~a^, q.v.), or for insight (vipassana^, q.v.), leading to the supermundane paths (s. ariya-puggala). The foundation for the former is the 4th absorption; for insight, however, any absorption is suitable. For details, s. samatha-vipassana^. - (App.).  'one for whom the words are the utmost attainment'. "Whoever, though having learned much, speaking much, knowing many things by heart, and discoursing much, has not penetrated the truth, such a man is called by that name" (Pug. 163).   'effort.' The 4 right efforts (samma-padha^na), forming the 6th stage of the 8-fold Path (i.e. samma^-va^ya^ma, s. magga) are: (1) the effort to avoid (samvara-padha^na), (2) to overcome (paha^na-padha^na), (3) to develop (bha^vana^-padha^na), (4) to maintain (anurakkhana-padha^na), i.e. (1) the effort to avoid unwholesome (akusala) states, such as evil thoughts, etc. (2) to overcome unwholesome states, (3) to develop wholesome (kusala) states, such as the 7 elements of enlightenment (bojjhanga, q.v.), (4) to maintain the wholesome states.
"The monk rouses his will to avoid the arising of evil, unwholesome things not yet arisen ... to overcome them ... to develop wholesome things not yet arisen ... to maintain them, and not to let them disappear, but to bring them to growth, to maturity and to the full perfection of development. And he makes effort, stirs up his energy, exerts his mind and strives" (A. IV, 13).
(1) "What now, o monks, is the effort to avoid? Perceiving a form, or a sound, or an odour, or a taste, or a bodily or mental impression, the monk neither adheres to the whole nor to its parts. And he strives to ward off that through which evil and unwholesome things might arise, such as greed and sorrow, if he remained with unguarded senses; and he watches over his senses, restrains his senses. This is called the effort to avoid.
(2) "What now is the effort to overcome? The monk does not retain any thought of sensual lust, or any other evil, unwholesome states that may have arisen; he abandons them, dispels them, destroys them, causes them to disappear. This is called the effort to overcome.
(3) "What now is the effort to develop? The monk develops the factors of enlightenment, bent on solitude, on detachment, on extinction, and ending in deliverance, namely: mindfulness (sati), investigation of the law (dhamma-vicaya), energy (viriya), rapture (pi^ti), tranquillity (passaddhi), concentraton (sama^dhi), equanimity (upekkha^). This is called the effort to develop.
(4) "What now is the effort to maintain? The monk keeps firmly in his mind a favourable object of concentration, such as the mental image of a skeleton, a corpse infested by worms, a corpse blueblack in colour, a festering corpse, a corpse riddled with holes, a corpse swollen up. This is called the effort to maintain" (A. IV, 14).   'elements of effort', are the following 5 qualities: faith, health, sincerity, energy, and wisdom (M. 85, 90; A. V. 53). See pa^risuddhi-padha^niyanga.   'proficiency', namely, of mental concomitants (ka^ya-pa^gun~n~ata^), and of consciousness (citta-pa^gun~n~ata^), are 2 mental phenomena associated with all wholesome consciousness. Cf. Tab. II.   'overcoming', abandoning. There are 5 kinds of overcoming: (1) overcoming by repression (vikkhambhana-paha^na), i.e. the temporary suspension of the 5 hindrances (ni^varana, q.v.) during the absorptions, (2) overcoming by the opposite (tadanga-paha^na), (3) overcoming by destruction (samuccheda-paha^na), (4) overcoming by tranquillization (patipassaddhi-paha^na), (5) overcoming by escape (nissarana-paha^na).
(1) "Among these, 'overcoming by repression' is the pushing back of adverse things, such as the 5 mental hindrances (ni^varana q.v), etc., through this or that mental concentration (sama^dhi, q.v.), just as a pot thrown into moss-clad water pushes the moss aside....
(2) " 'Overcoming by the opposite' is the overcoming by opposing this or that thing that is to be overcome, by this or that factor of knowledge belonging to insight (vipassana^ q.v.), just as a lighted lamp dispels the darkness of the night. In this way, the personality-belief (sakka^yaditthi, s. ditthi) is overcome by determining the mental and corporeal phenomena ... the view of uncausedness of existence by investigation into the conditions... the idea of eternity by contemplation of impermanency ... the idea of happiness by contemplation of misery....
(3) "If through the knowledge of the noble path (s. ariyapuggala) the fetters and other evil things cannot continue any longer, just like a tree destroyed by lightning, then such an overcoming is called 'overcoming by destruction' " (Vis.M. XXII, 110f.).
(4) When, after the disappearing of the fetters at the entrance into the paths, the fetters, from the moment of fruition (phala) onwards, are forever extinct and stilled, such overcoming is called the 'overcoming by tranquillization'.
(5) "The 'overcoming by escape' is identical with the extinction and Nibba^na" (Pts.M. I. 27). (App.).  parin~n~a^; s. parin~n~a^.   feeling of: s. vedana^.  'natural or genuine morality', is distinct from those outward rules of conduct laid down for either laymen or monks. Those later are the so-called 'prescribed morality' (pan~n~a^ttisi^la). Cf. si^la.  'direct inducement'; s. paccaya.   'obstacles', is the term for the following things if they obstruct the monk in the strict practice of a subject of meditation: a crowded monastery, travelling, relatives, association with lay folk, gifts, pupils, repairs in the monastery, sickness, study, magical power. The latter, however, may become an obstacle only in developing insight (vipassana^, q.v.). See Vis.M. III, 29ff. - (App.)   the 'vow to wear only robes made from picked-up rags', is one of the ascetic rules of purification; s. dhutanga.  'abstaining from the killing of living beings', is the first of the 5 moral rules binding upon all Buddhists; s. sikkha^pada.   'advertence to the 5-sense-doors'; s. vin~n~a^na-kicca.  s. sikkha^pada.  'five-group existence', is a name for existence in the sensuous sphere (ka^ma^vacara), or in the fine-material sphere (rpa^vacara, s. avacara), since all the 5 groups of existence (khandha, q.v.) are found there. In the immaterial sphere (arpa^vacara, s. avacara), however, only the 4 mental groups are found, and in the world of unconscious beings (asan~n~a^-satta, q.v.) only the one corporeality group. Cf eka-voka^ra-bhava and catu-pan~ca-voka^ra-bhava; further s. avacara. - (App.: voka^ra).  'answering questions'. "There are, o monks, 4 ways of answering questions: there are questions requiring a direct answer; questions requiring an explanation; questions to be answered by counter-questions; questions to be rejected (as wrongly put)." See D. 33; A. III, 68; A. IV, 42.   'understanding, knowledge, wisdom, insight', comprises a very wide field. The specific Buddhist knowledge or wisdom, however, as part of the Noble Eightfold Path (magga, q.v.) to deliverance, is insight (vipassana^, q.v.), i.e. that intuitive knowledge which brings about the 4 stages of holiness and the realization of Nibba^na (s. ariyapuggala), and which consists in the penetration of the impermanency (anicca, q.v.), misery (dukkha, s. sacca) and impersonality (anatta^) of all forms of existence. Further details, s. under tilakkhana.
With regard to the condition of its arising one distinguishes 3 kinds of knowledge knowledge based on thinking (cinta^-maya^-pan~n~a^), knowledge based on learning (suta-maya^-pan~n~a^), knowledge based on mental development (bha^vana^-maya^-pan~n~a^) (D. 33).
" 'Based on thinking' is that knowledge which one has accquired through one's own thinking, without having learnt it from others. 'Based on learning' is that knowledge which one has heard from others and thus acquired through learning. 'Based on mental development' is that knowledge which one has acquired through mental development in this or that way, and which has reached the stage of full concentration" (appana^, q.v.) (Vis.M. XIV).
Wisdom is one of the 5 mental faculties (s. bala), one of the 3 kinds of training (sikkha^, q.v.), and one of the perfections (s. pa^rami^) For further details, s. vipassana^, and the detailed exposition in Vis.M. XIV, 1-32.  'prescribed morality', is a name for the disciplinary rules of the monk or layman prescribed by the Buddha, as distinguished from natural or genuine morality (pakati-si^la; s. si^la).  'deliverance through wisdom' (or understanding'), signifies, according to Com. to A.V, 142, the wisdom associated with the fruition of holiness (arahatta-phala). In Pug. 31 and similarly in M. 70, it is said: "A monk may not have reached in his own person the 8 liberations (=jha^na, q.v.), but through his wisdom the cankers have come to extinction in him. Such a person is called wisdom-liberated" (pan~n~a^-vimutta). - Com. to Pug.: "He may be one of five persons: either a practiser of bare insight (sukkha-vipassako, q.v.), or one who has attained to Holiness after rising from one of the absorptions." See S. XII, 7().
The term is often linked with ceto-vimutti (q.v.), 'deliverance of mind'.   (Sanskrit prapan~ca): In doctrinal usage, it signifies the expansion, differentiation, 'diffuseness' or 'manifoldness' of the world; and it may also refer to the 'phenomenal world' in general, and to the mental attitude of 'worldliness'. In A. IV, 173, it is said: "As far as the field of sixfold sense-impression extends, so far reaches the world of diffuseness (or the phenomenal world; papan~cassa gati); as far as the world of diffuseness extends, so far extends the field of sixfold sense-impression. Through the complete fading away and cessation of the field of sixfold sense-impression, there comes about the cessation and the coming-to-rest of the world of diffuseness (papan~ca-nirodho papan~ca-vupasamo)." The opposite term nippapan~ca is a name for Nibba^na (S. LIII), in the sense of 'freedom from samsaric diffuseness'. - Dhp. 254: "Mankind delights in the diffuseness of the world, the Perfect Ones are free from such diffuseness" (papan~ca^bhirata^ paja^, nippapan~ca tatha^gata^). - The 8th of the 'thoughts of a great man' (maha^-purisa-vitakka; A. VIII, 30) has: "This Dhamma is for one who delights in non-diffuseness (the unworldly, Nibba^na); it is not for him who delights in worldliness (papan~ca)." - For the psychological sense of 'differentiation', see M. 18 (Madhupindika Sutta): "Whatever man conceives (vitakketi) that he differentiates (papan~ceti); and what he differentiates, by reason thereof ideas and considerations of differentiation (papan~ca-san~n~a^-sankha^) arise in him." On this text and the term papan~ca, see Dr. Kurt Schmidt in German Buddhist Writers (WHEEL 74/75) p. 61ff. - See D. 21 (Sakka's Quest; WHEEL 10, p.
In the commentaries, we often find a threefold classification tanha^-, ditthi-, ma^na-papan~ca, which probably means the world's diffuseness created hy craving, false views and conceit. - See M. 123; A. IV, 173; A. VI, 14, Sn. 530, 874, 916.
n~a^nananda Bhikkhu, in Concept and Reality: An Essay on Papan~ca and Papan~ca-san~n~a^-sankha^ (Kandy 1971, Buddhist Publication Society), suggests that the term refers to man's "tendency towards proliferation in the realm of concepts" and proposes a rendering by "conceptual proliferation," which appears convincing in psychological context, e.g. in two of the texts quoted above, A. IV, 173 and M. 18. - The threefold classification of papan~ca, by way of craving, false views and conceit, is explained by the author as three aspects, or instances, of the foremost of delusive conceptualisations, the ego-concept.   'adherence', attachment, 'misapprehension', is according to Vis.M. XXII a name for wrong views; in that sense it occurs in Dhs. 1174 ff. - See si^labbata-para^ma^sa.  (-sacca, -vacana, -desana^): 'truth (or term, exposition) that is true in the highest (or ultimate) sense', as contrasted with the 'conventional truth' (voha^ra-sacca), which is also called 'commonly accepted truth' (sammuti-sacca; in Skr: samvrti-satya). The Buddha, in explaining his doctrine, sometimes used conventional language and sometimes the philosophical mode of expression which is in accordance whith undeluded insight into reality. In that ultimate sense, existence is a mere process of physical and mental phenomena within which, or beyond which, no real ego-entity nor any abiding substance can ever be found. Thus, whenever the suttas speak of man, woman or person, or of the rebirth of a being, this must not be taken as being valid in the ultimate sense, but as a mere conventional mode of speech (voha^ra-vacana).
It is one of the main characteristics of the Abhidhamma Pitaka, in distinction from most of the Sutta Pitaka, that it does not employ conventional language, but deals only with ultimates, or realities in the highest sense (paramattha-dhamma^). But also in the Sutta Pitaka there are many expositions in terms of ultimate language (paramattha-desana^), namely, wherever these texts deal with the groups (khandha), elements (dha^tu) or sense-bases (a^yatana), and their components; and wherever the 3 characteristics (ti-lakkhana, q.v.) are applied. The majority of Sutta texts, however, use the conventional language, as appropriate in a practical or ethical context, because it "would not be right to say that 'the groups' (khandha) feel shame, etc."
It should be noted, however, that also statements of the Buddha couched in conventional language, are called 'truth' (voha^ra-sacca), being correct on their own level, which does not contradict the fact that such statements ultimately refer to impermanent and impersonal processes.
The two truths - ultimate and conventional - appear in that form only in the commentaries, but are implied in a sutta-distinction of 'explicit (or direct) meaning' (ni^tattha, q.v.) and 'implicit meaning (to be inferred)' (neyyattha). Further, the Buddha repeatedly mentioned his reservations when using conventional speech, e.g. in D. 9: "These are merely names, expressions, turns of speech, designations in common use in the world, which the Perfect Qne (Tatha^gata) uses without misapprehending them." See also S. I. 25.
The term paramattha, in the sense here used, occurs in the first para. of the Katha^vatthu, a work of the Abhidhamma Pitaka (s. Guide, p. 62). (App: voha^ra).
The commentarial discussions on these truths (Com. to D. 9 and M. 5) have not yet been translated in full. On these see K N. Jayatilleke, Early Buddhist Theory of Knowledge (London, 1963), pp. 361ff.
In Maha^yana, the Ma^dhyamika school has given a prominent place to the teaching of the two truths.  'perfection'. Ten qualities leading to Buddhahood: (1) perfection in giving (or liberality; da^na-pa^rami^), (2) morality (si^la-p.), (3) renunciation (nekkhamma-p.), (4) wisdom (pan~n~a^-p.), (5) energy (viriya-p.), (6) patience (or forbearance; khanti p.), (7) truthfulness (sacca-p.), (8) resolution (adhittha^na-p.), (9) loving-kindness (metta^-p.) (10) equanimity (upekkha^-p.).
These qualities were developed and brought to maturity by the Bodhisatta in his past existences, and his way of practising them is illustrated in many of the Birth Stories (Ja^taka), of which, however, only the verses are regarded as canonical. Apart from the latter, the 10 pa^rami^ are mentioned in only two other canonical works which are probably apocryphal, the Buddhavamsa (in the Story of Sumedha) and the Cariyapitaka. A long and methodical exposition of the pa^rami^ is given in the concluding Miscellaneous Section (pakinnakakatha^) of the Com. to Cariyapitaka
In Vis.M. IX it is said that through developing the 4 sublime states (loving-kindness, compassion, altruistic joy, equanimity; s. brahma-viha^ra), one may reach these 10 perfections, namely:
"As the Great Beings (maha^-satta; a synonym often found in the Maha^yana scriptures for Bodhisatta (q.v.), i.e. 'Enlightenment Being or Being destined for Buddhahood) are concerned about the welfare of living beings, not tolerating the suffering of beings, wishing long duration to the higher states of happiness of beings, and being impartial and just to all beings, therefore (1) they give alms (da^na, q.v.) to all beings so that they may be happy, without Investigating whether they are worthy or not. (2) By avoiding to do them any harm, they observe morality (si^la q.v.). (3) In order to bring morality to perfection, they train themselves in renunciation (nekkhamma). (4) In order to understand clearly what is beneficial and injurious to beings, they purify their wisdom (pan~n~a^). (5) For the sake of the welfare and happiness of others they constantly exert their energy (viriya). (6) Though having become heroes through utmost energy, they are nevertheless full of forbearance (khanti) toward s the manifold failings of beings . (7) Once they have promised to give or do something, they do not break their promise ('truthfulness'; sacca). (8) With unshakable resolution (adhittha^na) they work for the weal and welfare of beings. (9) With unshakable kindness (metta^) they are helpful to all. (10) By reason of their equanimity (upekkha^) they do not expect anything in return" (Vis.M. IX. 24).
In the Maha^yana scriptures, where the pa^rami^ occupy a much more prominent place, a partly differing list of six is given: liberality, morality, patience, energy, meditation. and wisdom.
Literature: Ten Jataka Stories (illustrating the 10 pa^rami^), by I. B. Horner (London 1957, Luzac & Co.); Buddhavamsa & Cariyapitaka. tr. by I. B. Horner (Minor Anthologies III, Sacred Books of the Buddhists. PTS). - Narada Thera, The Buddha & His Teachings, Ch. 41; Parami (BPS) - The treatise on the perfections from the Com. to Cariyapitaka has been translated in The Discourse on the All-Embracing Net of Views (Brahmajala Sutta, with Com.). tr. by Bhikkhu Bodhi (BPS) .  'heavenly beings with power over the productions of others', constitute a class of heavenly beings in the sensuous sphere (ka^ma-loka). Ma^ra (q.v.) is said to be their ruler. Cf. loka, deva I.  'penetration of the mind of others', is one of the higher powers (abhin~n~a^, q.v.).  'limited-space kasina' = space kasina; s. kasina. (App.).  'liable to decline'. "Now, someone reaches the attainments (absorptions: jha^na, q.v.) of the fine-material or immaterial sphere (s. avacara). But he does not reach them according to his wish, and not without trouble and exertion; and not according to his wish with regard to place, object and duration, does he enter them, or rise therefrom. Therefore it is well possible that such a monk, through negligence, may lose these attainments. Such a person is said to be liable to decline" (Pug. 5).   'preparatory-moment': s. javana.  'preparatory image'; s. nimitta, kasina.  'preparatory concentration', is the initial and still undeveloped concentration of mind; s. sama^dhi.   'full Nibba^na', is a synonym for Nibba^na; this term, therefore, does not refer exclusively to the extinction of the 5 groups of existence at the death of the Holy One, though often applied to it. Cf. nibba^na.   'full understanding', full comprehension. There are 3 kinds of mundane f.u. (lokiya-p.), namely: full understanding of the known (n~a^ta-p.), f.u. as investigating (ti^rana-p.), and f.u. as overcoming (paha^na-p.) In Vis.M. XX, 3 it is said:
"Full understanding of the known is the knowledge consisting in the discernment of the specific characteristics of such and such phenomena, as: 'Corporeality has the characteristic of being oppressed; feeling has the characteristic of being felt, etc.'
"Full understanding by investigating is that insight-wisdom (vipassana^-pan~n~a^; s. vipassana^), which has the 3 general characteristics (impermanence, suffering, not-self) as its objects, and which arises when attributing a general characteristic to (physical and mental) phenomena, as for instance: 'Corporeality is impermanent, feeling is impermanent, etc.'
"Full understanding by overcorning is that insight-wisdom which has the above mentioned general characteristics as its objects, and arises after overcoming the idea of permanence, etc." - (App.).  the 4 'elements of the effort for purity', are: effort for purity of morality (si^la-parisuddhi-padha^niyanga), for purity of mind (citta), of view (ditthi), of deliverance (vimutti). Cf. A. IV, 194. - Another 9 factors are enumerated in D. 34, namely the 7 'stages of purification (s. visuddhi) and the effort for purity of (higher) knowledge (vijja^-p.-p.) and of deliverance (vimutti-p.-p.).  'morality consisting in purity', is fourfold: restraint with regard to the monks' Disciplinary Code, sense restraint, purity of livelihood, morality with regard to the monks' 4 requisites; for details, s. si^la.  and paritta subha are 2 classes of heavenly beings of the fine-material sphere; s. deva (II).   'learning the doctrine', the 'wording of the doctrine'. In the 'progress of the disciple' (q.v.), 3 stages may be distinguished: theory, practice, realization, i.e. (1) learning the wording of the doctrine (pariyatti), (2) practising it (patipatti), (3) penetrating it (pativedha) and realising its goal. (App.).  'sensitive corporeality', is a name for the 5 physical sense-organs responding to sense-stimuli. Cf. a^yatana.  'tranquillity, as factor of enlightenment', consists in tranquillity of mental factors (ka^ya-passaddhi) and tranquillity of consciousness (citta-passaddhi). Cf. bojjhanga; further Tab. II.  up robes, the practice of wearing: is one of the ascetic rules of purification (dhutanga, q.v.).  and not path, the knowledge and vision regarding: s. visuddhi (V).  'earth-element'. or 'solid element'. It is cognizable through the sensations of pressure, touch, cold, heat. pain, etc. - About the 4 elements. s. dha^tu, khandha (I. A.).  'earth-kasina' (s. kasina).  magga-paccaya, is one of the 24 conditions (paccaya, q.v.).  knowledge, the 4 kinds of: s. visuddhi (VII).  result (fruition): phala (q.v.).  s. nimitta, kasina, sama^dhi.  the 'analytical knowledge of ready wit': s. patisambhida^.   'dependent origination', is the doctrine of the conditionality of all physical and psychical phenomena, a doctrine which, together with that of impersonality (anatta^ q.v.), forms the indispensable condition for the real understanding and realization of the teaching of the Buddha. It shows the conditionality and dependent nature of that uninterrupted flux of manifold physical and psychical phenomena of existence conventionally called the ego, or man, or animal, etc.
Whereas the doctrine of impersonality, or anatta^, proceeds analytically, by splitting existence up into the ultimate constituent parts, into mere empty, unsubstantial phenomena or elements, the doctrine of dependent origination, on the other hand, proceeds synthetically, by showing that all these phenomena are, in some way or other, conditionally related with each other. In fact, the entire Abhidhamma Pitaka, as a whole, treats really of nothing but just these two doctrines: phenomenality - implying impersonality and conditionality of all existence. The former or analytical method is applied in Dhammasangani, the first book of the Abhidhamma Pitaka; the latter or synthetical method, in Pattha^na, the last book of the Abhidhamma Pitaka. For a synopsis of these two works, s. Guide I and VII.
Though this subject has been very frequently treated by Western authors, by far most of them have completely misunderstood the true meaning and purpose of the doctrine of dependent origination, and even the 12 terms themselves have often been rendered wrongly.
The formula of dependent origination runs as follows:
1. Avijia^-paccaya^ sankha^ra^: "Through ignorance are conditioned the sankha^ras," i.e. the rebirth-producing volitions (cetana^), or 'karma-formations' .
2. Sankha^ra-paccaya^ vin~n~a^nam: "Through the karma-formations (in the past life) is conditioned consciousness (in the present life)."
3. Vin~n~a^na-paccaya^ na^ma-rpam: "Through consciousness are conditioned the mental and physical phenomena (na^ma-rpa)," i.e. that which makes up our so-called individual existence.
4. Na^ma-rpa-paccaya^ sala^yatanam: "Through the mental and physical phenomena are conditioned the 6 bases," i.e. the 5 physical sense-organs, and consciousness as the sixth.
5. Sala^yatana-paccaya^ phasso: "Through the six bases is conditioned the (sensorial mental) impression."
6. Phassa-paccaya^ vedana^: "Through the impression is conditioned feeling."
7. Vedana^-paccaya^ tanha^: "Through feeling is conditioned craving."
8. Tanha^-paccaya^ upa^da^nam: "Through craving is conditioned clinging."
9. Upa^da^na-paccaya^ bhavo: "Through clinging is conditioned the process of becoming," consisting in the active and the passive life process, i.e. the rebirth-producing karma-process (kamma-bhava) and, as its result, the rebirth-process (upapatti-bhava).
10. Bhava-paccaya^ ja^ti: "Through the (rebirth-producing karma-) process of becoming is conditioned rebirth."
11. Ja^ti-paccaya^ jara^maranam, etc.: "Through rebirth are conditioned old age and death (sorrow, lamentation, pain, grief and despair). Thus arises this whole mass of suffering again in the future."
 
The following diagram shows the relationship of dependence between three successive lives:
 PAST	1 Ignorance (avijja^)2 Karma-formations(sankha^ra^)	Karma-Process (kammabhava)5 causes: 1,2,8,9,10
     PRESENT	3 Consciousness (vin~n~a^na)4 Mind & Matter(na^ma-rpa)5 Six Bases (a^yatana)6 Impression (phassa)7 Feeling (vedana^)	  Rebirth-Process (upapattibhava)5 results: 3-7
 	8 Craving (tanha^)10 Process of Becoming (bhava)	Karma-Process (kammabhava)5 causes: 1,2,8,9,10
 FUTURE	11 Rebirth (ja^ti)12 Old Age and Death (jara^-marana)	Rebirth-Process (upapattibhava)5 results: 3-7
 
 
Before taking up the study of the following exposition, it is suggested that the reader first goes thoroughly through the article on the 24 conditions (s. paccaya). For a thorough understanding of the paticcasamuppa^da he should know the main modes of conditioning, as decisive support, co-nascence, pre-nascence, etc.
For a closer study of the subject should be consulted: Vis.M. XVII; Fund. III; Guide (Ch. VII and Appendix); Dependent Origination, by Piyadassi Thera (WHEEL 15); The Significance of Dependent Origination (WHEEL 140).
 
(1.) "Through ignorance are conditioned the karma-formations" (avijja^-paccaya^ sankha^ra^), i.e. all wholesome and unwholesome actions (karma, q.v.) of body, speech and mind, are conditioned through ignorance. By 'karma-formations' are meant karmically wholesome and unwholesome volitions (cetana^), or volitional activities, in short karma (q.v., and Fund. II).
In view of the many misconceptions current in the West, it is necessary to repeat here that karma (q.v.), as a technical term, never signifies anything but moral or immoral action, i.e. the above mentioned volitional activities, or karma-formations, as either causing results in the present life or being the causes of future destiny and rebirth. Thus karma, as a philosophical term, never means the result of action, as often wrongly conceived by Western authors.
Now, in what way are the karma-formations conditioned through ignorance? As concerns the unwholesome karmaformations associated with greed, hate or delusion (lobha, dosa, moha), these are always and in all circumstances, conditioned through the simultaneous ignorance inseparably associated therewith. Thus, ignorance is for the unwholesome karma-formations a condition by way of conascence (sahaja^ta-paccaya), association (sampayutta-paccaya), presence (atthi-paccaya), etc. Ignorance further may be for them a condition by way of decisive support or inducement (upanissaya-paccaya), if, for instance, ignorance coupled with greed induces a man to commit evil deeds, such as killing, stealing, unlawful sexual intercourse, etc. In these cases, therefore, ignorance is a 'natural decisive suppport' or 'direct inducement' (pakati-upanissaya-paccaya). It also may become an indirect inducement, by way of object (a^rammanpanissaya-paccaya) of our thinking. This takes place, if, for example, someone remembers a former state of ignorance combined with sensual enjoyment, and in doing so karmically unwholesome states spring up, such as sensual desire, grief, etc.
For the wholesome (kusala) karma-formations, ignorance can only be a condition by way of decisive support (upanissaya), never by way of co-nascence (sahaja^ta), etc., since wholesome consciousness at that very moment, of course, cannot be associated with any unwholesome phenomenon, such as ignorance. Ignorance is a 'natural decisive support' or 'direct inducement' (pakatupanissaya), for example, if, induced by ignorance and vanity, one exerts oneself to attain the absorptions, and thus finally, through perseverance, reaches these wholesome states of mind. Ignorance may also be for wholesome karma-formations a 'decisive support' or 'inducement by way of object' (a^rammanpanissaya), if, for example, one refleets on ignorance as the root of all misery in the world, and thus finally attains insight and entrance into one of the 4 supermundane paths of holiness.
For ignorance, s. avijja^; for karma-formations, s. sankha^ra.
 
(2.) "Through the karma-formations is conditioned consciousness" (sankha^ra-paccaya^ vin~n~a^nam). This proposition teaches that the wholesome and unwholesome karma-formations are the causes of future rebirth in an appropriate sphere (gati). The karma-formations of the previous life condition the budding in a new mother's womb of a fresh psycho-physical aggregation of the 5 groups of existence (s. khandha), which here are represented by consciousness (vin~n~a^na). All such karma-resultant (vipa^ka) consciousness, however, such as eye-consciousness (seeing), etc., as well as all the mental phenomena associated therewith (feeling, etc.), are karmically neutral. It should be understood that already from the very first moment of conception in the mother's womb, this karma resultant eonsciousness of the embryonic being is functioning.
Against Dr. Paul Dahlke's misconception of the paticcasamuppa^da as "one single karmical moment of personal experience," and of the 'simultaneity' of all the 12 links of this formula, I should like to state here distinctly that the interpretation of the p. given here as comprising 3 successive lives not only agrees with all the different schools of Buddhism and all the ancient commentaries, but also is fully identical with the explanations given already in the canonical suttas. Thus, for example, it is said verbatim in Nida^na-Samyutta (S. XII, 51): "Once ignorance (1) and clinging (9) are extinguished, neither karmically meritorious, nor demeritorious, nor imperturbable karma-formations (2=10) are produced, and thus no consciousness (3=11) will spring up again in a new mother's womb." And further: "For, if consciousness were not to appear in the mother's womb, would in that case mentality and corporeality (4) arise?" Cf. above diagram.
The purpose of the Buddha in teaching the p. was to show to suffering mankind how, depending on ignorance and delusion, this present existence and suffering has come about, and how through extinction of ignorance, and of the craving and clinging conditioned thereby, no more rebirth will follow, and thus the standstill of the process of existence will have been realized and therewith the extinction of all suffering.
 
(3.) "Through consciousness are conditioned corporeality and mentality" (vin~n~a^na-paccaya^ na^ma-rpani). This proposition implies that without consciousness there ean be no mental and physical process of existence. By mentality (na^ma) is here to be understood the karma-resultant (vipa^ka) mental phenomena, such as feeling (vedana^), perception (san~n~a^), volition (cetana^: non-karmical volition is here meant), consciousness-impression (phassa), advertence (manasika^ra) (M. 9; S. XII, 2). For the basic 7 mental phenomena inseparably associated with every state of consciousness, s. na^ma. By corporeality (rpa) is meant the 4 physical elements (s. dha^tu) and the corporeality dependent thereon (s. khandha, I).
Mentality is always conditioned through consciousness; i.e. consciousness (vin~n~a^na) is for mentality (na^ma) a condition by way of conascence (sahaja^ta), mutuality (an~n~aman~n~a), association (sampayutta), etc., since the 4 mental groups at all times form an inseparable unit.
Consciousness (vin~n~a^na) is for corporeality (rpa) a condition by way of co-nascence only at the moment of conception, thereafter a condition by way of post-nascence (paccha^ja^ta-paccaya; paccaya 11) and nutriment (a^ha^ra), i.e. as a support. Just as the repeatedly arising hunger is a condition and support for the pre-arisen body, so is the conseiousness arising afterwards a condition and support for the maintenance of this pre-arisen body.
 
(4.) "Through mentality and corporeality are conditioned the 6 bases (na^ma-rpa paccaya^ sala^yatanam). The 6 bases are a name for the 5 physical sense-organs and, as 6th, the mind-base (mana^yatana), i.e. consciousness.
Mentality (na^ma; s. 3) is for the 5 physical bases (a^yatana), or sense-organs, a condition by way of post-nascence. Cf. end of 3.
Mentality (na^ma), i.e. feeling. etc., is for the 6th base, or consciousness - as being always inseparably associated therewith a condition by way of co-nascencc. etc.
Corporeality (rpa), here the 4 elements, are for the 5 physical bases (a^yatana), or sense-organs, a condition by way of support (nissaya).
Corporeality (rpa), here the 5 physical sense-organs, are for the 6th base (a^yatana), i.e. consciousness, a condition by way of support and pre-nascence (pureja^ta-paccaya).
 
(5.) "Through the 6 bases is conditioned the (sensorial and mental) impression" (sala^yatana-paccaya^ phasso), for without the 5 physical bases, or sense-organs, there can be no sense-impressions; and without the 6th base, or consciousness, there can be no mental impression.
Thus, the 5 physical bases, eye, etc., are for the corresponding 5 sense-impressions (visual impression, etc.) a condition by way of support (nissaya) and pre-nascence (pureja^ta), whereas the 6th, the mind-base (consciousness), is for the mental impression a condition by way of co-nascence, association, mutuality, etc.
 
(6.) "Through impression is conditioned feeling" (phassa-paccaya^ vedana^), i.e. the sensorial and the mental impressions are for the feeling associated therewith a condition by way of co-nascence, association, mutuality, etc.
 
(7.) "Through feeling is conditioned craving" (vedana^-paccaya^ tanha^). Any (karma-resultant) feeling, whether agreeable, disagreeable or neutral, bodily or mental, past or expected, may become for craving a condition of decisive support by way of object (a^rammanpanissaya). Even physically and mentally painful feeling may, through the desire to be released therefrom, become for craving a condition of decisive support by way of object (a^rammanupanissaya).
 
(8.) "Through craving is conditioned clinging" (tanha^-paccaya^ upa^da^nam). 'Clinging' is explained as an intensified form of craving. It is of 4 kinds: (1) clinging to sensuality, (2) to erroneous views, (3) to rules and ritual, (4) to personality-belief. Sensuous craving is to (1) a condition of natural decisive support (pakatupanissaya). For (2-4), craving is a condition by way of co-nascence, mutuality, root (hetu), etc. It also may be a condition of natural decisive support. For example, through craving for heavenly rebirth, etc. people often may be induced to cling to certain rules and rituals, with the hope of reaching thereby the object of their desires.
 
(9.) "Through clinging is conditioned the process of becoming" (upa^da^na-paccaya^ bhavo), i.e. the wholesome and unwholesome active karma-process of becoming (kamma-bhava), as well as the karma-resultant (vipa^ka) passive process, the so-called 'rebirth-process' (upapatti-bhava). The karma-process (kammabhava) comprises the 5 karmical causes: ignorance, karma-formations, craving, clinging, karma-process (s. 1, 2, 8, 9, 10, of the diagram); the rebirth-process (upapatti-bhava) comprises the 5 karma-results (s. 3-7 of the diagram).
The karma-process is here, correctly speaking, a collective name for generative karmic volition (kamma-cetana^) and all the mental phenomena associated therewith, whilst the 2nd link (karma-formations) designates only karmic volition (s. a^yhana). Both, however, i.e. the 2nd and 10th proposition, practically state one and the same thing, namely, that karma is the cause of rebirth, as we shall see under 10.
Clinging (upa^da^na) may be an inducement of decisive support (upanissaya) to many kinds of wholesome and unwholesome karma. Sensuous clinging (ka^mpa^da^na), i.e. clinging to sensuous objects, for example, may be a direct inducement to murder, theft, unlawful intercourse with the other sex, evil words and thoughts, etc. Clinging to rules and ritual (si^labbatpa^da^na) may lead to self-complacency, fanaticism, cruelty, etc. Clinging is also for the evil karma associated therewith, a condition by way of co-nascence, association, etc.
 
(10.) "Through the process of becoming is conditioned rebirth" (bhava-paccaya^ ja^ti), i.e. through the wholesome and unwholesome karma-process (kamma-bhava) is conditioned the rebirth-process (upapatti-bhava). The 2nd and 10th propositions, as already pointed out, practically teach one and the same thing, namely, that karma is the cause of rebirth; in other words, that the karmical volition (cetana^) is the seed out of which springs the new life, just as from the mango-seed is generated the new mango-tree.
Hence, the 5 karmical causes (ignorance, etc.) of the past birth are the condition for the karma-results of the present birth; and the 5 karmical causes of the present birth are the condition for the 5 karma-results of the next birth (s. diagram). As it is said in Vis.M. XVII:
"Five causes were there in the past,
Five fruits we find in present life;
Five causes do we now produce,
Five fruits we reap in future life."
 
Now, just as in this process of continually changing mental and bodily phenomena, nothing can be found that would pass from one moment to the next moment, so also there is no enduring entity, ego, or personality, within this process of existence that would transmigrate from one life to the next (s. na^ma-rpa, anatta^, patisandhi, khandha). "No being and no living soul passed from the former life to this life, and yet this present embryo could not have entered into existence without the preceding causes" (Vis.M. XVII). "Many things may serve to illustrate this fact, as for example the echo, the light of a lamp, the impression of a seal, or the image produced by a mirror" (ib.).
"Whosoever is in the dark with regard to the conditionally arisen things, and does not understand that karma originates from ignorance, etc., he thinks that it must be his ego that knows or does not know, acts and causes to act, and that arises at rebirth. Or he thinks that the atoms, or a creator, with the help of this embryonic process, must have formed this body, or that it is the ego endowed with faculties that has impressions, feels, desires, clings, continues and enters again into existence in a new birth. Or he thinks that all beings have been born through fate, or fortuitously" (Vis.M. XVII).
Now, on hearing that Buddhism teaches that everything whatever in the world is determined by conditions some might come to the conclusion that Buddhism teaches some sort of fatalism, and that man has no free will, or that will is not free.
The problem 'whether man has a free will' does not exist for, the Buddhist, since he knows that, apart from these everchanging mental and physical phenomena, no such entity as 'man' can be found, and that 'man' is merely a name not relating to any reality. And the question, 'whether will is free', must be rejected for the reason that 'will', or volition, is a mental phenomenon flashing forth only for a moment, and that as such it had not any existence at the preceding moment. For of a thing which is not, or is not yet, one cannot, properly speaking, ask whether it is free or unfree. The only admissible question would be whether the arising of 'will' is independent of conditions, or whether it is conditioned. But the same question would equally apply also to all the other mental phenomena, as well as to all physical phenomena, in other words: to everything and every occurrence whatever. And the answer would be: whether will arises, or whether feeling arises, or whether any other mental or any physical phenomenon arises, the arising of anything whatsoever is dependent on conditions, and without conditions nothing ever can arise or enter into existence.
According to Buddhism, everything mental or physical happens in accordance with laws and conditions; and if it were otherwise, chaos and blind chance would reign. But such a thing is impossible and contradicts all laws of thinking. Cf. Fund. III (end).
 
 
(11.) "Through rebirth are conditioned old age and death" (ja^tipaccaya^ jara^-maranam). Without birth there can be no old age and death, no suffering and misery. Thus rebirth is to old age and death, etc. a condition by way of decisive support (upanissaya).
The Buddha has said (D. 15): "Profound, Ananda. is this dependent origination, and profound does it appear. It is through not understanding, not penetrating, this law that this world resembles a tangled ball of thread, a bird's nest, a thicket of sedge or reed, and that man does not escape from the lower states of existence, from the course of woe and perdition, suffering from the round of rebirth." And further (M. 28): 'Whoso understands the dependent origination understands the Dhamma; and whoso understands the Dhamma understands the dependent origination."   or forbearance (khanti): one of the 10 perfections (pa^rami^, q.v.).   - 1. In an ethical sense, it means: 'repugnance', grudge, resentment, anger, and is a synonym of vya^pa^da, 'ill-will' (s. ni^varana) and dosa, 'hate' (s. mla). It is one of the proclivities (anusaya, q.v.).
2. '(Sense-) reaction'. Applied to five-sense cognition, p. occurs in the following contexts:
(a) as patigha-san~n~a^, 'perception of sense-reaction', said to be absent in the immaterial absorptions (s. jha^na 5). Alternative renderings: resistance-perception, reflex-perception;
(b) as patigha-samphassa, '(mental) impression caused by 5fold sensorial reaction' (D. 15); s. phassa;
(c) as sappatigha-rpa, 'reacting corporeality', and appatigha, 'not reacting', which is an Abhidhammic classification of corporeality, occurring in Dhs. 659, 1050. Sappatigha are called the physical sense-organs as reacting (or responding) to sense stimuli; and also the physical sense-objects as impinging (or making an impact) on the sense-organs. All other corporeality is appatigha, non-reacting and non-impinging. These 2 terms have been variously rendered as resistant and not, responding and not, with and without impact.   'miracle', marvel. Three marvels are ascribed to the Buddha: the marvel of magic (iddhi-p.), the marvel of mind-reading (a^desana^-p.) and the marvel of instruction (anusa^sani^-p.). In D. 11, the Buddha says that he sees danger in the first two and therefore abhors them. In A. III, 61, the 'marvel of instruction' is called the one 'more noble and sublime'. For iddhi-pa^tiha^riya, see D. 25. See also yamakapa^tiha^riya.  s. ka^yagata^-sati.   'Disciplinary Code', is the name of the code of monk's rules, which on all full-moon and new moon days is recited before the assembled community of fully ordained monks (bhikkhu).
See The Patimokkha, Romanized Pa^li text and transl. by n~a^namoli Thera (Bangkok 1966, Maha^makut Buddhist Bookshop).  'morality consisting in restraint with regard to the Disciplinary Code' (Pa^timokkha, s. prec.). For details, s. si^la.   'contemplation on abandonment', is one of the 18 kinds of insight (vipassana^ q.v.). Further cf. the 16th exercise of anapana-sati (q.v.).   1. 'Road', 'path'; for instance in dukkhanirodha-ga^mini^-patipada^, 'the road leading to the extinction of suffering' (= 4th Noble Truth); majjhima-patipada^, 'the Middle Way'.
2. 'Progress' (see also the foll. article). There are 4 modes of progress to deliverance: (1) painful progress with slow comprehension (dukkha^ patipada^ dandha^bhin~n~a^), (2) painful progress with quick comprehension, (3) pleasant progress with slow comprehension, (4) pleasant progress with quick comprehension. In A. IV, 162 it is said:
(1) "Some person possesses by nature excessive greed, excessive hate, excessive delusion, and thereby he often feels pain and sorrow; and also the 5 mental faculties, as faith, energy, mindfulness, concentration and wisdom (s. indriya 15-19) are dull in him; and by reason thereof he reaches only slowly the immediacy (a^nantariya, q.v) to the cessation of all cankers.
(2) Some person possesses by nature excessive greed, etc., but the 5 mental faculties are sharp in him and by reason thereof he reaches quickly the immediacy to the cessation of all cankers ....
(3) "Some person possesses by nature no excessive greed, etc., but the 5 mental faculties are dull in him, and by reason thereof he reaches slowly the immediacy to the cessation of all cankers ....
(4) 'Some person possessess by nature no excessive greed, etc., and the mental faculties are sharp in him, and by reason thereof he reaches quickly the immediacy to the cessation of all cankers ....
See A. IV, 162, 163, 166-169; Dhs. 176ff; Atthasa^lini Tr. I, 243; 11, 291, 317.  'purification by knowledge and vision of the path-progress' forms the 6th stage of purification (visuddhi, q.v.).   'path-attainer', is he who had reached one of the 4 supermundane paths of holiness (s. ariya-puggala). - (App.)   practice, or 'pursuance' of the teaching, as distinguished from the mere theoretical knowledge of its wording (pariyatti, q.v.).  'overcoming (of defilements) by tranquillization' (s. paha^na).   'analytical knowledge' or 'discrimination', is of 4 kinds: analytical knowledge of the true meaning (attha-patisambhida^), of the law (dhamma-patisambhida^), of language (nirutti-patisambhida^), of ready wit (patibha^na-patisambhida^).
As an alternative rendering of the fourth term (patibha^na), Bhikkhu n~a^namoli proposes: perspicuity (in expression and knowledge).
 
1. The analytical knowledge of the meaning (attha-p.) is the knowledge with regard to the sense.
2. The analytical knowledge of the law (dhamma-p.) is the knowledge with regard to the law.
3. The analytical knowledge of language (nirutti-p.) is the knowledge of the language with regard to those former 2 things.
4. The analytical knowledge of ready-wit (patibha^na-p.) is the knowledge about the (former 3) kinds of knowledge" (Vibh. XV).
 
"(1) attha (Sanskrit artha, ? ar, to reach; result, meaning, purpose, true substance) designates, in short, the fruit (phala) of a cause (hetu); for since the fruit of a cause results from adhering to the cause, and is reached and effected thereby, therefore it is called result (attha). In particular, however, 5 things are considered as attha, namely: everything dependent on conditions, Nibba^na, the meaning of words, karma-result, and functional consciousness. When anyone reflects on that meaning any knowledge of his, falling within the category concerned with meaning (or result), is the 'analytical knowledge' of meaning.
"(2) dhamma (Sanskrit dharma, ? dhar, to bear; bearer, condition, law, phenomenon, thing) is, in short, a name for condition (paccaya).... In particular, however, 5 things are considered as dhamma, namely: every cause (hetu) producing a result, the noble path, the spoken word, the karmically wholesome, the karmically unwholesome. When anyone reflects on that law, any knowledge of his, falling within the category concerned with law (or cause), is the 'analytical knowledge' of the law.
In Vibh. it is further said: 'The knowledge of suffering is the 'analytical knowledge' of the true meaning (attha-patisambhida^), the knowledge of its origin is the 'analytical knowledge' of the law (dhamma-patisambhida^). The knowledge of the cause is the 'analytical knowledge' of the law (dhamma-patisambhida^), the knowledge of the result of the cause is the 'analytical knowledge' of the true meaning (attha-patisambhida^)... That the monk knows the law, the sunas etc. this is called the 'analytical knowledge' of the law (dhamma-patisambhida^); if however, he understands the meaning of this or that speech... it is called the 'analytical knowledge' of the true meaning (attha-patisambhida^).'
(3) " 'The knowledge of the language concerning those things' means: the language corresponding to reality, and the unfailing mode of expression concerning the true meaning and the law.
(4) " 'Knowledge about the kinds of knowledges' is that knowledge which has all knowledges as object and considers them. Or, the analytical knowledge of ready wit (patibha^na-patisambhida^) means the knowledge of the above mentioned 3 kinds of knowledge, in all their details, with their objects, functions, etc." (Vis.M. XIV).
On the 7 qualities leading to the attainment of the 4 'analytical knowledge' , s. A. VII, 37 - See Vis.M. XIV, 21ff; Vibh. XV; Pts.M. Patisambhida^ Katha^.   lit. 'reunion, relinking', i.e. rebirth, is one of the 14 functions of consciousness (vin~n~a^na-kicca, q.v.). It is a karma-resultant type of consciousness and arises at the moment of conception i.e. with the forming of new life in the mother's womb. Immediately afterwards it sinks into the subconscious stream of existence (bhavangasota, q.v.), and conditioned thereby ever and ever again corresponding states of subconsciousness arise. Thus it is really rebirth-consciousness that determines the latent character of a person.
"Neither has this (rebirth-) consciousness transmigrated from the previous existence to this present existence, nor did it arise without such conditions, as karma, karma-formations, propensity, object, etc. That this consciousness has not come from the previous existence to this present existence, yet that it has come into existence by means of conditions included in the previous existence, such as karma (q.v.), etc., this fact may be illustrated by various things, such as the echo, the light of a lamp, the impression of a seal, or the image produced by a mirror. For just as the resounding of the echo is conditioned by a sound, etc., and nowhere a transmigration of sound has taken place, just so it is with this consciousness. Further it is said: 'In this continuous process, no sameness and no otherness can be found.' For if there were full identity (between the different stages), then also milk never could turn into curd. And if there were a complete otherness, then curd could never come from milk.... If in a continuity of existence any karma-result takes place, then this karma-result neither belongs to any other being, nor does it come from any other (kamma), because absolute sameness and otherness are excluded here" (Vis, XVII 164ff).
In Mil. it is said:
"Now, Venerable Na^gasena, the one who is reborn, is he the same as the one who has died, or is he another?"
"Neither the same, nor another" (na ca so na ca an~n~o).
"Give me an example."
"What do you think, o King: are you now, as a grown-up person, the same that you had been as a little, young and tender babe? "
"No, Venerable Sir. Another person was the little, young and tender babe, but quite a different person am I now as a grown-up man . " . . .
"... Is perhaps in the first watch of the night one lamp burning, another one in the middle watch, and again another one in the last watch?"
"No, Venerable Sir. The light during the whole night depends on one and the same lamp.''
"Just so, o King, is the chain of phenomena linked together. One phenomenon arises, another vanishes, yet all are linked together, one after the other, without interruption. In this way one reaches the final state of consciousnes neither as the same person. nor as another person.''
According to the nature of their rebirth consciousness, beings divide into the following 3 groups:
1. ahetu-patisandhika: a 'being reborn without rootconditions', is a being whose consciousness at the moment of rebirth was not accompanied by any of the 3 noble rootconditions, viz. greedlessness, hatelessness, undeludedness (s. mla), i.e. selflessness, kindness, intelligence. Such beings are found in the 4 lower worlds (apa^ya, q.v.), in which case the function of rebirth is exercised by the class of consciousness listed in Tab. I as No. 56. But if such beings are born in the sensuous sphere as humans, they will be crippled, blind, deaf, mentally deficient, etc. (Rebirth-consciousness = Tab. I, No. 41)
2. dvihetu (or duhetu)-patisandhika: a 'being reborn with only 2 (noble) root-conditions', i.e. greedlessness and hatelessness. (Rebirth-consciousness = Tab. I, Nos. 44, 45, 48 or 49.)
3. tihetu-patisandhika: a 'being reborn with 3 (noble) rootconditions'. Such a being can be found only among men. (Rebirth-consciousness = Tab. 1, Nos. 42, 43, 46, or 47) and higher heavenly beings.
On these 3 types of rebirth, See Atthasa^lini Tr. 11, 354 - 379. (App.: patisandhika).
In the suttas, the terms for rebirth are chiefly punabbhava (q.v.), 'renewed existence', and abhinibbatti 'arising'; or both combined as punabbhava^bhinibbatti. - (App.: patisandhi).
Literature Vis.M. XVII, 133f, 164f, 189f, 289f; Vis.M. XIX, 22f. - Karma and Rebirth, by Nyanatiloka Thera (WHEEL 9). - The Case for Rebirth, by Francis Story (WHEEL 12/13). - Survival and Karma in Buddhist Perspective, by K. N. Jayatilleke (WHEEL 141/143). - Rebirth Explained, by V. F. Gunaratna (WHEEL 167/169).  bala and bha^vana^ bala: 'power of reflection', and 'power of mental development'. About these 2 powers it is said in A. II, 10:
"What, o monks, is the power of reflection? If, o monks, someone thinks thus: 'Bad conduct in deeds, words and thoughts verily bears bad fruits both in this life, as well as in the next life', and in consequence of this consideration, he abandons bad conduct in deeds, words and thoughts, follows good conduct, and keeps his heart pure, this, o monks, is the power of reflection.
"What, o monks, is the power of mental development? If, o monks, a monk develops the factors of enlightenment (bojjhanga, q.v.), bent on solitude, on detachment, on extinction, and ending in deliverance, namely: mindfulness, investigating of the law, energy, rapture, tranquillity, concentration, and equanimity, this, o monks, is the power of mental development."  'knowledge consisting in reflective contemplation"; is one of the 9 knowledges constituting the 'purification by knowledge and vision of the path-progress' (patipada^-n~a^nadassanavisuddhi; s. visuddhi VI), and one of the 18 chief kinds of insight (maha^vipassana^; s. vipassana^).   'penetration', signifies the realization of the truth of the Dhamma, as distinguished from the mere acquisition of its wording (pariyatti), or the practice (patipatti) of it, in other words, realization as distinguished from theory and practice. Cf. pariyatti.  the 'exercise of the bowl-eater', is one of the 13 ascetic purification-exercises (dhutanga, q.v.), consisting in the vow of using only the alms-bowl for eating, and the rejection of any other vessel.  lit. 'giving of the acquired', i.e. 'transference of merit.' Though in the older texts very seldom mentioned (e.g. A VII, 50), it is, however, a widespread custom in all Buddhist countries. It is presumed that moral merit, especially that acquired through giving alms, can be transferred to others, apparently for the reason that one's own good deeds may become to others, especially to departed relatives and friends reborn in the ghost realm, an inducement to a happy and morally wholesome state of mind. Transference of merit is advocated (though without mentioning the term patti-da^na) in the Tirokudda Sutta (Khp. and Petavatthu) and its Com. (Khp. Tr.). It is one of the ten 'bases of meritorious action' (pun~n~akiriyavatthu, q.v.), called there patta^nuppada^na. (App.).
See 'The Doctrine of Reversible Merit by F. L. Woodward. Buddhist Review (London), Vol. I (1914), p. 38.  s. pativedha, pariyatti. - For the power of penetrating (vippha^ra) knowledge and concentration, s. iddhi. - For morality combined with penetration (nibbedha), s. ha^na-bha^giya-si^la, etc. - For penetration (pariya) of the mind of others, s. abhin~n~a^.   the 10: pa^rami^ (q.v.).  one, the: tatha^gata (q.v.).  and avoidance: ca^ritta-va^ritta (q.v.).   idea of: s. vipalla^sa.   s. sakka^ya. For personality-belief, s. sakka^ya ditthi, ditthi, atta^, satta, puggala, vipalla^sa.   the 4: vipalla^sa (q.v.).  (Sanskrit preta): lit. 'departed spirit', ghost; s. loka.  'ghost realm'; s. loka.   lit. 'fruit'. - 1. result, effect (often together with hetu, cause ); 2. benefit (e.g. in Sa^man~n~a-phala Sutta, 'The Results, or Benefits, of Recluseship'; D. 2).
As 'path-result', or 'fruition', it donotes those moments of supermundane consciousness which flash forth immediately after the moment of path-consciousness (s. ariya-puggala) and which, till the attainment of the next higher path, may during the practice of insight (vipassana^, q.v.) still recur innumerable times. If thus repeated, they are called the 'attainment of fruition (phalasama^patti), which is explained in detail in Vis.M. XXIII.  (fr. phusati, to touch): 'sense-impression', contact. The term samphassa is used in compounds, e.g. in the following: '"T'here are 6 classes of sense-impression: visual impression (cakkhu-samphassa), impressions of hearing, smelling, tasting, bodily (tactile) impression and mental impression" (M. 9). A twofold division occurs in D. 15: patigha (q.v.) -samphassa, impression by sensorial reaction', and adhivacana-samphassa, verbal (or conceptual, i.e. mental) impression'.
Phassa does not signify physical impact, but is one of the 7 constant mental concomitants of consciousness (cetasika) and belongs to the group of mental formations (sankha^ra-kkhandha). In lists of both these categories it is generally mentioned first (e.g. Dhs. 1: M. 9), due to its fundamental position in the cognitive process In M. 18 it is thus defined: "Dependent on the eye and the forms, eye-consciousness arises; the coming-together of the three is sense-impression" (similarly stated in the case of the other 5 senses, including mind). In the dependent origination, it is conditioned by the six sense-bases and is a conditioning factor of feeling (s. paticca-samuppa^da 5, 6). Its relation to mind-and-body (na^ma-rpa) is described in D. 15, and its influence on feeling and wrong views, in D. 1 (at the end). - It is one of the 4 nutriments (a^ha^ra, q.v.), and the first factor in the pentad of sense-impression (phassa-pan~camaka), together with feeling, perception, volition and consciousness (see Abh. St., p. 47ff ).
Being a key function in the mind's contact with the world of objects and being a potential source of defilements, sense-impression is an important subject for reflective insight contemplation as succinctly formulated in many verses of the Sn.: 736/7, 778, 851, 870/72, 923.  up rags, wearing robes made from: s. dhutanga.   The 'practice of going for alms', is one of the 13 ascetic purification-exercises (s. dhutanga).  'yellow-kasina', is one of the kasina-exercises; s. kasina.   rapture, enthusiasm (rendered also by joy, happiness); interest it is one of the mental factors or concomitants (cetasika) and belongs to the group of mental formations (sankha^ra-kkhandha). As, in sutta texts, it is often linked in a compound word. with 'gladness' (pa^mojja) or 'happiness' (sukha), some Western translations have wrongly taken it as a synonym of these two terms. Pi^ti, however, is not a feeling or a sensation, and hence does not belong to the feeling-group (vedana^-kkhandha), but may be described psychologically as 'joyful interest'. As such it may be associated with wholesome as well as with unwholesome and neutral states of consciousness.
A high degree of rapture is characteristic of certain stages in meditative concentration, in insight practice (vipassana^) as well as in the first two absorptions (jha^na, q.v.). In the latter it appears as one of the factors of absorption (jha^nanga; s. jha^na) and is strongest in the 2nd absorption. Five degrees of intensity in meditative rapture are described in Vis.M. IV. 94ff. It is one of the factors of enlightenment (bojjhanga, q.v.).  of existence, the 3: s. avacara.   idea of: s. vipalla^sa, subhanimitta.   s. vi^mamsa^.  paccha^ja^ta-paccaya, one of the 24 conditions (paccaya, q.v.).   the 4 bodily: iriya^patha (q.v.).   the 5 spiritual: s. bala. - For the 6 higher p., s. abhin~n~na. For the 10 p. of a Buddha, s. dasabala. - For the 4 roads to p., s. iddhipa^da. For magical p., s. iddhi.   For theory, practice and realization, s. pariyatti.  and pre nascence: adhipati, pureja^ta, are 2 of the 24 conditions (paccaya, q.v.).  concentration (and preparatory image, etc.): s. sama^dhi, javana.  pan~n~atti-si^la (q.v.).   s. anusaya.  nipphanna-rpa (q.v.).  (or regenerative) karma; s. karma.  (of mental factors and consciousness): pa^gun~n~ata^ (q.v.)   s. patipada^, abhabbagamana - p. in morality, etc., s. ha^nabha^giya, etc. - Purification by knowledge and vision of path-progress, s. visuddhi (VI). - p. of the disciple, s. foll.  of the disciple, Gradual development of the Eightfold Path in the: In many suttas occurs an identical passage that outlines the gradual course of development in the progress of the disciple. There it is shown how this development takes place gradually, and in conformity with laws, from the very first hearing of the doctrine, and from germinating faith and dim comprehension, up to the final realization of deliverance.
"After hearing the law, he is filled with confidence, and he thinks: 'Full of hindrances is household life, a refuse heap; but the homeless life (of a monk) is like the open air. Not easy is it, when one lives at home, to fulfill in all points the rules of the holy life. How if now I were to cut off hair and beard, put on the yellow robe, and go forth from home to the homeless life?' And after a short time, having given up his possessions, great or little, having forsaken a circle of relations, small or large, he cuts off hair and beard, puts on the yellow robe, and goes forth from home to the homeless life.
Having thus left the world, he fulfills the rules of the monks. He avoids the killing of living beings and abstains from it; without stick or sword, conscientious, full of sympathy, he is desirous of the welfare of all living beings. He avoids stealing ... avoids unchastity ... avoids lying ... tale-bearing ... harsh language ... vain talk.
"He abstains from destroying vegetal germs and plants; eats only at one time of the day; keeps aloof from dance, song, music and the visiting of shows; rejects floral adornment, perfumes, ointment, as well as any other kind of adornment and embellishment. High and gorgeous beds he does not use. Gold and silver he does not accept ... keeps aloof from buying and selling things ....
"He contents himself with the robe that protects his body, and with the alms-bowl with which he keeps himself alive. Wherever he goes, he is provided with these two things, just as a winged bird in flying carries its wings along with him.
"By fulfilling this noble domain of morality (si^la) he feels in his heart an irreproachable happiness."
In what follows thereafter it is shown how the disciple watches over his 5 senses and his mind, and by this noble restraint of the senses (indriya-samvara) feels in his heart an unblemished happiness; how in all his actions he is ever mindful and clearly conscious; and how, being equipped with this lofty morality (si^la), and with this noble restraint of the senses (indriya-samvara), and with mindfulness and clear consciousness (sati-sampajan~n~a), he choses a secluded dwelling, and freeing his mind from the 5 hindrances (ni^varana, q.v.) he reaches full concentration (sama^dhi, q.v.); and how thereafter, by developing insight (vipassana^ q.v.) with regard to the impermanency (anicca), misery (dukkha) and impersonality (anatta^, q.v.) of all phenomena of existence, he finally realizes deliverance from all cankers and defilements, and thus the assurance arises in him:
"For ever am I liberated,
This is the last time I am born,
No new existence waits for me."
Cf. D.1, 2f; M. 27, 38, 51, 60, 76; A. IV, 198; X, 99: Pug. 239, etc.   anantara, is one of the 24 conditions (paccaya, q.v.).   'remembrance of former births', is one of the higher powers (abhin~n~a^, q.v.), and a factor of threefold knowledge (tevijja, q.v.).   'individual', 'person', as well as the synonyms: personality, individuality, being (satta), self (atta^), etc., in short all terms designating a personal entity, hence also: I, you, he, man, god, etc., all these, according to Buddhism, are mere names for certain combinations of material and mental processes, and apart from them they have no real existence. They are to be considered as mere 'conventional modes of expression' (voha^ra-vacana), and on that level they may be used, and are so used in the sutta texts, if taken "without misapprehending them" (s. quote from D. 9 under paramattha). With such tacit reservations, the term puggala occurs quite frequently in the suttas.
In the ultimate sense (paramattha, q.v.), however, there exist only ever-changing physical and mental phenomena, flashing up and dying every moment. - Kath., in its first section, discusses the question whether "in the absolute sense, any personality (puggala) can be found" (s. Guide, pp. 62ff). - See paramattha, anatta^.   (1) honour, respect, homage, (2) worship, devotional observances, devotional offerings; also offerings to monks.
(1) The Maha^-mangala Sutta (Sn. 259) says that "Honour and respect towards those worthy of it, is conducive to great blessing" (pja^ ca pjaniyesu etam mangalam uttamarn). See Dhp. 195f.
(2) The Buddha did not think much of mere outer worship. "Not thus, Ananda, is the Tatha^gata respected, venerated, esteemed, worshipped and honoured in the highest degree. But, Ananda, whatsoever bhikkhu or bhikkhuni, lay man or lay woman, abides by the Teaching, lives uprightly in the Teaching, walks in the way of the Teaching, it is by him that the Tatha^gata is respected, venerated, esteemed, worshipped and honoured in the highest degree" (D. 16). - "There are two kinds of worship: in a material way (a^misa-pja^) and through (practice of) the Dhamma (dhamma-pja^). The worship through (practice of) the Dhamma is the better of the two" (A. II).   lit.: re-becoming; 'renewed existence', is a sutta term for 'rebirth', which, in later literature mostly is called patisandhi (q.v.). The attainment of Sainthood (arahatta), implying the end of future rebirths, is often expressed in the words: "This is the last birth. Now there is no more a renewed existence!" (natthi 'da^ni punabbhavo) (M. 26; D. 15; Therag. 87, 339; Sn. 502). - The term is often linked with abhinibbatti ('arising').
"But how, o brother, does it come to renewed existence and arising in the future (a^yatim punabbhava^bhinibbatti)? Because beings, obstructed by ignorance and fettered by craving, find ever fresh delight now here, now there, for this reason there is renewed existence and arising in the future" (M. 43). See also S.XII. 38. Abhinibbatti also stands sometimes alone in signifying 'rebirth', e.g. in A. VI, 61; X, 65.
Cf., in the 2nd Truth, the adj. ponobhavika, 'leading to renewed existence'.
See A. III, 76; Sn. 163, 273, 514, 733; S. VII, 12; X, 3.   merit, meritorious, is a popular term for karmically wholesome (kusala) action. Opposite terms: apun~n~a, 'demerit'; pa^pa, 'bad', 'evil', The value of meritorious action is often stressed, e.g., in the Treasure Store Sutta (s. Khp. Tr.), Dhp 18, 118, 122. - The Community of Holy Monks (ariya-sangha), the third Refuge (s. ti-sarana), is said to be "the incomparable field of merit in the world" (anuttaram pun~n~akkhettam lokassa); s. anussati 3. The Arahats, however, having transcended all life-affirming and rebirth-producing actions, are said to be "beyond merit and demerit"; see Sn. 520, 547, 636, 790. - See foll. 3 articles.   'meritorious karma-formations' of the sensuous and fine-material sphere; s. sankha^ra I. 1.  'streams of merit'. It is said that one produces 4 streams of merit by offering the 4 requisites (robes, almsfood, dwelling, medicine) to a monk who has reached the conditionless deliverance of mind; further by being filled with unshakable faith in the Buddha, his doctrine and community of disciples, and by being perfect in morality (A. IV, 51, 52). A. VIII, 39 describes 4 further streams of merit.  'bases of meritorious action'. In the suttas, 3 are mentioned consisting of giving (liberality; da^na-maya-p.), of morality (si^la-maya-p.) and of mental development (meditation; bha^vana^-maya-p.). See D. 33; It. 60; expl. in A. VIII, 36.
Commentaries have a list of ten (dasa p.) which is very popular in Buddhist countries: (1)-(3) as above, (4) reverence (apaciti), (5) service (veyya^vacca), (6) transference of merit (patta^nuppada^na), (7) rejoicing in others' merit (abbha^numodana), (8) expounding the Doctrine (desana^), (9) listening to the Doctrine (savana), (10) straightening one's right views (rectification of views; ditthujukamma). - Expl. in Atthasa^lini Tr. 209ff.
See 'The Advantages of Merit', by Bhikkhu Khantipalo (BODHI LEAVES B. 38).  suddha^va^sa (q.v.).  'pre-nascence', is one of the 24 conditions (paccaya, q.v.).   the 7 stages of; s. visuddhi.   'Virility'; s. bha^va, khandha.   the elements of the effort for: pa^risuddhipadha^niyanga (q.v.).   lit.: 'one of the many folk', 'worldling', ordinary man, is any layman or monk who is still possessed of all the 10 fetters (samyojana, q.v.) binding to the round of rebirths, and therefore has not yet reached any of the 4 stages of holiness (s. ariya-puggala).
"Whoso is neither freed from the 3 fetters (personality-belief, sceptical doubt, attachment to mere rule and ritual), nor is on the way to lose these 3 things, such a one is called a worlding" (Pug. 9).
According to Com. to M. 9, a 'worlding' may be (1) an outsider (a non-Buddhist) who, if he believed in moral causation, may be said to have right view to that extent; but he has not the 'knowledge conforming to the Truths' (sacca^nulomika-n~a^na), as has (2) the 'worldling inside the Buddha's Dispensation' (sa^sanika). A worlding who professes Buddhism, may be either a 'blind worldling' (andha-p.) who has neither knowledge of, nor interest in the fundamental teaching (the Truths, groups, etc.); or he is a 'noble worldling' (kalya^na-p.), who has such knowledge and earnestly strives to understand and practise the Teaching. - See Atthasa^lini Tr. II, 451 (tr. by 'average man'); Com. to M. 1, D. 1.  pan~ha^-bya^karana (q.v.).  a^bhassara; cf. deva.   'lust', 'greed', is a synonym of lobha (s. mla), tanha^ (q.v.) and abhijjha^ (s. kammapatha). For ka^ma-, rpa-, arpa-ra^ga, s. samyojana.  the 'greedy-natured'; s. carita.   pi^ti (q.v.); further s. bojjhanga.   sense-: s. patigha.  s. patisambhida^.   s. paramattha. - Vision and knowledge according to r.- s. vipassana^ 15.   For theory, practice and r., s. pariyatti.   s. patisandhi, paticcasamuppa^da (3,10), karma, punabbhava.  sampaticchana-citta (s. vin~n~a^nakicca).   s. anussati.  s. kasina.  patisankha^nupassana^ (s. vipassana^, 17).   power of: patisankha^na-bala (q.v.).  s. patigha (2a).  formula, the 3-fold: ti-sarana (q.v.).  upapatti-bhava (s. bhava).  janaka-kamma (s. karma).  tada^rammana-citta (s. vin~n~a^na-kicca).  cf. puggala, paramattha-sacca, desana^, anatta^, satta.   of former existences: s. abhin~n~a^ 4.   kukkucca (q.v.).   a^sevana-paccaya, is one of the 24 conditions (paccaya, q.v.).   overcoming by: vikkhambhana-paha^na (s. paha^na).   patigha (q.v.).  s. patigha (2a).   uddhacca (q.v.).  paccavekkhana-n~a^na (q.v.).  patti-da^na (q.v.).  understanding (or r. view), r. thought, etc.: s. magga.  and fall (of phenomena): the knowledge consisting in the contemplation of r. and f., s. visuddhi VI, 1.  s. vatta (2), samsa^ra. - The 3-fold r. of r. (s. vatta, 1).  s. dhutanga.  and ritual, clinging to mere: (s. samyojana, upa^da^na).  vitakka-carita (s. carita).   (1) corporeality (s. khandha 1); (2) visual object (s. a^yatana); (3) fine-material (s. avacara, jha^na).  s. jha^na.  'corporeal group', material unit, designates a combination of several physical phenomena constituting a temporary unity. Thus, for instance, the so-called 'dead matter' forms the most primitive group, consisting only of 8 physical phenomena, called the 'pure eightfold unit' or 'octad' (suddhatthakakala^pa), to wit: the 4 elements (the solid, fluid, heat, motion); colour, smell, taste, nutriment (pathavi^, a^po, tejo, va^yo; vanna, gandha, rasa, oja^). In Vis.M., and elsewhere, it is also called ojatthamaka-kala^pa, 'the octad with nutriment as the 8th factor'.
The simplest form of living matter is the '9-fold vitality unit' or 'life-ennead' (ji^vita-navaka-kala^pa), formed by adding 'vitality' to the octad. Seven decades, or units of ten (dasaka-kala^pa), are formed by adding to the 9-fold unit one of the following corporeal phenomena: heart (physical seat of mind), sex, eye, ear, nose, tongue or body. - See Vis.M. XVIII, 4; Compendium of Buddhist Philosophy (PTS), p. 164, 250; Atthasa^lini Tr., II, 413f.  'body-group', as distinguished from na^ma-ka^ya, 'mind-group' (q.v.). See na^ma-rpa.  'corporeality group'; s. khandha (1).  'fine-material world'; s. loka.   'visual object', designates the external of visual physical phenomenon ('light wave') that forms the base consciousness. Cf. a^yatana (2).  rpa = nipphanna-rpa (q.v.).   s. avacara.   s. a^yatana (2).  'contemplation on disinterestedness regarding the whole world', described in A. X., 60 in the following words: "If, Ananda, the monk gives up his tenacious clinging to the world, his firm grasping and his biases and inclinations of the mind, and turns away from these things, does not cling to them, this, Ananda, is called the contemplation on disinterestedness regarding the whole world."  s. upadhi.   'Truth'. - 1. On the 'two truths', conventional and ultimale, see paramattha.
2. 'The Four Noble Truths' (ariya-sacca) are the briefest synthesis of the entire teachings of Buddhism, since all those manifold doctrines of the threefold canon are, without any exception, included therein. They are: the truth of suffering, of the origin of suffering, of the extinction of suffering, and of the Eightfold Path leading to the extinction of suffering.
I. The 1st truth, briefly stated, teaches that all forms of existence whatsoever are unsatisfactory and subject to suffering (dukkha).
II. The 2nd truth teaches that all suffering, and all rebirth, is produced by craving (tanha^).
III. The 3rd truth teaches that extinction of craving necessarily results in extinction (nirodha) of rebirth and suffering, i.e. nibba^na (q.v.).
IV. The 4th truth of the Eightfold Path (magga) indicates the means by which this extinction is attained.
The stereotype text frequently recurring in the Sutta Pitaka, runs as follows:
I. "But what, o monks, is the noble truth of suffering? Birth is suffering, decay is suffering, death is suffering; sorrow, lamentation, pain, grief and despair are suffering; in short, the 5 groups of existence connected with clinging are suffering (cf. dukkha, dukkhata).
II. ''But what, o monks, is the noble truth of the origin of suffering? It is that craving which gives rise to fresh rebirth and, bound up with lust and greed, now here, now there, finds ever fresh delight. It is the sensual craving (ka^ma-tanha^), the craving for existence (bhava-tanha^), the craving for non-existence or self-annihilation (vibhava-tanha^).
III. "But what, o monks, is the noble truth of the extinction of suffering? It is the complete fading away and extinction of this craving, its forsaking and giving up, liberation and detachment from it.
IV. "But what, o monks, is the noble truth of the path leading to the extinction of suffering? It is the Noble Eightfold Path (ariya-atthangika-magga) that leads to the extinction of suffering, namely:
 
1. Right view (samma^-ditthi)2. Right thought (samma^-sankappa)	III. Wisdom (pan~n~a^)
3. Right speech (samma^-va^ca^)4. Right action (samma^-kammanta)5. Right livelihood (sammd-djiva)	 I. Morality (si^la)
6. Right effort (samma^-va^ya^ma)7. Right mindfulness (samma^-sati)8. Right concentration (samma^-sama^dhi)	 II. Concentration (sama^dhi)
 
 
1. "What now, o monks, is right view (or right understanding)? It is the understanding of suffering, of the origin of suffering, of the extinction of suffering, and of the path leading to the extinction of suffering.
2. "What now, o monks, is right thought? It is a mind free from sensual lust, ill-will and cruelty.
3. "What now, o monks, is right speech? Abstaining from lying, tale-bearing, harsh words, and foolish babble (cf. tiraccha^nakatha^).
4. "What now, o monks, is right action? Abstaining from injuring living beings, from stealing and from unlawful sexual intercourse (s. ka^mesu miccha^ca^ra).
5. "What now, o monks, is right livelihood? If the noble disciple rejects a wrong living, and gains his living by means of right livelihood (s. magga, 5).
6. "What now, o monks, is right effort? If the disciple rouses his will to avoid the arising of evil, demeritorious things that have not yet arisen; ... if he rouses his will to overcome the evil, demeritorious things that have already arisen; ... if he rouses his will to produce meritorious things that have not yet arisen; ... if he rouses his will to maintain the meritorious things that have already arisen and not to let them disappear, but to bring them to growth, to maturity and to the full perfection of development; he thus makes effort, stirs up his energy, exerts his mind and strives (s. padha^na).
7. "What now, o monks is right mindfulness? If the disciple dwells in contemplation of corporeality ... of feeling ... of mind ... of the mind-objects, ardent, clearly conscious, and mindful after putting away worldly greed and grief (s. satipattha^na).
8. "What now, o monks, is right concentration? If the disciple is detached from sensual objects, detached from unwholesome things, and enters into the first absorption ... the second absorption ... the third absorption ... the fourth absorption" (s. jha^na).
In the Buddha's first sermon, the Dhammacakkappavattana Sutta, it is said that the first truth (suffering) is to be fully understood; the second truth (craving) to be abandoned; the third truth (Nibba^na) to be realized; the fourth truth (the path) to be cultivated.
"The truth of suffering is to be compared with a disease, the truth of the origin of suffering with the cause of the disease, the truth of extinction of suffering with the cure of the disease, the truth of the path with the medicine" (Vis.M. XVI).
In the ultimate sense, all these 4 truths are to be considered as empty of a self, since there is no feeling agent, no doer, no liberated one. no one who follows along the path. Therefore it is said:
'Mere suffering exists, no sufferer is found.
The deed is, but no doer of the deed is there.
Nibba^na is, but not the man that enters it.
The path is, but no traveller on it is seen.
 
'The first truth and the second truth are empty
Of permanency, joy, of self and beauty;
The Deathless Realm is empty of an ego,
And free from permanency, joy and self, the path.'
(Vis.M. XVI)
 
It must be pointed out that the first truth does not merely refer to actual suffering, i.e. to suffering as feeling, but that it shows that, in consequence of the universal law of impermanency, all the phenomena of existence whatsoever, even the sublimest states of existence, are subject to change and dissolution, and hence are miserable and unsatisfactory; and that thus, without exception, they all contain in themselves the germ of suffering. Cf. Guide, p. 101f.
Regarding the true nature of the path, s. magga.
Literature: Dhammacakkappavattana Sutta (in WHEEL 17 and BODHI LEAVES); M. 141; Sacca-Samyutta (S. LVI); Sacca Vibhanga; W. of B.; Vis.M. XVI: The Four Noble Truths by Francis Story (WHEEL 34/35); The Significance of the 4 Noble Truths by V. F. Gunaratna (WHEEL 123).  'knowledge of the truth' (s. prec.), may be of 2 kinds: (1) knowledge consisting in understanding (anubodha-n~a^na) and (2) knowledge consisting in penetration (pativedha-n~a^na), i.e. realization. Cf. pariyatti.
"Amongst these, (1) 'knowledge consisting in understanding' is mundane (lokiya, q.v.), and its arising with regard to the extinction of suffering, and to the path, is due to hearsay etc. (therefore not due to one's realization of the supermundane path; s. ariya-puggala) (2) 'Knowledge consisting in penetration', however, is supermundane (lokuttara), with the extinction of suffering (= nibba^na) as object, it penetrates with its functions the 4 truths (in one and the same moment), as it is said (S. LVI, 30): whosoever, o monks, understands suffering, he also understands the origin of suffering, the extinction of suffering, and the path leading to the extinction of suffering' " (Vis.M. XVI, 84). See visuddhi (end of article).
"Of the mundane kinds of knowledge, however, the knowledge of suffering by which (various) prejudices are overcome, dispels the personality-belief (sakka^ya-dilthi, s. ditthi). The knowledge of the origin of suffering dispels the annihilation-view (uccheda-ditthi, s. ditthi); the knowledge of extinction of suffering, the eternity-view (sassata-ditthi, s. ditthi); the knowledge of the path, the view of inefficacy of action (akiriya-ditthi, s. ditthi)" (Vis.M. XVI, 85).  anuloma-n~a^na (q.v.), puthujjana.  'things to be realized'. Recollection of former states of existence is to be realized through remembrance (abhin~n~a^ 4; q.v.). The vanishing and reappearing of beings is to be realized through the divine eye (abhin~n~a^ 5; q.v.). The 8 deliverances (vimokkha, q.v.) are to be realized through the mental group (ka^ya, here feeling, perception, mental formations; s. ka^ya). The extinction of cankers is to be realized through insight (vipassana^).   faith, confidence. A Buddhist is said to have faith if "he believes in the Perfect One's (the Buddha's) Enlightenment" (M 53; A.V, 2), or in the Three Jewels (s. ti-ratana), by taking his refuge in them (s. ti-sarana). His faith, however, should be "reasoned and rooted in understanding" (a^ka^ravata^ saddha^ dassanamlika; M. 47), and he is asked to investigate and test the object of his faith (M. 47, 95). A Buddhist's faith is not in conflict with the spirit of inquiry, and "doubt about dubitable things" (A. II, 65; S. XLII, 13) is admitted and inquiry into them is encouraged. The 'faculty of faith' (saddhindriya) should be balanced with that of wisdom (pan~n~indriya; s. indriya-samatta). It is said: "A monk who has understanding, establishes his faith in accordance with that understanding" (S. XLVIII, 45). Through wisdom and understanding, faith becomes an inner certainty and firm conviction based on one's own experience.
Faith is called the seed (Sn. v. 77) of all wholesome states because, according to commentarial explanations, it inspires the mind with confidence (okappana, pasa^da) and determination (adhimokkha), for 'launching out' (pakkhandhana; s. M. 122) to cross the flood of samsa^ra.
Unshakable faith is attained on reaching the first stage of holiness, 'stream-entry' (sota^patti, s. ariyapuggala), when the fetter of sceptical doubt (vicikiccha^; s. samyojana) is eliminated. Unshakable confidence (avecca-pasa^da) in the Three Jewels is one of the characteristic qualities of the Stream-winner (sota^pannassa anga^ni, q.v.).
Faith is a mental concomitant, present in all karmically wholesome, and its corresponding neutral, consciousness (s. Tab. II). It is one of the 4 streams of merit (pun~n~adha^ra^, q.v.), one of the 5 spiritual faculties (indriya, q.v.), spiritual powers (bala, q.v.), elements of exertion (padha^niyanga, q.v.) and one of the 7 treasures (dhana, q.v.).
See Faith in the Buddha's Teaching, by Soma Thera (WHEEL 262). "Does Saddha^ mean Faith?'' by n~a^namoli Thera (in WHEEL 52/53).  and saddha^ vimutta: the 'faith-devoted and the 'faith-liberated', are two of the 7 kinds of noble disciples (s. ariya-puggala, B.).   'heaven'; s. deva (heavenly heings).  'co-nascence', is one of the 24 conditions (paccaya, q.v.).  s. hetu.   the 'Once-returner': s. ariya-puggala, A.   the 'King of Gods' (deva^nam-inda), is the lord over the celestial beings in the heaven of the Thirty-Three' (ta^vatimsa, s. deva).   'existing group'. 'this word is usually translated by 'personality', but according to the commentaries it corresponds to sat-ka^ya, 'existing group', hence not to Sanskrit sva-ka^ya, 'own group' or 'own body'. In the suttas (e.g. M. 44) it is said to be a name for the 5 groups of existence (khandha): "Sakka^ya, o Brother Visa^kha, is said by the Blessed One to be a name for the 5 'groups as objects of clinging' (upa^da^na-kkhandha), to wit: corporeality, feeling, perception, mental formations, and consciousness." - See foll.  'personality-belief', is the first of the 10 fetters (samyojana). It is entirely abandoned only on reaching the path of Stream-winning (sota^patti-magga; s. ariya-puggala). There are 20 kinds of personality-belief, which are obtained by applying 4 types of that belief to each of the 5 groups of existence (khandha, q.v.): (1-5) the belief to be identical with corporeality, feeling, perception, mental formations or consciousness; (6-10) to be contained in them; (11-15) to be independent of them; (16-20) to be the owner of them (M. 44; S. XXII. 1). See prec., ditthi, upa^da^na 4.   the '6 bases' (of mental activity); s. a^yatana, paticcasamuppa^da.   'concentration'; lit. 'the (mental) state of being firmly fixed' (sam+a^+? ha^), is the fixing of the mind on a single object. "One-pointedness of mind (cittass' ekaggata^), Brother Visakha, this is called concentration" (M. 44). Concentration - though often very weak - is one of the 7 mental concomitants inseparably associated with all consciousness. Cf. na^ma, cetana^.
Right concentration (samma^-sama^dhi), as the last link of the 8-fold Path (s. magga), is defined as the 4 meditative absorptions (jha^na, q.v.). In a wider sense, comprising also much weaker states of concentration, it is associated with all karmically wholesome (kusala) consciousness. Wrong concentration (miccha^-sama^dhi) is concentration associated with all karmically unwholesome (akusala, q.v.) consciousness. Wherever in the texts this term is not differentiated by 'right' or 'wrong', there 'right' concentration is meant .
In concentration one distinguishes 3 grades of intensity:
(1) 'Preparatory concentration' (parikamma-sama^dhi) existing at the beginning of the mental exercise.
(2) 'Neighbourhood concentration' (upaca^ra-sama^dhi), i.e. concentration 'approaching' but not yet attaining the 1st absorption (jha^na, q.v.), which in certain mental exercises is marked by the appearance of the so-called 'counter-image' (patibha^ga-nimitta).
(3) 'Attainment concentration' (appana^-sama^dhi), i.e. that concentration which is present during the absorptions. (App.)
Further details, s. bha^vana, Vis.M. III and Fund. IV.
Concentration connected with the 4 noble path-moments (magga), and fruition-moments (phala), is called supermundane (lokuttara), having Nibba^na as object. Any other concentration, even that of the sublimest absorptions is merely mundane (lokiya, q.v.).
According to D. 33, the development of concentration (sama^dhi-bha^vana^) may procure a 4-fold blessing: (1) present happiness through the 4 absorptions; (2) knowledge and vision (n~a^na-dassana) - here probably identical with the 'divine eye' (s. abhin~n~a^) through perception of light (kasina); (3) mindfulness and clear comprehension through the clear knowledge of the arising, persisting and vanishing of feelings, perceptions and thoughts; (4) extinction of all cankers (a^savakkhaya) through understanding the arising and passing away of the 5 groups forming the objects of clinging (s. khandha).
Concentration is one of the 7 factors of enlightenment (bojjhanga, q.v.), one of the 5 spiritual faculties and powers (s. bala), and the last link of the 8-fold Path. In the 3-fold division of the 8-fold Path (morality, concentration and wisdom), it is a collective name for the three last links of the path (s. sikkha^).  'means, or requisites of concentration', are the 4 foundations of mindfulness (satipattha^na q.v.). See M. 44.  sama^patti kusalata^, -thiti-kusalata^, -uttha^nakusalata^: skilfulness in entering into concentration, in remaining in it, and in rising from it. Cf. S.XXXIV, llff.  'concentration as factor of enlightenment' (s. bojjhanga).  the 'power of penetrating concentration', is one of the magical faculties (iddhi, q.v.).  'contiguity', is one of the 24 conditions (paccaya, q.v.).  phala; the 'fruits of monkhood', is the name of a famous sutta (D. 2) and also, according to D. 33, a name for the 4 supermundane fruitions: Stream-entrance, Once-return, Non-return, and Perfect Holiness (s. ariya-puggala).   'attainments', is a name for the 8 absorptions of the fine-material and immaterial spheres to which occasionally is added as 9th attainment, attainment of extinction (nirodhasama^patti) Cf. jha^na.  one 'who attains two ends simultaneously', namely: the extinction of cankers and the end of life (s. Pug. 19). In A. VIII, 6 it is said: "Such is the case with a monk who dwells in the contemplation of impermanency of all forms of existence, keeping before his eyes their impermanency, perceiving their impermanency, perseveringly, steadfastly, undisturbed, of firm mind, wisely absorbed; and in whom at one and the same time the extinction of cankers and the end of like take place." (App.)   'tranquillity', serenity, is a synonym of sama^dhi (coneentration), cittekaggata^ (one-pointedness of mind) and avikkhepa (undistractedness). It is one of the mental factors in 'wholesome consciousness. Cf. foll. and bha^vana^.  'tranquillity and insight', are identical with concentration (sama^dhi, q.v.; s. prec.) and wisdom (pan~n~a^, q.v.), and form the two branches of mental development (bha^vana^, q.v.).
(1) 'Tranquillity' is all unperturbed, peaceful and lucid state of mind attained by strong mental concentration. Though as a distinct way of practice (s. samatha-ya^nika), it aims at the attainment of the meditative absorptions (jha^na, q.v.), a high degree of tranquil concentration (though not necessarily that of the absorptions) is indispensable for insight too. Tranquillity frees the mind from impurities and inner obstacles, and gives it greater penetrative strength.
''What now is the power of tranquillity (samatha-bala)? It is the one-pointedness and non-distraction of the mind due to freedom from desire (renunciation) ... to freedom from ill-will ... to the perception of light (s. aloka-san~n~a^) ... to non-distraction ... to the defilling of phenomena ... to knowledge, gladness, the 8 attainments, the 10 kasinas, the 10 recollections, the 9 cemetery contemplations, the 32 kinds of respiration-mindfulness ... the one-pointedness and non-distraction of the mind of one contemplating abandonment (relinquishment) while inhaling and exhaling (s. a^na^pa^nasati).
"The power of tranquillity consists of the freedom from perturbation; in the 1st absorption, from the 5 hindrances (ni^varana, (q.v.); in the 2nd absorption, from thought-conception and discursive thinking; ... in the sphere of neither-perception-nor-non-perception it consists of the freedom from perturbation by the perception of the sphere of nothingness (s. anupubbanirodha), which is no longer agitated and irritated by defilements associated with restlessness, nor by the groups of existence" (Pts.M. 1. p. 97)
(2) 'Insight' (s. vipassana^) is the penetrative understanding by direct meditative experience of the impermanency, unsatisfactoriness and impersonality of all material and mental phenomena of existence. It is insight that leads to entrance into the supermundance states of holiness and to final liberation.
''What now is the power of insight? It is the contemplation of impermanency (anicca^nupassana^), of misery (dukkhanupassana^), impersonality' (anatta^nupassana^), of aversion (nibbidanupassana^), detachment (vira^ganupassana^), extinction (nirodha), ahandonment (patinissagga), with regard to corporcality, feeling, perception, mental formations and consciousness.... That in contemplating the impermanency one is no more agitated by the idea of grasping ... no more by ignorance and the defilements associated therewith and no more by the groups of existence: this is called the power of insight" (Pts.M. p. 97).
"Two things are conducive to knowledge: tranquillity and insight. If tranquillity is developed, what profit does it bring? The mind is developed. If the mind is developed, what profit does it bring? All lust is abandoned.
"If insight is developed, what profit does it bring? Wisdom is developed. If wisdom is developed, what profit does it bring? All ignorance is abandoned" (A. II, 2.7).
There is a method of meditative practice where, in alternating sequence, tranquillity-meditation and insight-meditation are developed. It is called 'tranquillity and insight joined in pairs' (samatha-vipassana^yuganaddha), the coupling or yoking of tranquillity and insight. He who undertakes it, first enters into the 1st absorption. After rising from it, he contemplates the mental phenomena that were present in it (feeling, perception, etc.) as impermanent, painful and not-self, and thus he develops insight. Thereupon he enters into the 2nd absorption; and after rising from it, he again considers its constituent phenomena as impermanent, etc. In this way, he passes from one absorption to the next, until at last, during a moment of insight, the intuitive knowledge of the path (of Stream-entry, etc.) flashes forth - See A. IV, 170; A.IX, 36; Pts: Yuganaddha Katha^.  'one who takes tranquillity as his vehicle'. This is a name for a person who not only has reached insight but also one or the other of the absorptions, to distinguish him from one 'who practises only insight' (sukkha-vipassaka, q.v.).  = bodhi (q.v.).  = bojjhanga (q.v.).  ditthi, -sankappa, -vaca, etc: see magga.  see miccha^-magga.  'right exertion', is identical with the 6th link of the 8-fold path (s. magga, padha^na).  'Perfect Enlightenment', Universal Buddhahood, is the state attained by a Universal Buddha (samma^-sambuddha), i.e. one by whom the liberating law (dhamma) which had become lost to the world, has again been discovered, realized and clearly proclaimed to the world.
"Now, someone, in things never heard before, understands by himself the truth, and he therein attains omniscience, and gains mastery in the powers. Such a one is called a Universal Buddha, or Enlightened One" (Pug. 29).
The doctrine characteristie of all the Buddhas, and each time rediscovered by them and fully explained to the world, consists in the 4 Truths (sacca, q.v.) of suffering, its origin, its extinction and the way to its extinction (s. magga). See bodhi.   'comprehension', exploring, 'determining' (vavattha^na, q.v.) is a name for the determining of all phenomena of existence as impermanent, miserable and impersonal (anicca, dukkha, anatta^), etc., which is the beginning of insight (s. Pts.M. I, p. 53; Vis.M. XX); also called kala^pa-s. (q.v.), 'comprehension by groups (of existence - khandha).' (App.).   the 'state of rightness', are the 8 links of the 8-fold Path (D. 33). Cf. miccha^tta.  'conventional truth', is identical with voha^ra-sacca (s. paramattha-sacca).   'attainment, blessing'. The 5 blessings are said to be faith, morality, learning, liberality, wisdom (A. V, 91). Further: morality, concentration, wisdom, deliverance, the eye of knowledge connected with deliverance (A. V, 92).   'clarity of consciousness', clear comprehension. This term is frequently met with in combination with mindfulness (sati). In D. 22, M. 10 it is said: "Clearly conscious is he in going and coming, clearly conscious in looking forward and backward, clearly conscious in bending and stretching his body; clearly conscious in eating, drinking, chewing and tasting, clearly conscious in discharging excrement and urine; clearly conscious in walking, standing, sitting, falling asleep and awakening; clearly conscious in speaking and keeping silent." - For a definition of the term sati-sampajan~n~a, s. Pug. 86.
According to the Com., 'clarity of consciousness' is of 4 kinds: regarding the purpose, the suitability, (inclusion in the meditative) domain, and the undeluded conception of the activity concerned. Explained in detail in Com. to Satipattha^na Sutta. (tr. in The Way of Mindfulness, by Soma Thera; BPS).  'receptive consciousness', is the mindelement (mano-dha^tu) that follows immediately upon the arising of sense-consciousness (visual consciousness, etc.), performing on that occasion the function of recciving the sense-object. Regarding the other functions of consciousness, s. vin~n~a^na-kicca.  'condition of association', is one of the 24 conditions (paccaya, q.v.).  = phassa (q.v.).   'round of rebirth', lit. perpetual wandering', is a name by which is designated the sca of life ever restlessly heaving up and down, the symbol of this continuous process of ever again and again being born, growing old, suffering and dying. More precisely put, samsa^ra is the unbroken chain of the five-fold khandha-combinations, which, constantly changing from moment to moment follow continuously one upon the other through inconceivable periods of time. Of this samsa^ra, a single lifetime constitutes only a tiny and fleeting fraction; hence to be able to comprehend the first noble truth of universal suffering, one must let one's gaze rest upon the samsa^ra, upon this frightful chain of rebirths, and not merely upon one single life-time, which, of course, may be sometimes less painful. - Cf. tilakkhana, anatta^, paramattha, patisandhi.   'companionship'. (1) "Through companionship with bad men (asappurisa-s.) comes listening to bad advice, thereby unwise reflection, thereby inattention and mental confusion, thereby lack of sense-control, thereby 3-fold bad conduct in bodily action, speech and mind, thereby the 5 hindrances (ni^varana, q.v.), thereby craving for existence. (2) Through companionship with good men (sappurisa-s. ) comes listening to good advice, thereby faith, thereby wise reflection, thereby mindfulness and clarity of consciousness, thereby sense-control, thereby 3-fold good conduct, thereby the 4 foundations of mindfulness (satipattha^na, q.v ), thereby the 7 factors of enlightenment (bojjhanga, q.v.), thereby liberation through wisdom (pan~n~a^-vimutti, q.v.)." Cf. A. X 62.  'overcoming by destruction', is the absolute extinction of certain fetters of existence (samyojana, q.v.), which takes place by entering into one of the 4 supermundane paths of holiness (s. ariya-puggala). - Regarding the 5 kinds of overcoming, s. paha^na.  'truth of the origin', i.e. the origin of suffering, is the 2nd of the 4 Noble Truths (sacca, q.v.).   'origination'. There are 4 kinds of origination of corporeal phenomena, namely: through karma, consciousness, temperature, nutriment. For example, 'karma-produced' (kamma-s. = kammaja, karma-born) are the sense organs, sexual characteristics, etc., which, according to their nature, are conditioned either through wholesome or unwholesome karma formations (volitional actions; s. paticcasamuppa^da, 2) in a previous existence. 'Mindproduced', i.e. consciousness-produced (citta-samuttha^na = cittaja) are bodily and verbal expression (vin~n~atti, q.v.). For a detailed exposition, see Vis.M. XX. - (App.).  'effort to avoid'; s. padha^na.  'indriya-s.'; s. si^la.  'purity of control', is another name for morality consisting of restraint of the senses (indriya-samvara-si^la; s. si^la).  s. kappa.  'the sources of emotion', or of a sense of urgency, are 8: "birth, old age, disease, death, being 4; the suffering in the lower states of existence being the 5th; further, the misery of the past rooted in the cycle of rebirth, the misery of the future rooted in the cycle of rebirth, the misery of the present rooted in the search after food" (Vis.M. III.).  'places rousing emotion', are 4: the place where the Perfect One was born, (i.e. the Lumbini-grove near Kapilavatthu, at the present frontier of Nepal); the place where he reached Full Enlightenment (i.e. Uruvela, the modern Ureli, and Buddhagaya^, on the Neran~jara-river; the modern Lilanja); the place where he, for the first time, unveiled the Dhamma to the world (i.e. the deer-park at Isipatana near Benares); the place where he entered the final Nibba^na (i.e. Kusina^ra). (A. IV, 118).   'fetters'. There are 10 fetters tying beings to the wheel of existence, namely: (1) personality-belief (sakka^ya-ditthi, q.v.), (2) sceptical doubt (vicikiccha^ q.v.), (3) clinging to mere rules and ritual (si^labbata-para^ma^sa; s. upa^da^na), (4) sensuous craving (ka^ma-ra^ga, 4.v.), (5) ill-will (vya^pa^da), (6) craving for fine-material existence (rpa-ra^ga), (7) craving for immaterial existence (arpa-ra^ga), (8) conceit (ma^na, q.v.), (9) restlessness (uddhacca, q.v.), (10) ignorance (avijja^, q.v.). The first five of these are called 'lower fetters' (orambha^giya-samyojana), as they tie to the sensuous world. The latter 5 are called 'higher fetters' (uddhambha^giya-samyojana), as they tie to the higher worlds, i.e. the fine-material and immaterial world (A. IX, 67, 68; X. 13; D . 33, etc.).
He who is free from 1-3 is a Sota^panna, or Stream-winner, i.e. one who has entered the stream to Nibba^na, as it were. He who, besides these 3 fetters, has overcome 4 and 5 in their grosser form, is called a Sakada^ga^mi, a 'Once-returner' (to this sensuous world). He who is fully freed from 1-5 is an Ana^ga^mi^, or 'Non-returner' (to the sensuous world). He who is freed from all the 10 fetters is called an Arahat, i.e. a perfectly Holy One.
For more details, s. ariya-puggala.
The 10 fetters as enumerated in the Abhidhamma, e.g. Vibh. XVII, are: sensuous craving, ill-will, conceit, wrong views, sceptical doubt, clinging to mere rules and ritual, craving for existence, envy, stinginess, ignorance.  = cetana^, q.v.  the 4 'ways of showing favour' are liberality, kindly speech, beneficial actions, impartiality (A. IV, 32; VIII, 24).  (lit.: congregation), is the name for the Community of Buddhist monks. As the third of the Three Gems or Jewels (ti-ratana, q.v.) and the Three Refuges (ti-sarana, q.v.), i.e. Buddha, Dhamma and Sangha, it applies to the ariya-sangha, the community of the saints, i.e. the 4 Noble Ones (ariya-pugga, q.v.), the Stream-winner, etc.   'thought', is a synonym of vitakka (q.v.). For samma^-s., or right thought, s. magga (2).   This term has, according to its context, different shades of meaning, which should be carefully distinguished.
(I) To its most frequent usages (s. foll. 1-4) the general term 'formation' may be applied, with the qualifications required by the context. This term may refer either to the act of 'forming or to the passive state of 'having been formed' or to both.
1. As the 2nd link of the formula of dependent origination, (paticcasamuppa^da, q.v.), sankha^ra has the active aspect, 'forming, and signifies karma (q.v.), i.e. wholesome or unwholesome volitional activity (cetana^) of body (ka^ya-s.), speech (vaci^-s.) or mind (citta- or mano-s.). This definition occurs, e.g. at S. XII, 2, 27. For s. in this sense, the word 'karma-formation' has been coined by the author. In other passages, in the same context, s. is defined by reference to (a) meritorious karma-formations (pun~n~'a^bhisankha^ra), (b) demeritorious k. (apun~n~'abhisankha^ra), (c) imperturbable k. (a^nen~j'a^bhisankha^ra), e.g. in S. XII, 51; D. 33. This threefold division covers karmic activity in all spheres of existence: the meritorious karma-formations extend to the sensuous and the fine-material sphere, the demeritorious ones only to the sensuous sphere, and the 'imperturbable' only to the immaterial sphere.
2. The aforementioned three terms, ka^ya-, vaci^- and citta-s. are sometimes used in quite a different sense, namely as (1) bodily function, i.e. in-and-out-breathing (e.g. M. 10), (2) verbal function, i.e. thought-conception and discursive thinking, (3) mental-function, i.e. feeling and perception (e.g. M. 44). See nirodhasama^patti.
3. It also denotes the 4th group of existence (sankha^rakkhandha), and includes all 'mental formations' whether they belong to 'karmically forming' consciousness or not. See khandha, Tab. II. and S. XXII, 56, 79.
4. It occurs further in the sense of anything formed (sankhata, q.v.) and conditioned, and includes all things whatever in the world, all phenomena of existence. This meaning applies, e.g. to the well-known passage, "All formations are impermanent... subject to suffering" (sabbe sankha^ra anicca^ ... dukkha^). In that context, however, s. is subordinate to the still wider and all-embracing term dhamma (thing); for dhamma includes also the Unformed or Unconditioned Element (asankhata-dha^tu), i.e. Nibba^na (e.g. in sabbe dhamma^ anatta^, "all things are without a self").
(II) Sankha^ra also means sometimes 'volitional effort', e.g. in the formula of the roads to power (iddhi-pa^da, q.v.); in sasankha^ra- and asankha^ra-parinibba^yi^ (s. ana^ga^mi^, q.v.); and in the Abhidhamma terms asankha^rika- (q.v.) and sasankha^rika-citta, i.e. without effort = spontaneously, and with effort = prompted.
In Western literature, in English as well as in German, sankha^ra is sometimes mistranslated by 'subconscious tendencies' or similarly (e.g Prof Beckh: "unterbewu?te Bildekr?fte," i.e. subconscious formative forces). This misinterpretation derives perhaps from a similar usage in non-Buddhist Sanskrit literature, and is entirely inapplicable to the connotations of the term in Pa^li Buddhism, as listed above under I, 1-4. For instance, within the dependent origination, s. is neither subconscious nor a mere tendency, but is a fully conscious and active karmic volition. In the context of the 5 groups of existence (s. above I, 3), a very few of the factors from the group of mental formations (sankha^rakkhandha) are also present as concomitants of subconsciousness (s. Tab. I-III), but are of course not restricted to it, nor are they mere tendencies.  the 'equanimity-knowledge with regard to the formations of existence', is one of those kinds of knowledge which form the 'purification by knowledge and vision of the path-progress' (s. visuddhi, VI, 8). "It is known by 3 names: in the lowest stage it is called 'knowledge consisting in the desire for deliverance' (rnuccitu-kamyata^-n~a^na); in the middle stage it is called the 'reflecting contemplation' (patisankha^nupassana^n~a^na); in the last stage, however, i.e. after attaining the summit, it is called the 'equanimity-knowledge with regard to the formations of existence' " (Vis.M. XXI).   the 'formed', i.e. anything originated or conditioned, comprises all phenomena of existence. Cf. sankha^ra I, 4; asankhata.  in the Satipattha^na Sutta, signifies the 'contracted' or 'cramped' mind, not the concentrated (sama^hita) mind, as often translated by Western authors. Cf. Satipattha^na (3).   1. 'perception', is one of the 5 groups of existence (khandha, q.v.), and one of the 7 mental factors (cetasika) that are inseparably bound up with all consciousness (s. cetana^). It is sixfold as perception of the 5 physical sense-objects and of mental objects. It is the awareness of an object's distinctive marks ("one perceives blue, yellow, etc.," S. XXII, 79). If, in repeated perception of an object, these marks are recognized, san~n~a^ functions as 'memory' (s. Abh. St., p. 68f.).
2. san~n~a^ stands sometimes for consciousness in its entirety, e.g. in n'eva-san~n~a^-n'a^san~n~a^yatana, 'the realm of neither-perception-nor- non-perception'; further, in asan~n~a^-satta, 'unconscious beings'. In both cases reference is not to 'perception' alone, but also to all other constituents of consciousness. Cf. D. 9.
3. san~n~a^ may also refer to the 'ideas', which are objects of meditation, e.g. in a group of 7 ideas, of impermanence (anicca-s. ), etc. (A. VII, 46); of 10: impurity (asubha-s.), etc. (A. X, 56), and another set of 10 in A. X. 60; or to wrong notions, as in nicca-, subha-s. (the notion of permanence, beauty), etc.  vedayita nirodha = nirodha-sama^patti (q.v.).  'perversion of perception' (s. vipalla^sa).  = samyojana (q.v.).  = santati: 'continuity', may refer to the continuity of consciousness (citta-s.), of the groups of existence (khandha-s.), of sub-consciousness (bhavanga-s.), of corporeality (rpa-s.), to the uninterrupted continuity of the paticcasamuppa^da (q.v.), etc. (App.).  'investigating consciousness', is one of the stages in the cognitive series. For the 14 functions of consciousness. s. vin~n~a^nakicca.   'contentedness'; s. ariya-vamsa.   s. dhutanga.  'corporeality reacting to sense stimuli', refers to the 5 sense-organs (a^yatana, q.v.). - Cf. Vibh. II (s. Guide II, Chap. II) and Vis.M. XIV; further s. patigha 2.   s. ti-sarana.  (lit. 'message'): the Dispensation of the Buddha, the Buddhist religion; teaching, doctrine.
Navanga-Buddha (or satthu)-sa^sana, the ninefold Dispensation of the Buddha (or the Master) consists of suttas (sutta), mixed prose (geyya), exegesis (veyya^karana), verses (ga^tha^), solemn utterances (uda^na), sayings of the Blessed One (itivuttaka), birth stories (ja^taka), extraordinary things (abbhutadhamma), and analysis (vedalla). This classification is often found in the suttas (e.g. M. 22). According to the commentaries, also the Vinaya and the Abhidhamma Pitaka are comprised in that ninefold division (see Atthasa^lini Tr., I, 33). It is a classification according to literary styles, and not according to given texts or books.  'one who reaches Nibba^na with exertion', is a name of one of the 5 kinds of Non-returners (ana^ga^mi^, q.v.).  citta (in Dhs.: sasankha^rena ): a prepared, or prompted. state of consciousness, arisen after prior deliberation (e.g. weighing of motives) or induced by others (command, advice, persuasion) - See Tab. I; exemplified in Vis.M. XIV, 84f. - Opposite: asankha^rika-citta, q.v.  ditthi (-va^da): 'eternity-belief', is the belief in a soul or personality existing independently of the 5 groups of existence, and continuing after death eternally, as distinguished from the 'annihilation-belief' (uccheda-ditthi), i.e. the belief in a personality falling at death a prey to absolute annihilation. For more details, s. ditthi.   'mindfulness', is one of the 5 spiritual faculties and powers (s. bala), one of the 7 factors of enlightenment (bojjhanga, q.v.), and the 7th link of the 8-fold Path (magga, q.v.), and is, in its widest sense, one of those mental factors inseparably associated with all karmically wholesome (kusala, q.v.) and karma-produced lofty (sobhana) consciousness (Cf. Tab. II). - For the 4 foundations of mindfulness s. foll.   the 4 'foundations of mindfulness', lit. 'awarenesses of mindfulness' (sati-upattha^na), are: contemplation of body, feeling, mind and mind-objects. - For sati, s. prec.
A detailed treatment of this subject, so important for the practice of Buddhist mental culture, is given in the 2 Satipattha^na Suttas (D. 22; M. 10), which at the start as well as the conclusion, proclaim the weighty words: "The only way that leads to the attainment of purity, to the overcoming of sorrow and lamentation, to the end of pain and grief, to the entering of the right path, and to the realization of Nibba^na is the 4 foundations of mindfulness."
After these introductory words, and upon the question which these 4 are, it is said that the monk dwells in contemplation of the body, the feelings, the mind, and the mind-objects, "ardent, clearly conscious and mindful, after putting away worldly greed and grief."
These 4 contemplations are in reality not to be taken as merely separate exercises, but on the contrary, at least in many cases, especially in the absorptions, as things inseparably associated with each other. Thereby the Satipatha^na Sutta forms an illustration of the way in which these 4 contemplations relating to the 5 groups of existence (khandha, q.v.) simultaneously come to be realized, and finally lead to insight into the impersonality of all existence.
(1) The contemplation of the body (ka^yanupassana^) consists of the following exercises: mindfulness with regard to in-and-outbreathing (a^na^pa^nasati, q.v.), minding the 4 postures (iriya^patha, q.v.), mindfulness and clarity of consciousness (satisampajan~n~a, q.v.), reflection on the 32 parts of the body (s. ka^yagata^sati and asubha), analysis of the 4 physical elements (dha^tuvavattha^na, q.v.), cemetery meditations (si^vathika^ q.v.).
(2) All feelings (vedana^nupassana^) that arise in the meditator he clearly perceives, namely: agreeable and disagreeable feeling of body and mind, sensual and super-sensual feeling, indifferent feeling .
(3) He further clearly perceives and understands any state of consciousness or mind (citta^nupassana^), whether it is greedy or not, hateful or not, deluded or not, cramped or distracted, developed or undeveloped, surpassable or unsurpassable, concentrated or unconcentrated, liberated or unliberated.
(4) Concerning the mind-objects (dhamma^nupassana^), he knows whether one of the five hindrances (ni^varana, q.v.) is present in him or not, knows how it arises, how it is overcome, and how in future it does no more arise. He knows the nature of each of the five groups (khandha, q.v.), how they arise, and how they are dissolved. He knows the 12 bases of all mental activity (a^yatana q.v.): the eye and the visual object, the ear and the audible object, .. mind and mind-object, he knows the fetters (samyojana, q.v.) based on them, knows how they arise, how they are overcome, and how in future they do no more arise. He knows whether one of the seven factors of enlightenment (bojjhanga, q.v.) is present in him or not, knows how it arises, and how it comes to full development. Each of the Four Noble Truths (sacca, q.v.) he understands according to reality.
The 4 contemplations comprise several exercises, but the Satipattha^na should not therefore be thought of as a mere collection of meditation subjects, any one of which may be taken out and practised alone. Though most of the exercises appear also elsewhere in the Buddhist scriptures, in the context of this sutta they are chiefly intended for the cultivation of mindfulness and insight, as indicated by the repetitive passage concluding each section of the sutta (see below). The 4 contemplations cover all the 5 groups of existence (khandha, q.v.), because mindfulness is meant to encompass the whole personality. Hence, for the full development of mindfulness, the practice should extend to all 4 types of contemplation, though not every single exercise mentioned under these four headings need be taken up. A methodical practice of Satipattha^na has to start with one of the exercises out of the group 'contemplation of the body', which will serve as the primary and regular subject of meditation: The other exercises of the group and the other contemplatons are to be cultivated when occasion for them arises during meditation and in everyday life.
After cach contemplation it is shown how it finally leads to insight-knowledge: "Thus with regard to his own body he contemplates the body, with regard to the bodies of others he contemplates the body, with regard to both he contemplates the body. He beholds how the body arises and how it passes away, beholds the arising and passing away of the body. 'A body is there' (but no living being, no individual, no woman, no man, no self, nothing that belongs to a self; neither a person, nor anything belonging to a person; Com.): thus he has established his attentiveness as far as it serves his knowledge and mindfulness, and he lives independent, unattached to anything in the world.''
In the same way he contemplates feeling, mind and mind-objects.
In M. 118 it is shown how these four foundations of mindfulness may be brought about by the exercise of mindfulness on in-and-out breathing (a^na^pa^na-sati, q.v.).
Literature: The Way of Mindfullness, tr. of Sutta and Com., by Soma Thera (3rd ed; Kandy 1967, BPS). - The Heart of Buddhist Meditation, by Nyanaponika Thera (3rd ed.; London. Rider & Co.). The Foundations of Mindfulness (tr. of M. 10), Nyanasatta Thera (Wheel 19). The Satipattha^na Sutta and its Application to Modern Life, V. F. Gunaratna (WHEEL 60). - The Power of Mindfulness by Nyanaponika Thera (WHEEL 121/122).  'mindfulness as factor of enlightenment' s. bojjhanga.  'mindfulness and clarity of consciousness, s. sampajan~n~a.   'living being'. This term, just like atta^, puggala, ji^va, and all the other terms denoting 'ego-entity', is to be considered as a merely conventional term (voha^ra-vacana), not possessing any reality-value. For the impersonality of all existence. s. anatta^, paramattha, puggala, ji^va, satta, paticcasamuppa^da.  'one wth only 7 further rebirths at the utmost', is one of the 3 kinds of Stream-winners (sota^panna, q.v.).  'abodes of beings'. In the sutta-texts (e.g. D. 33; A.IX, 24) 9 such abodes are mentioned:
"There are, o monks, 9 abodes of beings, namely:
(1) "There are beings who are different in body and different in perception, such as the human beings, some heavenly beings, and some beings living in the world of suffering (vinipa^tika, q.v.).
(2) ''There are beings who are different in body but equal in perception, such as the first-born gods of the Brahma-world (i.e. at the beginning of each new world-formation; s. deva II).
(3) ''There are beings who are equal in body but different in perception, such as the Radiant Gods (a^bhassara, s. deva II).
(4) "There are beings who are equal in body and equal in perception, such as the All-Illuminating Gods (subha-kinha; s. deva II).
(5) "There are beings without perception and feeling, such as the unconscious beings (asan~n~a-satta, q.v.).
(6) "There are beings who, through the complete overcoming of perceptions of matter (rpa-san~n~a), the disappearance of perceptions of sense-reaction (patigha-san~n~a), and the non-attention to perceptions of variety thinking: 'Boundless is space', are reborn in the sphere of buundless space (s. deva, III; jha^na, 5).
(7) "There are beings who, through the complete overcoming of the sphere of boundless space, thinking: 'Boundless is consciousness', are reborn in the sphere of boundless consciousness (s. jha^na 6).
(8) "There are beings who, through the complete overcoming of the sphere of boundless consciousness, thinking: 'Nothing is there, are reborn in the sphere of nothingness (s. jha^na, 7).
(9) "There are beings who, through the complete overcoming of the sphere of nothingness, are reborn in the sphere of neither-perception-nor-non-perception (s. jha^na, 8)" (A. IX, 24).
According to the Com. to A., the beings of the Pure Abodes (suddha^va^sa, q.v.) are not mentioned here, for the reason that they exist only in those world-periods in which Buddhas appear. Cf. vin~n~a^na-tthiti.  s. nibba^na, upa^di.   'hearer', i.e. 'disciple', refers, in a restricted sense (then mostly ariya-sa^vaka, 'nohle disciple'), only to the 8 kinds of noble disciples (ariya-puggala, q.v.).  'enlightenment of the disciple', designates the holiness of the disciple, as distinguished from the holiness of the Pacceka-Buddha (q.v.) and the Samma^-sambuddha (q.v.).  vicikiccha^ (q.v.). Cf. kankha^.   kukkucca (q.v.).   a 'noble learner', a disciple in higher training, i.e. one who pursues the 3 kinds of training (sikkha^, q.v.), is one of those 7 kinds of noble disciples who have reached one of the 4 supermundane paths or the 3 lower fruitions (s. ariya-puggala), while the one possessed of the 4th fruition, or Arahatta-phala, is called 'one beyond training' (asekha, lit. 'no more learner'). The worldling (puthujjana, q.v.) is called 'neither a noble learner, nor perfected in learning' (n'eva-sekha-na^sekha). Cf. Pug. 23-25. F  atta^ (q.v.). F annihilation, craving for: vibhava-tanha^ (s. tanha^).  vesa^rajja (q.v.).  atta-kilamatha (q.v.).   'dwelling place', is one of the 4 requisites of the monk's life (s. si^la 4). To be suitable for spiritual training, it should possess 5 advantages. As it is said (A. X, 11): "But how, o monks, does the dwelling place possess 5 advantages? Such a dwelling place is not too far, nor too near (to the village), is suitable for going (on almsround) and returning. In the daytime it is not much crowded, and at night without noise and bustle. One is not much molested there by gadflies, mosquitoes, wind, sun and creeping things. While living there, the monk without difficulty obtains robes, almsfood, dwelling, and the necessary medicines. There are elder monks living there, with great learning, well versed in the Message, masters of the Law (dhamma), of the Discipline (vinaya) and of the Tables of Contents (i.e. either the twofold Abhidhamma Matrix, or the Bhikkhu and Bhikkhuni Pa^timokkha; s. pa^timokkha). And he approaches them from time to time, questions them, asks them for explanations, etc.  organs and objects: s. a^yatana, dha^tu.  stimuli, corporeality responding to: s. a^yatana.  pasa^da-rpa (q.v.).  (subj. & obj.): ka^ma (q.v.).  ka^mpa^da^na; s. upa^da^na.  ka^ma-tanha^ (-ra^ga), is one of the 10 fetters (samyojana, q.v.), and one of the 3 kinds of craving (tanha^, q.v.).  sphere (-world): s. avacara, loka.   s. samatha.  s. sota^panna.   s. bha^va.  intercourse, unlawful: s. ka^mesu miccha^ca^ra.   hiri (q.v.).   ahirika (q.v.).  (animitta): s. ceto-vimutti, vimokkha, vipassana^.   the 'training', which the Buddha's disciple has to undergo, is 3-fold: training in higher morality (adhisi^la-sikkha^), in higher mentality (adhicitta-sikkha^), and in higher wisdom (adhipan~n~a^-sikkha^). This 3-fold training refers to the 3-fold division of the the 8-fold Path (magga, q.v.) in morality, concentration and wisdom (si^la, sama^dhi, pan~n~a^). In D. 16 and A.IV,1 it is said:
"It is through not understanding, not penetrating noble morality ... noble concentration ... noble wisdom ... noble deliverance that I, as well as you, have had for such a long time to pass through this round of rebirths.''
"This then is morality, this concentration, this wisdom, this deliverance. Being endowed with morality, concentration brings high fruit and blessing. Being endowed with concentration, wisdom hrings high fruit and blessing. Being endowed with wisdom, the mind becomes freed from all cankers (a^sava q.v.) namely, from the sensuous canker (ka^ma^sava), from the canker of existence (bhavasava) from the canker of opinions (ditthisava) from the canker of ignorance (avijja^sava).   'steps of training', moral rules.
The 5 moral rules, also called pan~ca-si^la which are binding on all Buddhist laymen, are: (1) abstaining from killing any living being, (2) from stealing, (3) from unlawful sexual intercourse, (4) from lying, (5) from the use of intoxicants.(s. sura^meraya etc.)
The 10 rules (dasa-si^la) are binding on all novices and monks, namely: (1) abstaining from killing, (2) from stealing, (3) from unchastity, (4) from lying, (5) from the use of intoxicants, (6) from eating after midday, (7) from dancing, singing, music and shows, (8) from garlands, scents, cosmetics and adornments, etc., (9) from luxurious beds, (10) from accepting gold and silver.
In the 8 rules (attha-si^la) which on full and new moon days, and on the first and last quarter of the moon, are observed by many lay-followers (upa^saka, q.v.), the 7th and 8th of the above 10 rules are fused into one as the 7th rule, while the 9th becomes the 8th.   'morality', 'virtue', is a mode of mind and volition (cetana, q.v.) manifested in speech or bodily action (s. karma). It is the foundation of the whole Buddhist practice, and therewith the first of the 3 kinds of training (sikkha^, q.v.) that form the 3-fold division of the 8-fold Path (s. magga), i.e. morality, concentration and wisdom.
Buddhist morality is not, as it may appear from the negative formulations in the Sutta-texts, something negative. And it does not consist in the mere not committing of evil actions, but is in each instance the clearly conscious and intentional restraint from the bad actions in question and corresponds to the simultaneously arising volition.
Morality of the 8-fold Path, namely, right speech, right action and right livelihood, is called 'genuine or natural morality' pakatisi^la), as distinguished from the external rules for monks or laymen, the so-called 'prescribed morality' (pan~n~atti-si^la, q.v.), which, as such, is karmically neutral.
"What now is karmically wholesome morality (kusala-si^la)? It is the wholesome bodily action (ka^ya-kamma, s. karma), wholesome verbal action (vaci^-kamma, s. karma), and also the purity with regard to livelihood which I call morality" (M. 78). Cf. magga, 3-5.
For the 5, 8 and 10 rules, s. sikkha^pada. Further cf. ca^ritta- and va^ritta-si^la.
The 4 kinds of morality consisting of purification (catupa^risuddhi-si^la) are: (1) restraint with regard to the monks' Disciplinary Code, (2) restraint of the senses, (3) purification of livelihood, (4) morality with regard to the 4 requisites (of the monk) .
(1) Restraint with regard to the Disciplinary Code (pa^timokkha-samvara-si^la). "Here the monk is restrained in accordance with the monks' Disciplinary Code, is perfect in conduct and behaviour, and perceiving danger even in the least offences, he trains himself in the rules he has taken upon him" (A . V, 87,109 ,114, etc. ) .
(2) Restraint of the senses (indriya-samvara-si^la). "Whenever the monk perceives a form with the eye, a sound with the ear, an odour with the nose, a taste with the tongue, an impression with the body, an object with the mind, he neither adheres to the appearance as a whole, nor to its parts. And he strives to ward off that through which evil and unwholesome things, greed and sorrow, would arise, if he remained with unguarded senses; and he watches over his senses, restrains his senses" (M 38).
(3) Purification of livelihood (a^ji^va-pa^risuddhi-si^la). It consists therein that the monk does not acquire his livelihood in a way unbefitting to a monk.
(4) Morality with regard to the 4 rcquisites (paccaya-sannissita-si^la). It consists therein that the monk is guided by the right mental attitude when making use of the 4 requisites: robes, almsfood, dwelling and medicine. "Wisely reflecting he makes use of his robes ... merely to protect himself against cold and heat, etc. Wisely reflecting he makes use of his almsfood... merely as a prop and support to this body.... Wisely reflecting he makes use of his dwelling... merely to keep off the dangers of weather and to enjoy solitude.... Wisely rerlecting he makes use of the necessary medicines, merely to suppress feelings of sickness that arise, and to reach perfect freedom from suffering" (cf. M. 2).
About these 4 kinds of morality, Vis.M. I gives a detailed exposition.  para^ma^sa and -upa^da^na: 'attachment (or clinging) to mere rules and ritual', is the 3rd of the 10 fetters (samyojana, q.v.), and one of the 4 kinds of clinging (upa^da^na, q.v.). It disappears on attaining to Stream-entry (sota^patti). For definition, s. upa^da^na.  s. sikkha^, magga.  pacceka-buddha (q.v.).  position, sleeping in: s. dhutanga.   'cemetery contemplations', as deseribed in D. 22 and M. 10, have as their objects a corpse one or two or three days old, swollen up, blue-black in colour, full of corruption; a corpse eaten by crows, etc.; a framework of bones; flesh hanging from it, bespattered with blood, held together by the sinews; without flesh and blood, but still held together by the sinews; bones scattered in all direction; bleached and resembling shells; heaped together after the lapse of years; weathered and crumbled to dust. At the end of each of these contemplations there follows the conclusion: "This body of mine also has this nature, has this destiny, cannot escape it." Similar are the 10 objects of loathsomeness (asubha q.v.).   kusala (q.v.).   middha, s. ni^varana.   'lofty', beautiful, pure, are called, in Abh. S., all states of consciousness excepting the unwholesome and those without roots (ahetuka). Sobhana-sa^dha^rana are called the mental factors (cetasika) common to all lofty consciousness; s. Tab. II.   lit 'glad-minded-ness' (su+manas+ya), gladness, joy; identical with 'mentally agreeable feeling' (cetasika^ sukha^ vedana^), belongs to the feeling-group (vedana^-kkhandha, s. khandha II), and is enumerated amongst the 22 faculties (indriya, q.v.). It may or may not be associated with karmically wholesome consciousness (s. Tab. I. 1-4, 9-12, 18-21), with karmically unwholesome consciousness (greedy c. ib. 22-25), and with karmically neutral consciousness (ib. 40, 42-45, 57-60, 66-69, 72-76. 81-84), - Somanassa is not identical with pi^ti (q.v.).   'indulging in gladness'; s. mano-pavica^ra.   kin~cana (q.v.).   the 'Stream-winner', is the lowest of the 8 noble disciples (s. ariya-puggala). Three kinds are to be distinguished: the one 'with 7 rebirths at the utmost' (sattakkhattu-parama), the one 'passing from one noble family to another' (kolankola), the one 'germinating only once more' (eka-bi^ji^). As it is said (e.g. Pug. 37-39; A. III, 87):
(1) "If a man, after the disappearance of the 3 fetters (personality-belief, skeptical doubt, attachment to rules and ritual; s. samyojana), has entered the stream (to Nibba^na), he is no more subject to rebirth in lower worlds, is firmly established, destined to full enlightenment. After having passed amongst the heavenly and human beings only seven times more through the round of rebirths, he puts an end to suffering. Such a man is called 'one with 7 births at the utmost' (sattakkhattu-parama).
(2) "If a man, after the disappearance of the 3 fetters.... is destined to full enlightenment, he, after having passed among noble families two or three times through the round of rebirths, puts an end to suffering. Such a man is called 'one passing from one noble family to another' (kolankola).
(3) "If a man, after the disappearance of the 3 fetters.... is destined to full enlightenment, he, after having only once more returned to human existence, puts an end to suffering. Such a man is called 'one germinating only once more' (eka-bi^ji^). See Sota^patti-Samyutta (S. LV).  the 'characteristic qualities of a Stream-winner' are 4: unshakable faith towards the Enlightened One, unshakable faith towards the Doctrine, unshakable faith towards the Order, and perfect morality. Explained in S. LV, I, D. 33, in S. XLVII, 8 and in Netti-ppakarana these 4 qualities are called sota^pattiyanga (q.v.).   'Stream-entry'; s. sota^panna; s. -magga, -phala, 'path and fruition of Stream-entry'; s. ariyapuggala.   the 4 (preliminary) 'conditions to Stream-entry' are: companionship with good persons, hearing the Good Law, wise reflection, living in conformity with the Law (S. LV, 5; D. 33). Cf. sota^pannassa anga^ni.   s. a^ka^sa.  (of existence): avacara (q.v.). - The 4 immaterial spheres (a^yatana): s. jha^na (5-8).  s. indriya (15-19), indriya-samatta, bala.  opapa^tika (q.v.).   the 3: mala (q.v.).  (of morality etc.): s. ha^na-bha^giya-si^la. S. of existence: vivatta (q.v.).   macchariya (q.v.); cf. Tab. II.  katatta^; s. karma.  s. sota^panna, ariya-puggala.  pun~n~adha^ra^ (q.v.).  s. sota^panna, ariya-puggala.  s. carita.  stream (of existence): bhavanga-sota (q.v.).  kinha (or-kinna): s. deva, II.  'beautiful (or attractive) object of mind'; it may become an inducement to the arising of sense-desire (ka^macchanda; s. ni^varana): "No other thing do I know, o monks, through which in such a degree sense-desire may arise, and once arisen will continue to grow, as an attractive object. Whoso does not wisely consider an attractive object, in him sense-desire will arise, and once arisen will continue to grow" (A. I, 2).  'the perception (consciousnes or view) of beauty (or purity)' in what is actually devoid of it (asubhe subha-san~n~a^), is one of the 4 perversions (vipalla^sa, q.v.).  abodes (or States): brahma-viha^ra (q.v.).  upadhi (q.v.).   'good conduct', is 3-fold, in body, speech and mind, and comprises the 10 wholesome courses of action (s. kammapatha). According to A. X, 61, it has sense-control as its condition. See D. 33, A. II, 17; III, 2.  births, karma ripening in: s. karma.   tathata^ (q.v.).  s. foll.   the 'Pure Abodes', are a group of 5 heavens belonging to the fine-material world (rpa-loka, s. loka), where only the Non-returners (s. ana^ga^mi^, q.v.) are reborn, and in which they attain Arahatship and Nibba^na (ariya-puggala). The names of the inhabitants of these Pure Abodes are: a^viha, a^tappa, Sudassa, Sudassi^, Akanittha. Cf. ana^ga^mi^.  vipassana^ ya^nika = sukkha-vipassaka (q.v.).   For the 4 Truths of suffering, s. sacca; further s. ti-lakkhana.   'happy course of existence'; s. gati.   pleasant, happy; happiness, pleasure, joy, bliss. It is one of the three feelings (s. vedana^) and may be either bodily or mental. The texts distinguish between the happiness of the senses and the h. of renunciation (A. II), worldly (carnal; sa^misa) and unworldly (non-carnal; nira^misa) happiness (M. 10). See A. II, ch. VIII. - Happiness is an indispensable condition for attaining concentration of mind (sama^dhi, q.v.), and therefore it is one of the 5 factors (or constituents) of the 1st absorption (jha^nanga; s. jha^na) and is present up to the 3rd absorption inclusively. "The mind of the happy one has concentration as its fruit and reward" (A.X,1). - "In him who is filled with happiness, right concentration has found a foundation" (A.X,3).  'the perception (consciousness or view) of happiness' in what is actually suffering (dukkhe sukha-san~n~a^), i.e. any form of existence, it is one of the perversions (vipalla^sa, q.v.).  'one supported by bare insight', is the commentarial term for one who, without having attained any of the meditative absorptions (jha^na, q.v.), has realized only by the support of insight (vipassana^, q.v.) one or several of the supermundane paths (s. ariyapuggala). In Vis.M. XVIII, he is called suddha-vipassana^-ya^nika, as distinguished from 'one who has tranquillity as vehicle' (samathaya^nika, q.v.). Though the primary meaning of sukkha as intended here is as stated above, subcommentaries (e.g. D. Ti^ka^) employ also the literal meaning of sukkha, i.e. 'dry': "His insight is dry, rough, unmoistened by the moisture of tranquillity meditation." This justifies a frequent rendering of this term by 'dry-visioned' or 'having dry insight', which, however, should not lead to misconceptions about the nature of insight meditation as being 'dry' or 'merely intellectual', while in fact the development of insight will produce rapture (pi^ti) and a sense of urgency (samvega) in the meditator. - (App.).  (adj.), sun~n~ata^ (noun): void (ness), empty (emptiness). As a doctrinal term it refers, in Therava^da, exclusively to the anatta^ doctrine,.i.e. the unsubstantiality of all phenomena: "Void is the world ... because it is void of a self and anything belonging to a self" (sun~n~am attena va^ attaniyena va^; S. XXXV, 85); also stated of the 5 groups of existence (khandha, q.v.) in the same text. See also M. 43, M. 106. - In CNidd. (quoted in Vis.M. XXI, 55), it is said: "Eye ... mind, visual objects ... mind-objects, visual consciousness ... mind-consciousness, corporeality ... consciousness, etc., are void of self and anything belonging to a self; void of permanency and of anything lasting, eternal or immutable.. They are coreless: without a core of permanency, or core of happiness or core of self." - In M. 121, the voiding of the mind of the cankers, in the attainment of Arahatship, is regarded as the "fully purified and incomparably highest (concept of) voidness. - See Sn. v. 1119; M. 121; M. 122 (WHEEL 87); Pts.M. II: Sun~n~a-katha^; Vis.M. XXI, 53ff.   'contemplation of emptiness' (s. prec.), is one of the 18 chief kinds of insight (vipassana^, q.v.). Cf. Vis.M. XXI.  'emptiness-deliverance'; s. vimokkha.  s. ma^na.   lokuttara (q.v.);  faculties, s. indriya (20-22).   mahaggata (q.v.);  knowledges, s. abhin~n~a^.  (nissaya, upanissaya) are two of the 24 conditions (s. paccaya).  upatthambhaka-kamma; s. karma.  upapi^laka-kamma; s. karma.  "I take upon myself the vow to abstain from taking intoxicants and drugs such as wine, liquor, etc. since they lead to moral carelessness." This is the wording of the last of the 5 moral rules (s. sikkha^pada) binding on all Buddhists .   s. dhutanga.  'knowledge based on learning'; s. pan~n~a^.  'ovcrcoming by the opposite', is one of the 5 kinds of overcoming (paha^na, q.v.).  'registering consciousness' (s. Tab. I, 40-49, 56), is the last stage in the complete process of cognition (citta-vi^thi) immediately before sinking into the subconscious. It does not occur with the consciousness of the absorptions nor with supermundane consciousness, but only with large or distinct objects of the sensuous sphere. Cf. vin~n~a^na-kicca.   a^sava (q.v.).   low: tiraccha^na-katha^ (q.v.).   (lit. 'thirst'): 'craving', is the chief root of suffering, and of the ever-continuing cycle of rebirths. "What, o monks, is the origin of suffering? It is that craving which gives rise to ever-fresh rebirth and, bound up with pleasure and lust, now here, now there, finds ever fresh delight. It is the sensual craving (ka^ma-tanha^), the craving for existence (bhava-tanha^), the craving for non-existence (vibhava-tanha^)'' (D. 22). T. is the 8th link in the formula of the dependent origination (paticcasamuppa^da, q.v.). Cf. sacca.
Corresponding to the 6 sense-objects, there are 6 kinds of craving craving for visible objects, for sounds, odours, tastes, bodily impressions, mental impressions (rpa-, sadda-, gandha-, rasa-, photthabba-, dhamma-tanha^). (M. 9; D. 15)
Corresponding to the 3-fold existence, there are 3 kinds: craving for sensual existence (ka^ma-tanha^), for fine-material existence (rpa-tanha^), for immaterial existence (arpa-tanha^). (D. 33)
There are 18 'thought-channels of craving' (tanha^-vicarita) induced internally, and 18 induced externally; and as occurring in past, present and future, they total 108; see A. IV, 199; Vibh., Ch. 17 (Khuddakavatthu-Vibhanga).
According to the dependent origination, craving is conditioned by feeling; on this see D. 22 (section on the 2nd Truth).
Of craving for existence (bhava-tanha^ ) it is said (A. X, 62): "No first beginning of the craving for existence can be perceived, o monks, before which it was not and after which it came to be. But it can he perceived that craving for existence has its specific condition. I say, o monks, that also craving for existence has its condition that feeds it (sa^haram) and is not without it. And what is it? 'Ignorance', one has to reply." - Craving for existence and ignorance are called "the outstanding causes that lead to happy and unhappy destinies (courses of existence)" (s. Vis.M. XVII, 36-42).
The most frequent synonyms of tanha^ are ra^ga (q.v.) and lobha (s. mla).  'extinction of craving', is identical with 'extinction of cankers' (a^savakkhaya) and the attainment of perfect Holiness or Arahatship. Cf. ariya-puggala.  'morality based on craving' (s. nissaya).   the 'Perfect One', lit. the one who has 'thus gone', or 'thus come', is an epithet of the Buddha used by him when speaking of himself.
To the often asked questions, whether the Tatha^gata still exists after death, or not, it is said (e.g. S. XXII, 85, 86) that, in the highest sense (paramattha, q.v.) the Tatha^gata cannot, even at lifetime, be discovered, how much less after death, and that neither the 5 groups of existence (khandha, q.v.) are to be regarded as the Tatha^gata, nor can the Tatha^gata be found outside these corporeal and mental phenomena. The meaning intended here is that there exist only these ever-changing corporeal and mental phenomena, arising and vanishing from moment to moment, but no separate entity, no personality.
When the commentaries in this connection explain Tatha^gata by 'living being' (satta), they mean to say that here the questioners are using the merely conventional expression, Tatha^gata, in the sense of a really existing entity.
Cf. anatta^, paramattha, puggala, ji^va, satta.
A commentarial treatise on "The Meaning of the Word 'Tatha^gata' " is included in The All-Embracing Net of Views (Brahmaja^la Sutta), tr. Bhikkhu Bodhi (BPS).  the 'ten powers of the Perfect One'; s. dasa-bala.   'Suchness', designates the firmly fixed nature (bha^va) of all things whatever. The only passage in the Canon where the word occurs in this sense, is found in Kath. 186 (s. Guide, p. 83). On the Maha^yana term tathata^, s. Suzuki, Awakening of Faith, p. 53f. (App.).  'equanimity, equipoise, mental balance' (lit., 'remaining here and there in the middle'), is the name for a high ethical quality belonging to the sankha^ra-kkhandha (s. khandha) and is mostly known by the name upekkha^. In its widest sense it is associated with all pure consciousness (s. Tab. II). "Tatra-majjhattata^ is called the 'keeping in the middle of all things'. It has as charactcristic that it effects the balance of consciousness and mental factors; as nature (function; rasa), that it prevents excessiveness and deficiency, or that it puts an end to partiality; as manifestation, that it keeps the proper middle" (Vis.M. XIV). (App.).   'the Thirty-thrce (Gods)', a class of heavenly beings in the sensuous sphere; s. deva (I).  'practice of the three-rober', is one of the ascetical means for purificaton (dhutanga, q.v.).  'fire-element, heat-element'; s. dha^tu.  'fire-kasina', is one of the 10 kasina exercises; s. kasina.   utu (q.v.). - For corporeality produced by temperature, s. samuttha^na.   anusaya (q.v.).   awareness of: one of the insight-knowledges; s. visuddhi VI. 3.  'one endowed with the threefold (higher) knowledge'. In Brahmanism means 'knower of the 3 Vedas' ( tri-vidya^), in Buddhism means one who has realised 3 kinds of knowledge, to wit: remembrance of former rebirths, the divine eye, extinction of all cankers. For details, s. abhin~n~a^, 4-6. Cf. Tevijja^ Sutta, D. 13 (WHEEL 57/58).   'Doctrine of the Elders', is a name of the oldest form of the Buddha's teachings, handed down to us in the Pa^li language. According to tradition, its name is derived from the fact of having been fixed by 500 holy Elders of the Order, soon after the death of the Master.
Therava^da is the only one of the old schools of Buddhism that has survived among those which Maha^ya^nists have called 'Hinaya^na'. It is sometimes called Southern Buddhism or Pa^li Buddhism. It is found today in Sri Lanka, Burma, Thailand, Cambodia, Laos and Chittagong (East Bengal. ) - Cf. Guide, p. 60. - (App.). thi^na middha: 'sloth and torpor', constitute the 3rd of the 5 hindrances (ni^varana, q.v.). They may or may not, be associated with greedy consciousness (s. Tab. 23. 25, 27, 29 and II).   wisdom based on: cinta^mayapan~n~a^: s. pan~n~a^.  'static morality, static concentration, static wisdom'; s. ha^na-bha^giya-si^la.  s. vitakka.   Right: samma^-sankappa; .s. sacca, magga.   the 4: gantha (q.v.).  s. patisandhi.  the '3 charactcristies of existence', or signata, are impermanency (anicca, q.v.), suffcring or misery (dukkha, q.v.; s. sacca, dukkhata^), not-self (anatta^, q.v.).
"Whether Perfect Ones appear in the world, or whether Perfect Ones do not appear in the world, it still remains a firm condition, an immutable fact and fixed law: that all formations are impermanent, that all formations are subject to suffering, that everything is without a self'' (A. III, 134).
"What do you think, o monks: Is corporeality (rpa) permanent or impermanent? - Impermanent, o Venerable One. - Are feeling (vedana^), perception (san~n~a^), mental formations (sankha^ra) and consciousness (vin~n~a^na), permanent or impermanent? - Impermanent, o Venerable One.
"But that which is impermanent, is it something pleasant or painful? - It is painful, o Venerable One.
"But, of what is impermanent, painful and subject to change, could it be rightly said, 'This belongs to me, this am I, this is my ego'? - No, Venerable One.
"'I'herefore, whatever there is of corporeality, feeling, perception, mental formations and consciousness, whether past, present or future, one's own or external, gross or subtle, lofty or low, far or near, of all these things one should understand, according to reality and true wisdom: 'This does not belong to me, this am I not, this is not my ego' " (S. XXII, 59).
"In one who understands eye, ear, nose, tongue, body and all the remaining formations as impermanent, painful and not-self, in him the fetters (samyojana, q.v.) are dissolved" (S. XXXV, 53).
It is the full comprehension of the 3 characteristics by direct meditative experience which constitutes liberating insight. About their relation to the three gateways ot liberation', s. vimokkha I .
For further details, s. anicca, dukkha, anatta^, vipassana^.
Literature: The Three Signata, by Prof. O. H. de A. Wijesekera (WHEEL 20). - The Three Basic Facts of Existence: I-III (WHEEL BPS), Vis.M. XX, 13ff. 18ff; XXI, 47f, 67f.  ' T he Three Bascets', is the name for the 3 main divisions of the Pa^li Canon: the Basket of Discipline (Vinaya Pitaka), the Basket of Discourses (Sutta Pitaka) and the Basket ot Philosophy (Abhidhamma Pitaka).  'low talk', lit. 'beastly talk', is the name in the sutta-texts for the following: "Talk about kings and robbers, ministers and armies, danger and war, eating and drinking, clothes and dwellings, garlands and scents, relations, chariots, villages and markets, towns and districts, women and heroes, street talks, talks by the well, talk about those departed in days gone by, tittle-tattle, talks about world and sea, about gain and loss" (A.X, 69 etc.).
In the commentaries 4 further kinds are enumerated, thus bringing the number to 32, as mostly counted, namely: talk about sensuous enjoyment, self-mortification, eternity and self-annihilation.  'animal womb'; birth as animal. The animal kingdom belongs to the sensuous world (s. loka), is one of the 4 lower worlds (s. apa^ya) and one of the 3 woeful courses of existence (s. gati).  'full understanding by investigating'; s. parin~n~a^.  'Three Jewels' or Three Gems, which by all Buddhists are revered as the most venerable things, are the Buddha, the Dhamma and the Holy Sangha.' i.e.: the Enlightened One; the law of deliverance discovered, realized and proclaimed by him; and the Community of Holy Disciples and those who live in accordance with the Law. - The contemplations of the 3 Jewels belong to the 10 contemplations (anussati q.v.).  'Threefold Refuge', in which every faithful adherent of the Buddha puts his whole trust, consists in the Buddha, the Dhamma and the Sangha (s. prec.).
The Buddha, or Enlightened One, is the teacher who by himself has discovered, realized and proclaimed to the world the law of deliverance. The Dhamma is the law of deliverance. The Sangha is the community of the disciples, who have realized or are striving to realize the law of deliverance.
The 3-fold Refuge in Pa^li, by the uttering of which one may also outwardly profess one's faith, is still the same as in the Buddha's time, namely:
 
Buddham saranam gaccha^mi
Dhammam saranam gaccha^mi
Sangham saranam gaccha^mi
 
I take my refuge in the Buddha!
I take my refuge in the Dhamma!
I take my refuge in the Sangha!
 
Literature: The Threefold Refuge by Nyanaponika Thera (WHEEL 76). - Devotion in Buddhism (WHEEL 18). Going for Refuge, by Bhikkhu Bodhi (WHEEL 282/284) - Khp. Tr. pp. 4ff.   the 3 'articles of (heretical) belief'. which in A. III, 61 are declared as leading to inactivity, are: (1) the belief that all happiness and woe are produced through former karma (prenatal actions; s. karma); (2) that everything is uncaused; (3) that everything is created by God.
(1) is the teaching of Niggantha-Na^thaputta, the leader of the Nigganthas, the modern Jains. The fault with this doctrine is that it does not account for that happiness and woe which either are the result of the present life's good or bad action, or are associated with the corresponding action. (2) is the doctrine of Makkhali Gosa^la; s. ditthi.
According to the above 3 doctrines, man is not responsible for his actions, so that all moral exertions become useless.   thi^na, s. thi^na-middha (q.v.).   the 3-fold: sikkha^ (q.v.). - The steps of: sikkha^pada, (q.v.).   jha^na (q.v.).  (of mind): s. samatha, samatha-vipassana^, bha^vana^, bojjhanga. - 'One who has taken t. as his vehicle': samathaya^nika (q.v.).   Overcoming (of defilements) by way of: s. paha^na.  patti-da^na (q.v.).   power of: s. iddhi.   anicca (q.v.).   the 7: s. dhana (q.v.).   Living under a tree is one of the ascetical practices (dhutanga, q.v.).   the 4 Noble: sacca (q.v.). - 2-fold knowledge of the t.; s. saccan~a^na.  away, contemplation of the: vivattanupassana^; s. vipassana^.   a class of heavenly beings in the sensuous plane; s. deva (1).  yamaka-pa^tiha^riya (q.v.).  the 'both-ways-liberated one', is the name of one class of noble disciples (ariya-puggala, q.v.). He is liberated in 2 ways, namely, by way of all 8 absorptions (jha^na, q.v.) as well as by the supermundane path (sota^patti, etc.) based on insight (vipassana^, q.v.). In M. 70 it is said:
''Who, o monks, is a both-ways-liberated one'? If someone in his own person has reached the 8 liberations (absorptions), and through wise penetration the cankers (a^sava, q.v.) have become extinguished, such a one is called a both-ways-liberated one.'' Cf. D. 15.
In the widest sense, one is both-ways-liberated if one has reached one or the other of the absorptions, and one or the other of the supermundane paths (cf. A. IX, 44).
The first liberation is also called 'liberation of mind' (cetovimutti), the latter liberation through wisdom' (pan~n~a^-vimutti).
The first liberation, however, is merely temporary, being a liberation through repression (vikkhambhana-vimutti = vikkhambhana-paha^na: s. paha^na).  'annihilation-view'; s. ditthi.  'knowledge consisting in the contemplation of rise and fall', is the first of the 9 insight-knowledges constituting the purification by knowledge and vision of the path-progress'. For details, s. visuddhi, VI. 1.   'restlessness', belongs to the 10 fetters (samyojana, q.v.), and to the 5 hindrances (ni^varana, q.v.). It is one of those 4 mental factors inseparably associated with all unwholesome consciousness (akusala-sa^dha^rana, q.v.). Cf. Tab. II.  the 5 'higher fetters'; s. samyojana.  'passing upstream to the highest gods', is one of the 5 kinds of Non-returners (ana^ga^mi^, q.v.).  s. nimitta.   'one who already during a given explanation comes to penetrate the truth' (Pug.). This is one of four types of persons classified according to their ability of acquiring insight, mentioned in A. IV, 133. Cf. also vipacitan~n~u, neyya, pada-parama. See The Requisites of Enlightenment, by Ledi Sayadaw (WHEEL 171/174) p. 1ff.   (ka^ya-, citta- ): 'uprightness' (of mental factors and of consciousness), is associated with all pure consciousness. Cf. Tab. II.   the: asankhata (q.v.). - Contemplation of the u. (= animitta); s. vipassana^.  asan~n~a^-satta (q.v.).   s. ditthi, n~a^na, pan~n~a^, parin~n~a^. - Right u., s. magga (1). sacca (IV.1).   s. kala^pa, rpa-kala^pa.   unprompted: s. asankha^rika-citta.  s. cetto-vimutti.  one, the: akuppa-dhamma (q.v.).  things, the 4: acinteyya (q.v.).   karmically: akusala (q.v.).   'moment of access'; s. javana.  'neighbourhood or access-concentrationn', is the degree of concentration just before entering any of the absorptions, or jha^nas. It still belongs to the sensuous sphere (ka^ma^vacara; s. avacara).   rpassa: 'growth of corporeality'; s. khandha I; App.  'destructive karma'; s. karma.   'clinging', according to Vis.M. XVII, is an intensified degree of craving (tanha^, q.v.). The 4 kinds of clinging are: sensuous clinging (ka^mupa^da^na), clinging to views (ditthupa^da^na), clinging to mere rules and ritual (si^labbatupa^da^na), clinging to the personaljty-belief (atta-va^dupa^da^na).
(1) "What now is the sensuous clinging? Whatever with regard to sensuous objects there exists of sensuous lust, sensuous desire, sensuous attachment, sensuous passion, sensuous deludedness, sensuous fetters: this is called sensuous clinging.
(2) ''What is the clinging to views? 'Alms and offerings are useless; there is no fruit and result for good and bad deeds: all such view and wrong conceptions are called the clinging to views.
(3) "What is the clinging to mere rules and ritual? The holding firmly to the view that through mere rules and ritual one may reach purification: this is called the clinging to mere rules and ritual.
(4) "What is the clinging to the personality-belief? The 20 kinds of ego-views with regard to the groups of existence (s. sakka^ya-ditthi): these are called the clinging to the personality-belief" (Dhs. 1214-17).
This traditional fourfold division of clinging is not quite satisfactory. Besides kamupa^da^na we should expect either rpupa^da^na and arpupa^da^na, or simply bhavupa^da^na. Though the Ana^ga^mi^ is entirely free from the traditional 4 kinds of upa^da^na, he is not freed from rebirth, as he still possesses bhavupa^da^na. The Com. to Vis.M. XVII, in trying to get out of this dilemma, explains ka^mupa^da^na as including here all the remaining kinds of clinging.
"Clinging' is the common rendering for u., though 'grasping' would come closer to the literal meaning of it, which is 'uptake'; s. Three Cardinal Discourses (WHEEL 17), p.19.  the 5 'groups of clinging', or more clearly stated in accordance with Vis.M., 'the 5 groups of existence which form the objects of clinging'. Cf. M. 44, and see khandha.  'derived corporeality', signifies the 24 secondary corporeal phenomena dependent on the 4 primary physical elements, i.e. the sense-organs and sense-objects, etc. See khandha I; App.   'substratum of existence'. In the Com. there are enumerated 4 kinds: the 5 groups (khandha, q.v.), sensuous desire (ka^ma), mental defilements (kilesa, q.v.), karma (q.v.). In the suttas it occurs frequently in Sn. (vv. 33, 364, 546, 728), and, with reference to Nibba^na, in the phrase "the abandoning of all substrata" (sabbpadhi-patinissagga; D. 14). See viveka (3).   lit. 'something which one grasps, to which one clings, i.e. the 5 groups of existence (khandha, q.v.). In the suttas, the word is mostly used in such expressions as "One of the 2 fruits may be expected: either perfect wisdom or, if the groups are still remaining (sati upa^di-sese, 'if there is a remainder of groups ), Ana^ga^mi^ship" (D. 22). Further (A. IV. 118): "Here the Perfect One has passed into the Nibba^na-element in which no more groups are remaining (anupa^di-sesa)." Cf. nibba^na. upa^dinna rpa: 'karmically acquired corporeality', or 'matter clung-to (by karma)', is identical with karma-produced corporeality (kammaja-rpa; s. samuttha^na). In Vis.M. XIV it is said: "That corporcality which, later on, we shall refer to as 'karma-produced' (kammaja), is, for its being dependent on previous (pre-natal) karma, called 'karmically acquired'. '' The term (upa^dinna) occurs so in the suttas, e.g. M. 28 (WHEEL 101), 62, 140. See Dhs. 990; Khandha Vibh.  'destructive karma'; s. karma.  'one who reaches Nibba^na within the first half of life', is one of the 5 kinds of Ana^ga^mi^ (q.v.).   'impurities', corruptions, imperfections (a frequent rendering by 'defilements' is better reserved for kilesa, q.v.).
A list of 16 moral 'impurities of the mind' (cittassa upakkilesa) is mentioned and explained in M. 7 & 8 (WHEEI. 61/62): 1. covetousness and unrighteous greed (abhijjha^-visamalobha), 2. ill will (vya^pa^da), 3. anger (kodha), 4. hostility (upana^ha), 5. denigration (makkha), 6. domineering (pala^sa), 7. envy (issa^), 8. stinginess (macchariya), 9. hypocrisy (ma^ya^), 10. fraud (sa^theyya), 11. obstinacy (thambha), 12. presumption (sa^rambha), 13. conceit (ma^na), 14. arrogance (atima^na), 15. vanity (mada), 16. negligence (pama^da).
There are 3 groups of upakkilesa pertaining to meditation:
(a) 9 mental imperfections occurring in 'one devoted to higher mental training' (adhicitta); 3 coarse ones - evil conduct in deeds, words and thoughts; 3 medium - thoughts of sensual desire, ill will and cruelty; 3 subtle - thoughts about one's relatives, one's country and one's reputation (A. III, 100).
(b) 18 imperfections in the practice of mindfulness of breathing (a^na^pa^na-sati, q.v.), mentioned in Pts.M., a^na^pa^na-katha^ (tr. in Mindfulness of Breathing, by n~a^namoli Thera (p. 60; BPS).
(c) 10 'imperfections of insight' (-meditation, vipassanpakkilesa); s. visuddhi V.  'decisive support' or 'inducement', is one of the 24 conditions (paccaya, q.v.).  'karma ripening in the next birth'; s. karma.  'rebirth-process'; s. bhava.  'suppressive kamma'; s. karma.   lit. 'sitting close by', i.e. a 'lay adherent', is any lay follower who is filled with faith and has taken refuge in the Buddha, his doctrine and his community of noble disciples (A. VIII, 25). His virtue is regarded as pure if he observes the 5 Precepts (pan~ca-si^la; s. sikkha^pada). He should avoid the following wrong ways of livelihood: trading in arms, in living beings, meat, alcohol and poison (A. V, 177). See also A. VIII, 75.   'recollection of the peace of Nibba^na', is the last of the 10 recollections (anussati, q.v.). "Whatsoever, o monks, there are of things, as highest of them is considered detachment (vira^ga), i.e. the crushing of conceit, the stilling of thirst, the uprooting of clinging, the breaking through the round of rebirths, cessation of craving, detachment, extinction, Nibba^na" (A. IV, 34).   'female adherent'; s. upa^saka.  'supportive karma'; s. karma.   s. manopavica^ra.   'equanimity', also called tatra-majjhattata^ (q.v.), is an ethical quality belonging to the sankha^ra-group (s. khandha) and should therefore not be confounded with indifferent feeling (adukkha-m-asukha^ vedana^) which sometimes also is called upekkha^ (s. vedana^).
upekkha^ is one of the 4 sublime abodes (brahma-viha^ra, q.v.), and of the factors of enlightenment (bojjhanga, q.v.). See Vis.M. IV, 156ff.  n~a^na = sankha^rupekkha^-n~a^na (q.v.).  'equanimity as factor of enlightenment'; s. bojjhanga.  'equanimous happiness,' is the feeling of happiness accompanied by a high degree of equanimity (upekkha^) as, e.g. in the 3rd absorption (jha^na q.v.).  s. vedana^.   the 'faculty of indifference', is one of the 5 elements of feeling (M. 115) and therefore not to be confounded with the ethical quality 'equanimity', also called upekkha^ (q.v.).   'indulging in indifference'; s. manopavica^ra.   lit. 'fasting', i.e. 'fasting day', is the full-moon day, the new-moon day, and the two days of the first and last moonquarters. On full-moon and new-moon days, the Disciplinary Code, the Pa^timokkha, is read before the assembled community of monks (bhikkhu), while on the mentioned 4 moon-days many of the faithful lay devotees go to visit the monasteries, and there take upon themselves the observance of the 8 rules (attha-si^la; sikkha^pada). See A. VIII, 41ff.   ujukata^ q.v.  to the highest gods, passing: s. ana^ga^mi^.   the 4 noble: ariya-vamsa (q.v.).   temperature, heat, is identical with the heat-element (tejodha^tu, q.v.).  samuttha^na (- utuja)-rpa: 'corporeality produced by temperature'; s. samuttha^na.   'speech'. On right sp., s. magga (3), sacca (IV.3). - Low talk, s. tiraccha^na-katha^.  'verbal action'; s. karma, kamma-patha.  'verbal karma-formation', or 'verbal function'.
(1) For verbal karma-formation, s. sankha^ra (I. 1).
(2) For verbal function (of mind), i.e. thought-conception and discursive thinking, s. sankha^ra (I. 2).  s. vin~n~atti.   Contemplation of: vaya^nupassana^, is one of the 18 chief kinds of insight (vipassa^na, q.v.).  knowledge of the v. and r. of beings according to karma, is identical with the divine eye (s. abhin~n~a^ 5).  'morality consisting in avoiding' (evil things), as distinguished from 'morality consisting in performing' (good things). See caritta-varitta.   'mastery'. Vis.M. IV speaks of 5 kinds of m., which anyone who wishes to develop the absorptions (jha^na, q.v.) should acquire first of all, with regard to the 1st absorption, namely: mastery in adverting to it (a^vajjana-vasi^), in entering it (sama^pajjana-vasi^), in determining it (adhittha^na-vasi^), in rising therefrom (vuttha^na-vasi^), in retrospection (paccavekkhana-vasi^). - (App.).
"If wherever, whenever, and for whatever duration desired, one enters the 1st absorption, and at one's entering it, no slowness is experienced, this is called mastery in entering the absorption, etc. In an analogous way, the 4 remaining kinds are to be explained" (Vis.M. IV, 131f; XXIII, 27ff.).   1. 'round', 2. 'round of rebirths'.
(1) With reference to the dependent origination (paticcasamuppa^da, q.v.), Vis.M. XVII speaks of 3 rounds: the karma round (kamma-vatta) comprising the karma-formations and the karmaprocess (2nd and 10th links); the round of defilements (kilesa-vatta) comprising ignorance, craving and clinging (1st, 8th and 9th links); the round of results (vipa^ka-vatta) comprising consciousness, mind and corporeality, 6 bases, impression, feeling (3rd-7th links). Cf. paticcasamuppa^da (diagram).
(2) round of rebirth = samsa^ra (q.v.).   'physical base', i.e. the 6 physical organs on which the mental process is based, are the 5 physical sense-organs and, according to the Com., the heart (hadaya-vatthu, q.v.) as the 6th. This 6th vatthu must not be confounded with the 6th a^yatana, which is a collective name for all consciousness whatever. - (App.).  'objective sensuality', the 5 sense-objects; s. ka^ma.   'determining', defining. In its application to insight meditation, this term occurred first in Pts.M. (I, p. 53); but in a verbal form, as a past participle, already in M. 111: tyassa dhamma^ anupada-vavatthita^ honti, "these things (the mental factors) were determined by him (i.e. Sa^riputta) successively" (s. Abh. St., p. 54). In Vis.M. XX, 130, it is said: 'The determining of the truth of suffering is effected with the determining of mind-and-body in the purification of view (s. visuddhi III). The determining of the truth of origination is effected with the discerning of conditions in the purification by transcending doubt (s. visuddhi IV). The determining of the truth of the path is effected by emphasis on the right path in the purification by knowledge and vision of what is path and not-path (s. visuddhi V). Thus the determining of the 3 truths (suffering, origin, path) has been first effected by means of mundane (lokiya, q.v.) knowledge only." - See sammasana, visuddhi.
For the determining of the 4 physical elements, s. dha^tuvavattha^na.   'contemplation of vanishing', is one of the 18 chief kinds of insight (vipassana^, q.v.).  'wind-element'; s. dha^tu.  kasina 'wind-kasina', is one of the kasina exercises (kasina, q.v.).   'feeling', sensation, is the 2nd of the 5 groups of existence (s. khandha II). According to its nature, it may be divided into 5 classes: (1) bodily agreeable feeling (ka^yika^ sukha^-vedana^ = sukha); (2) bodily disagreeable feeling (ka^yika^ dukkha^-vedana^ = dukkha^); (3) mentally agreeable feeling (cetasika^ sukha^-vedana^ = somanassa); (4) mentally disagreeable feeling (cetasika^ dukkha^-vedana^ = domanassa); (5) indifferent or neutral (adukkha-m-asukha^ vedana^ = upekkha^, q.v.).
With regard to the 6 senses, one distinguishes 6 kinds of feeling: feeling associated with seeing, hearing, smelling, tasting, bodily impression and mental impression. The textual wording of it is 'feeling arisen through visual contact' (cakkhu-samphassaja^ vedana^; S. XXII, 55; D. 22), etc.
Feeling is one of the 7 mental factors inseparably associated with all consciousness whatever, s. na^ma. In the formula of the dependent origination (paticcasamuppa^da, q.v.), feeling is the condition for the arising of craving (tanha^). The above-mentioned 5 kinds of feeling are enumerated amongst the 22 faculties (indriya, q.v.). - See M. 59; Contemplation of Feeling (Vedana^ Samyutta), by Nyanaponika Thera (WHEEL 303/304).   'contemplation of feeling', is one of the 4 foundations of mindfulness (satipattha^na q.v.).  is the name of a class of heavenly beings in the fine-material world; s. deva.  vaci^-kamma; s. karma.  vaci^-sankha^ra; s. sankha^ra.   'self-confidence' of a Buddha is fourfold. He is confident: 1. to have attained to a perfect Enlightenment of which it cannot be said that it omits anything essential to it; 2. to have destroyed all cankers (a^sava), leaving none that can be said to be undestroyed by him; 3. that what were declared by him as obstacles to liberation are undeniably such; 4. that his teaching fulfils its purpose of actually leading to final liberation from suffering. See A. IV, 8; VII, 58; M. 12.  'analytical or discriminating doctrine' is an early name for the original Buddha doctrine, called Therava^da. - The term vibhajja-va^di^ occurs in M. 99 and A. X, 94, though not in the sense of a separate school, but as a characteristic of the Buddha himself: "Now, by blaming what is blamable and praising what is praiseworthy, the Blessed One is a 'discriminating teacher' (vibhajja-vadi^) and is not one-sided in his teaching" (A. X, 94).
Buddhaghosa, in the introduction to his Com. on the Katha^vatthu, says that in Asoka's time, when the Sangha prospered, many heretics took ordination as Buddhist monks but continued to spread their wrong doctrines. For purifying the Sangha, Asoka, together with the venerable Moggaliputtatissa, summoned assembly of the bhikkhus. When each of the assembled was individually questioned by the king about what the Buddha taught, those who said that he was an eternalist (sassata-vadi^), etc. were expelled. The genuine bhikkhus replied that the Buddha was a vibhajja-vadi^, an 'analyst' or 'discriminating teacher'; and when, on the king's question, Moggaliputtatissa confirmed that this was the correct view, those monks were admitted to the Uposatha (q.v.) assembly of the Sangha, and from their midst the participants of the 3rd Council at Pataliputta were selected. - See Maha^vamsa, tr. by Wilh. Geiger, Ch. V, v. 268f.  ditthi = uccheda-ditthi; s. ditthi.  'craving for non-existence', or for self-annihilation; s. tanha^.   'discursive thinking'; s. vitakka-vica^ra.   'sceptical doubt', is one of the 5 mental hindrances (ni^varana, q.v.) and one of the 3 fetters (samyojana, q.v.), which disappear for ever at Stream-entry, the first stage of holiness (s. ariya-puggala). As a fetter, it refers to sceptical doubt about the Master (the Buddha), the Teaching, the Sangha, and the training; about things past and future, and conditionality (Dhs. 1004; cf. A . X, 71 ) . It also applies to uncertainty whether things are wholesome or not, to be practised or not, of high or low value, etc. According to Vis.M. XIV, 177, vicikiccha^ is the lack of desire to think (things out i.e. to come to a conclusion; vigata-cikiccha^, desiderative to ? cit, to think); it has the nature of wavering, and its manifestation is indecision and a divided attitude; its proximate cause is unwise attention to matters of doubt. It is associated with one of the 2 classes of unwholesome consciousness rooted in delusion (Tab. I, No. 32). - See also kankha^.   right: samma^-ditthi; s. ditthi, magga 1, sacca IV, 1. - For wrong view, s. ditthi.  'disappearance', is one of the 24 conditions (paccaya, q.v.).   'abode' There are 3 abodes: the heavenly abode (dibba-viha^ra), the divine abode (brahma-viha^ra, q.v.), the noble abode (ariya-viha^ra). See A. III, 63; D. 33.   '(higher) knowledge', gnosis. For the 3-fold k., s. abhin~n~a^ and te-vijja^. Cf. foll.  knowledge and conduct'. This expression occurs in those passages in the suttas where the qualities of a Buddha are described, namely: Truly, the Blessed One is holy, is fully enlightened, perfect in knowledge and conduct..." According to Vis.M. VII, 1 and D. 3, knowledge (vijja^) refers here either to the 3-fold knowledge (s. te-vijja^), or to the 8 kinds of knowledge, namely: the 6 higher spiritual powers (abhin~n~a^, q.v.), insight (vipassana^, q.v.), and magical power (iddhi, q.v.); whilst conduct (carana) refers to 15 things: moral restraint, watching over the sense-doors, moderation in eating, wakefulness, faith, moral shame, moral dread, great learning, energy, mindfulness, wisdom and the 4 absorptions.  'overcoming by repression' (or 'suspension'), is one of the 5 kinds of overcoming (paha^na, q.v.).  the 'power of transformation', is one of the magical faculties (iddhi, q.v.).   'investigation, inquiry, pondering', is one of the 4 roads to power (iddhi-pa^da, q.v.) and one of the 4 factors of predominance (s. paccaya, 3).   'liberation' (deliverance). I. the 3; II. the 8.
I. The 3 liberations are: 1. the conditionless (or signless) liberation (animitta-v.), 2. the desireless liberation (apanihita-v.), 3. the emptiness (or void) liberation (sun~n~ata^-v. ). They are also called 'the triple gateway to liberation' (vimokkha-mukha; Vis.M. XXI, 66ff), as they are three different approaches to the paths of holiness. - See visuddhi VI, 8. Cf. Vis XXI, 6ff, 121ff; Pts.M. II. Vimokkha-Katha^.
1. "Whosoever being filled with determination (adhimokkha, q.v.), considers all formations as impermanent (anicca), such a one attains the conditionless liberation. 2. Whosoever being filled with tranquillity, considers all formations as painful (dukkha), such a one attains the desireless liberation. 3. Whosoever being filled with wisdom, considers all formations as without a self (anatta^), such a one attains the emptiness liberation" (Vis.M. XXI, 70 = Pts.M. II, p. 58).
(1) and (2) are mentioned and explained in M. 43, under the name of deliverances of mind (ceto-vimutti, q.v.). - (2) and (3) appear in Dhs. (344ff, 353ff) in the section on supermundane consciousness (see Atthasa^lini Tr., p. 299ff).
II. The 8 liberations (attha vimokkha) occur frequently in the texts (A. VIII, 66; D. 16, etc.) and are described as follows:
"There are 8 liberations, o monks. Which are these?
(1) ''Whilst remaining in the fine-material sphere (rpi^), one perceives corporeal forms: this is the first liberation.
(2) "Not perceiving corporcal forms on one's own person, one perceives corporcal forms externally: this is the 2nd liberation.
(3) ''By thinking of the beautiful, one is filled with confidence: this is the 3rd liberation.
(4) "Through the total ovcrcoming of the corporeality-perceptions, the vanishing of the reflex-perceptions, and the non-attention to the multiformity-perceptions, with the idea 'Unbounded is space', one reaches the sphere of unbounded space (a^ka^sa^nan~ca^yatana) and abides therein: this is the 4th liberation.
(5) "Through the total ovcrcoming of the sphere of unbounded space, and with the idea 'Unbounded is consciousness', one reaches the sphere of unbounded consciousness (vin~n~a^nan~ca^yatana) and abides therein: this is the 5th liberation.
(6) "Through the total overcoming of the sphere of unbounded consciousness, and with the idea 'Nothing is there', one reaches the sphere of nothingness (a^kin~ean~n~a^yatana) and abides therein: this is the 6th liberation.
(7) "Through the total overcoming of the sphere of nothingness, one reaches the sphere of neither-perception-nor-non-perception (n'eva-san~n~a^-na^san~n~a^yatana) and abides therein: this is the 7th liberation .
(8) "Through the total overcoming of the sphere of neither-perception-nor-non-perception, one reaches the extinction of perception and feeling (s. nirodha-sama^patti): this is the 8th liberation.
These, o monks, are the 8 kinds of liberation."
For (1-3), s. abhibha^yatana; for (4-7), s. jha^na; for (8), s. nirodha-sama^patti.
By (3) is meant the attainment of the fine-material absorptions (jha^na, q.v.) by means of concentrating the mind on perfectly pure and bright colours as objects of the kasina (q.v.). According to Pts.M. this mental state is produced also by concentrating the mind on the 4 sublime states, i.e. all-embracing kindness, compassion, sympathetic joy and equanimity, in consequence of which allbeings appear perfectly pure and glorified, and thus the mind turns to the beautiful.
See Pts.M. II, Vimokkha-katha^; Atthasa^lini Tr., p. 255; App.   'deliverance', is of 2 kinds: deliverance of mind (ceto-vimutti, q.v.) and deliverance through wisdom (pan~n~a^-vimutti, q.v.).
'Deliverance of mind', in the highest sense, is that kind of concentration (sama^dhi) which is bound up with the path of Arahatship (arahatta-magga); 'deliverance through wisdom' is the knowledge (n~a^na) bound up with the fruition of Arahatship (arahatta-phala). Cf. A. V, 142.
There are also 5 kinds of deliverance, identical with the 5 kinds of overcoming (paha^na, q.v.).   'world of suffering', is another name for the 4 woeful courses (duggati; s. gati) of existence, and for the 4 lower worlds (apa^ya, q.v.).
The Stream-Winner (sota^panna, q.v.) is no longer subject to rebirth in them (avinipa^ta-dhamma).   'consciousness', is one of the 5 groups of existence (aggregates; khandha, q.v.); one of the 4 nutriments (a^ha^ra, q.v.); the 3rd link of the dependent origination (paticcasamuppa^da, q.v.); the 5th in the sixfold division of elements (dha^tu, q.v.).
Viewed as one of the 5 groups (khandha), it is inseparably linked with the 3 other mental groups (feeling, perception and formations) and furnishes the bare cognition of the object, while the other 3 contribute more specific functions. Its ethical and karmic character, and its greater or lesser degree of intensity and clarity, are chiefly determined by the mental formations associated with it.
Just like the other groups of existence, consciousness is a flux (vin~n~a^na-sota^, 'stream of c.') and does not constitute an abiding mind-substance; nor is it a transmigrating entity or soul. The 3 characteristies (s. ti-lakkhana), impermanence, suffering and no-self, are frequently applied to it in the texts (e.g., in the Anattalakkhana Sutta, S.XXII, 59). The Buddha often stressed that "apart from conditions, there is no arising of consciousness' (M 38); and all these statements about its nature hold good for the entire range of consciousness, be it "past, future or presently arisen, gross or subtle, in oneself or external, inferior or lofty, far or near" (S. XXII, 59).
According to the 6 senses it divides into 6 kinds, viz. eye- (or visual) consciousness (cakkhu-v.), etc. About the dependent arising of these 6 kinds of consciousness, Vis.M. XV, 39 says: 'Conditioned through the eye, the visible object, light and attention, eye-consciousness arises. Conditioned through the ear, the audible object, the ear-passage and attention, ear-consciousness arises. Conditioned, through the nose, the olfactive object, air and attention, nose-consciousness arises. Conditioned through the tongue, the gustative object, humidity and attention, tongue-consciousness arises. Condlitioned through the body, bodily impression, the earth-element and attention, body-consciousness arises. Conditioned through the subconscious mind (bhavanga-mano), the mind-object and attention, mind-consciousness arises."
The Abhidhamma literature distinguishes 89 crasses of consciousness, being either karmically wholesome, unwholesome or neutral, and belonging either to the sense-sphere, the fine-material or the immaterial sphere, or to supermundane consciousness. See Table I.  'functions of consciousness', as exercised within a process of consciousness or cognitive series (cittavi^thi). In the Abhidhamma Com. and Vis.M. XIV the following functions are mentioned: rebirth (patisandhi), subconsciousness (bhavanga), advertence (a^vajjana), seeing, hearing, smelling, tasting, body-consciousness; recciving (sampaticchana), investigating (santi^rana), determining (votthapana), impulsion (javana), registering (tada^rammana), dying (cuti).
A single unit of sense-perception (e.g. visual consciousness), being conditioned through a sense-organ and its corresponding object, forms in reality an extremely complex process, in which all the single phases of consciousness follow one upon another in rapid succession, while performing their respective functions, e.g.:
"As soon as a visible object has entered the range of vision, it acts on the sensitive eye-organ (cakkhu-pasa^da), and conditioned thereby an excitation of the subconscious stream (bhavanga-sota) takes place.
"As soon, however, as subconsciousness is broken off, the functional mind-element (s. Tab. I, 70), grasping the object and breaking through the subconscious stream, performs the function of 'adverting' the mind towards the object (a^vajjana).
"Immediately thereupon there arises at the eye-door, and based on the sensitive eye-organ, the eye-consciousness, while performing the function of 'seeing' (dassana).... Immediately thereafter there arises the mind-element (Tab
I, 39, 55) performing the function of 'receiving' (sampaticchana) the object of that consciousness....
''Immediately thereafter there arises... the mind-consciousness-element (Tab. I, 40, 41, 56), while 'investigating' (santirana) the object received by the mind-element...
"Immediately thereafter there arises the functional, rootless mind-consciousness-element (Tab. I, 71), accompanied by indifference, while performing the function of 'determining' (votthapana) the object......
"Now, if the object is large, then immediately afterwards there flash forth 6 or 7 'impulsive moments' (javana-citta), constituted by one of the 8 wholesome, or 12 unwholesome, or 9 functional classes of consciousness (Tab. I, 1-8; 22-23; 72-80).
''Now, if at the end of the impulsive moments, the object at the five-sense doors is very large, and at the mind-door clear, then there arises, once or twice, one of the 8 root-accompanied, karma-resultant classes of consciousness (Tab. I, 42-49) of the sense-sphere, or one of the 3 rootless karma-resultant mind-consciousness-elements (Tab. I, 40, 41, 56).... Because this consciousness after the vanishing of the impulsive moments, possesses the faculty continuing with the object of the subconsciousness, taking the object of the subconsciousness as its own object, therefore it is called 'registering' (tada^rarmmana, lit. 'that object', or 'having that as object')" (Vis.M. XIV, 115ff).
If, however, the sense-object is weak, then it reaches merely the stage of 'impulsion' (javana), or of 'determining' (votthapana); if very weak, only an excitation ot the subconsciousness takes place.
The proeess of the inner or mind-consciousness, i.e. without participation of the 5 physical senses, is as follows: in the case that the mind-objeet entering the mind-door is distinct, then it passes through the stages of 'advertence at the mind-door' (manodva^ra^vajjana), the 'impulsive stage' and the 'registering stage', before finally sinking into the subconscious stream. - (App.: citta-vi^thi).
Literature: Aids to the Abhidhamma Philosophy, by Dr. C.B Dharmasena (with colour chart of the Cognitive Series; WHEEL 63/64). - The Psychology and Philosophy of Buddhism, by Dr. W. F. Javasuriya (Buddhist Missionary Socy., Kuala Lumpur, Malaysia).   'sphere of boundless consciousn is a name for the 2nd meditiative absorption in the immateria sphere (s. jha^na, 6).  'abodes or supports of consciousness'. The texts describe 7 such abodes (e.g. A. VII, 41):
(1) "There are beings who are different in body and different in perception, such as men, some heavenly beings, and some beings living in states of suffering (s. apa^ya). This is the 1st abode of consciousness.
(2) "There are beings who are different in body but equal in perception, such as the first-born gods of the Brahmaworld (s. deva II). This is the 2nd abode of consciousness.
(3) "There are beings who are equal in body but different in perception, such as the Radiant Gods (a^bhassara-deva). This is the 3rd abode of consciousness.
(4) ''There are beings who are equal in body and equal in perception, such as the All-illuminating Gods (subhakinha-deva). This is the 4th abode of consciousness.
(5) "There are beings ... reborn in the sphere of boundless space. This is the 5th abode of consciousness.
(6) "There are beings ... reborn in the sphere of boundless consciousness. This is the 6th abode of consciousness.
(7) There are beings... reborn in the sphere of nothingness. This is the 7th abode of consciousness"
About the 3 last-named spheres, s. jha^na (5-7). Cf. satta^va^sa.
In D. 33 there are mentioned 4 vin~n~a^na-tthiti, apparently in the sense of 'bases' of consciousness, namely: corporeality, feeling, perception, mental formations, which in S. XXII, 53 are further explained.   (lit. 'making known') 'intimation', is an Abhidhamma term for bodily expression (ka^ya-vin~n~atti) and verbal expression (vaci^-vin~n~atti), both belonging to the corporeality-group. They are produced by the co-nascent volition, and are therefore, as such, purely physical and not to be confounded with karma (q.v.), which as such is something mental. Cf. Kath. 80, 100, 101, 103, 194 (s. Guide V). - (App.).
"One speaks of 'bodily expression', because it makes known an intention by means of bodily movement, and can itself be understood by the bodily movement which is said to be corporeal.
" 'Verbal expression' is so called because it makes known an intention by means of a speech-produced noise" (Vis.M. XIV).  (or vipan~citan~n~u): 'one who realizes the truth after explanation.' Thus is called one who realizes the truth only after detailed explanation of that which already had been said to him in a concise form. Cf. ugghatitan~n~u.   'karma-result', is any karmically (morally) neutral mental phenomenon (e.g. bodily agreeable or painful feeling, sense-consciousness, etc. ), which is the result of wholesome or unwholesome volitional action (karma, q.v.) through body, speech or mind, done either in this or some previous life. Totally wrong is the belief that, according to Buddhism, everything is the result of previous action. Never, for example, is any karmically wholesome or unwholesome volitional action the result of former action, being in reality itself karma. On this subject s. tittha^yatana, karma, Tab. I; Fund II. Cf. A. III, 101; Kath. 162 (Guide, p. 80).
Karma-produced (kammaja or kamma-samuttha^na) corporeal things are never called kamma-vipa^ka, as this term may be applied only to mental phenomena.  'karma-result condition' is one of the 24 conditions (paccaya, q.v.).   'perversions' or 'distortions'. - ''There are 4 perversions which may be either of perception (san~n~a^-vipalla^sa), of consciousness (citta v.) or of views (ditthi-v.). And which are these four? To regard what is impermanent (anicca) as permanent; what is painful (dukkha) as pleasant (or happiness-yielding); what is without a self (anatta^) as a self; what is impure (ugly: asubha) as pure or beautiful'' (A. IV, 49). - See Manual of Insight, by Ledi Sayadaw (WHEEL 31/32). p.5.
"Of the perversions, the following are eliminated by the 1st path-knowledge (sota^patti): the perversions of perception, consciousness and views, that the impermanent is permanent and what is not a self is a self; further, the perversion of views that the painful is pleasant, and the impure is pure. By the 3rd path-knowledge (ana^ga^mita^) are eliminated: the perversions of perception and consciousness that the impure is pure. By the 4th path-knowledge (arahatta) are eliminated the perversions of perception and consciousness that the painful is pleasant" (Vis.M. XXII, 68).   'contemplation of change' (of all things), is one of the 18 chief kinds of insight (vipassana^, q.v.).   'insight', is the intuitive light flashing forth and exposing the truth of the impermanency, the suffering and the impersonal and unsubstantial nature of all corporeal and mental phenomena of existence. It is insight-wisdom (vipassana^-pan~n~a^) that is the decisive liberating factor in Buddhism, though it has to be developed along with the 2 other trainings in morality and concentration. The culmination of insight practice (s. visuddhi VI) leads directly to the stages of holiness (s. visuddhi VII).
Insight is not the result of a mere intellectual understanding, but is won through direct meditative observation of one's own bodily and mental processes. In the commentaries and the Vis.M., the sequene in developing insight-meditation is given as follows: 1. discernment of the corporeal (rpa), 2. of the mental (na^ma), 3. contemplation of both (na^marpa; i.e. of their pairwise occurrence in actual events, and their interdependence), 4. both viewed as conditioned (application of the dependent origination, paticcasamuppa^da), 5. application of the 3 characteristics (impermanency, etc.) to mind-and-body-cum-conditions.
The stages of gradually growing insight are described in the 9insight- knowledges (vipassana^-n~a^na), constituting the 6th stage of purification: beginning with the 'knowledge of rise and fall' and ending with the 'adaptation to Truth'. For details, see visuddhi VI and Vis.M. XXI.
Eighteen chief kinds of insight-knowledge (or principal insights, maha^-vipassana^) are listed and described in Vis.M. XXII, 113: (1) contemplation of impermanence (anicca^nupassana^), (2) of suffering (dukkha^nupassana^), (3) of no self (anatta^nupnupassana^), (4) of aversion (nibbida^nupassana^). (5) of detachment (vira^ga^nupassana^), (6) of extinction (nirodha^nupassana^), (7) of abandoning (patinissagga^nupassana^), (8) of waning (khaya^nupassana^), (9) of vanishing (vaya^nupassana^), (10) of change (viparina^ma^nupassana^), (11) of the unconditioned (or signless, animitta^nupassana^), (12) of desirelessness (apanihita^nupassana^), (13) of emptiness (sun~n~ata^upassana^), (14) insight into phenomena which is higher wisdom (adhipan~n~a^-dhamma-vipassana^), (15) knowledge and vision according to reality (yatha^-bhta-n~a^nadassana), (16) contemplation of misery (or danger, a^di^nava^nupassana^), (17) reflecting contemplation (patisankha^nupassana^), (18) contemplation of turning away (vivattana^nupassana^).
Through these 18, the adverse ideas and views are overcome, for which reason this way of overcoming is called 'overcoming by the opposite' (tadanga-paha^na, overcoming this factor by that). Thus (1) dispels the idea of permanence. (2) the idea of happiness, (3) the idea of self, (4) lust, (5) greed, (6) origination, (7) grasping, (8) the idea of compactness, (9) karma-accumulation, (10) the idea of lastingness, (11) the conditions, (12) delight, (13) adherence, (14) grasping and adherence to the idea of substance, (15) attachment and adherence, (17) thoughtlessness, (18) dispels entanglement and clinging.
Insight may be either mundane (lokiya, q.v.) or supermundane (lokuttara, q.v.). Supermundane insight is of 3 kinds: (1) joined with one of the 4 supermundane paths, (2) joined with one of the fruitions of these paths, (3) regarding the extinction, or rather suspension, of consciousness (s. nirodha-sama^patti).
See samatha-vipassana^, visuddhi, III-VII.
Literature: Manual of Insight, by Ledi Sayadaw (WHEL 31/32). Practical Insight Meditation, Progress of Insight, both by Maha^si Sayadaw (BPS). The Experience of Insight, by Joseph Goldstein (BPS).  ya^nika = sukkha-vipassaka (q.v.).   'imperfections of insight'; s. visuddhi.   'aberration' or 'deviation', may be: deviation from morality (si^la-vipatti), or deviation from understanding (ditthivipatti).
"To deviate in deeds, or in words, or in both deeds and words: this is called deviation from morality.
" 'Alms and offerings are useless, there is no fruit and result of good and bad actions, there are no such things as this and the next life' .... Such wrong views are called deviation from understanding." (Pug. 67, 68)  'dissociation', is one of the 24 conditions (paccaya, q.v.).   'fading away', detachment; absence of lust, dispassionateness. Appears frequently together with nirodha, 'cessation' (1) as a name for Nibba^na, (2) in the contemplations (a) forming the 4th tetrad in the exercises in mindfulness of breathing (s. a^na^pa^nasati 14), (b) of the 18 principal insights (No. 5); s. vipassana^.
According to Com., it may mean (1) the momentary destruction of phenomena, or (2) the ultimate 'fading away', i.e. Nibba^na. In the aforementioned two contemplations, it means the understanding of both, and the path attained by such understanding.   s. prec.   the 3 'abstentions' or abstinences, are: abstention from wrong speech, wrong (bodily) action and wrong livelihood; corresponding to right speech, action and livelihood of the 8-fold Path (s. magga, 3-5). By abstention is not simply meant the non-occurrence of the evil things in question, but the deliberate abstaining therefrom, whenever occasion arises. They belong to the 'secondary' (not constant) mental concomitants obtaining in lofty consciousness (s. Tab. II). Cf. si^la.   s. bha^va.   'energy', lit. 'virility', 'manliness' or 'heroism' (from vi^ra, man, hero; Lat. vir; cf. virtus), is one of the 5 spiritual faculties and powers (s. bala), one of the 7 factors of enlightenment (s. bojjhanga) and identical with right effort of the 8-fold Path (s. magga). For further explanations, s. padha^na.  'energy as factor of enlightenment', is one of the 7 factors of enlightenment (bojjhanga, q.v.).   s. si^la.  (-sama^dhi, -pan~n~a^): morality (concentration, wisdom) connected with progress'. For details, s. ha^nabha^giya-si^la.  s. a^yatana.   'purification', purity. The '7 stages of purification' (satta-visuddhi) form the substructure of Upatissa's Vimutti-Magga (The Path To Freedom), preserved only in Chinese, as well as of Buddhaghosa's monumental work, Visuddhi-Magga (The Path of Purification), based on the former work.
The only place in the Canon where these 7 kinds of purification are mentioned is M. 24, "The Simile of the Stage-coach" (s. 'Path', 64), wherein their purpose and goal are illustrated. There it is said that the real and ultimate goal does not consist in purification of morality, or of mind, or of view, etc., but in total deliverance and extinction. Now, just as one mounts the first coach and travels to the second coach, then mounts the second coach and travels with it to the third coach, etc., in exactly the same way the goal of (I) the purification of morality (sila-visuddhi) is (II) the purification of mind (citta-visuddhi); its goal: (III) the purification of view (ditthi-visuddhi); its goal: (IV) the purification by overcoming doubt (kankha^vitarana-visuddhi); its goal: (V) the purification by knowledge and vision of what is path and not-path (magga^magga-n~a^nadassana-visuddhi); its goal: (VI) the purification by knowledge and vision of the path-progress (patipada^-n~a^nadassana-visuddhi); its goal: (VII) the purification of knowledge and vision (n~a^nadassana-visuddhi); but the goal of this purification is deliverance freed from all clinging.
(I) "Purification of morality (si^la-visuddhi) consists of the 4-fold purity of morality (catu-pa^risuddhi-si^la), namely: restraint with regard to the Disciplinary Code (pa^timokkhasamvara-si^la), sense-restraint (indriysamvara-si^la), purity of livelihood (a^ji^vapa^risuddhi-si^la), morality with regard to the 4 requisites (paccaya-sannissita-si^la)" (Vis.M. XVIII). On these 4 terms, s. si^la. - In the case of a layman, it entails the observance of whatever moral rules (5 or more) he has taken upon himself.
(II) "Purification of mind (citta-visuddhi) is a name for the 8 attainments (= absorptions: jha^na, q.v.), as well as for neighbourhood-concentration (upaca^ra-sama^dhi; s. sama^dhi)." (ib.).
(III) "By purification of view (ditthi-visuddhi) is meant the understanding, according to reality, of mind and corporeality (na^marpa, q.v.)... which is founded on undeludedness (wisdom) as base, and which in manifold ways determines mind and corporeality after overcoming all belief in a persollality (atta^: self, ego.)." (ib.).
(IV) "By purification by overcoming doubt (kankha^-vitarana-visuddhi) is meant the understanding which, by grasping the conditions of this mind and corporeality, has escaped from all doubt with regard to the 3 times (past, present, future)." (ib. XIX)
(V) "By purification by knowledge and vision of what is path and not-path (magga^magga-n~a^nadassana-visuddhi) is meant that understanding which knows the right path from the wrong path: 'This is the right path, that the wrong path.' " (ib. XX)
In order to attain this 5th stage of purification, one at first should develop methodical insight (naya-vipassana^), i.e. through contemplation of the 5 groups of existence (khandha, q.v.). For whosoever does not yet possess a perfectly developed insight, to him such phenomena as effulgence of light, etc. (see below), arising during insight, may become impediments in the 3 kinds of full understanding here considered (s. parin~n~a^).
'As soon as the manifold ways and characteristics of the 4 Truths (sacca) and the dependent origination (paticcasamuppa^da) have become clear to the meditating disciple, he says to himself: Thus do these things never before arisen arise, and having arisen they disappear again. Thus do the formations of existence ever and again arise as something quite new. But not only are they something new, they are moreover also of limited duration, like a dew-drop at sunrise, like a bubble, like a line drawn with a stick in the water, like a mustard seed placed on the point of an arrow, or like a flash of lightning. Also as something unsubstantial and empty do they appear, as jugglery, as a mirage .... Merely something subject to vanishing arises, and having arisen disappears again.' "
During such insight practice, however, may arise the 10 imperfections (or defilements) of insight (vipassanpakkilesa): effulgence of light (obha^sa), knowledge (n~a^na), rapture (pi^ti), tranquillity (passaddhi), happiness (sukha), determination (adhimokkha), energy (paggaha), awareness (upattha^na), delight (nikanti). - See Vis.M. XX, 105f. (App.).
Excepting the last one, 'delight', they are not imperfections or defilements in themselves, but may become a basis for them through the arising of pride or delight or by a wrong conclusion that one of the holy paths has been attained. He, however, who is watchful and experienced in insight practice, will know that these states of mind do not indicate attainment of the true path, but are only symptoms or concomitants of insight meditation.
"Thus far the meditating disciple has determined 3 of the truths, namely while determining the corporeal and mental phenomena he has, through purification of view (ditthi-visuddhi), determined the 'truth of suffering'. While grasping the conditions he has, through purification by overcoming doubt (kankha^-vitarana-visuddhi), determined the 'truth of the origin of suffering'. While determining the right path, he has, through purification by knowledge and vision of what is path and not-path (magga^magga-n~a^nadassana-visuddhi), determined the 'truth of the path' (leading to the extinction of suffering)."
(VI) Purification by knowledge and vision of the path-progress (patipada^-n~a^nadassana-visuddhi) is the insight perfected in 8 kinds of knowledge, together with the 9th knowledge, the 'knowledge adapting itself to truth'.
By the 8 kinds of knowledge are here meant the following, which are freed from defilements, follow the right process, and are considered as insight, namely:
 
1. knowledge consisting in contemplation of rise and fall (udayabbaya^nupassana^-n~a^na),
2. in contemplation of dissolution (bhanga^nupassana^-n~a^na),
3. in awareness of terror (or the fearful) (bhayatpattha^na^-n~a^na),
4. in contemplation of misery (a^di^nava^nupassana^-n~a^na),
5. in contemplation of aversion (nibbida^nupassana^-n~a^na),
6. in the desire for deliverance (muccitu-kamyata^-n~a^na),
7. in reflecting contemplation (patisankha^nupassana^-n~a^na),
8. in equanimity regarding all formations of existence (sankha^rupekkha^-n~a^na) - which is followed by
9. in adaptation to truth (sacca^nulomika-n~a^na).
 
(1) consists in the meditative observation of the 3 characteristics of existence (impermanence, suffering, no self) in one's own bodily and mental processes. As long as the mind is still disturbed by the 10 imperfections (s. V), the 3 characteristics will not become fully clear in their true nature. Only when the mind is free from these imperfections can the characteristics be observed clearly.
(2) When through such repeated practice, knowledge and mindfulness have grown keen and the bodily and mental formations become apparent quickly, at that stage the phase of dissolution of these formations will become prominent.
"Consciousness with (e.g.) materiality as its object arises and dissolves. Having reflected on that object, he contemplates the dissolution of (reflecting) consciousness." (Pts.M. I, 57, quoted in Vis.M. XXI, 11).
The 8 blessings of this knowledge are: abandoning the belief in eternal existence (bhava-ditthi), giving up attachment to life, constant right application (of mind to meditative endeavour), a purified livelihood, overcoming of anxiety, absence of fear, acquisition of forbearance and gentleness, conquest of discontent and sensual delight (Vis.M. XXI, 28).
(3) Knowledge consisting in awareness of terror (or fearfulness) is the seeing of terror in the conditions as well as the continuity of existence. For whoso considers the formations as impermanent, to him the conditions of existence (i.e. the karma-formations producing ever new existence) appear as terror, as driving towards death. Whoso considers the formations as misery, to him the continuity of existence appears as terror, as something oppressive. Whoso considers the formations as impersonal, to him the karmaformations, as well as the continuity of existence, appear as terror, as an empty village, as a mirage, etc.
(4) Contemplation of misery (or danger) is another aspect of the awareness of terror: "The origin (of existence) is terror ... continuance of existence is terror ... arising is suffering', such understanding in the awareness of terror is the knowledge of misery. 'Non-arising is bliss', this is knowledge of the peaceful state (Pts.M. I, 59); that is, the no-more-arising is safety, is happiness, is Nibba^na.
(5) Contemplation of aversion means: aversion for all formations as terror, therefore its name 'awareness of terror' has come into use. Because it has made known the misery of all these formations, therefore it has received the name of 'contemplation of misery' (a^di^nava^nupassana^). Because it has arisen through aversion for those formations, therefore it is known as 'contemplation of aversion' (nibbida^nupassana^).
(6) Knowledge consisting in the desire for deliverance means: the desire for freedom and escape from all formations of existence.. For feeling aversion for all formations, becoming weary of them, finding no more delight in them, the mind does not cling to a single one of all these formations.
(7) Reflecting contemplation is the repeated meditative discernment of the formations of existence, attributing to them the 3 characteristics of existence, with the desire to find deliverance from all forms of existence.
(8) Equanimity regarding all formations: "When the meditator (through reflecting contemplation) has discerned the formations by applying the 3 characteristics to them and sees them as void, he abandons both terror and delight, and becomes indifferent and equanimous with regard to all formations; he neither takes them as I nor as 'mine'; he is like a man who has divorced his wife" (Vis.M. XXI, 61).
Now, while continuing to contemplate the 3 characteristics of existence and perceiving the tranquil lot of Nibba^na as the peace, this equanimity-knowledge becomes the triple gateway to liberation. As it is said (Pts.M. II, p. 48):
"Three gateways to liberation (vimokkha-mukha; s. vimokkha I) lead to escape from the world, namely: that the mind is contemplating all formations as limited, and is rushing forward to the conditionless element (animitta-dha^tu); that the mind is stirred with regard to all formations of existence, and is rushing forward to the desireless element (appanihita-dha^tu); that the mind sees all things as something foreign, and is rushing forward to the void element (sun~n~ata^-dha^tu)."
At this stage, and through the triple gateway, the diversification of path attainment takes place, according to the 7 kinds of noble persons (ariya-puggala, q.v.); on this see Vis.M. XXI, 74ff.
The 6th, 7th and 8th knowledges, according to Vis.M. XXI, form really only one single knowledge in its first, middle and final stages of development. This knowledge is also known as the 'insight leading to path ascent' (vuttha^na-ga^mini^-vipassana^, q.v.).
(9) Adaptation to truth (or conformity with truth) is called that knowledge which, while contemplating impermanency, etc. adapts itself to the preceding 8 kinds of insight-knowledge, as well as to the immediately following supermundane path and to the 37 elements pertaining to enlightenment (bodhipakkhiya-dhamma, q.v.). It is identical with adaptation-knowledge (anuloman~a^na).
"Whosoever has cultivated, developed, and frequently practised 'equanimity regarding all formations' in him arises very strong faith known as determination (adhimokkha-saddha^) and his energy is better exerted, his mindfulness better established, his mind better concentrated, and a still stronger 'equanimity regarding the formations' arises. 'Now the path will reveal itself', thus thinking, the meditator contemplates with his equanimity-knowledge all formations as impermanent, etc., and thereafter that knowledge sinks into the subconscious stream of existence (s. bhavanga-sota^). Immediately afterwards there arises advertence at the mind-door (s. vin~n~a^na-kicca). And just like equanimity-knowledge, the adaptation-knowledge, too, takes as its object the formations, regarding them as something impermanent, miserable and impersonal. Thereupon, while continuing the uninterrupted continuity of consciousness (citta-santati), there arises the 1st impulsive moment (javana, q.v.), called 'preparation' (parikamma), taking the same formations as object. Immediately thereafter, with the same formations as object, there arises the 2nd impulsive moment, known as 'access' (upaca^ra). And again immediately after that, there arises the impulsive moment called 'adaptation' (anuloma)."
(VII) Purification of knowledge and vision (n~a^nadassana-visuddhi) is the knowledge associated with any of the 4 kinds of supermundane path-consciousness (s. ariyapuggala).
"Immediately upon this adaptation-knowledge there arises the 'maturity-knowlege' (gotrabh-n~a^na; s. gotrabh) taking as object the Unconditioned, the standstill of existence, the absence of becoming, cessation, Nibba^na, while at the same time transcending the rank (gotta = gotra: lineage), designation and plane of the worldling (puthujjana, q.v.), and entering the rank, designation and plane of the Noble Ones (ariya), being the first turning towards Nibba^na as object, the first thinking of it, the first concentration on it, and the condition for the path ... forming the culmination of insight, and never as such coming back again.
''As the immediate continuation following upon that maturity knowledge (gotrabh-n~a^na), there arises the first path-consciousness (Stream-entrance) forever destroying the first 3 of the 10 fetters of existence (samyojana, q.v.), and closing the entrance to the lower worlds. Immediately after this path-knowledge, there arise, as its result, 2 or 3 path-produced states of consciousness, the fruitional consciousness (phala-citta). Immediately after the sinking of this consciousness into the subconscious stream of existence, the retrospective knowledge (paccavekkhana-n~a^na, q.v.) arises, having the path-consciousness as its object" (Vis.M. XXI). For the 3 higher paths, s. ariya-puggala.
Each of the 4 kinds of path-consciousness performs at the one and the same time 4 functions, namely: the function of full understanding (parin~n~a^, q.v.) of suffering, the function of overcoming (paha^na, q.v.) the origin of suffering, the function of realizing (sacchikiriya^) the extinction of suffering, the function of developing (bha^vana^, q.v.) the supermundane Noble Eightfold Path (magga, q.v.).
See Path of Purification, by Buddhaghosa, tr. by n~yanamoli (BPS); Path of Freedom, by Upatissa (BPS).   'thought', 'thought-conception', is one of the 'secondary' (not constant) mental concomitants (s. Tab. II), and may be either karmically wholesome, unwholesome or neutral. - "There are 3 karmically unwholesome (akusala) thoughts: sensuous thought (ka^ma-vitakka), hating thought (bya^pa^da-v.), and cruel thought (vihimsa-v.). There are 3 karmically wholesome (kusala) thoughts: thought of renunciation (nekkhamma-v.), of hatelessness (avya^pa^da-v.), of not harming (avihimsa^-v.) " The latter three constitute 'right thought', the 2nd link of the 8-fold Path (s. magga 2).
On the 'Removal of Distracting Thoughts' (vitakka-santha^na), s. M. 20 (tr. in WHEEL 21).  'thought-conception and discursive thinking', (or 'applied and sustained thought') are verbal functions (vaci^-sankha^ra: s. sankha^ra) of the mind, the so-called 'inner speech ('parole interieure'). They are constituents of the 1st absorption (s. jha^na), but absent in the higher absorptions.
(1) "Thought-conception (vitakka) is the laying hold of a thought, giving it attention. Its characteristic consists in fixing the consciousness to the object.
(2) "Discursive thinking (vica^ra) is the roaming about and moving to and fro of the mind.... It manifests itself as continued activity of mind" (Vis.M. IV).
(1) is compared with the striking against a bell, (2) with its resounding; (1) with the seizing of a pot, (2) with wiping it. (Cf. Vis . IV.).   ji^vitindriya; s. indriya, khandha (corporeality, mental formations), Tab. II.  'process of consciousness'; s. vin~n~a^nakicca.   'absence of the cycle of existence' (vatta, q.v.), standstill of existence, is a name for Nibba^na (s. nibba^na). - (App.).  s. kappa.   'contemplation of the turning away', is one of the 18 chief kinds of insight (vipassana^, q.v.). - (App.).   'detachment', seclusion, is according to Niddesa, of 3 kinds: (1) bodily detachment (ka^ya-viveka), i.e. abiding in solitude free from alluring sensuous objects; (2) mental detachment (citta-viveka), i.e. the inner detachment from sensuous things; (3) detachment from the substrata of existence (upadhi-viveka).
In the description of the 1st absorption, the words "detached from sensuous things" (vivicc' eva ka^mehi) refer, according to Vis.M. IV, to 'bodily detachment'; the words "detached from karmically unwholesome things" (vivicca akusalehi dhammehi) refer to 'mental detachment'; the words "born of detachment" (vivekaja), to the absence of the 5 hindrances.  'happiness of detachment', or aloofness (s. prec). "Whoso is addicted to society and worldly bustle, he will not partake of the happiness of renunciation, detachment, peace and enlightenment" (A. VII, 86).   'cleansing', may refer either to (1) morality (si^la), or (2) concentration (sama^dhi), or (3) wisdom (pan~n~a^).
(1) "Cleansing of morality takes place in 2 ways: by understanding the misery of moral deviation (si^la-vipatti; s. vipatti) and by understanding the blessing of moral perfection (si^la-sampatti)" (s. Vis.M. I).
(2) Cleansing of concentration is concentration connected with progress (visesa-bha^giya-sama^dhi; s. ha^na-bha^giya). If, for example, one has entered the 1st absorption, and sensuous perceptions and reflections arise, in that case there is concentration connected with decline ... If, however, perceptions and reflections free from thought-conception and discursive thinking (2nd jha^na; q.v.) arise, in that case there is concentration connected with progress.
(3) Cleansing, with reference to wisdom, is identical with the 'insight leading to the (path) ascent' (vuttha^na-ga^mini^-vipassana^, q.v.), which arises at the stage of 'purification by knowledge and vision of the path-progress' (s. visuddhi VI), and is followed immediately by the maturity moment and the entrance into the supermundane paths.  'conventional exposition', as distinguished from an explanation true in the highest sense (paramattha-desana^, q.v.). It is also called sammuti-sacca (in Sanskrit samvrti). (App.).  deliverance; s. ceto-vimutti.   s. pan~ca-voka^ra-bhava.   cetana^ (q.v.).  'determining consciousness', is that mindelement (functioning independently of karma; s. Tab. I, 70). which in the process of sense-perception performs the function of determining the sense-object. It is one of the 14 functions of consciousness (vin~n~a^na-kicca, q.v.).  'insight leading to (path) ascent'. It is also called 'cleansing' (voda^na, q.v.), and according to Pts.M. II, 64, it is a name for 3 kinds of insight-knowledge, namely: knowledge consisting in the desire for deliverance (muccitu-kamyata^-n~a^na; s. visuddhi VI 6); reflecting-contemplation-knowledge (patisankha^nupassana^-n~a^na; ib. VI, 7); and knowledge consisting in equanimity regarding all formations (sankha^rupekkha^-n~a^na; s. visuddhi VI, 8).
It arises at the stage of 'purification by knowledge and vision of the path-progress' (s. visuddhi VI), and is followed immediately by the maturity moment and the entrance into the supermundane paths.
" 'Ascent' (vuttha^na) is the supermundane path (s. ariya-puggala) since it rises above the object forming the external foundation (of insight; i.e. the external 5 groups of existence), in which object one's mind was absorbed, and also rises above one's own continuity (one's own 5 groups of existence, or khandha, q.v.) together with its defilements. By reason of its leading upwards to the supermundane path, this insight is called 'ascending insight'. That it passes on to the path: that is the meaning implied" (Vis.M. XXI, 83f.). (App.).   'ill-will', is a synonym of dosa (s. mla); it is one of the 5 hindrances (ni^varana, q.v.) and one of the 10 fetters (samyojana, q.v.).  a^po-dha^tu (s. dha^tu).  kasina, white-k., wind-k.: s. kasina.  garuka-kamma (s. karma).  s. samsa^ra, vatta.  dhamma-cakka (q.v.).   cetana^ (q.v.).  va^yo-dha^tu (s. dha^tu).   pan~n~a^ (q.v.).  courses (of existence): duggati (s. gati).   the 3-fold: loka (q.v.).   puthujjana (q.v.).   lokiya (q.v.).  conditions, the 8: loka-dhamma (q.v.).  period, formation, dissolution: s. kappa.   the 10: micchatta (q.v.).  miccha^-magga (q.v.).  understanding (or view), w. thought, w. speech; etc: s. miccha^-magga.   in popular belief, a kind of ghost, goblin. or ogre.  are a kind of heavenly beings of the sensuous world; s. deva.  'twin miracle'. "There the Perfect One performed the twin miracle unattainable to any disciple: from the upper part of his body a flame sprang forth, and from the lower part a stream of water. etc.'' (Pts.M. I, 125 f.); App.  'the knowledge and vision according to reality', is one of the 18 chief kinds of insight (vipassana^, q.v.).  'knowledge of rebirth according to one's actions'; s. abhin~n~a^ (4).   'the practice of being satisfied with whatever dwelling', is one of the ascetical means of purification; s. dhutanga (12).   'yokes, bonds', is another name for the 4 cankers (a^sava, q.v.) .  'one devoted to mental training,' is in Vis.M. the usual name for the disciple cultivating mental concentration (App.).   yoga, q.v.   'modes of generation.' There are 4 generation from the egg, from the mother's womb, from moisture, and spontaneous rebirth (opapa^tika, q.v.) in heaven, hell, etc. Explained in M. 12.  'thorough attention' or wise consideration': s. manasika^ra.  s. mada.   s. samatha-vipassana^, last paragraph.   
Attempt at a chronological fixing of terms not found, or not found in this form or meaning, in the oldest parts of the Sutta Pitaka.  This term is probably used for the first time in Abh. S., though already in Vis.M. XIV the 4 cetasika in question are mentioned amongst the mental factors associated with each of the 12 akusala-cittas (Tab. I, 22-33), while in the Abhidhamma Pitaka (Dhs.  365-429) uddhacca is found only in the last of the 12 cittas, missing in all the remaining 11 cittas.  This term seems to be used for the first time in Kath. (190) of the Abh. Canon; the 5 crimes mentioned, however, are already enumerated and explained in the old Sutta texts (e.g. A.V, 129), as is to be seen from the main part of this work.   s. paccaya, 2.   ka^ma^vacara is already met with in the oldest sutta texts (e.g. D. 1). Rpa^vacara and arpa^vacara, however, occur probably for the first time in Pts.M. (I. 83ff.), while in the Abhidhamma Canon and the Com. all the 3 terms are frequently mentioned and explained.   s. citta-vi^thi.   This term in the sense of 'amoral' or 'karmically neutral', does not occur in the old sutta texts, while it is found in Pts.M. (e.g. I, 79ff). It plays an important role in the Abh. Canon (e.g. Dhs.) and the philosophical commentaries.   probably met with for the first time in Pts.M. (I . 10f.).   The 2-fold division, kamma and upapatti, is probably found for the first time in Vibh. of the Abh. Canon, but it expresses throughout the genuine teaching of the suttas.   as an isolated word, signifying-the physical nature or faculties of sex, probably occurs only in the Com. The expression itthibha^va and purisabha^va, with the meaning of 'being a man', or 'being a woman', or after n~atva^, etc., as for instance tassa^ itthibha^vam n~atva^: 'knowing her to be a woman': such expressions are often found in the oldest sutta texts.  These 2 compound terms belong exclusively to the exegetical literature, while the term bhavanga is several times, briefly and unexplained, mentioned in the Patth. of the Abh. Canon, as though already known at that time.   ra^ga-c., dosa-c., buddhi-c., etc., are only to be met with in the Com. and Vis.M.   and va^ritta-sila: are only found in the Com., as Vis.M. 1, etc., but the teaching indicated by it is frequently mentioned in the old sutta texts as karani^ya and akarani^ya (e.g. A. II, 16).   This term oceurs often in the old sutta texts, but only as adj. (e.g. cetasikam sukham, etc.) or, at times, used as a sing. neut. noun (e.g. D. 1; p. 213, PTS). As a designation for mental factors, or concomitants of consciousness (citta-sampayutta^ dhamma^), it is frequently met with in Dhs. ( 1189, 1512) as cetasika-dhamma, while in Vis.M., Abh. S., etc., cetasika is used also as a neuter noun, in the sense of mental phenomenon.  lahuta^, -mudta, -kamman~n~ata^, -pa^gun~n~ata^, -ujukata^: s. lahuta^.  vi^thi, as well as all terms for the various functions within the processes of conseiousness, such as a^vajjana-citta, sampaticchana, santi^rana, votthapana, javana, tada^rammana, bhavanga, cuti: none of these terms is found in the Sutta Canon. except javana, in Pts.M. Even in the Ahh. Canon (e.g. Patth) only javana and bhavanga are twice or thrice briefly mentioned. The stages, however, must have been more or less known. Cf. e.g Patth: ''Cakkhu-vin~n~a^nam tam sampayuttaka^ ca dhamma^ (= cetasika^) mano-dha^tuya^ (performing the sampaticchana-function), tam sampayuttaka^nan~ ca dhamma^nam (cetasika^nani) anantara-paccayena paccayo. Mano-dha^tu ... manovin~n~a^na-dha^tuya (performing the santi^rana and votthapana function).... Purima^ purima^ kusala^ dhamma^ (javana^) pacchima^nam pacchima^nam kusala^nam dhamma^nam (javanacitta^nam) anantara-paccayena paccayo... avya^kata^nam dhamma^nam (tada^rammana- and bhavanga-citta^nam....)."
cuti-citta: s. citta-vi^thi.  This term is first used in Pts.M. while the subject in question is often treated in the old sutta texts (e.g. M. 28, 62, 140, etc.). Cf. sammasana.   This compound term is used only in the Com. The only place in the suttas where the first part, dhuta, is used in the above sense, is found in S. XIV. The names of the performers of these 13 ascetical exercises, however, are all mentioned in the suttas, but scattered here and there, for instance: pamsuklika, a^ran~n~ika, pindapa^tika, eka^sanika, teci^varika, sapa^da^naca^ri^, sosa^nika, abhhoka^sika, nesajjika, yatha^santhatika, in M. 5, 113; A. V, 181-190, etc.; rukkhamlika, khalupaccha^bhattika and pattapindika in A. V, 189f. etc.   s. javana.  This term is used in Abh. S. for the citta, Tab. I, 72. This type of consciousness (the Buddha's smile) is often implied in the suttas.   Most, or perhaps all, of the 10 terms listed at Vis.M. XII, as adhittha^na, etc., are absent in the older sutta texts. In Pts.M. (II, 205-214), however, they are enumerated in due order and minutely explained. The magical powers indicated by these terms are, nevertheless, for the most part explicitly described already in the oldest sutta texts. Cf. D. 34; M. 3; A. III, 99, etc.  This term is probably found for the first time in the Com., esp. Vis.M. IV. The rudiments of this doctrine, however, are already found in the old sutta texts, e.g. A. III, 100.   The only reference in the Sutta Pitaka is Pts.M. II, 73: kusalakammassa javana-khane, "in the impulsion-moment of a wholesome karma." In the Abhidhamma Pitaka it is briefly mentioned in the Pattha^na, but without explanation, as if already known. The teaching of the flashing forth of 4 javana immediately before entering the jha^na or lokuttara-magga, i.e. parikamma, upaca^ra, anuloma, gotrabh is, as such, without doubt a later development in the commentarial literature.   This doctrinal term, as well as the doctrine of the different corporeal units or groups, such as the suddhatthaka-k., ji^vitanavaka-k., cakkhudasaka-k., etc. (s. Vis.M. XVIII), belong only to the later developments of exegetical literature, as Vis.M. etc.   Vatthu-k. and kilesa-k. are probably found for the first time in MNid. 1. They correspond to the pan~ca ka^maguna^ (cakkhu-vin~n~eyya^ rpa^, etc.) and ka^ma-ra^ga in the older sutta texts (e.g A. VI, 68).   ahosi-, janaka-, garuka-, bahula-, upatthambhaka-, upagha^taka-, upapi^laka-, marana^sanna-, upacchedaka-k. None of these terms is found in the Sutta or Abh. Canon. They have been introduced by the commentators (e.g. in Abh. S. and Vis.M.) for the purpose of a systematical grouping of the various aspects and functions of karma. The term katatta^, however, occurs repeatedly in the Abh. Canon in such expressions as: 'Yasmim samaye ... kusalassa kammassa katatta^ ... cakkhuvin~n~a^nam hoti....' (Dhs.  431); or: 'Yam atthi rpam kammassa katatta^ ....' (Dhs.  653); or 'katatta^ ca rpa^nam' (Patth.), etc.   s. lahuta^.   This term, as a designation for the meditation exercises (bha^vana^), is found only in the Com. In the suttas the word is only used in a concrete sense for 'field of activity or occupation', as agriculture, trade, etc.  s. kamma.  -muduta^, -kamman~n~ata^, -pa^gun~n~ata^, -ujukata^, s. lahuta^.   The 3 phases in a moment of consciousness, i.e. uppa^da, thiti, bhanga, are probably mentioned for the first time in the commentaries; but there is a close parallel in two sutta texts which may have been the source for that teaching of a three-phased moment of consciousness:
"There are 3 characteristics of what is conditioned (sankhatassa lakkhana^): an arising (uppa^do) is apparent, a passing away (vayo) is apparent, a change in the existing (thitassa an~n~athattam: Com. = ageing) is apparent" (A. III, 47). The same 3 phases are mentioned in S. XXII, 37, where they are applied to each of the 5 khandha.   the 10 kilesa are probably for the first time enumerated and explained in Dhs. ( 1229-1239). There they are, however, called kilesa-vatthu, which name (dasa kilesa-vatthu) is already mentioned in Pts I, 130, though there they are neither enumerated nor explained.   (kiriya^, kriya^) citta is a term first used in the Abh. Canon (e.g. Dhs.  566-582). It has an important place in post-canonical Abh. literature, e.g. Vis.M. XIV.  as rpassa-, ka^ya-, or citta-, are for the first time found in the Abh. Canon, esp. Dhs. All, however, perhaps with the sole exception of pagun~n~ata^, are implied in the Sutta Canon, e.g. 'citte mudu-bhte kammani^ye' (M 4); 'lahu-san~n~an~ ca ka^ye okkamitva^' (S. LI. 22); 'cittam ujukam akamsu' (S. I. 26; PTS). Ka^ya-passaddhi and citta-passaddhi, however, are well known in the old sutta texts in this connection.   s. citta-vi^thi.   s. lahuta^.   Of the 9 kinds of insight-knowledge constituting the patipada^-n~a^nadassana-visuddhi (s. Vis.M. XXI), the following 6 are, as such, enumerated and explained for the first time in Pts.M., namely: udayabbaya^nupassana^-n~a^na (I. 54-57), bhanga^nupassana^-n~a^na, (ib. 57f.). bhayatupattha^na-n~a^na (ib. 59f). muccitukamyata^-n~a^na, patisanka^-n~a^na, sankha^rupekkha^-n~a^na (ib. 60-65). The terms udayabbaya and bhanga, in connection with the 5 groups of existence, however, are often met with in the old sutta texts. Of the remaining 3 kinds of knowledge, a^di^nava^nupassana^, nibbida^nupassana^ and anuloman~a^na, the first 2 occur often in the old sutta texts, while anuloma-n~a^na, though only briefly mentioned in the Abh. Canon (Patth.), plays a prominent part in the exegetical literature.  s. paccaya.  While the terms sekha and asekha occur frequently in the old sutta texts (e.g. A. II, 4: 'sekho ca asekho ca imasmim loke... a^huneyya^' etc.), the term n'eva-sekha-n'a^sekha is perhaps mentioned for the first time in Pug. of the Abh. Canon.   The 2 terms kilesa- and khandha-parinibba^na (or nibba^na) are found only in the Com.; their corresponding 2 aspects sa-upa^disesa and anupa^disesa-nibba^na, however, are mentioned and explained in It. 44 of the Sutta Canon.   As signifying the mental reflex-image occurring in meditation, this term, singly or in compounds (parikkamma-, uggaha-, patibha^ga-n.), is found only in the Com., Vis.M., etc. The same holds good for kamma-nimitta, gati-nimitta.  s. paha^na.  These two terms, in combination with tanha^ and ditthi, belong probably, as such, to the commentarial literature, e.g. Vis.M. I.   The compound words utu-, bi^ja-, kamma-, citta-, and dhamma-niya^ma, probably occur for the first time in the Com. Niya^mata^, however, occurs often in the old sutta texts, e.g. 'thita^ va sa^ dha^tu dhammatthitata^ dhammaniya^mata...' (A. III. 134. etc.)  is apparently mentioned for the first time in Dhs. (e.g.  1028) of the Abh. As a name for the 10th and last of the akusala-kammapathas, it plays a prominent role in the Com.   This term occurs often in the old sutta texts in such expressions as: 'ko hetu, ko paccayo', 'yam yad eva paccayam paticca uppajjati vin~n~a^nam', etc., or as abl. adverb in 'avijja^paccaya^ sankha^ra^'. All the 24 paccaya are for the first time enumerated, explained and applied to the phenomena of existence in the Abh. Canon (Patth). Of these 24 paccaya, 5 are already mentioned in Pts.M. (II, 49-54, 59f., 72-77), namely, sahaja^ta-, an~n~aman~n~a-, nissaya-, sampayutta-, vippayutta-paccaya.
1. Hetu is already used in the sutta texts as 'condition' in a general and indefinite way, as a synonym of paccaya. In the sense of kusala and akusala roots (mla; s. M. 9), however, it is only found in the Abh. Canon and Com.
2. a^rammana has in the 'sutta texts only the meaning of 'foundation', or 'basis', or 'dependent on', e.g. M. 21: 'tada^rammanan~ca sabbalokam metta^sahagatena cetasa^ pharitva^....' or D.33; S.XXII.53: 'vin~n~a^nam ... rpa^rammanam ... vedana^ram-manam....' As term for the 6 objects, rpa^rammana, sadda^rammana, etc.,
it is first used in the Abh. Canon, though the teaching of dependency of the 6 kinds of vin~n~a^na on the 6 sense-objects is an integral part of the suttas. Cf. e.g. M.38: 'cakkhun~ca paticca rpe ca uppajjati vin~n~a^nam sotan~ca paticca sadde ca ...' etc.
3. Adhipati, as a philosophical term, occurs for the first time in the Abh. Canon (esp. Patth.). The 4 adhipati are in the suttas called iddhipa^da (e.g. S. LI. 11). In the old sutta texts, 3 adhipateyya are however mentioned: atta-, loka-, dhamma- (A. III, 38).
4. & 5. Anantara- and samanantara-paccaya occur, as paccaya, for the first time in the Abh. Canon (esp. Patth.). In a veiled form, however, we find the first term in the old sutta texts (e.g. Ratana Sutta in Khp. and Sn.): 'sama^dhim a^nantarikan~n~ama^hu': the concentration (associated with the arahatta-magga), which is called the 'immediate' condition (for arahatta-phala).
6. & 7. Sahaja^ta and an~n~aman~n~a-paccaya. Though these terms, as such, are not found in the older sutta texts, still the teaching of the conascent and mutual conditionedness of the 4 mental groups (vedana^, san~n~a^, sankha^ra, vin~n~a^na) is taught in the old texts, e.g. M. 28, 43; S. XXII, etc.
8. Nissaya-paccaya is mentioned in Pts; s. first paragraph of this article, above.
9. Upanissaya-paccaya. Though this name is not found in the suttas, the teaching expressed thereby is, however, frequently met with there, sometimes even in the form of upanisa^ (apparently a contraction of upanissaya), e.g. S. XII, 23: 'Yam pi'ssa tam bhikkhave khayasmim khaye n~a^nam, tam sa-upanisam vada^mi, no anupanisam '. The terms pakati-, a^rammana- and anantara-upanissaya are later developments of the Abh. Com.
All the remaining terms are met with only in the Abh. literature though the substance is, perhaps in all cases, already dealt with in the old sutta texts.  This term is not found in the Sutta Canon, nor apparently in the Abh. Canon, but very often used in the exegetical literature. The idea, however, expressed thereby, is implied in many places of the old sutta texts, e.g., A. IX, 36, where it is shown how the jha^nas, one after the other, may serve as basis, or foundation (as mental object), for vipassana^. In many of the old sutta texts it is also shown how the 4th jha^na forms the foundation for the attainment of the 5 higher spiritual powers (abhin~n~a^).   s. lahuta^.   The 5 terms, as vikkhambhana, etc., are, as such, not found in the old sutta texts, but they are enumerated and explained already in Pts.M. (II. 179f.).   This 10-fold group is perhaps for the first time mentioned in Khp. Com. and explained in Vis.M. III.  s. a^vajjana.  s. voha^ra-desana^.  Only the Com. deals with this subject, apart from the 3 apocryphal works, Buddhavamsa and Cariyapitaka, and the Ja^taka.   This term is used in the Com. for the term a^ka^sa-kasina used in the older sutta texts.   n~a^ta-, ti^rana-, paha^na-p., belong to the exegetical literature, but they are already implied in Pts.M. I. 87: 'Abhin~n~a^-pan~n~a^ n~a^tatthe n~a^nam, parin~n~a^-pan~n~a^ ti^ranatthe n~a^nam, paha^na-pan~n~a^ paricca^gatthe n~a^nam ... ye ye dhamma^ abhin~n~a^ta^ honti, te te dhamma^ n~a^ta honti ... ti^rita^ ... pahi^na^.'  The first of these 3 fundamental terms, especially in this 3-fold grouping, belongs to the commentarial literature, though the idea expressed thereby is often found in the suttas in such expressions as: 'dhammam pariya^puna^ti suttam geyyam veyya^karanam ....' The 2 other terms are found separately in the suttas.   occurs in Pug. 17.   s. pariyatti.   is chiefly a commentarial term; but it occurs several times in one of the later books of the Sutta Pitaka, the Patisambhida^ Magga (Pts.M. I, 11f, 52, 59f.; II, 72f.). The usual sutta term for 'rebirth' is punabbhava.   ahetu-, dvihetu-, and tihetu-p.: are purely commentarial terms. For patisandhi-citta, s. citta-vi^thi.   s. pariyatti.   This term is found only in the Com., but the belief expressed by it is several times mentioned in the older sutta texts. Cf. the main part of this work.   the terms nipphanna-rpa and rpa-rpa are used only in the Com., although sappatigha and pasa^da are already found in the Abh. Canon (e.g. Dhs.  585, 597f.), while upa^dinna occurs repeatedly in the old sutta texts, e.g. M. 28, apparently with the meaning given in the main part of this work. Cf. further upa^da^-rpa.   parikamma-, upaca^ra-, and appana^-s.: are found only in the Com.  This term seems to be met with for the first time in Pug. 19, while the person indicated is described in A., as is to be seen in the main part of this work.  s. sukkha-vipassaka.   This term, as noun, occurs probably for the first time in Pts.M. I. 53, although as a verb it is found already in the old texts. The same holds good with its synonym vavattha^na.   s. sacca.  s. citta-vi^thi.   kamma- (= kamma-ja), utu-, a^ha^ra-s.: these terms are found only in the Com. Citta-samuttha^na-rpa, however, occurs already in Dhs. ( 586) of the Abh. Canon; and is indicated very often in Patth., e.g. 'tam (cittam) samuttha^na^nan~ ca rpa^nam'. The teaching of the origin of matter is, of course, already implied in the old sutta texts.  The terms citta-, rpa-, khandha-, bhavanga-s.:, etc., are found, here and there, in the Abh. Canon (e.g. Dhs.  634, Kath. 110; s. Guide V), but they are often met with in the Abh. Com. In the Sutta (Therag. 716) is found sankha^rasantati.  s. citta-vi^thi.   paccayasannissita-, pacca^vekkhana-si^la:, etc., are terms used in the Com. for the proper contemplation (patisankha^ yoniso) of the 4 requisites of a monk, often dealt with in the old texts (e.g. M. 2). Also the 3 other pa^risuddhi-si^la, as pa^timokkhasamvara-, indriya-, and a^ji^vapa^risuddhi-si^la, though under these names perhaps only known in the Com., are fully dealt with in the old texts, e.g. M.53, D.2, M.2, etc. The terms pannatti- and pan~n~atti-si^la are used only in the Com.  vipassaka = suddha-vipassana^-ya^nika: these terms are used only in the Com., as also their counterpart samathaya^nika.  s. citta-vi^thi.   This term, with the meaning in question, occurs perhaps only once in the Canon, namely in Kath. (s. Guide 83). Whether it is found also somewhere in the Com. , I am unable to say.   occurs probably for the first time in the Abh. Canon (e.g. Patth.; cf. Guide 110).   This term was already used by the Buddha himself in speaking of the doctrine of a^la^ra-Ka^la^ma (s. M. 26). As a name for the Buddha's doctrine it belongs to the commentarial literature.   s. lahuta^.   is an Abh. term but already alluded to in the old sutta texts, e.g. M. 149: 'a^yatim pan~cpa^da^nakkhandha^ upacayam gacchanti', or in D.2: 'Ayam ka^yo ... odana-kumma^s' upacayo'.  is, as such, an Abh. term, but it is used with the same meaning in the sutta texts, c.g. in M. 9: 'catunnan~ ca maha^bhta^nam upa^da^yn rpam'. Upa^da^ is an abbreviation of upa^da^ya (gerund).  s. ca^ritta.   The 5 kinds of vasi^ are probably found first in the Vis.M.   as a general term for the 5 sense-organs (cakkhu-vatthu, etc ) is frequent in the Com., and often used together with a^rammana (object). This usage, however, is already indicated in the Abh. Canon: 'Cakkhum p'etam... vatthum p'etam' (Dhs.  597; Vibh., p.71, PTS): 'cakkhuvin~n~a^nassa vatthu' (Dhs.  679ff.).   The 3, i.e. sun~n~ata^-, animitta-, appanihita-: are for the first time described and enumerated in Pts.M. II, 351. As sun~n~ata^sama^dhi, etc., however, they are already given at D. 33.   ka^ya- and vaci^-v., seem to occur for the first time in Dhs. ( 665,718) of the Abh. Canon.   is frequently found in the older sutta texts (e.g. A. II, 32; S. XLV, 159), also together with samatha. The 9 and 18 insight-knowledges (vipassana^-n~a^na and maha^-vipassana^), however, occur in the Sutta Pitaka only in the Pts.M., n~a^nakatha^, where they are enumerated and explained, though without any group name being attached to them.   The group of 10 is mentioned for the first time in Pts.M. II, 102, and it is said that the mind may become defiled thereby (kilissati), but the above term is not used for the 10. This is probably done for the first time in Vis.M. XX.   as a name for Nibba^na, seems to be found only in the Com.   is already mentioned in Pts.M., together with the remaining 17 kinds of vipassana^. In the old texts it is not found.  etc. The terms paramattha-, voha^ra-, sammuti-: etc., belong as such to the commentarial literature, but their significance is clearly shown in the old sutta texts, e.g. D. 9: 'loka-sa^man~n~a^, loka-voha^ra'; further(D 33): 'sammuti-n~a^na', etc.   pan~ca-, catu-, and eka-v. (bhava), occur as technical terms only in the Abh. (Vibh., Yam., Patth.) and Com., e.g. Vis.M., but their substance is an integral part of the suttas.  s. citta-vi^thi.  is probably implied in Pts.M. I, 60, under the name of vuttha^na-vivattane n~a^na.  is perhaps for the first time mentioned and described in Pts.M., as seen in the main part of this work.  These 2 terms belong to the commentarial literature, but the first term appears also in Mil. 
Table II - Mental-States (sankha^ra kkhandha)
Mental states are of 50 kinds (cetasika), namely:(*1)
11 Common (an~n~asama^na)(*2)
(a) 5 universals (sabbacitta) (in every consciousness):
Consciousness-impression (phassa) 
Volition (cetana^) 
(mental) vitality (jvita) 
One-pointedness (sama^dhi) 
Attention (manasika^ra) 
(b) 6 particulars (pakinnaka^) (not in every consciousness)
thought-conception (vitakka) 
discursive thinking (vica^ra) 
determination (adhimokkha) 
effort (viriya) 
enthusiasm (joy) (pti) 
intention (chanda) 
25 Lofty, pure (sobhana)
(a) primary (in every lofty consciousness) 
Confidence (saddha^)  
Mindfulness (sati)  
Moral shame (hiri) 
Moral dread (ottappa)  
Generous (alobha)  
Hatelessness (adosa)  
Equanimity (tatramajjhattata^)  
Tranquility of mental factors (ka^ya-passaddhi)  
Tranquility of consciousness (citta-passaddhi) 
Agility or lightness of mental factors (ka^ya-lahuta^) 
Agility or lightness of consciousness (citta-lahuta^)  
Elasticity of mental factors (ka^ya-muduta^)  
Elasticity of consciousness (citta-muduta^)  
Adaptability of mental factors (ka^ya-kamman~n~ata^)  
Adaptability of consciousness (citta-kamman~n~ata^)  
Proficiency of mental factors (ka^ya-pa^gun~n~ata^)  
Proficiency of consciousnesss (citta-pa^gun~n~ata^) 
Uprightness of mental factors (ka^ya'ujukata^) 
Uprightness of consciousness (citta'ujukata^) 
(b) 6 secondary
3 Abstinences (viratiyo):(*3)
Right bodily action (samma^kammanto) 
Right speech (samma^va^ca^) 
Right livelihood (samma-a^jvo) 
 2 Boundless states (appaman~n~a^):
Compassion (karuna^) 
Altruistic joy (mudita^) 
1 Faculty of wisdom (pan~n~indriya):
Non-delusion (amoha)  
= wisdom (pan~n~a^)
14 Unwholesome (akusala)
(a) 4 primary (in every unwholesome consciousness)
Delusion (moha) 
Lack of moral shame (ahirika) 
Lack of moral dread (anottappa) 
Restlessness (uddhacca) 
(b) 10 secondary (not in every unwholesome consciousness)
4 Hate rooted:
Hatred (dosa) 
Envy (issa^) 
Stinginess (macchariya) 
Worry (kukkucca) 
Furthermore:
Greed (lobha) 
View, insight (wrong) (ditthi) 
Conceit, pride (ma^na) 
Sloth (thna) 
Torpor (middha) 
Skepticism (vicikiccha^) 